/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wmqfte.explorer.wizards.v2;

import com.ibm.wmqfte.explorer.wizards.v2.TransferWizardV2;
import org.eclipse.jface.wizard.IWizardPage;

public class PageSelection {
    private PageRules[] rules = new PageRules[]{new PageRules(PageIndexes.InitialPage, RequirementIndexes.Always), new PageRules(PageIndexes.ResourceMonitorPage, RequirementIndexes.ResMon), new PageRules(PageIndexes.ResourceMonitorPageB, RequirementIndexes.ResMon), new PageRules(PageIndexes.ItemTransferPage, RequirementIndexes.Always), new PageRules(PageIndexes.SchedulePage, RequirementIndexes.Transfer), new PageRules(PageIndexes.AttributePage, RequirementIndexes.Always), new PageRules(PageIndexes.MetaDataPage, RequirementIndexes.Always), new PageRules(PageIndexes.SummaryPage, RequirementIndexes.Always)};
    IWizardPage[] pages;
    TransferWizardV2 outerWizard;

    public PageSelection(TransferWizardV2 outer, IWizardPage[] pages) {
        this.outerWizard = outer;
        this.pages = pages;
    }

    public IWizardPage prevPage(IWizardPage currentPage) {
        int position = this.getIndex(currentPage);
        if (position == -1) {
            return currentPage;
        }
        boolean cont = true;
        while (position > 0 && cont) {
            boolean bl = cont = !this.canVisit(this.rules[--position]);
        }
        return this.pages[position];
    }

    public IWizardPage nextPage(IWizardPage currentPage) {
        int position = this.getIndex(currentPage);
        if (position == -1) {
            return currentPage;
        }
        boolean cont = true;
        while (position < this.pages.length - 1 && cont) {
            boolean bl = cont = !this.canVisit(this.rules[++position]);
        }
        return cont ? null : this.pages[position];
    }

    private boolean canVisit(PageRules rules) {
        RequirementIndexes[] requirementIndexesArray = rules.canVisit;
        int n = rules.canVisit.length;
        int n2 = 0;
        while (n2 < n) {
            RequirementIndexes test = requirementIndexesArray[n2];
            switch (test) {
                case Always: {
                    break;
                }
                case ResMon: {
                    if (this.outerWizard.getCreateType().isResourceMonitor()) break;
                    return false;
                }
                case Transfer: {
                    if (!this.outerWizard.getCreateType().isResourceMonitor()) break;
                    return false;
                }
                case Submit: {
                    if (this.outerWizard.isSubmitable()) break;
                    return false;
                }
            }
            ++n2;
        }
        return true;
    }

    public int getIndex(IWizardPage currentPage) {
        int idx = 0;
        while (idx < this.pages.length) {
            if (this.pages[idx] == currentPage) {
                return idx;
            }
            ++idx;
        }
        return -1;
    }

    public static enum PageIndexes {
        InitialPage,
        ResourceMonitorPage,
        ResourceMonitorPageB,
        SchedulePage,
        ItemTransferPage,
        AttributePage,
        MetaDataPage,
        SummaryPage,
        SendPage;

    }

    private static class PageRules {
        PageIndexes page;
        RequirementIndexes[] canVisit;

        public PageRules(PageIndexes page, RequirementIndexes ... canVisit) {
            this.page = page;
            this.canVisit = canVisit;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.page.name());
            String sep = " ";
            RequirementIndexes[] requirementIndexesArray = this.canVisit;
            int n = this.canVisit.length;
            int n2 = 0;
            while (n2 < n) {
                RequirementIndexes visitItem = requirementIndexesArray[n2];
                sb.append(sep);
                sep = ",";
                sb.append(visitItem.name());
                ++n2;
            }
            return sb.toString();
        }
    }

    public static enum RequirementIndexes {
        Always,
        ResMon,
        Transfer,
        Submit;

    }
}

