/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wmqfte.explorer.wizards.pages.v2.configuration;

import com.ibm.wmqfte.explorer.Elements;
import com.ibm.wmqfte.explorer.data.FTEConfigurationPersistence;
import com.ibm.wmqfte.explorer.utils.PageUtils;
import com.ibm.wmqfte.explorer.wizards.v2.FTEConfigurationWizardSettings;
import java.text.MessageFormat;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class FTEConfigurationNamePage
extends WizardPage {
    private static final String EOL = System.getProperty("line.separator");
    private final FTEConfigurationWizardSettings settings;
    private Text configurationName;

    public FTEConfigurationNamePage(FTEConfigurationWizardSettings settings) {
        super(Elements.UI_WIZARD_MFT_NEW_CONFIGURATION_TITLE, Elements.UI_WIZARD_MFT_SELECT_CONFIG_NAME_TITLE, null);
        this.setDescription(Elements.UI_WIZARD_MFT_SELECT_CONFIG_NAME_DESC);
        this.settings = settings;
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        final ScrolledComposite scrolledComposite = new ScrolledComposite(parent, 768);
        final Composite container = new Composite((Composite)scrolledComposite, 0);
        this.initializeDialogUnits((Control)container);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        container.setLayout((Layout)new GridLayout(2, false));
        Label nameLabel = new Label(container, 131072);
        nameLabel.setText(String.valueOf(Elements.UI_WIZARD_NEW_CONFIGURATION_NAME_LABEL) + ':');
        nameLabel.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        this.configurationName = new Text(container, 2048);
        this.configurationName.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.configurationName.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                e.text = e.text.toUpperCase();
            }
        });
        this.configurationName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FTEConfigurationNamePage.this.checkPageForErrors();
                FTEConfigurationNamePage.this.checkPageComplete();
            }
        });
        Label spacer = new Label(container, 0);
        spacer.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        Text description = new Text(container, 74);
        description.setText(String.valueOf(Elements.UI_WIZARD_NEW_CONFIGURATION_NAME_DESC) + EOL + EOL + Elements.UI_WIZARD_NEW_CONFIGURATION_NAME_CONVENTION_DESC);
        description.setBackground(Display.getCurrent().getSystemColor(22));
        GridData gd = new GridData(4, 0x1000000, false, false, 2, 1);
        gd.widthHint = this.convertWidthInCharsToPixels(80);
        description.setLayoutData((Object)gd);
        scrolledComposite.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e) {
                scrolledComposite.setMinSize(container.computeSize(-1, -1, true));
                scrolledComposite.layout();
                container.layout();
            }

            public void controlMoved(ControlEvent e) {
            }
        });
        scrolledComposite.notifyListeners(11, new Event());
        parent.pack();
        scrolledComposite.setContent((Control)container);
        scrolledComposite.setMinHeight(container.computeSize((int)-1, (int)-1, (boolean)true).y);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        this.setControl((Control)scrolledComposite);
    }

    private void checkPageForErrors() {
        if (this.getControl() == null || this.getControl().isDisposed()) {
            return;
        }
        Status status = null;
        String name = this.configurationName.getText().trim();
        if (name.length() > 0) {
            String msg;
            Pattern INVALID_MQ_OBJECT_NAME;
            Matcher matcher;
            Map<String, FTEConfigurationWizardSettings> configurationSets = FTEConfigurationPersistence.getConfigurationSets();
            if (configurationSets.containsKey(name)) {
                String msg2 = MessageFormat.format(Elements.UI_WIZARD_MFT_SELECTED_CONFIG_NAME_ALREADY_EXISTS_ERROR, name);
                status = new Status(4, "com.ibm.wmqfte.explorer", msg2);
            }
            if ((matcher = (INVALID_MQ_OBJECT_NAME = Pattern.compile(".*([^A-Za-z0-9._/%]).*")).matcher(name)).matches()) {
                msg = MessageFormat.format(Elements.UI_WIZARD_MFT_SELECTED_CONFIG_NAME_INVALID_CHARS_ERROR, matcher.group(1));
                status = new Status(4, "com.ibm.wmqfte.explorer", msg);
            }
            if (name.length() > 48) {
                msg = Elements.UI_WIZARD_MFT_SELECTED_CONFIG_NAME_TOO_LONG_ERROR;
                status = new Status(4, "com.ibm.wmqfte.explorer", msg);
            }
        }
        if (status == null) {
            status = new Status(0, "com.ibm.wmqfte.explorer", "");
        }
        PageUtils.setStatusLine(this, status);
    }

    private void checkPageComplete() {
        if (this.getControl() == null || this.getControl().isDisposed()) {
            return;
        }
        boolean isPageComplete = this.getErrorMessage() == null;
        isPageComplete = isPageComplete && this.configurationName.getText().trim().length() > 0;
        this.setPageComplete(isPageComplete);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            if (this.settings.getConfigurationName() != null && this.configurationName.getText().trim().length() == 0) {
                this.configurationName.setText(this.settings.getConfigurationName());
                this.getControl().getParent().layout(true);
            }
            this.checkPageComplete();
        }
    }

    public IWizardPage getNextPage() {
        if (this.configurationName != null) {
            this.settings.setConfigurationName(this.configurationName.getText());
        }
        return super.getNextPage();
    }
}

