/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wmqfte.explorer.wizards.pages.v2;

import com.ibm.wmqfte.explorer.Elements;
import com.ibm.wmqfte.explorer.ExplorerPlugin;
import com.ibm.wmqfte.explorer.dialogs.ItemDialogInfo;
import com.ibm.wmqfte.explorer.utils.PageUtils;
import com.ibm.wmqfte.explorer.utils.v2.ControlGroup;
import com.ibm.wmqfte.explorer.utils.v2.Generator;
import com.ibm.wmqfte.explorer.utils.v2.PriorityStatus;
import com.ibm.wmqfte.explorer.utils.v2.Tools;
import com.ibm.wmqfte.explorer.utils.v2.TransferItem;
import com.ibm.wmqfte.explorer.wizards.pages.v2.ItemPage;
import com.ibm.wmqfte.explorer.wizards.v2.TransferWizardV2;
import com.ibm.wmqfte.objects.TransferTemplate;
import com.ibm.wmqfte.utils.xmlmessage.transfer.ItemSpecification;
import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public class SummaryPage
extends WizardPage {
    private static final String EOL = System.getProperty("line.separator");
    private static final int PREVIEW_LINES = 5;
    private Composite container;
    private TableViewer tbvItems;
    private Text templateNameText;
    private Button saveAsTemplateButton;
    private String templateName = null;
    private final TransferWizardV2 outerWizard;

    public SummaryPage(TransferWizardV2 outerWizard) {
        super(SummaryPage.class.getName(), null, null);
        if (outerWizard.getCreateType().isResourceMonitor()) {
            this.setTitle(outerWizard.getCreateType().getSummarySubTitle());
            this.setDescription(Elements.UI_WIZARD_V2_MONITOR_SUMMARY_DESC);
        } else {
            this.setTitle(outerWizard.getCreateType().getSummarySubTitle());
            this.setDescription(Elements.UI_WIZARD_V2_SUMMARY_DESC);
        }
        this.outerWizard = outerWizard;
    }

    public void createControl(Composite parent) {
        final ScrolledComposite scrolledComposite = new ScrolledComposite(parent, 2560);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        scrolledComposite.setLayout((Layout)new GridLayout(1, true));
        scrolledComposite.setLayoutData((Object)new GridData(4, 4, false, true));
        this.container = new Composite((Composite)scrolledComposite, 0);
        scrolledComposite.setContent((Control)this.container);
        this.setControl((Control)scrolledComposite);
        this.initializeDialogUnits((Control)this.container);
        this.container.setLayoutData((Object)new GridData(4, 4, false, true));
        this.container.setLayout((Layout)new GridLayout(1, false));
        this.container.layout();
        parent.layout();
        parent.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e) {
                if (SummaryPage.this.container.isDisposed()) {
                    return;
                }
                SummaryPage.this.container.layout();
                scrolledComposite.setMinSize(new Point(0, ((SummaryPage)SummaryPage.this).container.computeSize((int)-1, (int)-1).y));
            }

            public void controlMoved(ControlEvent e) {
            }
        });
    }

    private void updateControl() {
        this.outerWizard.updateTemplate();
        TransferTemplate template = this.outerWizard.getTransferTemplate();
        if (this.container != null) {
            Control[] controlArray = this.container.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control control = controlArray[n2];
                control.dispose();
                ++n2;
            }
        }
        Group source = new Group(this.container, 0);
        source.setText(Elements.UI_WIZARD_V2_SUMMARY_SOURCE_GROUP);
        source.setLayout((Layout)new GridLayout(2, false));
        source.setLayoutData((Object)new GridData(4, 4, true, false));
        new ItemDialogInfo.AgentInformation((Composite)source, this.outerWizard.getInitialPage().getSourceAgentDetails(), 0, true);
        Group destination = new Group(this.container, 0);
        destination.setText(Elements.UI_WIZARD_V2_SUMMARY_DESTINATION_GROUP);
        destination.setLayout((Layout)new GridLayout(2, false));
        destination.setLayoutData((Object)new GridData(4, 4, true, false));
        new ItemDialogInfo.AgentInformation((Composite)destination, this.outerWizard.getInitialPage().getDestinationAgentDetails(), 0, true);
        ArrayList<TransferItem> transfers = new ArrayList<TransferItem>();
        for (ItemSpecification is : template.getFileSpecs()) {
            try {
                transfers.add(new TransferItem(is));
            }
            catch (TransferItem.InternalException ex) {
                Tools.internalError(ex, ex.getLocalizedMessage(), new Object[0]);
            }
        }
        if (transfers.size() > 0) {
            TableColumn c;
            ItemPage.TableColName tableColName;
            Group files = new Group(this.container, 0);
            files.setText(Elements.UI_WIZARD_V2_SUMMARY_TRANSFER_GROUP);
            files.setLayout((Layout)new GridLayout(2, false));
            files.setLayoutData((Object)new GridData(4, 4, true, false));
            this.tbvItems = new TableViewer((Composite)files, 68354);
            this.tbvItems.setContentProvider((IContentProvider)new ItemPage.ItemContentProviderV2());
            this.tbvItems.setLabelProvider((IBaseLabelProvider)new ItemPage.ItemLabelProviderV2());
            Table table = this.tbvItems.getTable();
            GridData tableGridData = new GridData(4, 4, true, true, 2, 1);
            tableGridData.heightHint = table.getHeaderHeight() + 5 * (table.getItemHeight() + 3);
            table.setLayoutData((Object)tableGridData);
            ItemPage.TableColName[] tableColNameArray = ItemPage.TableColName.values();
            int n = tableColNameArray.length;
            int n3 = 0;
            while (n3 < n) {
                tableColName = tableColNameArray[n3];
                c = new TableColumn(table, 16384);
                c.setText(tableColName.getNLSName());
                ++n3;
            }
            this.tbvItems.setInput(transfers);
            tableColNameArray = ItemPage.TableColName.values();
            n = tableColNameArray.length;
            n3 = 0;
            while (n3 < n) {
                tableColName = tableColNameArray[n3];
                c = table.getColumn(tableColName.getPosition());
                if (tableColName.isInSummary()) {
                    c.pack();
                } else {
                    c.setWidth(0);
                    c.setResizable(false);
                }
                ++n3;
            }
            this.tbvItems.setInput(transfers);
            table.setHeaderVisible(table.getItemCount() > 0);
        }
        if (this.outerWizard.getTransferTemplate().isComplete()) {
            Group commandGroup = new Group(this.container, 0);
            commandGroup.setLayout((Layout)new GridLayout(1, false));
            commandGroup.setLayoutData((Object)new GridData(4, 4, true, false));
            commandGroup.setText(Elements.UI_WIZARD_V2_SUMMARY_COMMAND_GROUP);
            String commandText = Generator.showCommands(this.outerWizard.getTransferTemplate());
            TransferWizardV2.CreateType createType = this.outerWizard.getCreateType();
            String temp = commandText;
            switch (createType) {
                case NEW_TEMPLATE: 
                case EXISTING_TEMPLATE: 
                case EDIT_TEMPLATE: 
                case COPY_TEMPLATE: {
                    temp = temp.replaceFirst("fteCreateTransfer", "fteCreateTemplate");
                    temp = String.valueOf(temp) + " -tn " + this.outerWizard.getTransferTemplate().getName();
                    break;
                }
            }
            commandText = temp;
            this.addPreviewControl((Composite)commandGroup, commandText);
            Group xmlGroup = new Group(this.container, 0);
            xmlGroup.setLayout((Layout)new GridLayout(1, false));
            xmlGroup.setLayoutData((Object)new GridData(4, 4, true, false));
            xmlGroup.setText(Elements.UI_WIZARD_V2_SUMMARY_XML_GROUP);
            String xmlText = Generator.showXML(this.outerWizard.getTransferTemplate());
            this.addPreviewControl((Composite)xmlGroup, xmlText);
        }
        this.addSaveTemplateControls(this.container);
        this.container.layout();
        this.getControl().getParent().notifyListeners(11, new Event());
        this.setPageComplete(true);
    }

    public String getTemplateName() {
        return this.templateName;
    }

    private void addSaveTemplateControls(Composite parent) {
        if (!this.outerWizard.getCreateType().isTemplate() && !this.outerWizard.getCreateType().isResourceMonitor()) {
            this.saveAsTemplateButton = new Button(parent, 32);
            this.saveAsTemplateButton.setText(Elements.UI_WIZARD_V2_SUMMARY_SAVE_BUTTON);
            this.saveAsTemplateButton.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
            final ControlGroup saveGroup = new ControlGroup("Summy-Save");
            Composite saveIdentComp = new Composite(parent, 0);
            GridLayout gl = new GridLayout(2, false);
            gl.marginLeft = 16;
            gl.marginRight = 8;
            saveIdentComp.setLayout((Layout)gl);
            saveIdentComp.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
            saveGroup.add((Control)saveIdentComp);
            Label templateNameLabel = new Label(saveIdentComp, 0);
            templateNameLabel.setText(Elements.UI_WIZARD_V2_SUMMARY_SAVE_NAME);
            templateNameLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
            saveGroup.add((Control)templateNameLabel);
            this.templateNameText = new Text(saveIdentComp, 2048);
            if (this.templateName != null) {
                this.saveAsTemplateButton.setSelection(true);
                this.templateNameText.setText(this.templateName);
                this.validate();
            }
            this.templateNameText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            saveGroup.add((Control)this.templateNameText);
            saveGroup.enabled(this.saveAsTemplateButton.getSelection());
            this.saveAsTemplateButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent arg0) {
                }

                public void widgetSelected(SelectionEvent arg0) {
                    saveGroup.enabled(SummaryPage.this.saveAsTemplateButton.getSelection());
                    SummaryPage.this.validate();
                }
            });
            this.templateNameText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent arg0) {
                    SummaryPage.this.validate();
                }
            });
        }
    }

    private void validate() {
        PriorityStatus status = new PriorityStatus(null);
        this.templateName = null;
        if (this.saveAsTemplateButton != null && this.saveAsTemplateButton.getSelection() && this.templateNameText != null) {
            this.templateName = this.templateNameText.getText().trim();
            if (this.templateName.length() == 0) {
                status.setIncomplete();
            } else if (this.outerWizard.isTemplatePresent(this.templateNameText.getText())) {
                status.setError(Elements.UI_WIZARD_V2_INITIAL_DUPLICATED_TEMPLATE_NAME);
            }
        }
        PageUtils.setStatusLine(this, (IStatus)status.getStatus());
        this.setPageComplete(status.isComplete());
    }

    private void addPreviewControl(Composite parent, String previewText) {
        Text text = new Text(parent, 2826);
        GridData gd = new GridData(4, 0x1000000, true, false);
        int lineCount = previewText.split(EOL).length;
        int maxHeight = this.convertHeightInCharsToPixels(Math.min(lineCount, 5));
        gd.heightHint = maxHeight + text.getBorderWidth();
        text.setLayoutData((Object)gd);
        text.setText(previewText);
        text.pack();
    }

    public IWizardPage getPrevPage() {
        return ((TransferWizardV2)this.getWizard()).getPrevPage((IWizardPage)this);
    }

    public IWizardPage getNextPage() {
        return ((TransferWizardV2)this.getWizard()).getNextPage((IWizardPage)this);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.updateControl();
            ExplorerPlugin.setHelp((Control)this.getContainer().getShell(), "com.ibm.wmqfte.explorer.context.UI_Summary");
        }
    }
}

