/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wmqfte.explorer.wizards.pages.v2;

import com.ibm.wmqfte.api.CommandScheduleSpecification;
import com.ibm.wmqfte.explorer.Elements;
import com.ibm.wmqfte.explorer.ExplorerPlugin;
import com.ibm.wmqfte.explorer.Icons;
import com.ibm.wmqfte.explorer.utils.PageUtils;
import com.ibm.wmqfte.explorer.utils.v2.ControlGroup;
import com.ibm.wmqfte.explorer.utils.v2.PriorityStatus;
import com.ibm.wmqfte.explorer.utils.v2.Tools;
import com.ibm.wmqfte.explorer.wizards.v2.TransferWizardV2;
import com.ibm.wmqfte.objects.TransferTemplate;
import com.ibm.wmqfte.utils.xmlmessage.transfer.ScheduleSpecification;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

public class SchedulePage
extends WizardPage {
    private final SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm");
    private static final int defaultType = 3;
    private Button enableScheduleButton;
    private Combo timeBaseCombo;
    private DateTimeWidgets dateTimeWidget;
    private Button enableScheduleRepeatButton;
    private Spinner numSpinner;
    private Combo repeatIntervalTypeCombo;
    private Button untilButton;
    private DateTimeWidgets dateTimeUntilWidgets;
    private Button freqButton;
    private Spinner numRepeatsSpinner;
    private Button foreverButton;
    private TransferWizardV2 outerWizard;
    private final ControlGroup scheduleControl = new ControlGroup("Schedule");
    private final ControlGroup repeatControl = new ControlGroup("ScheduleRepeat");
    private final ControlGroup untilControl = new ControlGroup("ScheduleUntil");
    private final ControlGroup freqControl = new ControlGroup("ScheduleFreq");

    public SchedulePage(TransferWizardV2 outerWizard) {
        super(SchedulePage.class.getName(), outerWizard.getCreateType().getSubTitle(), null);
        this.setDescription(Elements.UI_WIZARD_V2_SCHEDULE_DESC);
        this.setPageComplete(true);
        this.outerWizard = outerWizard;
    }

    public void createControl(Composite parent) {
        Composite scheduleEnableComp = new Composite(parent, 0);
        scheduleEnableComp.setLayout((Layout)new GridLayout(1, false));
        scheduleEnableComp.setLayoutData((Object)new GridData(4, -1, false, false));
        this.enableScheduleButton = new Button(scheduleEnableComp, 32);
        this.enableScheduleButton.setText(Elements.UI_WIZARD_V2_SCHEDULE_ENABLE_BUTTON);
        Composite scheduleStartComp = new Composite(scheduleEnableComp, 0);
        scheduleStartComp.setLayout((Layout)Tools.indentedGridLayout(4));
        this.scheduleControl.add((Control)scheduleStartComp);
        GridData startLabelGD = new GridData(0x1000008, 0x1000000, false, false);
        startLabelGD.widthHint = Tools.getWidth(parent, new String[]{Elements.UI_WIZARD_V2_SCHEDULE_TIMEBASE_LABEL, Elements.UI_WIZARD_V2_SCHEDULE_START_AT_LABEL});
        Label start = new Label(scheduleStartComp, 131072);
        this.scheduleControl.add((Control)start);
        start.setText(Elements.UI_WIZARD_V2_SCHEDULE_START_AT_LABEL);
        start.setLayoutData((Object)startLabelGD);
        this.dateTimeWidget = new DateTimeWidgets(scheduleStartComp, this.scheduleControl);
        this.dateTimeWidget.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                SchedulePage.this.validatePage();
            }
        });
        Label timeBaselabel = new Label(scheduleStartComp, 131072);
        this.scheduleControl.add((Control)timeBaselabel);
        timeBaselabel.setText(Elements.UI_WIZARD_V2_SCHEDULE_TIMEBASE_LABEL);
        timeBaselabel.setLayoutData((Object)startLabelGD);
        this.timeBaseCombo = new Combo(scheduleStartComp, 8);
        this.scheduleControl.add((Control)this.timeBaseCombo);
        this.timeBaseCombo.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 3, 1));
        this.updateTimeBaseOptions(true);
        this.enableScheduleRepeatButton = new Button(scheduleStartComp, 32);
        this.scheduleControl.add((Control)this.enableScheduleRepeatButton);
        this.enableScheduleRepeatButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 4, 1));
        this.enableScheduleRepeatButton.setText(Elements.UI_WIZARD_V2_SCHEDULE_REPEATS_BUTTON);
        this.createScheduleRepeatContents(scheduleStartComp);
        this.enableScheduleRepeatButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                SchedulePage.this.updateRepeatSelection();
                SchedulePage.this.validatePage();
            }
        });
        this.enableScheduleButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                SchedulePage.this.updateScheduleSelection();
            }
        });
        this.scheduleControl.add(this.repeatControl);
        if (this.outerWizard.isTemplateMode() && this.outerWizard.getTransferTemplate().getScheduleSpec() != null) {
            this.loadTemplateDetails();
        }
        this.updateScheduleSelection();
        scheduleEnableComp.layout();
        this.setControl((Control)scheduleEnableComp);
    }

    private void createScheduleRepeatContents(Composite parent) {
        Composite scheduleRepeatComp = new Composite(parent, 0);
        scheduleRepeatComp.setLayout((Layout)Tools.indentedGridLayout(4));
        scheduleRepeatComp.setLayoutData((Object)new GridData(4, -1, true, false, 4, 1));
        this.repeatControl.add((Control)scheduleRepeatComp);
        Text every = Tools.accessibleLabel(scheduleRepeatComp, Elements.UI_WIZARD_V2_SCHEDULE_REPEAT_INTERVAL_LABEL);
        this.repeatControl.add((Control)every);
        this.numSpinner = new Spinner(scheduleRepeatComp, 2048);
        this.numSpinner.setMinimum(1);
        this.numSpinner.setIncrement(1);
        this.numSpinner.setMaximum(this.dateTimeWidget.getMaximums()[3]);
        this.numSpinner.setLayoutData((Object)new GridData(4, 1, true, false));
        this.repeatControl.add((Control)this.numSpinner);
        this.repeatIntervalTypeCombo = new Combo(scheduleRepeatComp, 8);
        this.repeatIntervalTypeCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.repeatIntervalTypeCombo.setItems(TimeInterval.getAllNLSMessages());
        this.repeatControl.add((Control)this.repeatIntervalTypeCombo);
        this.repeatIntervalTypeCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                Object s = e.getSource();
                if (s instanceof Combo) {
                    int[] maximums = SchedulePage.this.dateTimeWidget.getMaximums();
                    int index = ((Combo)s).getSelectionIndex();
                    SchedulePage.this.numSpinner.setMaximum(maximums[index]);
                }
            }
        });
        this.repeatIntervalTypeCombo.select(3);
        Composite buttonComp = new Composite(scheduleRepeatComp, 0);
        buttonComp.setLayout((Layout)Tools.indentedGridLayout(4));
        buttonComp.setLayoutData((Object)new GridData(4, -1, true, false, 4, 1));
        this.untilButton = new Button(buttonComp, 16);
        this.untilButton.setSelection(true);
        this.repeatControl.add((Control)this.untilButton);
        this.untilButton.setText(Elements.UI_WIZARD_V2_SCHEDULE_UNTIL_LABEL);
        this.dateTimeUntilWidgets = new DateTimeWidgets(buttonComp, this.untilControl);
        this.dateTimeUntilWidgets.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                SchedulePage.this.validatePage();
            }
        });
        this.freqButton = new Button(buttonComp, 16);
        this.repeatControl.add((Control)this.freqButton);
        this.freqButton.setText(Elements.UI_WIZARD_V2_SCHEDULE_FOR_LABEL);
        this.repeatControl.add(this.untilControl);
        this.numRepeatsSpinner = new Spinner(buttonComp, 2048);
        this.freqControl.add((Control)this.numRepeatsSpinner);
        this.numRepeatsSpinner.setValues(1, 1, 9999, 0, 1, 10);
        this.numRepeatsSpinner.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.numRepeatsSpinner.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                super.getName(e);
                e.result = String.valueOf(SchedulePage.this.numRepeatsSpinner.getSelection()) + " " + Elements.UI_WIZARD_V2_SCHEDULE_REPETITIONS_ACCESSIBLE;
            }
        });
        Text repetitions = Tools.accessibleLabel(buttonComp, Elements.UI_WIZARD_V2_SCHEDULE_REPITIIONS_LABEL);
        this.freqControl.add((Control)repetitions);
        repetitions.setText(Elements.UI_WIZARD_V2_SCHEDULE_REPITIIONS_LABEL);
        repetitions.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 1));
        this.repeatControl.add(this.freqControl);
        this.foreverButton = new Button(buttonComp, 16);
        this.repeatControl.add((Control)this.foreverButton);
        this.foreverButton.setText(Elements.UI_WIZARD_V2_SCHEDULE_FOREVER_LABEL);
        SelectionListener scheduleRadioListener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                SchedulePage.this.updateForUntilSelection();
                SchedulePage.this.validatePage();
            }
        };
        this.untilButton.addSelectionListener(scheduleRadioListener);
        this.freqButton.addSelectionListener(scheduleRadioListener);
        this.foreverButton.addSelectionListener(scheduleRadioListener);
        scheduleRadioListener.widgetDefaultSelected(null);
    }

    public IWizardPage getPrevPage() {
        return ((TransferWizardV2)this.getWizard()).getPrevPage((IWizardPage)this);
    }

    public IWizardPage getNextPage() {
        return ((TransferWizardV2)this.getWizard()).getNextPage((IWizardPage)this);
    }

    public void updateTransferTemplate(TransferTemplate template) {
        if (this.enableScheduleButton != null && this.enableScheduleButton.getSelection()) {
            CommandScheduleSpecification cssTemplate = this.generateScheduleSpec();
            template.setScheduleSpec(cssTemplate);
        }
    }

    private void loadTemplateDetails() {
        CommandScheduleSpecification cssTemplate = this.outerWizard.getTransferTemplate().getScheduleSpec();
        this.enableScheduleButton.setSelection(true);
        this.dateTimeWidget.load(cssTemplate.getStartSchedule());
        TimeBase tb = TimeBase.getByInternalRef(cssTemplate.getTimeBase());
        if (tb != null) {
            this.timeBaseCombo.select(tb.getPosition());
        }
        if (cssTemplate.getRepeatInterval() != null) {
            this.enableScheduleRepeatButton.setSelection(true);
            this.numSpinner.setSelection(cssTemplate.getRepeatFrequency());
            this.repeatIntervalTypeCombo.select(TimeInterval.getByInternalType(ScheduleSpecification.RepeatInterval.fromValue((String)cssTemplate.getRepeatInterval())).getPosition());
            this.unselectAllTransferRepeatRadios();
            if (cssTemplate.getRepeatCount() != -1) {
                this.numRepeatsSpinner.setSelection(cssTemplate.getRepeatCount());
                this.freqButton.setSelection(true);
            } else if (cssTemplate.getEndSchedule() != null) {
                this.dateTimeUntilWidgets.load(cssTemplate.getEndSchedule());
                this.untilButton.setSelection(true);
            } else {
                this.foreverButton.setSelection(true);
            }
        }
    }

    public CommandScheduleSpecification generateScheduleSpec() {
        String deferredSchedule = this.dateTimeWidget.generateDateTime();
        String untilSchedule = null;
        if (this.enableScheduleRepeatButton.getSelection() && this.untilButton.getSelection()) {
            untilSchedule = this.dateTimeUntilWidgets.generateDateTime();
        }
        CommandScheduleSpecification cssTemplate = new CommandScheduleSpecification(deferredSchedule, TimeBase.getByPosition(this.timeBaseCombo.getSelectionIndex()).getAgentEnum(), this.enableScheduleRepeatButton.getSelection() ? TimeInterval.getByPosition(this.repeatIntervalTypeCombo.getSelectionIndex()).getAgebntEnum() : null, this.enableScheduleRepeatButton.getSelection() ? this.numSpinner.getSelection() : -1, this.enableScheduleRepeatButton.getSelection() && this.freqButton.getSelection() ? this.numRepeatsSpinner.getSelection() : -1, untilSchedule);
        return cssTemplate;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            ExplorerPlugin.setHelp((Control)this.getContainer().getShell(), "com.ibm.wmqfte.explorer.context.UI_Scheduler");
        }
        this.updateTimeBaseOptions(false);
    }

    private void updateTimeBaseOptions(boolean resetPosition) {
        if (this.timeBaseCombo != null) {
            int position = resetPosition ? 0 : this.timeBaseCombo.getSelectionIndex();
            String[] timeOptions = new String[]{TimeBase.ADMIN.getNLSMessage(TimeZone.getDefault().getID()), TimeBase.SOURCE.getNLSMessage(this.outerWizard.getSendingAgentToneZone()), TimeBase.UTC.getNLSMessage(null)};
            this.timeBaseCombo.setItems(timeOptions);
            this.timeBaseCombo.select(position);
        }
    }

    private void updateScheduleSelection() {
        boolean enabled = this.enableScheduleButton.getSelection();
        this.scheduleControl.enabled(enabled);
        if (enabled) {
            this.updateRepeatSelection();
        }
    }

    private void updateRepeatSelection() {
        boolean enabled = this.enableScheduleRepeatButton.getSelection();
        this.repeatControl.enabled(enabled);
        if (enabled) {
            this.updateForUntilSelection();
        }
    }

    private void unselectAllTransferRepeatRadios() {
        this.untilButton.setSelection(false);
        this.freqButton.setSelection(false);
        this.foreverButton.setSelection(false);
    }

    private void updateForUntilSelection() {
        if (this.untilButton.getSelection()) {
            this.untilControl.enabled(true);
            this.freqControl.enabled(false);
        } else if (this.freqButton.getSelection()) {
            this.untilControl.enabled(false);
            this.freqControl.enabled(true);
        } else if (this.foreverButton.getSelection()) {
            this.untilControl.enabled(false);
            this.freqControl.enabled(false);
        }
    }

    private void validatePage() {
        PriorityStatus scheduleStatus = new PriorityStatus(null);
        if (this.enableScheduleRepeatButton.getSelection() && this.untilButton.getSelection() && this.dateTimeUntilWidgets.isBefore(this.dateTimeWidget)) {
            scheduleStatus.setError(Elements.UI_WIZARD_V2_SCHEDULE_REPEAT_BEFORE_START);
        }
        PageUtils.setStatusLine(this, (IStatus)scheduleStatus.getStatus());
        this.setPageComplete(scheduleStatus.isOk());
    }

    private static class DateTimeDialogHandler {
        private final DateTime dateTime;
        private final Shell parentShell;
        private final Control dialogButton;
        private Shell dialog = null;

        public DateTimeDialogHandler(Control dialogButton, DateTime dateTime) {
            this.dateTime = dateTime;
            this.parentShell = dialogButton.getShell();
            this.dialogButton = dialogButton;
        }

        public void open() {
            if (this.dialog == null) {
                this.dialog = new Shell(this.parentShell, 2048);
                this.dialog.setLayout((Layout)new GridLayout(2, false));
                final DateTime cal = new DateTime((Composite)this.dialog, 1024);
                cal.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
                Button cancel = new Button((Composite)this.dialog, 8);
                cancel.setText(Elements.UI_WIZARD_V2_SCHEDULE_DATETIME_CANCEL);
                cancel.setLayoutData((Object)new GridData(0x1000008, 0x1000000, true, false));
                cancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        this.close();
                    }
                });
                Button ok = new Button((Composite)this.dialog, 8);
                ok.setText(Elements.UI_WIZARD_V2_SCHEDULE_DATETIME_OK);
                ok.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
                ok.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        this.updateButton(cal);
                        this.close();
                    }
                });
                this.dialog.setDefaultButton(ok);
                this.dialog.pack();
                Point pt = this.dialogButton.getParent().toDisplay(this.dateTime.getLocation());
                this.dialog.setLocation(pt.x, pt.y + this.dateTime.getBounds().height);
                this.dialog.open();
            }
        }

        private void updateButton(DateTime cal) {
            this.dateTime.setYear(cal.getYear());
            this.dateTime.setMonth(cal.getMonth());
            this.dateTime.setDay(cal.getDay());
        }

        private void close() {
            this.dialog.close();
            this.dialog = null;
        }
    }

    private class DateTimeWidgets {
        private final DateTime dateWidget;
        private final DateTime timeWidget;

        public DateTimeWidgets(Composite parent, ControlGroup cg) {
            Composite dtwComp = new Composite(parent, 0);
            dtwComp.setLayout((Layout)Tools.noMarginGridLayout(3));
            dtwComp.setLayoutData((Object)new GridData(4, -1, true, false, 3, 1));
            this.dateWidget = new DateTime(dtwComp, 2080);
            cg.add((Control)this.dateWidget);
            Button dateCal = new Button(dtwComp, 2048);
            cg.add((Control)dateCal);
            dateCal.setImage(Icons.datePicker);
            this.timeWidget = new DateTime(dtwComp, 34944);
            cg.add((Control)this.timeWidget);
            this.roundTime(this.timeWidget, TimeZone.getDefault());
            final DateTimeDialogHandler dateHandler = new DateTimeDialogHandler((Control)dateCal, this.dateWidget);
            dateCal.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    dateHandler.open();
                }
            });
            this.dateWidget.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }

                public void widgetSelected(SelectionEvent e) {
                    int[] maximums = DateTimeWidgets.this.getMaximums();
                    int index = SchedulePage.this.repeatIntervalTypeCombo.getSelectionIndex();
                    SchedulePage.this.numSpinner.setMaximum(maximums[index]);
                }
            });
        }

        public void load(String schedule) {
            try {
                Date ss = SchedulePage.this.df.parse(schedule);
                Calendar cal = Calendar.getInstance();
                cal.setTime(ss);
                this.dateWidget.setYear(cal.get(1));
                this.dateWidget.setMonth(cal.get(2));
                this.dateWidget.setDay(cal.get(5));
                this.timeWidget.setHours(cal.get(11));
                this.timeWidget.setMinutes(cal.get(12));
            }
            catch (ParseException ex) {
                Tools.internalError(ex, Elements.UI_WIZARD_V2_INTERR_BAD_START_SCHEDULE, SchedulePage.this.outerWizard.getTransferTemplate().getName(), schedule);
            }
        }

        public String generateDateTime() {
            Calendar cal = this.getCalendar();
            return SchedulePage.this.df.format(cal.getTime());
        }

        public boolean isBefore(DateTimeWidgets before) {
            Calendar thisCal = this.getCalendar();
            Calendar beforeCal = before.getCalendar();
            return thisCal.before(beforeCal);
        }

        public void addSelectionListener(SelectionListener sl) {
            this.dateWidget.addSelectionListener(sl);
            this.timeWidget.addSelectionListener(sl);
        }

        private Calendar getCalendar() {
            Calendar cal = Calendar.getInstance();
            cal.set(this.dateWidget.getYear(), this.dateWidget.getMonth(), this.dateWidget.getDay(), this.timeWidget.getHours(), this.timeWidget.getMinutes());
            return cal;
        }

        private int[] getMaximums() {
            int year = this.dateWidget.getYear();
            int month = this.dateWidget.getMonth();
            int day = this.dateWidget.getDay();
            Calendar c = Calendar.getInstance();
            c.set(year, month, day);
            return new int[]{60, 24, c.getActualMaximum(6), c.getActualMaximum(3), 12, 100};
        }

        private void roundTime(DateTime time, TimeZone tz) {
            Calendar cal = Calendar.getInstance(tz);
            cal.clear(14);
            cal.clear(13);
            cal.clear(12);
            cal.roll(11, true);
            time.setSeconds(cal.get(13));
            time.setMinutes(cal.get(12));
            time.setHours(cal.get(11));
        }
    }

    public static enum TimeBase {
        ADMIN("admin", Elements.UI_WIZARD_V2_SCHEDULE_TIMEBASE_ADMIN),
        SOURCE("source", Elements.UI_WIZARD_V2_SCHEDULE_TIMEBASE_SOURCE),
        UTC("utc", Elements.UI_WIZARD_V2_SCHEDULE_TIMEBASE_UTC);

        private final String nlsMessage;
        private final String agentEnum;

        private TimeBase(String agentRef, String nlsMessage) {
            this.agentEnum = agentRef;
            this.nlsMessage = nlsMessage;
        }

        public String getNLSMessage(String timeZoneStr) {
            return MessageFormat.format(this.nlsMessage, timeZoneStr);
        }

        public String getAgentEnum() {
            return this.agentEnum;
        }

        public int getPosition() {
            return this.ordinal();
        }

        public static TimeBase getByInternalRef(String agentEnum) {
            TimeBase[] timeBaseArray = TimeBase.values();
            int n = timeBaseArray.length;
            int n2 = 0;
            while (n2 < n) {
                TimeBase tb = timeBaseArray[n2];
                if (tb.agentEnum.equalsIgnoreCase(agentEnum)) {
                    return tb;
                }
                ++n2;
            }
            return null;
        }

        public static TimeBase getByPosition(int position) {
            return TimeBase.values()[position];
        }
    }

    public static enum TimeInterval {
        MINUTES(Elements.UI_WIZARD_V2_SCHEDULE_MINUTES, ScheduleSpecification.RepeatInterval.MINUTES),
        HOURS(Elements.UI_WIZARD_V2_SCHEDULE_HOURS, ScheduleSpecification.RepeatInterval.HOURS),
        DAYS(Elements.UI_WIZARD_V2_SCHEDULE_DAYS, ScheduleSpecification.RepeatInterval.DAYS),
        WEEKS(Elements.UI_WIZARD_V2_SCHEDULE_WEEKS, ScheduleSpecification.RepeatInterval.WEEKS),
        MONTHS(Elements.UI_WIZARD_V2_SCHEDULE_MONTHS, ScheduleSpecification.RepeatInterval.MONTHS),
        YEARS(Elements.UI_WIZARD_V2_SCHEDULE_YEARS, ScheduleSpecification.RepeatInterval.YEARS);

        private final String nlsMessage;
        private final ScheduleSpecification.RepeatInterval agentType;

        private TimeInterval(String nlsMessage, ScheduleSpecification.RepeatInterval agentType) {
            this.nlsMessage = nlsMessage;
            this.agentType = agentType;
        }

        public String getNLSMessage() {
            return this.nlsMessage;
        }

        public int getPosition() {
            return this.ordinal();
        }

        public ScheduleSpecification.RepeatInterval getAgebntEnum() {
            return this.agentType;
        }

        public static TimeInterval getByPosition(int position) {
            return TimeInterval.values()[position];
        }

        public static TimeInterval getByInternalType(ScheduleSpecification.RepeatInterval internalType) {
            TimeInterval[] timeIntervalArray = TimeInterval.values();
            int n = timeIntervalArray.length;
            int n2 = 0;
            while (n2 < n) {
                TimeInterval ti = timeIntervalArray[n2];
                if (ti.agentType == internalType) {
                    return ti;
                }
                ++n2;
            }
            return null;
        }

        public static String[] getAllNLSMessages() {
            ArrayList<String> typeList = new ArrayList<String>();
            TimeInterval[] timeIntervalArray = TimeInterval.values();
            int n = timeIntervalArray.length;
            int n2 = 0;
            while (n2 < n) {
                TimeInterval ti = timeIntervalArray[n2];
                typeList.add(ti.nlsMessage);
                ++n2;
            }
            return typeList.toArray(new String[0]);
        }
    }
}

