/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wmqfte.explorer.wizards.pages.v2;

import com.ibm.wmqfte.api.InternalException;
import com.ibm.wmqfte.explorer.Elements;
import com.ibm.wmqfte.explorer.ExplorerPlugin;
import com.ibm.wmqfte.explorer.utils.PageUtils;
import com.ibm.wmqfte.explorer.utils.v2.ControlGroup;
import com.ibm.wmqfte.explorer.utils.v2.PriorityStatus;
import com.ibm.wmqfte.explorer.utils.v2.SectionHistory;
import com.ibm.wmqfte.explorer.utils.v2.Tools;
import com.ibm.wmqfte.explorer.utils.v2.TransferItem;
import com.ibm.wmqfte.explorer.wizards.pages.v2.ResourceMonitorPageA;
import com.ibm.wmqfte.explorer.wizards.v2.TransferWizardV2;
import com.ibm.wmqfte.monitor.MonitorPattern;
import com.ibm.wmqfte.monitor.impl.MonitorRequest;
import com.ibm.wmqfte.monitor.impl.MonitorTriggerCondition;
import com.ibm.wmqfte.monitor.impl.MonitorTriggerOperator;
import com.ibm.wmqfte.objects.TransferTemplate;
import com.ibm.wmqfte.utils.Content;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public class ResourceMonitorPage {
    private static String DATASET = "//";
    private static String NODE = "[^/\\\\]{2,}:";
    private static String NOT_DATASET_OR_NODE = "(?!(?:" + DATASET + ")|(?:" + NODE + "))";
    private static Pattern PatternDirectory = Pattern.compile(String.valueOf(NOT_DATASET_OR_NODE) + ".*");
    private WizardPage outerWizardPage = null;
    private Text headerNameA;
    private Text headerTypeA;
    private Text headerNameB;
    private Text headerTypeB;
    private Combo directoryCombo;
    private Button directoryBrowseButton;
    private Combo queueQueue;
    private Text queueMgrQueue;
    private ControlGroup resMonControl = new ControlGroup("ResMon");
    private ControlGroup directoryControl = new ControlGroup("ResMon Directory");
    private ControlGroup queueControl = new ControlGroup("ResMon Queue");
    private ControlGroup batchControl = new ControlGroup("Res Mon Batch value");
    private ControlGroup contentOuterCG = new ControlGroup("Content Outer Res Mon.");
    private Combo triggerFilePatternCombo;
    private Combo triggerFileExcludePatternCombo;
    private Combo patternsAreRegexCombo;
    private Button shouldMatchButton;
    private Button exceedButton;
    private Spinner sizeValueSpinner;
    private Combo sizeTypeCombo;
    private Button sizeUnchangedButton;
    private Spinner sizeUnchangedValueSpinner;
    private Button notExistButton;
    private Button queueNotEmptyButton;
    private Button completeGroupsButton;
    private Button directoryRecursionButton;
    private Spinner directoryRecursionSpinner;
    private Spinner directoryPollIntervalValueSpinner;
    private Combo directoryPollIntervalTypeCombo;
    private Spinner queuePollIntervalValueSpinner;
    private Combo queuePollIntervalTypeCombo;
    private Button batchSizeButton;
    private Spinner batchSizeValueSpinner;
    private TableViewer subVarTableViewer;
    private Button contentDefault;
    private Button contentCustom;
    private Button contentEnabled;
    private Combo contentCustomRegEx;
    private Combo contentCaptureOrder;
    private boolean showErrors = false;
    private SortedMap<String, String> defaultRFH2attributes = new TreeMap<String, String>();
    private final TransferWizardV2 outerWizard;
    private final MonitorRequest templateMonitor;

    public ResourceMonitorPage(TransferWizardV2 outerWizard) {
        this.outerWizard = outerWizard;
        this.templateMonitor = outerWizard.isTemplateMode() ? outerWizard.getTransferTemplate().getResourceMonitor() : null;
    }

    protected void contentsHeaderA(Composite parent) {
        GridData gd = new GridData(131072, 0x1000000, false, false);
        gd.widthHint = Tools.getWidth(parent, new String[]{Elements.UI_WIZARD_V2_RESMON_HEADER_NAME, Elements.UI_WIZARD_V2_RESMON_HEADER_TYPE});
        Composite comp = new Composite(parent, 131072);
        comp.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        comp.setLayout((Layout)new GridLayout(2, false));
        Label nameLabel = new Label(comp, 0);
        nameLabel.setText(Elements.UI_WIZARD_V2_RESMON_HEADER_NAME);
        nameLabel.setLayoutData((Object)gd);
        this.headerNameA = Tools.accessibleLabel(comp, "");
        Label typeLabel = new Label(comp, 131072);
        typeLabel.setText(Elements.UI_WIZARD_V2_RESMON_HEADER_TYPE);
        typeLabel.setLayoutData((Object)gd);
        this.headerTypeA = Tools.accessibleLabel(comp, "");
    }

    protected void contentsHeaderB(Composite parent) {
        GridData gd = new GridData(131072, 0x1000000, false, false);
        gd.widthHint = Tools.getWidth(parent, new String[]{Elements.UI_WIZARD_V2_RESMON_HEADER_NAME, Elements.UI_WIZARD_V2_RESMON_HEADER_TYPE});
        Composite comp = new Composite(parent, 131072);
        comp.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        comp.setLayout((Layout)new GridLayout(2, false));
        Label nameLabel = new Label(comp, 0);
        nameLabel.setText(Elements.UI_WIZARD_V2_RESMON_HEADER_NAME);
        nameLabel.setLayoutData((Object)gd);
        this.headerNameB = Tools.accessibleLabel(comp, "");
        Label typeLabel = new Label(comp, 131072);
        typeLabel.setText(Elements.UI_WIZARD_V2_RESMON_HEADER_TYPE);
        typeLabel.setLayoutData((Object)gd);
        this.headerTypeB = Tools.accessibleLabel(comp, "");
    }

    protected void contentsDirectory(final Composite parent) {
        Group directoryGroup = new Group(parent, 0);
        directoryGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        directoryGroup.setLayout((Layout)new GridLayout(3, false));
        directoryGroup.setText(Elements.UI_WIZARD_V2_RESMON_DIRECTORY);
        this.directoryControl.add((Control)directoryGroup);
        Text directoryTitleLabel = Tools.accessibleLabel((Composite)directoryGroup, Elements.UI_WIZARD_V2_RESMON_DIRECTORY_TITLE);
        directoryTitleLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        this.directoryControl.add((Control)directoryTitleLabel);
        Composite dirIdentComp = new Composite((Composite)directoryGroup, 0);
        dirIdentComp.setLayout((Layout)Tools.indentedGridLayout(3));
        dirIdentComp.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        Label directoryLabel = new Label(dirIdentComp, 131072);
        directoryLabel.setText(Elements.UI_WIZARD_V2_RESMON_DIRECTORY_LABEL);
        this.directoryControl.add((Control)directoryLabel);
        this.directoryCombo = new Combo(dirIdentComp, 0);
        this.directoryCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.directoryControl.add((Control)this.directoryCombo);
        SectionHistory.HistoryReference.DIRECTORY_HISTORY.loadHistory(this.directoryCombo);
        if (this.templateMonitor != null && this.templateMonitor.getResourceType() == MonitorRequest.MonitorResourceType.DIRECTORY) {
            this.directoryCombo.setText(this.templateMonitor.getResourceName());
        }
        this.addListener((Control)this.directoryCombo);
        this.directoryBrowseButton = new Button(dirIdentComp, 8);
        this.directoryControl.add((Control)this.directoryBrowseButton);
        this.directoryBrowseButton.setText(Elements.UI_WIZARD_V2_ITEM_DIALOG_BROWSE);
        GridData gd = new GridData(0x1000008, 0x1000000, false, false, 1, 1);
        gd.widthHint = Tools.getWidth(parent, Elements.UI_WIZARD_V2_ITEM_DIALOG_BROWSE) + 20;
        this.directoryBrowseButton.setLayoutData((Object)gd);
        this.directoryBrowseButton.setEnabled(false);
        this.directoryBrowseButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                String destinationDirectory = Tools.directoryBrowser(parent, new File(ResourceMonitorPage.this.directoryCombo.getText()), 4096);
                if (destinationDirectory != null) {
                    ResourceMonitorPage.this.directoryCombo.setText(destinationDirectory);
                }
            }
        });
        this.contentsDirectoryOptioncontrol(dirIdentComp);
        this.contentsDirectoryPollControl((Composite)directoryGroup, Elements.UI_WIZARD_V2_RESMON_POLL_FREQ_TITLE_DIRECTORY, this.directoryControl);
        this.resMonControl.add(this.directoryControl);
    }

    protected void contentsQueue(Composite parent) {
        Group queueGroup = new Group(parent, 0);
        queueGroup.setLayoutData((Object)new GridData(4, 1, true, false));
        queueGroup.setText(Elements.UI_WIZARD_V2_RESMON_QUEUE);
        queueGroup.setLayout((Layout)new GridLayout(2, false));
        this.queueControl.add((Control)queueGroup);
        Text queueTitleLabel = Tools.accessibleLabel((Composite)queueGroup, Elements.UI_WIZARD_V2_RESMON_QUEUE_TITLE);
        queueTitleLabel.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
        this.queueControl.add((Control)queueTitleLabel);
        GridData gdLabel = new GridData(0x1000008, 0x1000000, false, false);
        gdLabel.widthHint = Tools.getWidth((Composite)queueGroup, new String[]{Elements.UI_WIZARD_V2_RESMON_QUEUE_LABEL, Elements.UI_WIZARD_V2_RESMON_QUEUE_MGR_LABEL});
        Label queueLabel = new Label((Composite)queueGroup, 131072);
        queueLabel.setText(Elements.UI_WIZARD_QUEUE_LABEL);
        queueLabel.setLayoutData((Object)gdLabel);
        this.queueControl.add((Control)queueLabel);
        this.queueQueue = new Combo((Composite)queueGroup, 0);
        this.queueQueue.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.queueControl.add((Control)this.queueQueue);
        SectionHistory.HistoryReference.QUEUE_HISTORY.loadHistory(this.queueQueue);
        this.addListener((Control)this.queueQueue);
        if (this.templateMonitor != null && this.templateMonitor.getResourceType() == MonitorRequest.MonitorResourceType.QUEUE) {
            this.queueQueue.setText(this.templateMonitor.getResourceName());
        }
        Label QueueMgrLabel = new Label((Composite)queueGroup, 131072);
        this.queueControl.add((Control)QueueMgrLabel);
        QueueMgrLabel.setText(Elements.UI_WIZARD_V2_RESMON_QUEUE_MGR_LABEL);
        QueueMgrLabel.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        this.queueMgrQueue = Tools.accessibleLabel((Composite)queueGroup, this.outerWizard.getInitialPage().getSendingQMgrName());
        this.queueControl.add((Control)this.queueMgrQueue);
        this.contentsQueuePollControl((Composite)queueGroup, Elements.UI_WIZARD_V2_RESMON_POLL_FREQ_TITLE_QUEUE, this.queueControl);
        this.resMonControl.add(this.queueControl);
    }

    protected void contentsDirectoryMatchControl(Composite triggerConditionControl) {
        MonitorTriggerCondition mtc = null;
        if (this.templateMonitor != null && this.templateMonitor.getResourceType() == MonitorRequest.MonitorResourceType.DIRECTORY) {
            mtc = this.templateMonitor.getTrigger(0);
        }
        Group matchingGroup = new Group(triggerConditionControl, 0);
        matchingGroup.setLayout((Layout)new GridLayout(2, false));
        matchingGroup.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
        matchingGroup.setText(Elements.UI_WIZARD_V2_RESMON_FILE_MATCHING_GROUP);
        this.directoryControl.add((Control)matchingGroup);
        Text matchingTitleLabel = Tools.accessibleLabel((Composite)matchingGroup, Elements.UI_WIZARD_V2_RESMON_FILE_MATCHING_TITLE);
        matchingTitleLabel.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
        GridData gdLabel = new GridData(4, 0x1000000, false, false);
        gdLabel.widthHint = Tools.getWidth((Composite)matchingGroup, new String[]{Elements.UI_WIZARD_V2_RESMON_FILE_PATTERN_LABEL, Elements.UI_WIZARD_V2_RESMON_FILE_IGNORE_PATTERN_LABEL, Elements.UI_WIZARD_V2_RESMON_FILE_PATTERN_METHOD});
        Label triggerFilePatternLabel = new Label((Composite)matchingGroup, 131072);
        triggerFilePatternLabel.setText(Elements.UI_WIZARD_V2_RESMON_FILE_PATTERN_LABEL);
        triggerFilePatternLabel.setLayoutData((Object)gdLabel);
        this.directoryControl.add((Control)triggerFilePatternLabel);
        this.triggerFilePatternCombo = new Combo((Composite)matchingGroup, 0);
        this.triggerFilePatternCombo.setLayoutData((Object)new GridData(4, 1, true, false));
        this.triggerFilePatternCombo.setText("*");
        SectionHistory.HistoryReference.RESMON_FILE_PATTERN_HISTORY.loadHistory(this.triggerFilePatternCombo);
        if (mtc != null) {
            this.triggerFilePatternCombo.setText(mtc.getPattern().getPattern());
        }
        this.directoryControl.add((Control)this.triggerFilePatternCombo);
        this.addListener((Control)this.triggerFilePatternCombo);
        Label triggerFileExcludePatternLabel = new Label((Composite)matchingGroup, 131072);
        triggerFileExcludePatternLabel.setText(Elements.UI_WIZARD_V2_RESMON_FILE_IGNORE_PATTERN_LABEL);
        triggerFileExcludePatternLabel.setLayoutData((Object)gdLabel);
        this.directoryControl.add((Control)triggerFileExcludePatternLabel);
        this.triggerFileExcludePatternCombo = new Combo((Composite)matchingGroup, 0);
        this.triggerFileExcludePatternCombo.setLayoutData((Object)new GridData(4, 1, true, false));
        SectionHistory.HistoryReference.RESMON_EXCLUDE_PATTERN_HISTORY.loadHistory(this.triggerFileExcludePatternCombo);
        if (this.templateMonitor != null && this.templateMonitor.getExcludePattern() != null && this.templateMonitor.getExcludePattern().getPattern() != null) {
            this.triggerFileExcludePatternCombo.setText(this.templateMonitor.getExcludePattern().getPattern());
        }
        this.directoryControl.add((Control)this.triggerFileExcludePatternCombo);
        this.addListener((Control)this.triggerFileExcludePatternCombo);
        Label patternTypeLabel = new Label((Composite)matchingGroup, 131072);
        patternTypeLabel.setLayoutData((Object)gdLabel);
        patternTypeLabel.setText(Elements.UI_WIZARD_V2_RESMON_FILE_PATTERN_METHOD);
        this.addListener((Control)patternTypeLabel);
        this.patternsAreRegexCombo = new Combo((Composite)matchingGroup, 8);
        this.patternsAreRegexCombo.setItems(FilePatternType.getAllNames());
        if (this.templateMonitor != null) {
            MonitorTriggerCondition firstTrigger = this.templateMonitor.getTrigger(0);
            if (firstTrigger != null && firstTrigger.getPattern() != null) {
                this.patternsAreRegexCombo.select(FilePatternType.getByAgentValue(firstTrigger.getPattern().getType()).getPosition());
            } else {
                this.patternsAreRegexCombo.select(0);
            }
        } else {
            this.patternsAreRegexCombo.select(0);
        }
        this.directoryControl.add((Control)this.patternsAreRegexCombo);
        this.addListener((Control)this.patternsAreRegexCombo);
    }

    protected void contentsDirectoryTriggerContentControl(Composite triggerConditionControl) {
        Group contentGroup = new Group(triggerConditionControl, 0);
        contentGroup.setLayout((Layout)new GridLayout(1, false));
        contentGroup.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
        contentGroup.setText(Elements.UI_WIZARD_V2_RESMON_FILE_CONTENT_GROUP);
        this.contentOuterCG.add((Control)contentGroup);
        Text directoryTitleLabel = Tools.accessibleLabel((Composite)contentGroup, Elements.UI_WIZARD_V2_RESMON_FILE_CONTENT_TITLE);
        directoryTitleLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        this.contentOuterCG.add((Control)directoryTitleLabel);
        this.contentEnabled = new Button((Composite)contentGroup, 32);
        this.contentEnabled.setText(Elements.UI_WIZARD_V2_RESMON_FILE_CONTENT_CHECK);
        this.contentEnabled.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        this.contentOuterCG.add((Control)this.contentEnabled);
        Composite indentContentGroup = new Composite((Composite)contentGroup, 0);
        indentContentGroup.setLayout((Layout)Tools.indentedGridLayout(1));
        indentContentGroup.setLayoutData((Object)new GridData(1, 1, false, false));
        this.contentOuterCG.add((Control)indentContentGroup);
        final ControlGroup contentInnerCG = new ControlGroup("Content Inner Res Mon.");
        Composite buttonColumns = new Composite(indentContentGroup, 0);
        buttonColumns.setLayout((Layout)new GridLayout(2, false));
        buttonColumns.setLayoutData((Object)new GridData(4, 1, true, false));
        contentInnerCG.add((Control)buttonColumns);
        this.contentDefault = new Button(buttonColumns, 16);
        this.contentDefault.setLayoutData((Object)new GridData(4, 1, true, true, 2, 1));
        this.contentDefault.setText(Elements.UI_WIZARD_V2_RESMON_FILE_CONTENT_DEFAULT_REGEX);
        this.contentDefault.setSelection(true);
        contentInnerCG.add((Control)this.contentDefault);
        this.contentCustom = new Button(buttonColumns, 16);
        this.contentCustom.setText(Elements.UI_WIZARD_V2_RESMON_FILE_CONTENT_CUSTOM_REGEX);
        this.contentCustom.setLayoutData((Object)new GridData(4, 1, false, false));
        contentInnerCG.add((Control)this.contentCustom);
        final ControlGroup contentCustomCG = new ControlGroup("Content Custom Res Mon.");
        this.contentCustomRegEx = new Combo(buttonColumns, 0);
        this.contentCustomRegEx.setLayoutData((Object)new GridData(4, 1, true, false));
        SectionHistory.HistoryReference.RESMON_CONTENT_REGEX_HISTORY.loadHistory(this.contentCustomRegEx);
        contentCustomCG.add((Control)this.contentCustomRegEx);
        Composite order = new Composite(indentContentGroup, 0);
        order.setLayout((Layout)new GridLayout(2, false));
        order.setLayoutData((Object)new GridData(4, 1, true, false));
        Text captureOrderLabel = Tools.accessibleLabel(order, Elements.UI_WIZARD_V2_RESMON_FILE_CONTENT_REGEX_DESC);
        captureOrderLabel.setLayoutData((Object)new GridData(4, 1, false, false));
        contentCustomCG.add((Control)captureOrderLabel);
        this.contentCaptureOrder = new Combo(order, 8);
        this.contentCaptureOrder.setLayoutData((Object)new GridData(1, 1, false, false));
        this.contentCaptureOrder.setItems(TriggerContentOrderType.getAllNames());
        this.contentCaptureOrder.select(0);
        contentCustomCG.add((Control)this.contentCaptureOrder);
        contentInnerCG.add(contentCustomCG);
        this.contentOuterCG.add(contentInnerCG);
        SelectionListener contentCheckListener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                contentInnerCG.enabled(ResourceMonitorPage.this.contentEnabled.getSelection());
                ResourceMonitorPage.this.contentDefault.notifyListeners(13, new Event());
            }
        };
        this.contentEnabled.addSelectionListener(contentCheckListener);
        SelectionListener contentRegExListener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                contentCustomCG.enabled(ResourceMonitorPage.this.contentCustom.getSelection() && ResourceMonitorPage.this.contentEnabled.getSelection());
            }
        };
        this.contentDefault.addSelectionListener(contentRegExListener);
        this.contentCustom.addSelectionListener(contentRegExListener);
        this.addListener((Control)this.contentEnabled);
        this.addListener((Control)this.contentCustom);
        this.addListener((Control)this.contentCustomRegEx);
        if (this.templateMonitor != null) {
            Content content = this.templateMonitor.getTriggerContent();
            if (content != null) {
                this.contentEnabled.setSelection(true);
                if (content.isContentRegExDefault()) {
                    this.contentDefault.setSelection(true);
                    this.contentCustom.setSelection(false);
                    this.contentCaptureOrder.select(0);
                } else {
                    this.contentDefault.setSelection(false);
                    this.contentCustom.setSelection(true);
                    this.contentCustomRegEx.setText(content.getContentRegEx().toString());
                    if (content.isCaptureOrderDefault()) {
                        this.contentCaptureOrder.select(TriggerContentOrderType.getDefault().getPosition());
                    } else {
                        this.contentCaptureOrder.select(TriggerContentOrderType.getByContent(content.getCaptureOrder()).getPosition());
                    }
                }
            } else {
                this.contentEnabled.setSelection(false);
                this.contentDefault.setSelection(true);
                this.contentCustom.setSelection(false);
                this.contentCustomRegEx.clearSelection();
            }
        } else {
            this.contentEnabled.setSelection(false);
            this.contentDefault.setSelection(true);
            this.contentCustom.setSelection(false);
            this.contentCustomRegEx.clearSelection();
        }
        this.contentEnabled.notifyListeners(13, new Event());
    }

    protected void contentsDirectoryTriggerControl(Composite triggerGroup) {
        MonitorTriggerCondition mtc = null;
        if (this.templateMonitor != null && this.templateMonitor.getResourceType() == MonitorRequest.MonitorResourceType.DIRECTORY) {
            mtc = this.templateMonitor.getTrigger(0);
        }
        Text control = Tools.accessibleLabel(triggerGroup, Elements.UI_WIZARD_V2_RESMON_DIRECTORY_TRIGGER_TITLE);
        this.directoryControl.add((Control)control);
        Composite columns = new Composite(triggerGroup, 0);
        columns.setLayout((Layout)new GridLayout(2, false));
        columns.setLayoutData((Object)new GridData(4, 1, true, false));
        this.directoryControl.add((Control)columns);
        Composite buttons = new Composite(columns, 0);
        buttons.setLayout((Layout)Tools.indentedGridLayout(1));
        buttons.setLayoutData((Object)new GridData(1, 1, false, false));
        this.directoryControl.add((Control)buttons);
        this.shouldMatchButton = new Button(buttons, 16);
        this.shouldMatchButton.setLayoutData((Object)new GridData(4, 1, false, false));
        this.shouldMatchButton.setText(Elements.UI_WIZARD_V2_RESMON_TRIGGER_EXISTS_BUTTON);
        this.shouldMatchButton.setSelection(true);
        this.directoryControl.add((Control)this.shouldMatchButton);
        this.sizeUnchangedButton = new Button(buttons, 16);
        this.sizeUnchangedButton.setText(Elements.UI_WIZARD_V2_RESMON_TRIGGER_SIZE_UNCHANGED1_BUTTON);
        this.sizeUnchangedButton.setLayoutData((Object)new GridData(4, 1, false, false));
        this.directoryControl.add((Control)this.sizeUnchangedButton);
        this.exceedButton = new Button(buttons, 16);
        this.exceedButton.setText(Elements.UI_WIZARD_V2_RESMON_TRIGGER_EXCEED_BUTTON);
        this.exceedButton.setLayoutData((Object)new GridData(4, 1, false, false));
        this.directoryControl.add((Control)this.exceedButton);
        this.notExistButton = new Button(buttons, 16);
        this.notExistButton.setLayoutData((Object)new GridData(4, 1, false, false));
        this.notExistButton.setText(Elements.UI_WIZARD_V2_RESMON_TRIGGER_NOT_EXIST_BUTTON);
        this.directoryControl.add((Control)this.notExistButton);
        Composite parametersComp = new Composite(columns, 0);
        parametersComp.setLayout((Layout)Tools.indentedGridLayout(2));
        parametersComp.setLayoutData((Object)new GridData(4, 1, true, false));
        this.directoryControl.add((Control)buttons);
        Tools.addSpacer(parametersComp, 2);
        this.sizeUnchangedValueSpinner = new Spinner(parametersComp, 2048);
        this.sizeUnchangedValueSpinner.setValues(1, 1, 1024, 0, 1, 100);
        this.sizeUnchangedValueSpinner.setLayoutData((Object)new GridData(4, 1, false, false));
        this.directoryControl.add((Control)this.sizeUnchangedValueSpinner);
        new Label(parametersComp, 0);
        this.sizeValueSpinner = new Spinner(parametersComp, 2048);
        this.sizeValueSpinner.setValues(1, 0, Integer.MAX_VALUE, 0, 1, 100);
        this.sizeValueSpinner.setLayoutData((Object)new GridData(1, 1, false, false));
        this.directoryControl.add((Control)this.sizeValueSpinner);
        this.sizeTypeCombo = new Combo(parametersComp, 8);
        this.sizeTypeCombo.setLayoutData((Object)new GridData(1, 1, false, false));
        this.sizeTypeCombo.setItems(UnitType.getAllNames());
        this.sizeTypeCombo.select(0);
        this.directoryControl.add((Control)this.sizeTypeCombo);
        Tools.addSpacer(parametersComp, 2);
        if (mtc != null) {
            this.shouldMatchButton.setSelection(false);
            this.exceedButton.setSelection(false);
            this.sizeUnchangedButton.setSelection(false);
            this.notExistButton.setSelection(false);
            switch (mtc.getTriggerOperator()) {
                case FILE_EXIST: {
                    this.shouldMatchButton.setSelection(true);
                    break;
                }
                case FILE_NOT_EXIST: {
                    this.notExistButton.setSelection(true);
                    break;
                }
                case FILE_SIZE: {
                    this.exceedButton.setSelection(true);
                    this.sizeValueSpinner.setSelection(mtc.getSize());
                    this.sizeTypeCombo.select(UnitType.getByAgentValue("" + mtc.getUnits()).getPosition());
                    break;
                }
                case FILE_SIZE_SAME: {
                    this.sizeUnchangedButton.setSelection(true);
                    this.sizeUnchangedValueSpinner.setSelection(mtc.getPolls());
                }
            }
        }
        SelectionListener triggerRadioListener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                boolean exceedEnabled = ResourceMonitorPage.this.exceedButton.getSelection();
                ResourceMonitorPage.this.sizeValueSpinner.setEnabled(exceedEnabled);
                ResourceMonitorPage.this.sizeTypeCombo.setEnabled(exceedEnabled);
                ResourceMonitorPage.this.sizeUnchangedValueSpinner.setEnabled(ResourceMonitorPage.this.sizeUnchangedButton.getSelection());
                boolean contentAvailable = ResourceMonitorPage.this.shouldMatchButton.getSelection() || ResourceMonitorPage.this.sizeUnchangedButton.getSelection();
                ResourceMonitorPage.this.contentOuterCG.enabled(contentAvailable);
                if (contentAvailable && ResourceMonitorPage.this.contentEnabled != null) {
                    ResourceMonitorPage.this.contentEnabled.notifyListeners(13, new Event());
                }
            }
        };
        this.shouldMatchButton.addSelectionListener(triggerRadioListener);
        this.notExistButton.addSelectionListener(triggerRadioListener);
        this.exceedButton.addSelectionListener(triggerRadioListener);
        this.sizeUnchangedButton.addSelectionListener(triggerRadioListener);
        this.shouldMatchButton.notifyListeners(13, new Event());
    }

    protected void contentsDirectoryPollControl(Composite parent, String titleLabel, ControlGroup cg) {
        Text pollTitleLabel = Tools.accessibleLabel(parent, titleLabel);
        cg.add((Control)pollTitleLabel);
        pollTitleLabel.setLayoutData((Object)new GridData(4, 1, true, false, 3, 1));
        Composite pollIdentComp = new Composite(parent, 0);
        pollIdentComp.setLayout((Layout)Tools.indentedGridLayout(2));
        GridData gd = new GridData(4, 1, true, false, 3, 1);
        gd.verticalIndent = 10;
        pollTitleLabel.setLayoutData((Object)gd);
        cg.add((Control)pollIdentComp);
        Composite pollValueComp = new Composite(pollIdentComp, 0);
        pollValueComp.setLayout((Layout)Tools.noMarginGridLayout(2));
        Text pollIntervalLabel = Tools.accessibleLabel(pollValueComp, Elements.UI_WIZARD_POLL_INTERVAL);
        pollIntervalLabel.setLayoutData((Object)new GridData(0x1000008, 1, false, false));
        cg.add((Control)pollIntervalLabel);
        this.directoryPollIntervalValueSpinner = new Spinner(pollValueComp, 2048);
        this.directoryPollIntervalValueSpinner.setMinimum(1);
        this.directoryPollIntervalValueSpinner.setIncrement(1);
        this.directoryPollIntervalValueSpinner.setMaximum(PollIntervalType.getDefaultPIT().getMax());
        this.directoryPollIntervalValueSpinner.setLayoutData((Object)new GridData(4, 1, false, false));
        if (this.templateMonitor != null) {
            this.directoryPollIntervalValueSpinner.setSelection(this.templateMonitor.getPollInterval());
        }
        cg.add((Control)this.directoryPollIntervalValueSpinner);
        this.directoryPollIntervalTypeCombo = new Combo(pollIdentComp, 8);
        this.directoryPollIntervalTypeCombo.setItems(PollIntervalType.getAllNames());
        this.directoryPollIntervalTypeCombo.select(PollIntervalType.getDefaultPIT().getPosition());
        if (this.templateMonitor != null) {
            this.directoryPollIntervalTypeCombo.select(PollIntervalType.getByCmdEnum(this.templateMonitor.getPollUnits()).getPosition());
        }
        cg.add((Control)this.directoryPollIntervalTypeCombo);
        this.directoryPollIntervalTypeCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                Object s = e.getSource();
                if (s instanceof Combo) {
                    PollIntervalType pit = PollIntervalType.getByLabel(((Combo)s).getText());
                    ResourceMonitorPage.this.directoryPollIntervalValueSpinner.setMaximum(pit.getMax());
                    ResourceMonitorPage.this.directoryPollIntervalValueSpinner.pack();
                }
            }
        });
    }

    protected void contentsQueuePollControl(Composite parent, String titleLabel, ControlGroup cg) {
        Text pollTitleLabel = Tools.accessibleLabel(parent, titleLabel);
        cg.add((Control)pollTitleLabel);
        GridData gd = new GridData(4, 1, true, false, 3, 1);
        gd.verticalIndent = 10;
        pollTitleLabel.setLayoutData((Object)gd);
        Composite pollIdentComp = new Composite(parent, 0);
        pollIdentComp.setLayout((Layout)Tools.indentedGridLayout(3));
        pollIdentComp.setLayoutData((Object)new GridData(4, 1, true, false, 3, 1));
        cg.add((Control)pollIdentComp);
        Label pollIntervalLabel = new Label(pollIdentComp, 0);
        pollIntervalLabel.setText(Elements.UI_WIZARD_POLL_INTERVAL);
        pollIntervalLabel.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        cg.add((Control)pollIntervalLabel);
        this.queuePollIntervalValueSpinner = new Spinner(pollIdentComp, 2048);
        this.queuePollIntervalValueSpinner.setMinimum(1);
        this.queuePollIntervalValueSpinner.setIncrement(1);
        this.queuePollIntervalValueSpinner.setMaximum(PollIntervalType.getDefaultPIT().getMax());
        this.queuePollIntervalValueSpinner.setLayoutData((Object)new GridData(4, 1, false, false));
        if (this.templateMonitor != null) {
            this.queuePollIntervalValueSpinner.setSelection(this.templateMonitor.getPollInterval());
        }
        cg.add((Control)this.queuePollIntervalValueSpinner);
        this.queuePollIntervalTypeCombo = new Combo(pollIdentComp, 8);
        this.queuePollIntervalTypeCombo.setItems(PollIntervalType.getAllNames());
        this.queuePollIntervalTypeCombo.select(PollIntervalType.getDefaultPIT().getPosition());
        if (this.templateMonitor != null) {
            this.queuePollIntervalTypeCombo.select(PollIntervalType.getByCmdEnum(this.templateMonitor.getPollUnits()).getPosition());
        }
        cg.add((Control)this.queuePollIntervalTypeCombo);
        this.queuePollIntervalTypeCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                Object s = e.getSource();
                if (s instanceof Combo) {
                    PollIntervalType pit = PollIntervalType.getByLabel(((Combo)s).getText());
                    ResourceMonitorPage.this.queuePollIntervalValueSpinner.setMaximum(pit.getMax());
                    ResourceMonitorPage.this.queuePollIntervalValueSpinner.pack();
                }
            }
        });
    }

    protected void contentsBatchControl(Composite parent) {
        Composite batchOptionsComp = new Composite(parent, 0);
        batchOptionsComp.setLayout((Layout)new GridLayout(1, false));
        batchOptionsComp.setLayoutData((Object)new GridData(4, -1, true, false));
        this.batchSizeButton = new Button(batchOptionsComp, 32);
        this.batchSizeButton.setText(Elements.UI_WIZARD_V2_RESMON_BATCH_BUTTON);
        Composite indentedbatchOptionsComp = new Composite(batchOptionsComp, 0);
        indentedbatchOptionsComp.setLayout((Layout)Tools.indentedGridLayout(2));
        indentedbatchOptionsComp.setLayoutData((Object)new GridData(4, -1, true, false));
        this.batchControl.add((Control)indentedbatchOptionsComp);
        Label batchSizeLabel = new Label(indentedbatchOptionsComp, 0);
        batchSizeLabel.setText(Elements.UI_WIZARD_V2_RESMON_BATCH_SPINNER);
        batchSizeLabel.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        this.batchControl.add((Control)batchSizeLabel);
        this.batchSizeValueSpinner = new Spinner(indentedbatchOptionsComp, 2048);
        this.batchSizeValueSpinner.setValues(2, 2, 5000, 0, 1, 10);
        this.batchControl.add((Control)this.batchSizeValueSpinner);
        if (this.templateMonitor != null && this.templateMonitor.getBatchSize() > 1) {
            this.batchSizeValueSpinner.setSelection(this.templateMonitor.getBatchSize());
            this.batchControl.enabled(true);
            this.batchSizeButton.setSelection(true);
        } else {
            this.batchControl.enabled(false);
        }
        this.batchSizeButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ResourceMonitorPage.this.batchControl.enabled(ResourceMonitorPage.this.batchSizeButton.getSelection());
            }
        });
    }

    protected void contentsQueueTriggerControl(Composite triggerGroup) {
        Composite queueTriggerComp = new Composite(triggerGroup, 0);
        queueTriggerComp.setLayout((Layout)new GridLayout(1, false));
        queueTriggerComp.setLayoutData((Object)new GridData(4, 1, true, false));
        this.queueControl.add((Control)queueTriggerComp);
        Text control = Tools.accessibleLabel(queueTriggerComp, Elements.UI_WIZARD_V2_RESMON_QUEUE_TRIGGER_TITLE);
        this.queueControl.add((Control)control);
        Composite buttons = new Composite(queueTriggerComp, 0);
        buttons.setLayout((Layout)new GridLayout(2, false));
        buttons.setLayoutData((Object)PageUtils.getIndentGridData());
        this.queueNotEmptyButton = new Button(buttons, 16);
        this.queueNotEmptyButton.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
        this.queueNotEmptyButton.setText(Elements.UI_WIZARD_V2_RESMON_QUEUE_TRIGGER_MESSAGE_BUTTON);
        this.queueNotEmptyButton.setSelection(true);
        this.queueControl.add((Control)this.queueNotEmptyButton);
        this.completeGroupsButton = new Button(buttons, 16);
        this.completeGroupsButton.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
        this.completeGroupsButton.setText(Elements.UI_WIZARD_V2_RESMON_QUEUE_TRIGGER_GROUP_BUTTON);
        this.queueControl.add((Control)this.completeGroupsButton);
        if (this.templateMonitor != null && this.templateMonitor.getResourceType() == MonitorRequest.MonitorResourceType.QUEUE) {
            MonitorTriggerCondition mtc = this.templateMonitor.getTrigger(0);
            this.completeGroupsButton.setSelection(false);
            this.queueNotEmptyButton.setSelection(false);
            switch (mtc.getTriggerOperator()) {
                case COMPLETE_GROUPS: {
                    this.completeGroupsButton.setSelection(true);
                    break;
                }
                default: {
                    this.queueNotEmptyButton.setSelection(true);
                }
            }
        }
    }

    protected void contentsQueueSubVarcontrol(Composite parent) {
        Group queueMonitorOptionsGroup = new Group(parent, 0);
        queueMonitorOptionsGroup.setText(Elements.UI_WIZARD_V2_RESMON_QUEUE_SUBVAR_GROUP);
        queueMonitorOptionsGroup.setLayout((Layout)new GridLayout(2, false));
        queueMonitorOptionsGroup.setLayoutData((Object)new GridData(4, 1, true, false));
        this.queueControl.add((Control)queueMonitorOptionsGroup);
        Label titleLabel = new Label((Composite)queueMonitorOptionsGroup, 0);
        titleLabel.setText(Elements.UI_WIZARD_V2_RESMON_QUEUE_SUBVAR_TITLE);
        titleLabel.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
        GridData gdLabel = new GridData(4, 1, false, false);
        gdLabel.widthHint = Tools.getWidth((Composite)queueMonitorOptionsGroup, new String[]{Elements.UI_WIZARD_V2_RESMON_QUEUE_SUBVAR_NAME, Elements.UI_WIZARD_V2_RESMON_QUEUE_SUBVAR_VALUE});
        Label attrNameLabel = new Label((Composite)queueMonitorOptionsGroup, 131072);
        attrNameLabel.setText(Elements.UI_WIZARD_V2_RESMON_QUEUE_SUBVAR_NAME);
        attrNameLabel.setLayoutData((Object)gdLabel);
        this.queueControl.add((Control)attrNameLabel);
        final Text attrName = new Text((Composite)queueMonitorOptionsGroup, 2048);
        attrName.setLayoutData((Object)gdLabel);
        this.queueControl.add((Control)attrName);
        Label attrValueLabel = new Label((Composite)queueMonitorOptionsGroup, 131072);
        attrValueLabel.setText(Elements.UI_WIZARD_V2_RESMON_QUEUE_SUBVAR_VALUE);
        attrValueLabel.setLayoutData((Object)gdLabel);
        this.queueControl.add((Control)attrValueLabel);
        final Text attrValue = new Text((Composite)queueMonitorOptionsGroup, 2048);
        attrValue.setLayoutData((Object)new GridData(4, 1, true, false));
        this.queueControl.add((Control)attrValue);
        Label padding = new Label((Composite)queueMonitorOptionsGroup, 0);
        this.queueControl.add((Control)padding);
        Composite buttons = new Composite((Composite)queueMonitorOptionsGroup, 0);
        buttons.setLayout((Layout)Tools.noMarginGridLayout(2));
        buttons.setLayoutData((Object)new GridData(4, 1, true, false));
        this.queueControl.add((Control)buttons);
        GridData gdButton = new GridData(4, 1, false, false);
        gdButton.widthHint = 20 + Tools.getWidth((Composite)queueMonitorOptionsGroup, new String[]{Elements.UI_WIZARD_V2_RESMON_QUEUE_SUBVAR_ADD_BUTTON, Elements.UI_WIZARD_V2_RESMON_QUEUE_SUBVAR_REMOVE_BUTTON});
        final Button add = new Button(buttons, 8);
        add.setText(Elements.UI_WIZARD_V2_RESMON_QUEUE_SUBVAR_ADD_BUTTON);
        add.setLayoutData((Object)new GridData(0x1000000, 1, false, false));
        add.setLayoutData((Object)gdButton);
        add.setEnabled(false);
        final Button remove = new Button(buttons, 8);
        remove.setText(Elements.UI_WIZARD_V2_RESMON_QUEUE_SUBVAR_REMOVE_BUTTON);
        remove.setLayoutData((Object)gdButton);
        remove.setEnabled(false);
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                add.setEnabled(attrName.getText().trim().length() > 0 && attrValue.getText().trim().length() > 0);
            }
        };
        attrName.addModifyListener(modifyListener);
        attrValue.addModifyListener(modifyListener);
        Table table = new Table((Composite)queueMonitorOptionsGroup, 68354);
        GridData tableGD = new GridData(4, 1, true, false, 2, 1);
        table.setLayoutData((Object)tableGD);
        new TableColumn(table, 16384).setText(Elements.UI_WIZARD_V2_RESMON_QUEUE_SUBVAR_COL_NAME);
        new TableColumn(table, 16384).setText(Elements.UI_WIZARD_V2_RESMON_QUEUE_SUBVAR_COL_VALUE);
        table.setHeaderVisible(true);
        this.subVarTableViewer = new TableViewer(table);
        this.subVarTableViewer.setContentProvider((IContentProvider)new QueueSubVarContentProvider());
        this.subVarTableViewer.setLabelProvider((IBaseLabelProvider)new QueueSubVarLabelProvider());
        this.subVarTableViewer.setInput(this.defaultRFH2attributes);
        this.subVarTableViewer.refresh();
        tableGD.heightHint = table.getHeaderHeight() + 5 * table.getItemHeight();
        if (this.templateMonitor != null && this.templateMonitor.getDefaultVariables() != null) {
            this.defaultRFH2attributes.putAll(this.templateMonitor.getDefaultVariables());
        }
        this.subVarTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                remove.setEnabled(!event.getSelection().isEmpty());
            }
        });
        add.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                ResourceMonitorPage.this.defaultRFH2attributes.put(attrName.getText(), attrValue.getText());
                attrName.setText("");
                attrValue.setText("");
                ResourceMonitorPage.this.refreshTable();
            }
        });
        remove.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                ISelection s = ResourceMonitorPage.this.subVarTableViewer.getSelection();
                if (s instanceof IStructuredSelection) {
                    for (Object o : ((IStructuredSelection)s).toList()) {
                        if (!(o instanceof Map.Entry)) continue;
                        ResourceMonitorPage.this.defaultRFH2attributes.remove(((Map.Entry)o).getKey().toString());
                    }
                    ResourceMonitorPage.this.refreshTable();
                }
            }
        });
        table.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent arg0) {
            }

            public void controlResized(ControlEvent arg0) {
                ResourceMonitorPage.this.tableResize(ResourceMonitorPage.this.subVarTableViewer);
            }
        });
        queueMonitorOptionsGroup.layout();
        this.subVarTableViewer.refresh();
    }

    public void updateTransferTemplate(TransferTemplate template) {
        MonitorRequest monitor = this.createMonitor();
        template.setResourceMonitor(monitor);
    }

    private void contentsDirectoryOptioncontrol(Composite parent) {
        this.directoryRecursionButton = new Button(parent, 32);
        this.directoryRecursionButton.setText(Elements.UI_WIZARD_V2_RESMON_RECURSE_CHECK);
        this.directoryRecursionButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        final ControlGroup recurseCG = new ControlGroup("Recurse Res Mon.");
        Composite identRecurseComp = new Composite(parent, 0);
        identRecurseComp.setLayout((Layout)Tools.indentedGridLayout(3));
        identRecurseComp.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        Text recursionDepth = Tools.accessibleLabel(identRecurseComp, Elements.UI_WIZARD_V2_RESMON_DIRECTORY_RESOURCE_LIMIT);
        recursionDepth.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        recurseCG.add((Control)recursionDepth);
        this.directoryRecursionSpinner = new Spinner(identRecurseComp, 2048);
        this.directoryRecursionSpinner.setValues(1, 0, 99, 0, 1, 10);
        recurseCG.add((Control)this.directoryRecursionSpinner);
        Text recursionDepthPost = Tools.accessibleLabel(identRecurseComp, Elements.UI_WIZARD_V2_RESMON_DIRECTORY_RESOURCE_LIMIT_POST);
        recursionDepthPost.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        recurseCG.add((Control)recursionDepthPost);
        recurseCG.enabled(false);
        if (this.templateMonitor != null) {
            int recurseLevel = this.templateMonitor.getRecursionLevel();
            boolean recurseEnabled = recurseLevel != 0;
            this.directoryRecursionButton.setSelection(recurseEnabled);
            recurseCG.enabled(recurseEnabled);
            if (recurseEnabled) {
                this.directoryRecursionSpinner.setSelection(recurseLevel);
            }
        }
        this.directoryRecursionButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                recurseCG.enabled(ResourceMonitorPage.this.directoryRecursionButton.getSelection());
            }
        });
    }

    public void setVisible(boolean visible, WizardPage outerWizardPage) {
        this.showErrors = true;
        if (visible) {
            this.outerWizardPage = outerWizardPage;
            this.headerNameA.setText(this.outerWizard.getMonitorName());
            this.headerNameB.setText(this.outerWizard.getMonitorName());
            ResourceType rmt = this.outerWizard.getMonitorResourceType();
            if (rmt != null) {
                this.headerTypeA.setText(rmt.getNLSMessage());
                this.headerTypeB.setText(rmt.getNLSMessage());
                if (rmt == ResourceType.DIRECTORY) {
                    this.directoryControl.visible(true);
                    this.queueControl.visible(false);
                    this.contentOuterCG.visible(true);
                    ExplorerPlugin.setHelp((Control)this.outerWizard.getShell(), "com.ibm.wmqfte.explorer.context.UI_ResourceMonitorDirectory");
                } else if (rmt == ResourceType.QUEUE) {
                    this.queueControl.visible(true);
                    this.directoryControl.visible(false);
                    this.queueMgrQueue.setText(this.outerWizard.getInitialPage().getSendingQMgrName());
                    this.contentOuterCG.visible(false);
                    this.directoryBrowseButton.setEnabled(this.outerWizard.getInitialPage().isSendingMachineLocal());
                    ExplorerPlugin.setHelp((Control)this.outerWizard.getShell(), "com.ibm.wmqfte.explorer.context.UI_ResourceMonitorQueue");
                }
            } else {
                Tools.internalError(new Exception(), Elements.UI_WIZARD_V2_INTERR_INV_MONITOR_ACCESS, new Object[0]);
            }
            this.validatePage();
            this.directoryBrowseButton.setEnabled(this.outerWizard.getInitialPage().getSourceAgentDetails().isAgentLocalToMachine());
        } else {
            this.saveHistory();
        }
    }

    public boolean validatePage() {
        boolean retBool = false;
        PriorityStatus overvalStatus = null;
        PriorityStatus outerStatus = new PriorityStatus(null);
        boolean isPageA = this.outerWizardPage instanceof ResourceMonitorPageA;
        ResourceType rmt = this.outerWizard.getMonitorResourceType();
        if (rmt != null) {
            if (rmt == ResourceType.DIRECTORY) {
                overvalStatus = new PriorityStatus(outerStatus, isPageA ? this.checkDirectoryForStatus() : this.checkContentForStatus());
            } else if (rmt == ResourceType.QUEUE) {
                overvalStatus = new PriorityStatus(outerStatus, this.checkQueueForStatus());
            }
            if (overvalStatus != null) {
                retBool = overvalStatus.isComplete();
                if (this.outerWizardPage != null) {
                    if (this.showErrors) {
                        PageUtils.setStatusLine(this.outerWizardPage, (IStatus)overvalStatus.getStatus());
                    }
                    this.outerWizardPage.setPageComplete(retBool);
                }
            }
        }
        return retBool;
    }

    public void refresh(Composite outer) {
        Composite parent = outer.getParent();
        outer.setSize(parent.computeSize(parent.getSize().x, -1, true));
        parent.layout(true);
    }

    private PriorityStatus checkDirectoryForStatus() {
        PriorityStatus status = new PriorityStatus(null);
        if (Tools.isEmpty((Control)this.directoryCombo)) {
            status.setIncomplete();
        }
        if (!PatternDirectory.matcher(this.directoryCombo.getText().trim()).matches()) {
            status.setError(Elements.UI_WIZARD_V2_RESMON_DIRECTORY_INV);
        } else if (Tools.isEmpty((Control)this.triggerFilePatternCombo)) {
            status.setIncomplete();
        } else {
            boolean regEx;
            boolean bl = regEx = this.patternsAreRegexCombo != null && this.patternsAreRegexCombo.getSelectionIndex() == FilePatternType.REGEX.getPosition();
            if (regEx) {
                try {
                    if (this.triggerFilePatternCombo != null && !"".equals(this.triggerFilePatternCombo.getText().trim())) {
                        Pattern.compile(this.triggerFilePatternCombo.getText().trim());
                    }
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    status.setError(Elements.UI_WIZARD_V2_RESMON_MONITOR_INVALID_PATTERN_MESSAGE);
                }
                try {
                    if (this.triggerFileExcludePatternCombo != null && !"".equals(this.triggerFileExcludePatternCombo.getText().trim())) {
                        Pattern.compile(this.triggerFileExcludePatternCombo.getText().trim());
                    }
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    status.setError(Elements.UI_WIZARD_V2_RESMON_MONITOR_INVALID_IGNORE_MESSAGE);
                }
            }
        }
        if (status.getSeverity() == 0 && this.outerWizardPage instanceof ResourceMonitorPageA && this.triggerFilePatternCombo != null && this.triggerFileExcludePatternCombo != null && this.triggerFilePatternCombo != null && !this.comparePatterns(this.triggerFilePatternCombo.getText(), this.triggerFileExcludePatternCombo.getText(), this.patternsAreRegexCombo.getSelectionIndex() == FilePatternType.REGEX.getPosition())) {
            status.setWarning(Elements.UI_WIZARD_V2_RESMON_MONITOR_IMPOSSIBLE_PATTERN);
        }
        return status;
    }

    private PriorityStatus checkQueueForStatus() {
        PriorityStatus status = new PriorityStatus(null);
        String queueName = this.queueQueue.getText();
        if (queueName == null || queueName.length() == 0) {
            status.setIncomplete();
        } else if (!TransferItem.QueueItem.isQMgrNameValid(queueName, false)) {
            status.setError(Elements.UI_WIZARD_V2_RESMON_QUEUE_INV);
        }
        return status;
    }

    private PriorityStatus checkContentForStatus() {
        PriorityStatus status = new PriorityStatus(null);
        if (this.contentEnabled.getSelection() && this.contentCustom.getSelection()) {
            try {
                if (this.contentCustomRegEx != null && !"".equals(this.contentCustomRegEx.getText().trim())) {
                    Pattern.compile(this.contentCustomRegEx.getText().trim());
                }
            }
            catch (PatternSyntaxException patternSyntaxException) {
                status.setError(Elements.UI_WIZARD_V2_RESMON_MONITOR_INVALID_CONTENT_MESSAGE);
            }
        }
        return status;
    }

    private void addListener(Control control) {
        ModifyListener ml = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ResourceMonitorPage.this.validatePage();
            }
        };
        SelectionListener sl = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                ResourceMonitorPage.this.validatePage();
            }
        };
        if (control instanceof Text) {
            Text text = (Text)control;
            text.addModifyListener(ml);
            text.addSelectionListener(sl);
        } else if (control instanceof Combo) {
            Combo combo = (Combo)control;
            combo.addModifyListener(ml);
            combo.addSelectionListener(sl);
        } else if (control instanceof Button) {
            Button button = (Button)control;
            button.addSelectionListener(sl);
        }
    }

    public MonitorRequest createMonitor() {
        MonitorRequest monitor = null;
        if (this.validatePage()) {
            String monitorName = this.outerWizard.getMonitorName();
            String monitorAgent = this.outerWizard.getInitialPage().getSendingAgentName();
            ResourceType resourceType = this.outerWizard.getMonitorResourceType();
            MonitorRequest.MonitorResourceType mrt = resourceType == null ? null : resourceType.getCmdMonitorResourceType();
            String resourceName = resourceType == ResourceType.DIRECTORY ? this.directoryCombo.getText() : this.queueQueue.getText();
            monitor = new MonitorRequest(monitorName, monitorAgent, mrt, resourceName, "");
            monitor.setOverwrite(this.outerWizard.getInitialPage().shouldOverwriteMonitor());
            monitor.setClearHistory(this.outerWizard.getInitialPage().shouldClearMonitorHistory());
            monitor.setMetaData(this.outerWizard.getMetadataPage().getMonitorMetadata());
            if (resourceType == ResourceType.DIRECTORY) {
                MonitorPattern.Type mpt = FilePatternType.getByPosition(this.patternsAreRegexCombo.getSelectionIndex()).getAgentValue();
                String triggerFilePatternStr = this.triggerFilePatternCombo.getText();
                MonitorPattern triggermp = Tools.hasContents(triggerFilePatternStr) ? new MonitorPattern(triggerFilePatternStr, mpt) : null;
                MonitorTriggerOperator triggerOperator = this.generateTriggerOperator();
                String comparisonStr = triggerOperator == MonitorTriggerOperator.FILE_SIZE ? "GE" : null;
                UnitType unitType = UnitType.getByPosition(this.sizeTypeCombo.getSelectionIndex());
                MonitorTriggerCondition triggerCondition = new MonitorTriggerCondition(triggermp, triggerOperator, comparisonStr, unitType.getAgentValue(), this.sizeValueSpinner.getSelection());
                triggerCondition.setPolls(this.sizeUnchangedValueSpinner.getSelection());
                monitor.addTrigger(triggerCondition);
                int rl = this.directoryRecursionButton.getSelection() ? this.directoryRecursionSpinner.getSelection() : 0;
                monitor.setRecursionLevel(rl);
                String triggerFileExcludePatternStr = this.triggerFileExcludePatternCombo.getText().trim();
                MonitorPattern triggerExcludemp = Tools.hasContents(triggerFileExcludePatternStr) ? new MonitorPattern(triggerFileExcludePatternStr, mpt) : null;
                monitor.setExcludePattern(triggerExcludemp);
                monitor.setPollInterval(this.directoryPollIntervalValueSpinner.getSelection());
                PollIntervalType pollIntervalType = PollIntervalType.getByPosition(this.directoryPollIntervalTypeCombo.getSelectionIndex());
                monitor.setPollUnits(pollIntervalType.getCmdEnum());
                if (this.contentEnabled.getSelection() && this.contentEnabled.getEnabled()) {
                    String regex = null;
                    Content.ContentCaptureGroupOrder contentCaptureGroupOrder = null;
                    if (this.contentCustom.getSelection()) {
                        regex = this.contentCustomRegEx.getText();
                        contentCaptureGroupOrder = TriggerContentOrderType.getByLabel(this.contentCaptureOrder.getText()).getByContentCaptureGroupOrder();
                    }
                    try {
                        Content content = new Content(regex, contentCaptureGroupOrder);
                        monitor.setTriggerContent(content);
                    }
                    catch (Content.ContentException ce) {
                        Tools.internalError(ce, Elements.UI_WIZARD_V2_INTERR_RM_INV_CONTENT_REGEX, regex);
                    }
                }
            } else {
                String triggerParameter = this.completeGroupsButton.getSelection() ? "completegroups" : "queuenotempty";
                try {
                    MonitorTriggerCondition triggerCondition = new MonitorTriggerCondition(mrt, triggerParameter, null);
                    monitor.addTrigger(triggerCondition);
                }
                catch (InternalException e) {
                    Tools.internalError(e, Elements.UI_WIZARD_V2_INTERR_RM_INV_MONITOR, mrt.name());
                }
                monitor.setDefaultVariables(this.defaultRFH2attributes);
                monitor.setPollInterval(this.queuePollIntervalValueSpinner.getSelection());
                PollIntervalType queuePollIntervalType = PollIntervalType.getByPosition(this.queuePollIntervalTypeCombo.getSelectionIndex());
                monitor.setPollUnits(queuePollIntervalType.getCmdEnum());
            }
            if (this.batchSizeButton.getSelection()) {
                monitor.setBatchSize(this.batchSizeValueSpinner.getSelection());
            }
        } else {
            Tools.internalError(new Exception(), Elements.UI_WIZARD_V2_INTERR_RM_INCOMPLETE, new Object[0]);
        }
        return monitor;
    }

    private boolean comparePatterns(String includeMatch, String excludeMatch, boolean regExStyle) {
        boolean result = true;
        if (includeMatch != null && includeMatch.length() > 0 && excludeMatch != null && excludeMatch.length() > 0) {
            Pattern excludePattern = Pattern.compile(regExStyle ? excludeMatch : excludeMatch.replace("*", ".*"));
            result = !excludePattern.matcher(includeMatch).matches();
        }
        return result;
    }

    private MonitorTriggerOperator generateTriggerOperator() {
        MonitorTriggerOperator mto = null;
        ResourceType resourceType = this.outerWizard.getMonitorResourceType();
        if (resourceType != null) {
            if (resourceType == ResourceType.DIRECTORY) {
                if (this.shouldMatchButton.getSelection()) {
                    mto = MonitorTriggerOperator.FILE_EXIST;
                } else if (this.exceedButton.getSelection()) {
                    mto = MonitorTriggerOperator.FILE_SIZE;
                } else if (this.sizeUnchangedButton.getSelection()) {
                    mto = MonitorTriggerOperator.FILE_SIZE_SAME;
                } else if (this.notExistButton.getSelection()) {
                    mto = MonitorTriggerOperator.FILE_NOT_EXIST;
                }
            } else if (resourceType == ResourceType.QUEUE) {
                if (this.queueNotEmptyButton.getSelection()) {
                    mto = MonitorTriggerOperator.QUEUE_NOT_EMPTY;
                } else if (this.completeGroupsButton.getSelection()) {
                    mto = MonitorTriggerOperator.COMPLETE_GROUPS;
                } else {
                    Tools.internalError(new Exception(), Elements.UI_WIZARD_V2_INTERR_MTO_BAD_QUEUE_OPT, new Object[0]);
                }
            }
        }
        return mto;
    }

    private void saveHistory() {
        ResourceType resourceType = this.outerWizard.getMonitorResourceType();
        if (resourceType != null) {
            if (resourceType == ResourceType.DIRECTORY) {
                SectionHistory.HistoryReference.DIRECTORY_HISTORY.put(this.directoryCombo);
                SectionHistory.HistoryReference.RESMON_FILE_PATTERN_HISTORY.put(this.triggerFilePatternCombo);
                SectionHistory.HistoryReference.RESMON_EXCLUDE_PATTERN_HISTORY.put(this.triggerFileExcludePatternCombo);
                SectionHistory.HistoryReference.RESMON_CONTENT_REGEX_HISTORY.put(this.contentCustomRegEx);
            } else if (resourceType == ResourceType.QUEUE) {
                SectionHistory.HistoryReference.QUEUE_HISTORY.put(this.queueQueue);
            }
        }
    }

    private void refreshTable() {
        if (!Display.getCurrent().isDisposed()) {
            Display.getCurrent().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!ResourceMonitorPage.this.subVarTableViewer.getControl().isDisposed()) {
                        ResourceMonitorPage.this.subVarTableViewer.refresh();
                        Display.getCurrent().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                ResourceMonitorPage.this.tableResize(ResourceMonitorPage.this.subVarTableViewer);
                            }
                        });
                    }
                }
            });
        }
    }

    private void tableResize(TableViewer tbv) {
        Table table = tbv.getTable();
        Rectangle areaTable = table.getClientArea();
        int numCols = table.getColumnCount();
        if (numCols > 0) {
            int columnWidth = areaTable.width / table.getColumnCount();
            int idx = 0;
            while (idx < numCols) {
                table.getColumn(idx).setWidth(columnWidth);
                ++idx;
            }
        }
    }

    public static enum FilePatternType {
        WILDCARD(MonitorPattern.Type.WILDCARD, Elements.UI_WIZARD_V2_RESMON_FILE_PATTERN_METHOD_WILD),
        REGEX(MonitorPattern.Type.REGEX, Elements.UI_WIZARD_V2_RESMON_FILE_PATTERN_METHOD_REGEX);

        private final String nlsMessage;
        private final MonitorPattern.Type pattern;

        private FilePatternType(MonitorPattern.Type pattern, String nlsMessage) {
            this.nlsMessage = nlsMessage;
            this.pattern = pattern;
        }

        public String getNlSMessage() {
            return this.nlsMessage;
        }

        public MonitorPattern.Type getAgentValue() {
            return this.pattern;
        }

        public int getPosition() {
            return this.ordinal();
        }

        public static FilePatternType getByPosition(int pos) {
            return pos >= 0 && pos < FilePatternType.values().length ? FilePatternType.values()[pos] : null;
        }

        public static String[] getAllNames() {
            ArrayList<String> names = new ArrayList<String>();
            FilePatternType[] filePatternTypeArray = FilePatternType.values();
            int n = filePatternTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                FilePatternType ut = filePatternTypeArray[n2];
                names.add(ut.nlsMessage);
                ++n2;
            }
            return names.toArray(new String[0]);
        }

        public static FilePatternType getByLabel(String label) {
            int i = 0;
            while (i < UnitType.values().length) {
                if (FilePatternType.values()[i].nlsMessage.equalsIgnoreCase(label)) {
                    return FilePatternType.values()[i];
                }
                ++i;
            }
            return null;
        }

        public static FilePatternType getByAgentValue(MonitorPattern.Type agentValue) {
            int i = 0;
            while (i < UnitType.values().length) {
                if (FilePatternType.values()[i].pattern == agentValue) {
                    return FilePatternType.values()[i];
                }
                ++i;
            }
            return null;
        }
    }

    public static enum PollIntervalType {
        SECOND(Elements.UI_WIZARD_SCHEDULE_SECONDS, MonitorRequest.PollUnits.SECONDS, 59, 1),
        MINUTE(Elements.UI_WIZARD_SCHEDULE_MINUTES, MonitorRequest.PollUnits.MINUTES, 59, 1),
        HOUR(Elements.UI_WIZARD_SCHEDULE_HOURS, MonitorRequest.PollUnits.HOURS, 23, 1),
        DAY(Elements.UI_WIZARD_SCHEDULE_DAYS, MonitorRequest.PollUnits.DAYS, 99, 1);

        private static PollIntervalType defaultPIT;
        final String nlsMessage;
        final MonitorRequest.PollUnits cmdEnum;
        final int max;
        final int defaultValue;

        static {
            defaultPIT = MINUTE;
        }

        private PollIntervalType(String nlsMessage, MonitorRequest.PollUnits cmdEnum, int max, int defaultValue) {
            this.nlsMessage = nlsMessage;
            this.cmdEnum = cmdEnum;
            this.max = max;
            this.defaultValue = defaultValue;
        }

        public String getNLSMessage() {
            return this.nlsMessage;
        }

        public MonitorRequest.PollUnits getCmdEnum() {
            return this.cmdEnum;
        }

        public int getMax() {
            return this.max;
        }

        public int getDefaultValue() {
            return this.defaultValue;
        }

        public int getPosition() {
            return this.ordinal();
        }

        public static PollIntervalType getByPosition(int pos) {
            return pos >= 0 && pos < PollIntervalType.values().length ? PollIntervalType.values()[pos] : null;
        }

        public static String[] getAllNames() {
            ArrayList<String> names = new ArrayList<String>();
            PollIntervalType[] pollIntervalTypeArray = PollIntervalType.values();
            int n = pollIntervalTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                PollIntervalType pit = pollIntervalTypeArray[n2];
                names.add(pit.nlsMessage);
                ++n2;
            }
            return names.toArray(new String[0]);
        }

        public static PollIntervalType getByLabel(String label) {
            int i = 0;
            while (i < PollIntervalType.values().length) {
                if (PollIntervalType.values()[i].nlsMessage.equalsIgnoreCase(label)) {
                    return PollIntervalType.values()[i];
                }
                ++i;
            }
            return null;
        }

        public static PollIntervalType getByCmdEnum(MonitorRequest.PollUnits value) {
            int i = 0;
            while (i < PollIntervalType.values().length) {
                if (PollIntervalType.values()[i].cmdEnum == value) {
                    return PollIntervalType.values()[i];
                }
                ++i;
            }
            return null;
        }

        public static PollIntervalType getDefaultPIT() {
            return defaultPIT;
        }
    }

    public static class QueueSubVarContentProvider
    implements IStructuredContentProvider {
        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Map) {
                return ((Map)inputElement).entrySet().toArray();
            }
            if (inputElement instanceof Collection) {
                return ((Collection)inputElement).toArray();
            }
            return null;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    public static class QueueSubVarLabelProvider
    implements ITableLabelProvider {
        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)element;
                return columnIndex == 0 ? entry.getKey().toString() : entry.getValue().toString();
            }
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    public static enum ResourceType {
        DIRECTORY(Elements.UI_WIZARD_DEST_DIRECTORY_TYPE, MonitorRequest.MonitorResourceType.DIRECTORY),
        QUEUE(Elements.UI_WIZARD_DEST_MESSAGE_TYPE, MonitorRequest.MonitorResourceType.QUEUE);

        private String nlsMessage;
        private MonitorRequest.MonitorResourceType cmdMonRestType;

        private ResourceType(String nlsMessage, MonitorRequest.MonitorResourceType cmdMonRestType) {
            this.nlsMessage = nlsMessage;
            this.cmdMonRestType = cmdMonRestType;
        }

        public String getNLSMessage() {
            return this.nlsMessage;
        }

        public int getByPosition() {
            return this.ordinal();
        }

        public MonitorRequest.MonitorResourceType getCmdMonitorResourceType() {
            return this.cmdMonRestType;
        }

        public static String[] getAllNames() {
            ArrayList<String> names = new ArrayList<String>();
            ResourceType[] resourceTypeArray = ResourceType.values();
            int n = resourceTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ResourceType rmt = resourceTypeArray[n2];
                names.add(rmt.nlsMessage);
                ++n2;
            }
            return names.toArray(new String[0]);
        }

        public static ResourceType getByLabel(String label) {
            int i = 0;
            while (i < ResourceType.values().length) {
                if (ResourceType.values()[i].nlsMessage.equalsIgnoreCase(label)) {
                    return ResourceType.values()[i];
                }
                ++i;
            }
            return null;
        }

        public static ResourceType getByCmdMonitorResourceType(MonitorRequest.MonitorResourceType type) {
            int i = 0;
            while (i < ResourceType.values().length) {
                if (ResourceType.values()[i].cmdMonRestType == type) {
                    return ResourceType.values()[i];
                }
                ++i;
            }
            return null;
        }
    }

    public static enum TriggerContentOrderType {
        SRC_DEST(Elements.UI_WIZARD_V2_RESMON_FILE_CONTENT_SRC_DEST, Content.ContentCaptureGroupOrder.SRCDEST),
        DEST_SRC(Elements.UI_WIZARD_V2_RESMON_FILE_CONTENT_DEST_SRC, Content.ContentCaptureGroupOrder.DESTSRC);

        private final String nlsMessage;
        private final Content.ContentCaptureGroupOrder contentCaptureGroupOrder;

        private TriggerContentOrderType(String nlsMessage, Content.ContentCaptureGroupOrder contentCaptureGroupOrder) {
            this.nlsMessage = nlsMessage;
            this.contentCaptureGroupOrder = contentCaptureGroupOrder;
        }

        public String getNLSMessage() {
            return this.nlsMessage;
        }

        public int getPosition() {
            return this.ordinal();
        }

        public Content.ContentCaptureGroupOrder getByContentCaptureGroupOrder() {
            return this.contentCaptureGroupOrder;
        }

        public static String[] getAllNames() {
            ArrayList<String> names = new ArrayList<String>();
            TriggerContentOrderType[] triggerContentOrderTypeArray = TriggerContentOrderType.values();
            int n = triggerContentOrderTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                TriggerContentOrderType ut = triggerContentOrderTypeArray[n2];
                names.add(ut.nlsMessage);
                ++n2;
            }
            return names.toArray(new String[0]);
        }

        public static TriggerContentOrderType getByLabel(String label) {
            int i = 0;
            while (i < UnitType.values().length) {
                if (TriggerContentOrderType.values()[i].nlsMessage.equalsIgnoreCase(label)) {
                    return TriggerContentOrderType.values()[i];
                }
                ++i;
            }
            return null;
        }

        public static TriggerContentOrderType getByContent(Content.ContentCaptureGroupOrder ccgo) {
            int i = 0;
            while (i < UnitType.values().length) {
                if (TriggerContentOrderType.values()[i].contentCaptureGroupOrder == ccgo) {
                    return TriggerContentOrderType.values()[i];
                }
                ++i;
            }
            return null;
        }

        public static TriggerContentOrderType getDefault() {
            return SRC_DEST;
        }
    }

    public static enum UnitType {
        BYTE(Elements.UI_WIZARD_V2_RESMON_B, "B"),
        KILO_BYTE(Elements.UI_WIZARD_V2_RESMON_KB, "KB"),
        MEGA_BYTE(Elements.UI_WIZARD_V2_RESMON_MB, "MB"),
        GIGA_BYTE(Elements.UI_WIZARD_V2_RESMON_GB, "GB");

        private final String nlsMessage;
        private final String agentValue;

        private UnitType(String nlsMessage, String agentValue) {
            this.nlsMessage = nlsMessage;
            this.agentValue = agentValue;
        }

        public String getNlSMessage() {
            return this.nlsMessage;
        }

        public String getAgentValue() {
            return this.agentValue;
        }

        public int getPosition() {
            return this.ordinal();
        }

        public static UnitType getByPosition(int pos) {
            return pos >= 0 && pos < UnitType.values().length ? UnitType.values()[pos] : null;
        }

        public static String[] getAllNames() {
            ArrayList<String> names = new ArrayList<String>();
            UnitType[] unitTypeArray = UnitType.values();
            int n = unitTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                UnitType ut = unitTypeArray[n2];
                names.add(ut.nlsMessage);
                ++n2;
            }
            return names.toArray(new String[0]);
        }

        public static UnitType getByLabel(String label) {
            int i = 0;
            while (i < UnitType.values().length) {
                if (UnitType.values()[i].nlsMessage.equalsIgnoreCase(label)) {
                    return UnitType.values()[i];
                }
                ++i;
            }
            return null;
        }

        public static UnitType getByAgentValue(String value) {
            int i = 0;
            while (i < UnitType.values().length) {
                if (UnitType.values()[i].agentValue.equalsIgnoreCase(value)) {
                    return UnitType.values()[i];
                }
                ++i;
            }
            return null;
        }
    }
}

