/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wmqfte.explorer.wizards.pages.v2;

import com.ibm.wmqfte.explorer.Elements;
import com.ibm.wmqfte.explorer.ExplorerPlugin;
import com.ibm.wmqfte.explorer.utils.PageUtils;
import com.ibm.wmqfte.explorer.utils.v2.PriorityStatus;
import com.ibm.wmqfte.explorer.utils.v2.SectionHistory;
import com.ibm.wmqfte.explorer.utils.v2.Tools;
import com.ibm.wmqfte.explorer.wizards.v2.TransferWizardV2;
import com.ibm.wmqfte.monitor.impl.MonitorRequest;
import com.ibm.wmqfte.objects.TransferTemplate;
import com.ibm.wmqfte.utils.Metadata;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;

public class MetadataPage
extends WizardPage {
    private final MetadataSection transferMetadata;
    private final MetadataSection monitorMetadata;

    public MetadataPage(TransferWizardV2 outerWizard) {
        super(MetadataPage.class.getName(), outerWizard.getCreateType().getSubTitle(), null);
        TransferTemplate template;
        this.setDescription(Elements.UI_WIZARD_V2_METADATA_DESC);
        this.setPageComplete(true);
        this.transferMetadata = new MetadataSection(this, Elements.UI_WIZARD_ATTRIBUTE_TRANSFER_LABEL, Elements.UI_WIZARD_ATTRIBUTE_TRANSFER_SUB_TITLE_LABEL);
        if (outerWizard.isTemplateMode() && (template = outerWizard.getTransferTemplate()) != null && template.getMetadata() != null) {
            this.transferMetadata.putMetadata(template.getMetadata());
        }
        if (outerWizard.getCreateType().isResourceMonitor()) {
            MonitorRequest monitor;
            this.monitorMetadata = new MetadataSection(this, Elements.UI_WIZARD_ATTRIBUTE_MONITOR_LABEL, Elements.UI_WIZARD_ATTRIBUTE_MONITOR_SUB_TITLE_LABEL);
            if (outerWizard.isTemplateMode() && (monitor = outerWizard.getTransferTemplate().getResourceMonitor()) != null && monitor.getMetaData() != null) {
                this.monitorMetadata.putMetadata(monitor.getMetaData().getMetadata());
            }
        } else {
            this.monitorMetadata = null;
        }
    }

    public void createControl(Composite parent) {
        Composite outer = new Composite(parent, 0);
        outer.setLayout((Layout)new GridLayout());
        MetadataSection[] metadataSectionArray = new MetadataSection[]{this.transferMetadata, this.monitorMetadata};
        int n = metadataSectionArray.length;
        int n2 = 0;
        while (n2 < n) {
            MetadataSection mds = metadataSectionArray[n2];
            if (mds != null) {
                mds.createControl(outer);
            }
            ++n2;
        }
        outer.layout();
        this.setControl((Control)outer);
    }

    public IWizardPage getPrevPage() {
        return ((TransferWizardV2)this.getWizard()).getPrevPage((IWizardPage)this);
    }

    public IWizardPage getNextPage() {
        return ((TransferWizardV2)this.getWizard()).getNextPage((IWizardPage)this);
    }

    public void updateTransferTemplate(TransferTemplate template) {
        template.setMetaData(this.transferMetadata.getMetadata());
    }

    public Metadata getMonitorMetadata() {
        return this.monitorMetadata == null ? null : new Metadata(this.monitorMetadata.getMetadata());
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            ExplorerPlugin.setHelp((Control)this.getContainer().getShell(), "com.ibm.wmqfte.explorer.context.UI_MetaData");
        }
    }

    private void refreshTable(final TableViewer tbv) {
        if (!Display.getCurrent().isDisposed()) {
            Display.getCurrent().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!tbv.getControl().isDisposed()) {
                        tbv.refresh();
                    }
                }
            });
        }
    }

    public static class MetadataContentProvider
    implements IStructuredContentProvider {
        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Map) {
                return ((Map)inputElement).entrySet().toArray();
            }
            if (inputElement instanceof Collection) {
                return ((Collection)inputElement).toArray();
            }
            return null;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    public static class MetadataLabelProvider
    implements ITableLabelProvider {
        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)element;
                if (columnIndex == 0) {
                    return entry.getKey().toString();
                }
                return entry.getValue().toString();
            }
            if (element instanceof String) {
                return (String)element;
            }
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    public class MetadataSection {
        private final MetadataPage metadataPage;
        private Map<String, String> metadata = new TreeMap<String, String>();
        private Combo attrName;
        private Combo attrValue;
        private String title;
        private String subTitle;

        public MetadataSection(MetadataPage metadataPage2, String title, String subTitle) {
            this.metadataPage = metadataPage2;
            this.title = title;
            this.subTitle = subTitle;
        }

        public void putMetadata(Map<String, String> metadataParm) {
            this.metadata.putAll(metadataParm);
        }

        public void createControl(Composite parent) {
            Group c = new Group(parent, 0);
            c.setText(this.title);
            c.setLayout((Layout)new GridLayout(2, false));
            c.setLayoutData((Object)new GridData(4, 4, true, true));
            Label subtitleLabel = new Label((Composite)c, 0);
            subtitleLabel.setText(this.subTitle);
            subtitleLabel.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
            GridData gdLabel = new GridData(4, 1, false, false);
            gdLabel.widthHint = Tools.getWidth((Composite)c, new String[]{String.valueOf(Elements.UI_WIZARD_ATTRIBUTE_NAME_LABEL) + ":", String.valueOf(Elements.UI_WIZARD_ATTRIBUTE_VALUE_LABEL) + ":"});
            Label attrNameLabel = new Label((Composite)c, 0);
            attrNameLabel.setText(String.valueOf(Elements.UI_WIZARD_ATTRIBUTE_NAME_LABEL) + ":");
            attrNameLabel.setLayoutData((Object)gdLabel);
            this.attrName = new Combo((Composite)c, 2048);
            this.attrName.setLayoutData((Object)new GridData(4, 4, true, false));
            SectionHistory.HistoryReference.METADATA_NAME.loadHistory(this.attrName);
            Label attrValueLabel = new Label((Composite)c, 0);
            attrValueLabel.setText(String.valueOf(Elements.UI_WIZARD_ATTRIBUTE_VALUE_LABEL) + ":");
            attrValueLabel.setLayoutData((Object)gdLabel);
            this.attrValue = new Combo((Composite)c, 2048);
            this.attrValue.setLayoutData((Object)new GridData(4, 4, true, false));
            SectionHistory.HistoryReference.METADATA_VALUE.loadHistory(this.attrValue);
            Composite buttons = new Composite((Composite)c, 0);
            buttons.setLayout((Layout)Tools.noMarginGridLayout(2));
            buttons.setLayoutData((Object)new GridData(0x1000000, 1, true, false, 2, 1));
            GridData gdButton = new GridData(4, 1, false, false);
            gdButton.widthHint = 20 + Tools.getWidth((Composite)c, new String[]{Elements.UI_WIZARD_V2_METADATA_ADD_BUTTON, Elements.UI_WIZARD_V2_METADATA_REMOVE_BUTTON});
            final Button add = new Button(buttons, 8);
            add.setText(Elements.UI_WIZARD_V2_METADATA_ADD_BUTTON);
            add.setLayoutData((Object)gdButton);
            add.setEnabled(false);
            final Button remove = new Button(buttons, 8);
            remove.setText(Elements.UI_WIZARD_V2_METADATA_REMOVE_BUTTON);
            remove.setLayoutData((Object)gdButton);
            remove.setEnabled(false);
            ModifyListener modifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    add.setEnabled(MetadataSection.this.attrName.getText().trim().length() > 0 && MetadataSection.this.attrValue.getText().trim().length() > 0);
                    MetadataSection.this.validate();
                }
            };
            this.attrName.addModifyListener(modifyListener);
            this.attrValue.addModifyListener(modifyListener);
            Composite viewer = new Composite((Composite)c, 0);
            viewer.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
            TableColumnLayout tableColumnLayout = new TableColumnLayout();
            viewer.setLayout((Layout)tableColumnLayout);
            Table table = new Table(viewer, 68354);
            table.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
            final TableViewer attrTableViewer = new TableViewer(table);
            attrTableViewer.setContentProvider((IContentProvider)new MetadataContentProvider());
            attrTableViewer.setLabelProvider((IBaseLabelProvider)new MetadataLabelProvider());
            TableColumn nameColumn = new TableColumn(table, 16384);
            nameColumn.setText(Elements.UI_WIZARD_V2_METADATA_NAME_LABEL);
            tableColumnLayout.setColumnData((Widget)nameColumn, (ColumnLayoutData)new ColumnWeightData(50));
            TableColumn valueColumn = new TableColumn(table, 16384);
            valueColumn.setText(Elements.UI_WIZARD_V2_METADATA_VALUE_LABEL);
            tableColumnLayout.setColumnData((Widget)valueColumn, (ColumnLayoutData)new ColumnWeightData(50));
            table.setHeaderVisible(true);
            attrTableViewer.setInput(this.metadata);
            attrTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    remove.setEnabled(!event.getSelection().isEmpty());
                }
            });
            add.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }

                public void widgetSelected(SelectionEvent e) {
                    MetadataSection.this.metadata.put(MetadataSection.this.attrName.getText(), MetadataSection.this.attrValue.getText());
                    SectionHistory.HistoryReference.METADATA_NAME.put(MetadataSection.this.attrName);
                    SectionHistory.HistoryReference.METADATA_VALUE.put(MetadataSection.this.attrValue);
                    SectionHistory.HistoryReference.METADATA_NAME.loadHistory(MetadataSection.this.attrName);
                    SectionHistory.HistoryReference.METADATA_VALUE.loadHistory(MetadataSection.this.attrValue);
                    MetadataSection.this.attrName.setText("");
                    MetadataSection.this.attrValue.setText("");
                    MetadataPage.this.refreshTable(attrTableViewer);
                }
            });
            remove.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }

                public void widgetSelected(SelectionEvent e) {
                    ISelection s = attrTableViewer.getSelection();
                    if (s instanceof IStructuredSelection) {
                        for (Object o : ((IStructuredSelection)s).toList()) {
                            if (!(o instanceof Map.Entry)) continue;
                            MetadataSection.this.metadata.remove(((Map.Entry)o).getKey().toString());
                        }
                        MetadataPage.this.refreshTable(attrTableViewer);
                    }
                }
            });
        }

        public Map<String, String> getMetadata() {
            return this.metadata.isEmpty() ? null : this.metadata;
        }

        private void validate() {
            PriorityStatus status = new PriorityStatus(null);
            String newAttrName = Tools.getComboText(this.attrName);
            if (newAttrName != null && this.metadata.containsKey(newAttrName)) {
                status.setWarning(Elements.UI_WIZARD_V2_METADATA_DUPLICATE_NAME);
            }
            PageUtils.setStatusLine(this.metadataPage, (IStatus)status.getStatus());
        }
    }
}

