/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wmqfte.explorer.wizards.pages.v2;

import com.ibm.wmqfte.explorer.Elements;
import com.ibm.wmqfte.explorer.ExplorerPlugin;
import com.ibm.wmqfte.explorer.Icons;
import com.ibm.wmqfte.explorer.dialogs.ItemDialog;
import com.ibm.wmqfte.explorer.dialogs.ItemDialogUtils;
import com.ibm.wmqfte.explorer.utils.PageUtils;
import com.ibm.wmqfte.explorer.utils.v2.EnvironmentInformation;
import com.ibm.wmqfte.explorer.utils.v2.PriorityStatus;
import com.ibm.wmqfte.explorer.utils.v2.Tools;
import com.ibm.wmqfte.explorer.utils.v2.TransferItem;
import com.ibm.wmqfte.explorer.utils.v2.WizardScrolled;
import com.ibm.wmqfte.explorer.wizards.pages.v2.InitialPage;
import com.ibm.wmqfte.explorer.wizards.pages.v2.ResourceMonitorPage;
import com.ibm.wmqfte.explorer.wizards.v2.TransferWizardV2;
import com.ibm.wmqfte.monitor.impl.MonitorRequest;
import com.ibm.wmqfte.monitor.impl.MonitorTriggerCondition;
import com.ibm.wmqfte.objects.TransferTemplate;
import com.ibm.wmqfte.utils.xmlmessage.transfer.ItemSpecification;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class ItemPage
extends WizardPage {
    private Composite parent;
    private TableViewer tbv;
    private Table table;
    private GridData tableGridData;
    private Button addButton;
    private Button editButton;
    private Button copyButton;
    private Button removeButton;
    private Status status = new Status(0, "com.ibm.wmqfte.explorer", "");
    private final List<TransferItem> items = new LinkedList<TransferItem>();
    private final TransferWizardV2 outerWizard;
    private boolean complete = false;

    public ItemPage(TransferWizardV2 outerWizard) {
        super(ItemPage.class.getName(), outerWizard.getCreateType().getSubTitle(), null);
        this.outerWizard = outerWizard;
        this.setDescription(Elements.UI_WIZARD_V2_ITEM_DESC);
        this.validatePage();
    }

    public void createControl(Composite parent) {
        this.parent = parent;
        WizardScrolled ws = new WizardScrolled(parent);
        this.createBasicTabControl(ws.getContentsComposite());
        ws.finalise();
        this.setControl((Control)ws.getControlComposite());
        if (this.outerWizard.isTemplateMode()) {
            this.refreshTable();
            this.validatePage();
        } else {
            this.setPageComplete(false);
        }
        parent.addListener(1000, new Listener(){

            public void handleEvent(Event arg0) {
                ItemPage.this.validatePage();
            }
        });
    }

    public GridData getFillGridData() {
        return new GridData(4, 4, true, true);
    }

    public IWizardPage getPrevPage() {
        return ((TransferWizardV2)this.getWizard()).getPrevPage((IWizardPage)this);
    }

    public IWizardPage getNextPage() {
        return ((TransferWizardV2)this.getWizard()).getNextPage((IWizardPage)this);
    }

    public void requestValidation() {
        if (this.parent != null && !this.parent.isDisposed()) {
            this.parent.notifyListeners(1000, (Event)new ItemDialogUtils.ItemEvent(null));
        }
    }

    private void createBasicTabControl(Composite parent) {
        Composite outer = new Composite(parent, 0);
        outer.setLayout((Layout)new GridLayout(2, false));
        outer.setLayoutData((Object)new GridData(4, 4, true, true));
        final Composite tableComp = new Composite(outer, 0);
        tableComp.setLayout((Layout)new GridLayout(1, false));
        GridData tableCompGridData = new GridData(4, 4, true, true);
        tableComp.setLayoutData((Object)tableCompGridData);
        this.table = new Table(tableComp, 68354);
        this.tableGridData = new GridData(4, 4, true, true);
        this.table.setLayoutData((Object)this.tableGridData);
        this.table.setHeaderVisible(true);
        int num = 0;
        int alloc = 0;
        TableColName[] tableColNameArray = TableColName.values();
        int n = tableColNameArray.length;
        int n2 = 0;
        while (n2 < n) {
            int width;
            TableColName tcn = tableColNameArray[n2];
            TableColumn tc = new TableColumn(this.table, 16384);
            if (tcn.getNLSName() != null) {
                tc.setText(tcn.getNLSName());
            }
            if ((width = tcn.getColumnWidth((Composite)this.table)) != 0) {
                alloc += width;
                tc.setWidth(width);
            } else {
                ++num;
            }
            ++n2;
        }
        final int numWidthNotAssigned = num;
        final int totalWidthAllocated = alloc;
        this.tbv = new TableViewer(this.table);
        this.tbv.setContentProvider((IContentProvider)new ItemContentProviderV2());
        this.tbv.setLabelProvider((IBaseLabelProvider)new ItemLabelProviderV2());
        this.tbv.setInput(this.items);
        this.tbv.refresh();
        tableCompGridData.heightHint = this.table.getHeaderHeight() + 5 * (this.table.getItemHeight() + 3);
        Composite buttons = new Composite(outer, 0);
        buttons.setLayout((Layout)new GridLayout(1, false));
        buttons.setLayoutData((Object)new GridData(-1, 128, false, false));
        this.addButton = new Button(buttons, 8);
        this.addButton.setText(Elements.UI_WIZARD_V2_ITEM_DIALOG_DATASET_ADD);
        this.addButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.addButton.setEnabled(true);
        this.copyButton = new Button(buttons, 8);
        this.copyButton.setText(Elements.UI_WIZARD_V2_ITEM_DIALOG_DATASET_COPY);
        this.copyButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.copyButton.setEnabled(false);
        this.editButton = new Button(buttons, 8);
        this.editButton.setText(Elements.UI_WIZARD_V2_ITEM_DIALOG_DATASET_EDIT);
        this.editButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.editButton.setEnabled(false);
        this.removeButton = new Button(buttons, 8);
        this.removeButton.setText(Elements.UI_WIZARD_V2_ITEM_DIALOG_DATASET_REMOVE);
        this.removeButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.removeButton.setEnabled(false);
        this.tbv.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection s = event.getSelection();
                if (s instanceof IStructuredSelection) {
                    IStructuredSelection ss = (IStructuredSelection)s;
                    ItemPage.this.editButton.setEnabled(ss.size() == 1);
                    ItemPage.this.copyButton.setEnabled(ss.size() == 1);
                    ItemPage.this.removeButton.setEnabled(ss.size() > 0);
                }
            }
        });
        this.addButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }

            public void widgetSelected(SelectionEvent arg0) {
                TransferItem item = ItemPage.this.openItemDialog(null);
                if (item != null) {
                    ItemPage.this.items.add(item);
                }
                ItemPage.this.validatePage();
                ItemPage.this.refreshTable();
            }
        });
        this.editButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }

            public void widgetSelected(SelectionEvent arg0) {
                ItemPage.this.editSelectedItem();
            }
        });
        this.copyButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }

            public void widgetSelected(SelectionEvent arg0) {
                IStructuredSelection ss;
                ISelection s = ItemPage.this.tbv.getSelection();
                if (s instanceof IStructuredSelection && (ss = (IStructuredSelection)s).size() == 1) {
                    TransferItem original = (TransferItem)ss.getFirstElement();
                    TransferItem item = ItemPage.this.openItemDialog(original);
                    if (item != null) {
                        ItemPage.this.items.add(item);
                    }
                    ItemPage.this.validatePage();
                    ItemPage.this.refreshTable();
                }
            }
        });
        this.removeButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }

            public void widgetSelected(SelectionEvent arg0) {
                ISelection s = ItemPage.this.tbv.getSelection();
                if (s instanceof IStructuredSelection) {
                    IStructuredSelection ss = (IStructuredSelection)s;
                    Iterator it = ss.iterator();
                    while (it.hasNext()) {
                        ItemPage.this.items.remove(it.next());
                    }
                    ItemPage.this.validatePage();
                    ItemPage.this.tbv.refresh();
                }
            }
        });
        this.table.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent arg0) {
            }

            public void controlResized(ControlEvent arg0) {
                if (numWidthNotAssigned > 0) {
                    Rectangle areaClient = tableComp.getClientArea();
                    Rectangle areaEmptyTable = ItemPage.this.table.computeTrim(0, 0, 0, 0);
                    int availableWidth = areaClient.width - areaEmptyTable.width - totalWidthAllocated;
                    int columnWidth = availableWidth / numWidthNotAssigned;
                    TableColName[] tableColNameArray = TableColName.values();
                    int n = tableColNameArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TableColName tcn = tableColNameArray[n2];
                        if (tcn.getColumnWidth((Composite)ItemPage.this.table) == 0) {
                            TableColumn tc = ItemPage.this.table.getColumn(tcn.getPosition());
                            tc.setWidth(columnWidth);
                        }
                        ++n2;
                    }
                }
            }
        });
        this.tbv.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent arg0) {
                ItemPage.this.editSelectedItem();
            }
        });
        if (this.outerWizard.isTemplateMode()) {
            this.loadTransferTable(this.outerWizard.getTransferTemplate());
        }
        this.refreshTable();
    }

    private TransferItem openItemDialog(TransferItem original) {
        InitialPage initialPage = this.outerWizard.getInitialPage();
        TransferTemplate tt = this.outerWizard.generateTransferTemplate();
        EnvironmentInformation sourceEnvOptions = EnvironmentInformation.createSourceEnvOptions(this.outerWizard.getCreateType(), initialPage.getSourceAgentDetails());
        EnvironmentInformation destinationEnvOptions = EnvironmentInformation.createDestinationEnvOptions(this.outerWizard.getCreateType(), initialPage.getDestinationAgentDetails());
        ResourceMonitorPage.ResourceType resourceType = initialPage.getMonitorResourceType();
        MonitorRequest resourceMonitor = tt.getResourceMonitor();
        MonitorTriggerCondition resourceTrigger = resourceMonitor == null ? null : resourceMonitor.getTrigger(0);
        ItemDialog dialog = new ItemDialog(this.parent.getShell(), sourceEnvOptions, destinationEnvOptions, resourceType, resourceTrigger);
        dialog.create();
        dialog.loadValues(original);
        dialog.open();
        return dialog.getItem();
    }

    private void editSelectedItem() {
        IStructuredSelection ss;
        ISelection s = this.tbv.getSelection();
        if (s instanceof IStructuredSelection && (ss = (IStructuredSelection)s).size() == 1) {
            TransferItem original = (TransferItem)ss.getFirstElement();
            TransferItem item = this.openItemDialog(original);
            if (item != null) {
                int location = this.items.indexOf(original);
                this.items.set(location, item);
            }
            this.validatePage();
            this.refreshTable();
        }
    }

    private void refreshTable() {
        if (!Display.getCurrent().isDisposed()) {
            Display.getCurrent().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!ItemPage.this.tbv.getControl().isDisposed()) {
                        ItemPage.this.tbv.refresh();
                    }
                }
            });
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.validatePage();
        if (visible) {
            ExplorerPlugin.setHelp((Control)this.getContainer().getShell(), "com.ibm.wmqfte.explorer.context.UI_Item");
        }
    }

    public boolean isComplete() {
        return this.complete;
    }

    public boolean hasItems() {
        return !this.items.isEmpty();
    }

    private void validatePage() {
        if (this.getControl() != null && !this.getControl().isDisposed()) {
            this.clearTableStatus();
            PriorityStatus tableStatus = this.checkTableForStatus();
            if (!this.outerWizard.isSubmitable()) {
                tableStatus.demoteErrorToInformation();
            }
            if (this.items.isEmpty()) {
                tableStatus.setIncomplete();
                if (tableStatus.isOk()) {
                    tableStatus.setInformation(Elements.UI_WIZARD_V2_ITEM_WELCOME_LABEL);
                }
            }
            PageUtils.setStatusLine(this, (IStatus)tableStatus.getStatus());
            this.tbv.refresh();
            this.complete = tableStatus.isComplete();
            boolean canProceed = this.complete || !this.outerWizard.isSubmitable() && tableStatus.isOk();
            this.setPageComplete(canProceed);
        }
    }

    private PriorityStatus checkTableForStatus() {
        boolean withVarSt = this.outerWizard.getCreateType().isResourceMonitor();
        PriorityStatus pStatus = new PriorityStatus(null);
        for (TransferItem item : this.items) {
            TransferItem.QueueItem qi;
            if (!item.getSource().validate(withVarSt)) {
                this.status = new Status(4, "com.ibm.wmqfte.explorer", Elements.UI_WIZARD_V2_ITEM_SOURCE_INV);
                item.setStatus((IStatus)this.status);
                pStatus.setError(this.status);
                break;
            }
            if (!item.getDestination().validate(withVarSt)) {
                this.status = new Status(4, "com.ibm.wmqfte.explorer", Elements.UI_WIZARD_V2_ITEM_DESTINATION_INV);
                item.setStatus((IStatus)this.status);
                pStatus.setError(this.status);
                break;
            }
            if (item.getSource() instanceof TransferItem.QueueItem && !this.outerWizard.getInitialPage().isSourceQueueMessagingAvailable()) {
                this.status = new Status(4, "com.ibm.wmqfte.explorer", Elements.UI_WIZARD_V2_ITEM_SRC_BACKLEVEL);
                item.setStatus((IStatus)this.status);
                pStatus.setError(this.status);
                continue;
            }
            if (item.getDestination() instanceof TransferItem.QueueItem && !this.outerWizard.getInitialPage().isDestinationQueueMessagingAvailable()) {
                this.status = new Status(4, "com.ibm.wmqfte.explorer", Elements.UI_WIZARD_V2_ITEM_DEST_BACKLEVEL);
                item.setStatus((IStatus)this.status);
                pStatus.setError(this.status);
                continue;
            }
            TransferItem.BaseItem bi = item.getSource();
            if (bi instanceof TransferItem.QueueItem && (qi = (TransferItem.QueueItem)bi).isQMgrDefined() && !qi.isQMgr(this.outerWizard.getInitialPage().getSendingQMgrName())) {
                this.status = new Status(4, "com.ibm.wmqfte.explorer", Elements.UI_WIZARD_V2_ITEM_SRC_QUEUE_BAD);
                item.setStatus((IStatus)this.status);
                pStatus.setError(this.status);
                break;
            }
            if (!(bi instanceof TransferItem.FileItem) || !this.outerWizard.getCreateType().isResourceMonitor()) continue;
            TransferItem.FileItem fi = (TransferItem.FileItem)bi;
            int wildcardIdx = fi.getName().indexOf("*");
            if (wildcardIdx == -1) {
                wildcardIdx = fi.getName().indexOf("?");
            }
            if (wildcardIdx == -1) continue;
            this.status = new Status(2, "com.ibm.wmqfte.explorer", Elements.UI_WIZARD_V2_ITEM_MONITOR_WILD_WILD);
            item.setStatus((IStatus)this.status);
            pStatus.setWarning(this.status);
            break;
        }
        if (pStatus.isOk()) {
            List<ItemDialog.ItemType> sourceTypes = ItemDialog.ItemType.listOfItemTypes(this.outerWizard.getInitialPage().getSourceAgentDetails(), ItemDialog.LocationMenuType.Source);
            List<ItemDialog.ItemType> destinationTypes = ItemDialog.ItemType.listOfItemTypes(this.outerWizard.getInitialPage().getDestinationAgentDetails(), ItemDialog.LocationMenuType.Destination);
            for (TransferItem item : this.items) {
                if (!this.isCompatible(item.getSource(), sourceTypes)) {
                    Status status = new Status(4, "com.ibm.wmqfte.explorer", Elements.UI_WIZARD_V2_ITEM_AGENT_SRC_COMP_ERR);
                    item.setStatus((IStatus)status);
                    pStatus.setError(status);
                }
                if (this.isCompatible(item.getDestination(), destinationTypes)) continue;
                this.status = new Status(4, "com.ibm.wmqfte.explorer", Elements.UI_WIZARD_V2_ITEM_AGENT_DEST_COMP_ERR);
                item.setStatus((IStatus)this.status);
                pStatus.setError(this.status);
            }
        }
        if (this.items.size() >= 2 && pStatus.isOk()) {
            int outer = 0;
            while (outer < this.items.size()) {
                TransferItem outerItem = this.items.get(outer);
                if (outerItem.getSource() instanceof TransferItem.FileItem && outerItem.getSourceDisposition() == TransferItem.SourceDispositionType.DELETE) {
                    String outerPath = ((TransferItem.FileItem)outerItem.getSource()).getName();
                    int inner = outer + 1;
                    while (inner < this.items.size()) {
                        String innerPath;
                        TransferItem innerItem = this.items.get(inner);
                        if (innerItem.getSource() instanceof TransferItem.FileItem && this.isSamePath(outerPath, innerPath = ((TransferItem.FileItem)innerItem.getSource()).getName())) {
                            this.status = new Status(4, "com.ibm.wmqfte.explorer", Elements.UI_WIZARD_V2_ITEM_EARLIER_DISPOSITION_REMOVE);
                            outerItem.setStatus((IStatus)this.status);
                            innerItem.setStatus((IStatus)this.status);
                            pStatus.setError(this.status);
                            return pStatus;
                        }
                        ++inner;
                    }
                }
                ++outer;
            }
        }
        return pStatus;
    }

    private boolean isCompatible(TransferItem.BaseItem item, List<ItemDialog.ItemType> types) {
        boolean result;
        ItemDialog.ItemType itemType = null;
        if (item instanceof TransferItem.FileItem) {
            itemType = ItemDialog.ItemType.FILE;
        } else if (item instanceof TransferItem.DirItem) {
            itemType = ItemDialog.ItemType.DIRECTORY;
        } else if (item instanceof TransferItem.DataSetItem) {
            itemType = ItemDialog.ItemType.DATASET;
        } else if (item instanceof TransferItem.FileSpaceItem) {
            itemType = ItemDialog.ItemType.FILESPACE;
        } else if (item instanceof TransferItem.QueueItem) {
            itemType = ItemDialog.ItemType.MESSAGE;
        }
        boolean bl = result = itemType != null && types.contains((Object)itemType);
        if (!result && itemType != null && itemType == ItemDialog.ItemType.DATASET) {
            result = types.contains((Object)ItemDialog.ItemType.SDS);
        }
        return result;
    }

    private void clearTableStatus() {
        for (TransferItem item : this.items) {
            item.setStatus(null);
        }
    }

    private boolean isSamePath(String firstParm, String secondParm) {
        boolean retBool = false;
        String first = firstParm;
        String second = secondParm;
        if (first.endsWith("*")) {
            first = first.substring(0, first.length() - 2);
        }
        if (second.endsWith("*")) {
            second = second.substring(0, second.length() - 2);
        }
        retBool = first.length() < second.length() ? second.startsWith(first) : first.startsWith(second);
        return retBool;
    }

    public void updateTransferTemplate(TransferTemplate template, String sourceEndPoint, String destinationEndPoint) {
        ArrayList<ItemSpecification> itemSpecs = new ArrayList<ItemSpecification>();
        for (TransferItem transfer : this.items) {
            itemSpecs.add(transfer.createItemSpecification(sourceEndPoint, destinationEndPoint));
        }
        template.setFileSpecs(itemSpecs);
    }

    public void loadTransferTable(TransferTemplate template) {
        if (template.getFileSpecs() != null) {
            String sourceEndPointName = this.outerWizard.getInitialPage().getSourceEndPoint();
            String destinationEndPointName = this.outerWizard.getInitialPage().getDestinationEndPoint();
            for (ItemSpecification itemSpec : template.getFileSpecs()) {
                try {
                    TransferItem transferItem = new TransferItem(itemSpec);
                    this.trimEndPointName(transferItem.getSource(), sourceEndPointName);
                    this.trimEndPointName(transferItem.getDestination(), destinationEndPointName);
                    this.items.add(transferItem);
                }
                catch (TransferItem.InternalException ex) {
                    Tools.internalError(ex, ex.getLocalizedMessage(), new Object[0]);
                }
            }
            this.refreshTable();
        }
    }

    public void updateSourceAgentQMGR(String sourceAgentQmgr) {
        for (TransferItem item : this.items) {
            if (!(item.getSource() instanceof TransferItem.QueueItem)) continue;
            TransferItem.QueueItem queueItem = (TransferItem.QueueItem)item.getSource();
            String queueName = queueItem.getName();
            queueItem.setName(String.valueOf(queueName.replaceAll("@.*", "")) + "@" + sourceAgentQmgr);
        }
    }

    private void trimEndPointName(TransferItem.BaseItem item, String endPointName) {
        if (endPointName != null && item instanceof TransferItem.FileItem && item.getName().startsWith(String.valueOf(endPointName) + ":")) {
            item.setName(item.getName().substring(endPointName.length() + 1));
        }
    }

    public static class ExternalChangeEvent
    extends Event {
        public static final int ExternalListener = 1000;
        final Object obj;

        public ExternalChangeEvent(Object obj) {
            this.obj = obj;
        }

        public Object getObject() {
            return this.obj;
        }
    }

    public static class ItemContentProviderV2
    implements IStructuredContentProvider {
        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Collection) {
                return ((Collection)inputElement).toArray();
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    public static class ItemLabelProviderV2
    implements ITableLabelProvider {
        public Image getColumnImage(Object element, int columnIndex) {
            Image image = null;
            if (element instanceof TransferItem) {
                TransferItem tfr = (TransferItem)element;
                switch (TableColName.getByPosition(columnIndex)) {
                    case STATUS: {
                        if (tfr.getStatus() == null) break;
                        image = Icons.crossObj;
                        break;
                    }
                    case SOURCE: {
                        image = tfr.getSource().getImage();
                        break;
                    }
                    case DESTINATION: {
                        image = tfr.getDestination().getImage();
                    }
                }
            }
            return image;
        }

        public String getColumnText(Object element, int columnIndex) {
            String result = "";
            if (element instanceof String) {
                result = (String)element;
            } else if (element instanceof TransferItem) {
                TransferItem tfr = (TransferItem)element;
                switch (TableColName.getByPosition(columnIndex)) {
                    case STATUS: {
                        result = "";
                        break;
                    }
                    case SOURCE: {
                        result = tfr.getSource().getName();
                        break;
                    }
                    case DESTINATION: {
                        result = tfr.getDestination().getName();
                        break;
                    }
                    case MODE: {
                        result = tfr.getTransferMode().getName();
                        break;
                    }
                    case SRC_DISP: {
                        if (tfr.getSource().dispositionApplies()) {
                            result = tfr.getSourceDisposition().getName();
                            break;
                        }
                        result = Elements.UI_WIZARD_V2_ITEM_TABLE_OPT_NA;
                        break;
                    }
                    case DEST_DISP: {
                        result = tfr.getDestination().dispositionApplies() ? tfr.getDestinationDisposition().getName() : Elements.UI_WIZARD_V2_ITEM_TABLE_OPT_NA;
                    }
                }
            }
            return result;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    public static enum TableColName {
        STATUS(false, 16, null, ""),
        SOURCE(true, 0, null, Elements.UI_WIZARD_V2_ITEM_FROM_LABEL),
        DESTINATION(true, 0, null, Elements.UI_WIZARD_V2_ITEM_TO_LABEL),
        MODE(true, 0, TransferItem.TransferModeType.getAllNames(), Elements.UI_WIZARD_V2_ITEM_TABLE_HDR_MODE),
        SRC_DISP(true, 0, TransferItem.SourceDispositionType.getAllNames(), Elements.UI_WIZARD_V2_ITEM_TABLE_HDR_SRC_DISP),
        DEST_DISP(true, 0, TransferItem.DestinationDispositionType.getAllNames(), Elements.UI_WIZARD_V2_ITEM_TABLE_HDR_DEST_DISP);

        private static final int FIDDLE_FACTOR = 15;
        private final String nlsName;
        private final int fixedWidth;
        private final boolean inSummary;
        private final String[] options;

        private TableColName(boolean inSummary, int fixedWidth, String[] options, String nlsName) {
            this.nlsName = nlsName;
            this.fixedWidth = fixedWidth;
            this.inSummary = inSummary;
            this.options = options;
        }

        public String getNLSName() {
            return this.nlsName;
        }

        public int getPosition() {
            return this.ordinal();
        }

        public boolean isInSummary() {
            return this.inSummary;
        }

        public String[] getOptions() {
            return this.options;
        }

        public int getColumnWidth(Composite parent) {
            int width = this.fixedWidth;
            if (width == 0 && this.options != null) {
                int optionWidth;
                int headerWidth = Tools.getWidth(parent, this.nlsName);
                int n = width = headerWidth >= (optionWidth = Tools.getWidth(parent, this.options)) ? headerWidth : optionWidth;
            }
            if (width != 0) {
                width += 15;
            }
            return width;
        }

        public static TableColName getByName(String name) {
            TableColName[] tableColNameArray = TableColName.values();
            int n = tableColNameArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableColName tableColName = tableColNameArray[n2];
                if (tableColName.toString().equals(name)) {
                    return tableColName;
                }
                ++n2;
            }
            return null;
        }

        public static String[] getAllNames() {
            String[] allNames = new String[TableColName.values().length];
            int i = 0;
            while (i < TableColName.values().length) {
                allNames[i] = TableColName.values()[i].toString();
                ++i;
            }
            return allNames;
        }

        public static TableColName getByPosition(int position) {
            TableColName[] tableColNameArray = TableColName.values();
            int n = tableColNameArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableColName tableColName = tableColNameArray[n2];
                if (tableColName.ordinal() == position) {
                    return tableColName;
                }
                ++n2;
            }
            return null;
        }
    }
}

