/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wmqfte.explorer.wizards.pages.v2;

import com.ibm.wmqfte.explorer.Elements;
import com.ibm.wmqfte.explorer.ExplorerPlugin;
import com.ibm.wmqfte.explorer.utils.AgentDetails;
import com.ibm.wmqfte.explorer.utils.PageUtils;
import com.ibm.wmqfte.explorer.utils.v2.AgentCombo;
import com.ibm.wmqfte.explorer.utils.v2.PriorityStatus;
import com.ibm.wmqfte.explorer.utils.v2.SectionHistory;
import com.ibm.wmqfte.explorer.utils.v2.Tools;
import com.ibm.wmqfte.explorer.utils.v2.Validator;
import com.ibm.wmqfte.explorer.wizards.pages.v2.ResourceMonitorPage;
import com.ibm.wmqfte.explorer.wizards.v2.TransferWizardV2;
import com.ibm.wmqfte.monitor.impl.MonitorRequest;
import com.ibm.wmqfte.objects.TransferTemplate;
import com.ibm.wmqfte.utils.AgentType;
import com.ibm.wmqfte.utils.xmlmessage.transfer.AgentClientSpecification;
import com.ibm.wmqfte.utils.xmlmessage.transfer.AgentSpecification;
import com.ibm.wmqfte.utils.xmlmessage.transfer.ItemSpecification;
import java.text.MessageFormat;
import java.util.List;
import java.util.TimeZone;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class InitialPage
extends WizardPage {
    private final TransferWizardV2.CreateType createType;
    private final TransferWizardV2 outerWizard;
    private Text templateNameText;
    private AgentCombo sendingAgent;
    private AgentCombo receivingAgent;
    private AgentDetails sourceAgent = null;
    private AgentDetails destinationAgent = null;
    private Combo monitorName;
    private Button directoryMonitorButton;
    private Button queueMonitorButton;
    private boolean complete = false;
    private Button updateMonitorButton;
    private Button clearMonitorHistoryButton;

    public InitialPage(TransferWizardV2 outerWizard) {
        super(InitialPage.class.getName(), outerWizard.getCreateType().getSubTitle(), null);
        this.outerWizard = outerWizard;
        this.setDescription(outerWizard.getCreateType().isResourceMonitor() ? Elements.UI_WIZARD_V2_INITIAL_RESMON_DESC : Elements.UI_WIZARD_V2_INITIAL_DESC);
        this.createType = outerWizard.getCreateType();
    }

    public IWizardPage getPrevPage() {
        return ((TransferWizardV2)this.getWizard()).getPrevPage((IWizardPage)this);
    }

    public IWizardPage getNextPage() {
        return ((TransferWizardV2)this.getWizard()).getNextPage((IWizardPage)this);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite outerGroup = new Composite(parent, 0);
        outerGroup.setLayout((Layout)new GridLayout(1, false));
        if (this.createType.isTemplate()) {
            this.contentsTemplateName(outerGroup);
        }
        if (this.createType.isResourceMonitor()) {
            this.contentsMonitor(outerGroup);
        }
        this.contentsEndPoints(outerGroup);
        if (this.createType.isResourceMonitor() && !this.createType.isNameChangeable()) {
            this.updateMonitorButton = new Button(outerGroup, 32);
            this.updateMonitorButton.setText(Elements.UI_WIZARD_V2_INITIALPAGE_OVERWRITE_MONITOR_BUTTON);
            this.updateMonitorButton.setSelection(true);
            this.updateMonitorButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
            this.clearMonitorHistoryButton = new Button(outerGroup, 32);
            this.clearMonitorHistoryButton.setText(Elements.UI_WIZARD_V2_INITIALPAGE_CLEARHISTORY_BUTTON);
            this.clearMonitorHistoryButton.setSelection(false);
            this.clearMonitorHistoryButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
            this.updateMonitorButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    InitialPage.this.clearMonitorHistoryButton.setEnabled(InitialPage.this.updateMonitorButton.getSelection());
                    if (!InitialPage.this.updateMonitorButton.getSelection()) {
                        InitialPage.this.clearMonitorHistoryButton.setSelection(false);
                    }
                    InitialPage.this.validate();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
        }
        this.updateTransferForm();
        if (this.outerWizard.isTemplateMode()) {
            this.validate();
        } else {
            this.setPageComplete(false);
        }
        this.setControl((Control)outerGroup);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            String helpId;
            switch (this.createType) {
                case NEW_TEMPLATE: {
                    helpId = "com.ibm.wmqfte.explorer.context.UI_Initial_NewTemplate";
                    break;
                }
                case COPY_TEMPLATE: {
                    helpId = "com.ibm.wmqfte.explorer.context.UI_Initial_EditTemplate";
                    break;
                }
                case EXISTING_TEMPLATE: {
                    helpId = "com.ibm.wmqfte.explorer.context.UI_Initial_SubmitTemplate";
                    break;
                }
                case EDIT_TEMPLATE: {
                    helpId = "com.ibm.wmqfte.explorer.context.UI_Initial_EditTemplate";
                    break;
                }
                case NEW_MONITOR: 
                case COPY_MONITOR: {
                    helpId = "com.ibm.wmqfte.explorer.context.UI_Initial_NewMonitor";
                    break;
                }
                case EDIT_MONITOR: {
                    helpId = "com.ibm.wmqfte.explorer.context.UI_Initial_EditMonitor";
                    break;
                }
                default: {
                    helpId = "com.ibm.wmqfte.explorer.context.UI_Initial_NewTransfer";
                }
            }
            ExplorerPlugin.setHelp((Control)this.getContainer().getShell(), helpId);
        }
    }

    public ResourceMonitorPage.ResourceType getMonitorResourceType() {
        ResourceMonitorPage.ResourceType rt = null;
        if (this.createType.isResourceMonitor()) {
            rt = this.directoryMonitorButton.getSelection() ? ResourceMonitorPage.ResourceType.DIRECTORY : ResourceMonitorPage.ResourceType.QUEUE;
        }
        return rt;
    }

    public String getMonitorName() {
        return this.monitorName != null && this.monitorName.getText().length() > 0 ? this.monitorName.getText() : null;
    }

    private void contentsTemplateName(Composite parent) {
        Composite templateGroup = new Composite(parent, 0);
        templateGroup.setLayout((Layout)new GridLayout(2, false));
        templateGroup.setLayoutData((Object)new GridData(4, -1, true, false, 2, 1));
        Label templateNameLabel = new Label(templateGroup, 131072);
        if (this.createType == TransferWizardV2.CreateType.NEW_TEMPLATE || this.createType == TransferWizardV2.CreateType.COPY_TEMPLATE) {
            templateNameLabel.setText(Elements.UI_WIZARD_V2_INITIAL_NEW_TEMPLATE_NAME);
        } else if (this.createType == TransferWizardV2.CreateType.EXISTING_TEMPLATE) {
            templateNameLabel.setText(Elements.UI_WIZARD_V2_INITIAL_EXISTING_TEMPLATE_NAME);
        } else if (this.createType == TransferWizardV2.CreateType.EDIT_TEMPLATE) {
            templateNameLabel.setText(Elements.UI_WIZARD_V2_INITIAL_EDIT_TEMPLATE_NAME);
        }
        this.templateNameText = new Text(templateGroup, 2048);
        this.templateNameText.setLayoutData((Object)new GridData(4, -1, true, false));
        if (this.outerWizard.getTransferTemplate() != null) {
            this.templateNameText.setText(this.outerWizard.getTransferTemplate().getName());
        }
        this.templateNameText.setEnabled(this.createType.isNameChangeable());
        if (this.createType.isNameChangeable()) {
            this.templateNameText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    InitialPage.this.outerWizard.setWindowTitle(InitialPage.this.createType.getTitle(InitialPage.this.templateNameText.getText()));
                    InitialPage.this.validate();
                }
            });
        }
    }

    private void contentsEndPoints(Composite parent) {
        Composite endPointComp = parent;
        this.sendingAgent = new AgentCombo(endPointComp, true, this.createType, new Validator(){

            @Override
            public void Validate() {
                InitialPage.this.validate();
                InitialPage.this.outerWizard.getItemPage().updateSourceAgentQMGR(InitialPage.this.sendingAgent.getAgentDetails().getQueueManagerName());
                InitialPage.this.outerWizard.getItemPage().requestValidation();
            }
        });
        this.receivingAgent = new AgentCombo(endPointComp, false, this.createType, new Validator(){

            @Override
            public void Validate() {
                InitialPage.this.validate();
                InitialPage.this.outerWizard.getItemPage().requestValidation();
            }
        });
        if (this.outerWizard.isTemplateMode()) {
            ItemSpecification item;
            List items;
            AgentClientSpecification destinationAgent;
            AgentSpecification sourceAgent = this.outerWizard.getTransferTemplate().getSourceAgent();
            if (sourceAgent != null) {
                this.sendingAgent.setAgentName(sourceAgent.getAgentName());
            }
            if ((destinationAgent = this.outerWizard.getTransferTemplate().getDestinationAgent()) != null) {
                this.receivingAgent.setAgentName(destinationAgent.getAgentName());
            }
            boolean srcEP = this.sendingAgent.hasCDEndPoint();
            boolean destEP = this.receivingAgent.hasCDEndPoint();
            if ((srcEP || destEP) && !(items = this.outerWizard.getTransferTemplate().getFileSpecs()).isEmpty() && (item = (ItemSpecification)items.get(0)) != null) {
                String endPointname;
                if (srcEP && (endPointname = this.getEndPointName(item.getSourceName())) != null) {
                    this.sendingAgent.setEndPoint(endPointname);
                }
                if (destEP && (endPointname = this.getEndPointName(item.getDestinationName())) != null) {
                    this.receivingAgent.setEndPoint(endPointname);
                }
            }
        }
    }

    private void contentsMonitor(Composite parent) {
        Composite monitorComp = new Composite(parent, 0);
        monitorComp.setLayout((Layout)new GridLayout(2, false));
        monitorComp.setLayoutData((Object)new GridData(4, -1, true, false));
        Label monitorNameLabel = new Label(monitorComp, 0);
        monitorNameLabel.setText(Elements.UI_WIZARD_V2_INITIAL_MONITOR_NAME);
        this.monitorName = new Combo(monitorComp, 0);
        this.monitorName.setTextLimit(256);
        SectionHistory.HistoryReference.MONITOR_NAME.loadHistory(this.monitorName);
        this.monitorName.setLayoutData((Object)new GridData(4, -1, true, false));
        this.monitorName.setEnabled(this.createType.isNameChangeable());
        Group typeGroup = new Group(monitorComp, 0);
        typeGroup.setText(Elements.UI_WIZARD_V2_INITIAL_MONITOR_TYPE_GRP);
        typeGroup.setLayoutData((Object)new GridData(4, -1, true, false, 2, 1));
        this.directoryMonitorButton = new Button((Composite)typeGroup, 16);
        this.directoryMonitorButton.setText(Elements.UI_WIZARD_V2_INITIAL_MONITOR_DIRECTORY_BUTTON);
        this.directoryMonitorButton.setSelection(true);
        Tools.accessibleTextOverride((Control)this.directoryMonitorButton, Elements.UI_WIZARD_V2_INITIAL_MONITOR_DIRECTORY_DESC);
        this.queueMonitorButton = new Button((Composite)typeGroup, 16);
        this.queueMonitorButton.setText(Elements.UI_WIZARD_V2_INITIAL_MONITOR_QUEUE_BUTTON);
        this.queueMonitorButton.setSelection(false);
        Tools.accessibleTextOverride((Control)this.queueMonitorButton, Elements.UI_WIZARD_V2_INITIAL_MONITOR_QUEUE_DESC);
        Label directoryMonitorLabel = new Label((Composite)typeGroup, 0);
        directoryMonitorLabel.setText(Elements.UI_WIZARD_V2_INITIAL_MONITOR_DIRECTORY_DESC);
        Label queueMonitorLabel = new Label((Composite)typeGroup, 0);
        queueMonitorLabel.setText(Elements.UI_WIZARD_V2_INITIAL_MONITOR_QUEUE_DESC);
        typeGroup.setLayout((Layout)new FormLayout());
        int charWidth = this.convertWidthInCharsToPixels(1);
        FormData data = new FormData();
        data.top = new FormAttachment(0, charWidth);
        data.left = new FormAttachment(0, charWidth / 2);
        this.directoryMonitorButton.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.directoryMonitorButton, charWidth, -1);
        data.left = new FormAttachment(0, charWidth * 4);
        directoryMonitorLabel.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)directoryMonitorLabel, charWidth, -1);
        data.left = new FormAttachment(0, charWidth / 2);
        this.queueMonitorButton.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.queueMonitorButton, charWidth, -1);
        data.left = new FormAttachment(0, charWidth * 4);
        data.bottom = new FormAttachment(100, -charWidth);
        queueMonitorLabel.setLayoutData((Object)data);
        this.monitorName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                InitialPage.this.validate();
            }
        });
    }

    private void validate() {
        PriorityStatus receivingStatus;
        PriorityStatus sendingStatus = this.sendingAgent.getStatus();
        PriorityStatus status = new PriorityStatus(sendingStatus, receivingStatus = this.receivingAgent.getStatus());
        if (status.getSeverity() < 4) {
            boolean agentIsRestricted = this.sendingAgent.isRestrictedAgent();
            boolean unRestrictedAgentRequired = this.createType.isResourceMonitor();
            if (unRestrictedAgentRequired && agentIsRestricted) {
                status.setError(Elements.UI_WIZARD_V2_INITIAL_RESTRICTED_AGENT);
            }
        }
        if (this.createType.isTemplate() && this.createType.isNameChangeable() && status.getSeverity() < 4) {
            String templateName = this.templateNameText.getText();
            if (templateName == null || templateName.length() == 0) {
                status.setError(Elements.UI_WIZARD_V2_INITIAL_NO_TEMPLATE_NAME);
            } else if (this.outerWizard.isTemplatePresent(this.templateNameText.getText())) {
                status.setError(Elements.UI_WIZARD_V2_INITIAL_DUPLICATED_TEMPLATE_NAME);
            }
        }
        if (status.getSeverity() < 4 && this.outerWizard.isTemplateMode()) {
            if (!this.sendingAgent.isValid()) {
                status.setError(Elements.UI_WIZARD_V2_INITIAL_SRC_AGENT_NOT_PRESENT);
            }
            if (!this.receivingAgent.isValid()) {
                status.setError(Elements.UI_WIZARD_V2_INITIAL_DEST_AGENT_NOT_PRESENT);
            }
        }
        this.sourceAgent = this.sendingAgent.getAgentDetails();
        this.destinationAgent = this.receivingAgent.getAgentDetails();
        if (status.getSeverity() < 4 && this.sourceAgent != null && this.destinationAgent != null && this.sourceAgent.getAgentName().equalsIgnoreCase(this.destinationAgent.getAgentName()) && this.sourceAgent.getAgentType() == AgentType.CD_BRIDGE) {
            status.setError(Elements.UI_WIZARD_V2_INITIAL_CD_BRIDGE_AGENT_SAME);
        }
        if (this.createType.isResourceMonitor()) {
            AgentSpecification origSourceAgent;
            String agentName;
            if (this.monitorName != null && this.monitorName.getText().length() == 0) {
                status.setIncomplete();
            } else if (!MonitorRequest.isValidMonitorName((String)this.monitorName.getText())) {
                status.setError(MessageFormat.format(Elements.UI_WIZARD_V2_INITIAL_MONITOR_INV_NAME, MonitorRequest.getInvalidMonitorNameChar((String)this.monitorName.getText())));
            }
            String string = agentName = this.sendingAgent.getAgentDetails() != null ? this.sendingAgent.getAgentDetails().getAgentName() : null;
            if (this.createType.isNameChangeable() && agentName != null && this.monitorName != null && this.monitorName.getText().length() > 0 && this.outerWizard.isMonitorPresent(agentName, this.monitorName.getText().toUpperCase())) {
                status.setError(Elements.UI_WIZARD_V2_INITIAL_DUPLICATED_MONITOR_NAME);
            }
            if (!this.createType.isNameChangeable() && !this.shouldOverwriteMonitor() && (origSourceAgent = this.outerWizard.getTransferTemplate().getSourceAgent()) != null && origSourceAgent.getAgentName().equals(this.sendingAgent.getAgentDetails().getAgentName())) {
                status.setWarning(Elements.UI_WIZARD_V2_INITIALPAGE_MONITOR_ALREADY_EXISTS_WARN);
            }
        }
        PageUtils.setStatusLine(this, (IStatus)status.getStatus());
        this.complete = status.isComplete();
        boolean canProceed = !(status != null && status.getSeverity() > 2 || !this.complete && this.createType.isSubmitable());
        this.setPageComplete(canProceed);
    }

    public boolean isComplete() {
        return this.complete;
    }

    public boolean isDestinationOS(String platformName) {
        return this.destinationAgent == null || this.destinationAgent.isOSPlatform(platformName);
    }

    public boolean isSourceOS(String platformName) {
        return this.sourceAgent == null || this.sourceAgent.isOSPlatform(platformName);
    }

    public boolean isSourceQueueMessagingAvailable() {
        return this.sourceAgent == null || this.sourceAgent.isQueueMessagingAvailable();
    }

    public boolean isDestinationQueueMessagingAvailable() {
        return this.destinationAgent == null || this.destinationAgent.isQueueMessagingAvailable();
    }

    public String getReceivingAgentName() {
        return this.destinationAgent != null ? this.destinationAgent.getAgentName() : "";
    }

    public String getSendingAgentToneZone() {
        TimeZone tz;
        String retStr = "";
        if (this.sourceAgent != null && (tz = this.sourceAgent.getAgentTimeZone()) != null) {
            retStr = tz.getID();
        }
        return retStr;
    }

    public void saveHistory() {
        this.sendingAgent.saveHistory();
        this.receivingAgent.saveHistory();
    }

    public void updateTransferTemplate(TransferTemplate template) {
        AgentDetails receivingAgentDetails;
        template.setName(this.templateNameText != null ? this.templateNameText.getText() : "Internal");
        AgentDetails sendingAgentDetails = this.sendingAgent.getAgentDetails();
        if (sendingAgentDetails != null) {
            template.setSourceAgent(sendingAgentDetails.getAgentName());
            template.setSourceAgentQmgr(sendingAgentDetails.getQueueManagerName());
        }
        if ((receivingAgentDetails = this.receivingAgent.getAgentDetails()) != null) {
            template.setDestinationAgent(receivingAgentDetails.getAgentName());
            template.setDestinationAgentQmgr(receivingAgentDetails.getQueueManagerName());
        }
    }

    public String getSendingQMgrName() {
        return this.sourceAgent != null ? this.sourceAgent.getQueueManagerName() : "";
    }

    public boolean isSendingMachineLocal() {
        return this.sourceAgent != null ? this.sourceAgent.isAgentLocalToMachine() : false;
    }

    public boolean isReceivingMachineLocal() {
        return this.destinationAgent != null ? this.destinationAgent.isAgentLocalToMachine() : false;
    }

    public String getSendingAgentName() {
        return this.sourceAgent != null ? this.sourceAgent.getAgentName() : "";
    }

    public AgentType getSendingAgentType() {
        return this.sourceAgent == null ? null : this.sourceAgent.getAgentType();
    }

    public AgentType getReceivingAgentType() {
        return this.destinationAgent == null ? null : this.destinationAgent.getAgentType();
    }

    public boolean isReceivingAgent(Object agent) {
        return this.receivingAgent == agent;
    }

    public boolean isSendingAgent(Object agent) {
        return this.sendingAgent == agent;
    }

    public boolean isProgramInvocationSupportedOnSourceAgent() {
        return this.sourceAgent != null && this.sourceAgent.isProgramInvocationSupported();
    }

    public AgentDetails getSourceAgentDetails() {
        return this.sourceAgent;
    }

    public AgentDetails getDestinationAgentDetails() {
        return this.destinationAgent;
    }

    public boolean isProgramInvocationSupportedOnDestinationAgent() {
        return this.destinationAgent != null && this.destinationAgent.isProgramInvocationSupported();
    }

    public boolean shouldOverwriteMonitor() {
        boolean shouldOverwrite = false;
        if (this.createType.isResourceMonitor() && !this.createType.isNameChangeable()) {
            shouldOverwrite = this.updateMonitorButton != null && !this.updateMonitorButton.isDisposed() && this.updateMonitorButton.getSelection();
        }
        return shouldOverwrite;
    }

    public boolean shouldClearMonitorHistory() {
        boolean shouldClearHistory = false;
        if (this.shouldOverwriteMonitor()) {
            shouldClearHistory = this.clearMonitorHistoryButton != null && !this.clearMonitorHistoryButton.isDisposed() && this.clearMonitorHistoryButton.getSelection();
        }
        return shouldClearHistory;
    }

    public String getSourceEndPoint() {
        return this.sendingAgent.getEndPtName();
    }

    public String getDestinationEndPoint() {
        return this.receivingAgent.getEndPtName();
    }

    private void updateTransferForm() {
        TransferTemplate tt;
        MonitorRequest mr;
        if (this.outerWizard.isTemplateMode() && (mr = (tt = this.outerWizard.getTransferTemplate()).getResourceMonitor()) != null) {
            this.monitorName.setText(mr.getMonitorName());
            if (mr.getResourceType() == MonitorRequest.MonitorResourceType.DIRECTORY) {
                this.directoryMonitorButton.setSelection(true);
                this.queueMonitorButton.setSelection(false);
            } else {
                this.directoryMonitorButton.setSelection(false);
                this.queueMonitorButton.setSelection(true);
            }
        }
    }

    private String getEndPointName(String name) {
        String retStr = null;
        int pos = name.indexOf(":");
        if (pos != -1) {
            retStr = name.substring(0, pos);
        }
        return retStr;
    }
}

