/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wmqfte.explorer.wizards.pages.v2;

import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.wmqfte.explorer.Elements;
import com.ibm.wmqfte.explorer.ExplorerPlugin;
import com.ibm.wmqfte.explorer.dialogs.InvocationDialog;
import com.ibm.wmqfte.explorer.utils.AgentDetails;
import com.ibm.wmqfte.explorer.utils.PageUtils;
import com.ibm.wmqfte.explorer.utils.v2.ControlGroup;
import com.ibm.wmqfte.explorer.utils.v2.SectionHistory;
import com.ibm.wmqfte.explorer.utils.v2.Tools;
import com.ibm.wmqfte.explorer.utils.v2.TransferItem;
import com.ibm.wmqfte.explorer.wizards.pages.v2.InitialPage;
import com.ibm.wmqfte.explorer.wizards.v2.TransferWizardV2;
import com.ibm.wmqfte.objects.TransferTemplate;
import com.ibm.wmqfte.runcommand.CommandType;
import com.ibm.wmqfte.utils.AgentType;
import com.ibm.wmqfte.utils.xmlmessage.transfer.ItemSpecification;
import com.ibm.wmqfte.utils.xmlmessage.transfer.ProgramCall;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class AttributePage
extends WizardPage {
    public static final int REQUIRES_VALIDATION = 998;
    public static final int REFRESH_SCROLL_AREA = 999;
    private final TransferWizardV2 outerWizard;
    private Combo jobNameCombo;
    private Combo priorityCombo;
    private Combo checksumCombo;
    private InvocationDialog preSourceDialog;
    private InvocationDialog postSourceDialog;
    private InvocationDialog preDestinationDialog;
    private InvocationDialog postDestinationDialog;
    private ControlGroup checkSumCG = new ControlGroup("Attribute-Checksum");
    private ControlGroup innvocationSourceCG = new ControlGroup("Attribute-Innvocation-Source");
    private ControlGroup innvocationDestinationCG = new ControlGroup("Attribute-Innvocation-Destination");
    private static final Object[] emptyArray = new Object[1];
    private TableViewer tbvPreSource;
    private TableViewer tbvPostSource;
    private TableViewer tbvPreDestination;
    private TableViewer tbvPostDestination;
    private boolean complete = true;
    private Button recoveryDefaultModeButton;
    private Button recoveryASSAModeButton;
    private Button recoveryCustomModeButton;
    private Combo recoveryTimeoutCombo;

    public AttributePage(TransferWizardV2 outerWizard) {
        super(AttributePage.class.getName(), outerWizard.getCreateType().getSubTitle(), null);
        this.outerWizard = outerWizard;
        this.setDescription(Elements.UI_WIZARD_V2_ATTRIBUTEPAGE_DESC);
        this.setPageComplete(true);
    }

    public void createControl(Composite parent) {
        final ScrolledComposite scrolledComposite = new ScrolledComposite(parent, 768);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        scrolledComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        scrolledComposite.setAlwaysShowScrollBars(true);
        scrolledComposite.setMinWidth(0);
        final Composite container = new Composite((Composite)scrolledComposite, 0);
        this.initializeDialogUnits((Control)container);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        container.setLayout((Layout)new GridLayout(1, false));
        this.createGeneralContents(container);
        this.createCallOutContents(container);
        this.createRecoveryTimeoutContents(container);
        scrolledComposite.setContent((Control)container);
        this.setControl((Control)scrolledComposite);
        scrolledComposite.setMinHeight(container.computeSize((int)-1, (int)-1, (boolean)true).y);
        scrolledComposite.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e) {
                scrolledComposite.layout();
                container.layout();
            }

            public void controlMoved(ControlEvent e) {
            }
        });
        this.preSourceDialog = new InvocationDialog(parent.getShell(), Elements.UI_WIZARD_V2_ATTRIBUTEPAGE_PRE_SOURCE_SUMMARY, Elements.UI_WIZARD_V2_ATTRIBUTEPAGE_PRE_SOURCE_DESC);
        this.postSourceDialog = new InvocationDialog(parent.getShell(), Elements.UI_WIZARD_V2_ATTRIBUTEPAGE_POST_SOURCE_SUMMARY, Elements.UI_WIZARD_V2_ATTRIBUTEPAGE_POST_SOURCE_DESC);
        this.preDestinationDialog = new InvocationDialog(parent.getShell(), Elements.UI_WIZARD_V2_ATTRIBUTEPAGE_PRE_DEST_SUMMARY, Elements.UI_WIZARD_V2_ATTRIBUTEPAGE_PRE_DEST_DESC);
        this.postDestinationDialog = new InvocationDialog(parent.getShell(), Elements.UI_WIZARD_V2_ATTRIBUTEPAGE_POST_DEST_SUMMARY, Elements.UI_WIZARD_V2_ATTRIBUTEPAGE_POST_DEST_DESC);
        if (this.outerWizard.isTemplateMode()) {
            this.loadFromTemplate(this.outerWizard.getTransferTemplate());
        }
        scrolledComposite.notifyListeners(11, new Event());
    }

    private void createGeneralContents(Composite parent) {
        String jobName;
        Composite genComp = new Composite(parent, 0);
        genComp.setLayout((Layout)new GridLayout(2, false));
        genComp.setLayoutData((Object)new GridData(4, 4, true, false));
        Label jobNameLabel = new Label(genComp, 131072);
        jobNameLabel.setText(Elements.UI_WIZARD_V2_JOBNAME);
        jobNameLabel.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        this.jobNameCombo = new Combo(genComp, 2048);
        SectionHistory.HistoryReference.JOBNAME_HISTORY.loadHistory(this.jobNameCombo);
        this.jobNameCombo.setToolTipText(Elements.UI_WIZARD_V2_JOBNAME_DESC_LABEL);
        this.jobNameCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        if (this.outerWizard.isTemplateMode() && (jobName = this.outerWizard.getTransferTemplate().getJobName()) != null) {
            this.jobNameCombo.setText(jobName);
        }
        Label priorityLabel = new Label(genComp, 131072);
        priorityLabel.setText(Elements.UI_WIZARD_PRIORITY_LABEL);
        priorityLabel.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        this.priorityCombo = new Combo(genComp, 8);
        this.priorityCombo.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        this.priorityCombo.setToolTipText(Elements.UI_WIZARD_V2_PRIORITY_DESC_LABEL);
        String[] priorities = new String[]{"0 (" + Elements.UI_WIZARD_V2_ATTRIBUTEPAGE_LOWEST_LABEL + ")", "1", "2", "3", "4", "5", "6", "7", "8", "9 (" + Elements.UI_WIZARD_V2_ATTRIBUTEPAGE_HIGHEST_LABEL + ")"};
        this.priorityCombo.setItems(priorities);
        this.priorityCombo.select(0);
        Label checksumLabel = new Label(genComp, 131072);
        checksumLabel.setText(Elements.UI_WIZARD_CHECKSUM_LABEL);
        checksumLabel.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        this.checkSumCG.add((Control)checksumLabel);
        this.checksumCombo = new Combo(genComp, 8);
        this.checksumCombo.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        this.checksumCombo.setToolTipText("");
        this.checksumCombo.setItems(TransferItem.ChecksumType.getAllNames());
        this.checksumCombo.select(1);
        this.checkSumCG.add((Control)this.checksumCombo);
    }

    private void createCallOutContents(Composite parent) {
        Group programInvocation = new Group(parent, 0);
        programInvocation.setText(Elements.UI_WIZARD_V2_ATTRIBUTEPAGE_PROGRAM_INVOCATION_TITLE);
        programInvocation.setLayout((Layout)new GridLayout(1, true));
        programInvocation.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Text desc = new Text((Composite)programInvocation, 72);
        desc.setBackground(Display.getCurrent().getSystemColor(22));
        desc.setText(Elements.UI_WIZARD_V2_ATTRIBUTEPAGE_PROGRAM_INVOCATION_DESC);
        GridData gd = new GridData(4, 0x1000000, true, false, 2, 1);
        gd.widthHint = this.convertWidthInCharsToPixels(80);
        desc.setLayoutData((Object)gd);
        desc.setEnabled(true);
        desc.setEnabled(false);
        Group source = new Group((Composite)programInvocation, 0);
        this.innvocationSourceCG.add((Control)source);
        source.setText(Elements.UI_WIZARD_V2_ATTRIBUTEPAGE_SOURCE_TITLE);
        source.setLayout((Layout)new GridLayout(1, true));
        source.setLayoutData((Object)new GridData(4, 1, true, false));
        Composite preSource = new Composite((Composite)source, 0);
        this.innvocationSourceCG.add((Control)preSource);
        preSource.setLayoutData((Object)new GridData(4, 1, true, false));
        preSource.setLayout((Layout)new GridLayout(2, false));
        Text desc2 = Tools.accessibleLabel(preSource, Elements.UI_WIZARD_V2_ATTRIBUTEPAGE_PRE_SOURCE_DESC_LABEL);
        desc2.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 1));
        this.tbvPreSource = this.addInvocationTableViewer(preSource);
        Button button = new Button(preSource, 0);
        button.setLayoutData((Object)new GridData(4, 1, false, false));
        button.setText(Elements.UI_WIZARD_V2_ATTRIBUTEPAGE_CONFIGURE_BUTTON_LABEL);
        button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AttributePage.this.preSourceDialog.create();
                if (AttributePage.this.tbvPreSource.getInput() instanceof ProgramCall) {
                    AttributePage.this.preSourceDialog.loadValues((ProgramCall)AttributePage.this.tbvPreSource.getInput());
                } else {
                    AttributePage.this.preSourceDialog.loadValues(null);
                }
                int rc = AttributePage.this.preSourceDialog.open();
                if (rc == 0) {
                    ProgramCall programCall = AttributePage.this.preSourceDialog.getProgramCall();
                    if (programCall == null) {
                        AttributePage.this.tbvPreSource.setInput((Object)emptyArray);
                    } else {
                        AttributePage.this.tbvPreSource.setInput((Object)programCall);
                    }
                }
                AttributePage.this.checkPageForErrors();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        Composite postSource = new Composite((Composite)source, 0);
        this.innvocationSourceCG.add((Control)postSource);
        postSource.setLayoutData((Object)new GridData(4, 1, true, false));
        postSource.setLayout((Layout)new GridLayout(2, false));
        Text desc3 = Tools.accessibleLabel(postSource, Elements.UI_WIZARD_V2_ATTRIBUTEPAGE_POST_SOURCE_DESC_LABEL);
        desc3.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 1));
        this.tbvPostSource = this.addInvocationTableViewer(postSource);
        Button button2 = new Button(postSource, 0);
        button2.setLayoutData((Object)new GridData(4, 1, false, false));
        button2.setText(Elements.UI_WIZARD_V2_ATTRIBUTEPAGE_CONFIGURE_BUTTON_LABEL);
        button2.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AttributePage.this.postSourceDialog.create();
                if (AttributePage.this.tbvPostSource.getInput() instanceof ProgramCall) {
                    AttributePage.this.postSourceDialog.loadValues((ProgramCall)AttributePage.this.tbvPostSource.getInput());
                } else {
                    AttributePage.this.postSourceDialog.loadValues(null);
                }
                int rc = AttributePage.this.postSourceDialog.open();
                if (rc == 0) {
                    ProgramCall programCall = AttributePage.this.postSourceDialog.getProgramCall();
                    if (programCall == null) {
                        AttributePage.this.tbvPostSource.setInput((Object)emptyArray);
                    } else {
                        AttributePage.this.tbvPostSource.setInput((Object)programCall);
                    }
                }
                AttributePage.this.checkPageForErrors();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        Group destination = new Group((Composite)programInvocation, 0);
        this.innvocationDestinationCG.add((Control)destination);
        destination.setText(Elements.UI_WIZARD_V2_ATTRIBUTEPAGE_DESTINATION_TITLE);
        destination.setLayout((Layout)new GridLayout(1, true));
        destination.setLayoutData((Object)new GridData(4, 1, true, false));
        Composite preDestination = new Composite((Composite)destination, 0);
        this.innvocationDestinationCG.add((Control)preDestination);
        preDestination.setLayoutData((Object)new GridData(4, 1, true, false));
        preDestination.setLayout((Layout)new GridLayout(2, false));
        desc3 = Tools.accessibleLabel(preDestination, Elements.UI_WIZARD_V2_ATTRIBUTEPAGE_PRE_DEST_DESC_LABEL);
        desc3.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 1));
        this.tbvPreDestination = this.addInvocationTableViewer(preDestination);
        button2 = new Button(preDestination, 0);
        button2.setLayoutData((Object)new GridData(4, 1, false, false));
        button2.setText(Elements.UI_WIZARD_V2_ATTRIBUTEPAGE_CONFIGURE_BUTTON_LABEL);
        button2.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AttributePage.this.preDestinationDialog.create();
                if (AttributePage.this.tbvPreDestination.getInput() instanceof ProgramCall) {
                    AttributePage.this.preDestinationDialog.loadValues((ProgramCall)AttributePage.this.tbvPreDestination.getInput());
                } else {
                    AttributePage.this.preDestinationDialog.loadValues(null);
                }
                int rc = AttributePage.this.preDestinationDialog.open();
                if (rc == 0) {
                    ProgramCall programCall = AttributePage.this.preDestinationDialog.getProgramCall();
                    if (programCall == null) {
                        AttributePage.this.tbvPreDestination.setInput((Object)emptyArray);
                    } else {
                        AttributePage.this.tbvPreDestination.setInput((Object)programCall);
                    }
                }
                AttributePage.this.checkPageForErrors();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        Composite postDestination = new Composite((Composite)destination, 0);
        this.innvocationDestinationCG.add((Control)postDestination);
        postDestination.setLayoutData((Object)new GridData(4, 1, true, false));
        postDestination.setLayout((Layout)new GridLayout(2, false));
        Text desc4 = Tools.accessibleLabel(postDestination, Elements.UI_WIZARD_V2_ATTRIBUTEPAGE_POST_DEST_DESC_LABEL);
        desc4.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 1));
        this.tbvPostDestination = this.addInvocationTableViewer(postDestination);
        Button button3 = new Button(postDestination, 0);
        button3.setLayoutData((Object)new GridData(4, 1, false, false));
        button3.setText(Elements.UI_WIZARD_V2_ATTRIBUTEPAGE_CONFIGURE_BUTTON_LABEL);
        button3.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AttributePage.this.postDestinationDialog.create();
                if (AttributePage.this.tbvPostDestination.getInput() instanceof ProgramCall) {
                    AttributePage.this.postDestinationDialog.loadValues((ProgramCall)AttributePage.this.tbvPostDestination.getInput());
                } else {
                    AttributePage.this.postDestinationDialog.loadValues(null);
                }
                int rc = AttributePage.this.postDestinationDialog.open();
                if (rc == 0) {
                    ProgramCall programCall = AttributePage.this.postDestinationDialog.getProgramCall();
                    if (programCall == null) {
                        AttributePage.this.tbvPostDestination.setInput((Object)emptyArray);
                    } else {
                        AttributePage.this.tbvPostDestination.setInput((Object)programCall);
                    }
                }
                AttributePage.this.checkPageForErrors();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    private void createRecoveryTimeoutContents(Composite parent) {
        Group recoveryTimeoutGrp = new Group(parent, 0);
        recoveryTimeoutGrp.setText(Elements.UI_WIZARD_V2_ATTRIBUTEPAGE_TRANSFER_RECOVERY_TITLE);
        recoveryTimeoutGrp.setToolTipText(Elements.UI_WIZARD_V2_ATTRIBUTEPAGE_TRANSFER_RECOVERY_DESC);
        recoveryTimeoutGrp.setLayoutData((Object)new GridData(4, 1, true, false));
        recoveryTimeoutGrp.setLayout((Layout)new GridLayout(3, false));
        recoveryTimeoutGrp.setLayoutData((Object)new GridData(4, 4, true, false));
        this.recoveryDefaultModeButton = new Button((Composite)recoveryTimeoutGrp, 16);
        this.recoveryDefaultModeButton.setText(Elements.UI_WIZARD_V2_ATTRIBUTEPAGE_TRANSFER_RECOVERY_DEFAULT);
        this.recoveryDefaultModeButton.setLayoutData((Object)new GridData(1, 0x1000000, true, false, 3, 1));
        this.recoveryDefaultModeButton.setSelection(true);
        this.recoveryASSAModeButton = new Button((Composite)recoveryTimeoutGrp, 16);
        this.recoveryASSAModeButton.setText(Elements.UI_WIZARD_V2_ATTRIBUTEPAGE_TRANSFER_RECOVERY_ASSA);
        this.recoveryASSAModeButton.setLayoutData((Object)new GridData(1, 0x1000000, true, false, 3, 1));
        this.recoveryCustomModeButton = new Button((Composite)recoveryTimeoutGrp, 16);
        this.recoveryCustomModeButton.setText(Elements.UI_WIZARD_V2_ATTRIBUTEPAGE_TRANSFER_RECOVERY_TIMEOUT_SUFIX);
        this.recoveryCustomModeButton.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.recoveryTimeoutCombo = new Combo((Composite)recoveryTimeoutGrp, 2048);
        SectionHistory.HistoryReference.RECOVERYTIMEOUT_VALUE.loadHistory(this.recoveryTimeoutCombo);
        this.recoveryTimeoutCombo.setToolTipText(Elements.UI_WIZARD_V2_ATTRIBUTEPAGE_TRANSFER_RECOVERY_TIMEOUT_DESC);
        this.recoveryTimeoutCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.recoveryTimeoutCombo.setTextLimit(9);
        this.recoveryTimeoutCombo.setEnabled(false);
        this.recoveryTimeoutCombo.addListener(25, new Listener(){

            public void handleEvent(Event e) {
                String string = e.text;
                char[] chars = new char[string.length()];
                string.getChars(0, chars.length, chars, 0);
                int i = 0;
                while (i < chars.length) {
                    if ('0' > chars[i] || chars[i] > '9') {
                        e.doit = false;
                        return;
                    }
                    ++i;
                }
            }
        });
        this.recoveryCustomModeButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                boolean mode = AttributePage.this.recoveryCustomModeButton.getSelection();
                AttributePage.this.recoveryTimeoutCombo.setEnabled(mode);
            }
        });
    }

    private TableViewer addInvocationTableViewer(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayoutData((Object)new GridData(4, 1, true, false));
        container.setLayout((Layout)new GridLayout(2, false));
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        container.setLayout((Layout)tableColumnLayout);
        TableViewer tbv = new TableViewer(container, 68352);
        tbv.setContentProvider((IContentProvider)new InvocationContentProvider());
        tbv.setLabelProvider((IBaseLabelProvider)new InvocationLabelProvider());
        Table table = tbv.getTable();
        table.setHeaderVisible(false);
        table.setLinesVisible(false);
        table.setLayoutData((Object)new GridData(4, 1, true, false));
        TableColumn keyColumn = new TableColumn(table, 0);
        tableColumnLayout.setColumnData((Widget)keyColumn, (ColumnLayoutData)new ColumnPixelData(this.convertWidthInCharsToPixels(Elements.UI_WIZARD_V2_ATTRIBUTEPAGE_TYPE_HEADER.length() + 4), true, true));
        TableColumn valueColumn = new TableColumn(table, 0);
        tableColumnLayout.setColumnData((Widget)valueColumn, (ColumnLayoutData)new ColumnWeightData(100, true));
        tbv.setInput((Object)emptyArray);
        table.setVisible(true);
        return tbv;
    }

    public IWizardPage getPrevPage() {
        return ((TransferWizardV2)this.getWizard()).getPrevPage((IWizardPage)this);
    }

    public IWizardPage getNextPage() {
        return ((TransferWizardV2)this.getWizard()).getNextPage((IWizardPage)this);
    }

    public void loadFromTemplate(TransferTemplate transferTemplate) {
        ProgramCall pc;
        String jobName = transferTemplate.getJobName();
        if (jobName != null) {
            this.jobNameCombo.setText(jobName);
        }
        this.priorityCombo.select(transferTemplate.getPriority());
        if (transferTemplate.getTransferRecoveryTimeout() == -1) {
            this.recoveryDefaultModeButton.setSelection(true);
            this.recoveryASSAModeButton.setSelection(false);
            this.recoveryCustomModeButton.setSelection(false);
            this.recoveryTimeoutCombo.setEnabled(false);
        } else if (transferTemplate.getTransferRecoveryTimeout() == -2) {
            this.recoveryDefaultModeButton.setSelection(false);
            this.recoveryASSAModeButton.setSelection(true);
            this.recoveryTimeoutCombo.setEnabled(false);
        } else if (transferTemplate.getTransferRecoveryTimeout() >= 0) {
            this.recoveryDefaultModeButton.setSelection(false);
            this.recoveryASSAModeButton.setSelection(false);
            this.recoveryCustomModeButton.setSelection(true);
            this.recoveryTimeoutCombo.setEnabled(true);
            this.recoveryTimeoutCombo.setText(String.valueOf(transferTemplate.getTransferRecoveryTimeout()));
        } else {
            this.recoveryDefaultModeButton.setSelection(true);
            this.recoveryASSAModeButton.setSelection(false);
            this.recoveryCustomModeButton.setSelection(false);
            this.recoveryTimeoutCombo.setEnabled(false);
        }
        if (transferTemplate.getFileSpecs() != null && transferTemplate.getFileSpecs().size() > 0) {
            this.checksumCombo.select(TransferItem.ChecksumType.getByAgentEnum(((ItemSpecification)transferTemplate.getFileSpecs().get(0)).getChecksumMethodType()).getPosition());
        }
        this.tbvPreSource.setInput((Object)((pc = transferTemplate.getPreSourceCall()) == null ? emptyArray : pc));
        this.tbvPreSource.refresh();
        pc = transferTemplate.getPostSourceCall();
        this.tbvPostSource.setInput((Object)(pc == null ? emptyArray : pc));
        this.tbvPostSource.refresh();
        pc = transferTemplate.getPreDestinationCall();
        this.tbvPreDestination.setInput((Object)(pc == null ? emptyArray : pc));
        this.tbvPreDestination.refresh();
        pc = transferTemplate.getPostDestinationCall();
        this.tbvPostDestination.setInput((Object)(pc == null ? emptyArray : pc));
        this.tbvPostDestination.refresh();
    }

    public void updateTransferTemplate(TransferTemplate template) {
        template.setPriority(this.priorityCombo.getSelectionIndex());
        template.setJobName(this.jobNameCombo.getText());
        template.setTransferRecoveryTimeout(this.getTransferRecoveryTimeout());
        template.updateChecksumType(TransferItem.ChecksumType.getByPositon(this.checksumCombo.getSelectionIndex()).getAgentEnum());
        Object obj = this.tbvPreSource.getInput();
        if (obj != null && obj instanceof ProgramCall) {
            template.setPreSourceCall((ProgramCall)obj);
        }
        if ((obj = this.tbvPostSource.getInput()) != null && obj instanceof ProgramCall) {
            template.setPostSourceCall((ProgramCall)obj);
        }
        if ((obj = this.tbvPreDestination.getInput()) != null && obj instanceof ProgramCall) {
            template.setPreDestinationCall((ProgramCall)obj);
        }
        if ((obj = this.tbvPostDestination.getInput()) != null && obj instanceof ProgramCall) {
            template.setPostDestinatioinCall((ProgramCall)obj);
        }
    }

    public void saveHistory() {
        String jobName = this.jobNameCombo.getText();
        if (jobName != null && jobName.length() > 0) {
            SectionHistory.HistoryReference.JOBNAME_HISTORY.put(jobName);
        }
        if (this.recoveryCustomModeButton.getSelection()) {
            String timeout = this.recoveryTimeoutCombo.getText();
            SectionHistory.HistoryReference.RECOVERYTIMEOUT_VALUE.put(timeout);
        }
    }

    private int getTransferRecoveryTimeout() {
        int timeout = -2;
        if (this.recoveryDefaultModeButton.getSelection()) {
            timeout = -1;
        } else if (this.recoveryCustomModeButton.getSelection()) {
            timeout = Integer.parseInt(this.recoveryTimeoutCombo.getText());
        }
        return timeout;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            AgentDetails destAgentDetails;
            InitialPage initialPage = this.outerWizard.getInitialPage();
            boolean sourceSupported = initialPage.isProgramInvocationSupportedOnSourceAgent();
            boolean destinationSupported = initialPage.isProgramInvocationSupportedOnDestinationAgent();
            AgentDetails sourceAgentDetails = initialPage.getSourceAgentDetails();
            if (sourceAgentDetails != null && sourceAgentDetails.isOSPlatform("4690 OS")) {
                this.preSourceDialog.setAgentDetails(sourceAgentDetails);
                this.postSourceDialog.setAgentDetails(sourceAgentDetails);
            }
            if ((destAgentDetails = initialPage.getDestinationAgentDetails()) != null && destAgentDetails.isOSPlatform("4690 OS")) {
                this.preDestinationDialog.setAgentDetails(initialPage.getDestinationAgentDetails());
                this.postDestinationDialog.setAgentDetails(initialPage.getDestinationAgentDetails());
            }
            this.innvocationSourceCG.enabled(sourceSupported);
            this.innvocationDestinationCG.enabled(destinationSupported);
            this.checkSumCG.enabled(this.outerWizard.getItemPage().hasItems());
            Control control = this.getControl();
            if (control instanceof ScrolledComposite) {
                ((ScrolledComposite)control).setAlwaysShowScrollBars(false);
            }
            ExplorerPlugin.setHelp((Control)this.getContainer().getShell(), "com.ibm.wmqfte.explorer.context.UI_Attributes");
        }
    }

    private void checkPageForErrors() {
        String msg;
        if (this.getControl() == null || this.getControl().isDisposed()) {
            return;
        }
        TransferTemplate tt = this.outerWizard.generateTransferTemplate();
        Status status = null;
        if (this.tbvPreDestination.getInput() instanceof ProgramCall || this.tbvPostDestination.getInput() instanceof ProgramCall) {
            AgentDetails destinationAgent = this.outerWizard.getInitialPage().getDestinationAgentDetails();
            if (destinationAgent.getAgentType() == AgentType.BRIDGE || destinationAgent.getAgentType() == AgentType.CD_BRIDGE) {
                msg = Message.format((String)Elements.UI_WIZARD_V2_ATTRIBUTEPAGE_PROGRAM_INVOCATION_BRIDGE_DEST_AGENT_NOT_SUPPORTED, (String)destinationAgent.getAgentType().getDisplayValue());
                status = new Status(2, "com.ibm.wmqfte.explorer", msg);
            }
            if (tt.isAnyDestinationItemQueue()) {
                msg = Elements.UI_WIZARD_V2_ATTRIBUTEPAGE_PROGRAM_INVOCATION_QUEUE_DEST_NOT_SUPPORTED;
                status = new Status(2, "com.ibm.wmqfte.explorer", msg);
            }
        }
        if (this.tbvPreSource.getInput() instanceof ProgramCall || this.tbvPostSource.getInput() instanceof ProgramCall) {
            AgentDetails sourceAgent = this.outerWizard.getInitialPage().getSourceAgentDetails();
            if (sourceAgent.getAgentType() == AgentType.BRIDGE || sourceAgent.getAgentType() == AgentType.CD_BRIDGE) {
                msg = Message.format((String)Elements.UI_WIZARD_V2_ATTRIBUTEPAGE_PROGRAM_INVOCATION_BRIDGE_SRC_AGENT_NOT_SUPPORTED, (String)sourceAgent.getAgentType().getDisplayValue());
                status = new Status(2, "com.ibm.wmqfte.explorer", msg);
            }
            if (tt.isAnySourceItemQueue()) {
                msg = Elements.UI_WIZARD_V2_ATTRIBUTEPAGE_PROGRAM_INVOCATION_QUEUE_SRC_NOT_SUPPORTED;
                status = new Status(2, "com.ibm.wmqfte.explorer", msg);
            }
        }
        if (status == null) {
            status = new Status(0, "com.ibm.wmqfte.explorer", "");
        }
        PageUtils.setStatusLine(this, status);
    }

    public boolean isComplete() {
        return this.complete;
    }

    public static void main(String[] args) {
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setLayout((Layout)new GridLayout());
        shell.setText(String.valueOf(AttributePage.class.getSimpleName()) + " Example");
        TransferWizardV2 wizard = new TransferWizardV2(TransferWizardV2.CreateType.NEW_TRANSFER, null);
        AttributePage attributePage = new AttributePage(wizard);
        attributePage.createControl((Composite)shell);
        shell.setSize(600, 800);
        shell.open();
        shell.layout();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    private class InvocationContentProvider
    implements IStructuredContentProvider {
        private InvocationContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            Table table;
            if (viewer instanceof TableViewer && (table = ((TableViewer)viewer).getTable()) != null) {
                Layout layout = table.getParent().getLayout();
                if (layout instanceof TableColumnLayout) {
                    Object[] elements;
                    int maxLength = 0;
                    Object[] objectArray = elements = this.getElements(newInput);
                    int n = elements.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object key;
                        Object element = objectArray[n2];
                        if (element instanceof Map.Entry && (key = ((Map.Entry)element).getKey()) instanceof String) {
                            maxLength = Math.max(((String)key).length(), maxLength);
                        }
                        ++n2;
                    }
                    ((TableColumnLayout)layout).setColumnData((Widget)table.getColumn(0), (ColumnLayoutData)new ColumnPixelData(AttributePage.this.convertWidthInCharsToPixels(maxLength + 4), true, true));
                }
                Display.getCurrent().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        Control control = AttributePage.this.getControl();
                        if (control != null && !control.isDisposed()) {
                            control.notifyListeners(11, new Event());
                            if (control instanceof ScrolledComposite) {
                                ScrolledComposite scrolledComposite = (ScrolledComposite)control;
                                Point computedSize = scrolledComposite.getContent().computeSize(-1, -1, true);
                                scrolledComposite.setMinHeight(computedSize.y);
                                control.notifyListeners(11, new Event());
                            }
                        }
                    }
                });
            }
        }

        public Object[] getElements(Object inputElement) {
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            map.put(Elements.UI_WIZARD_V2_ATTRIBUTEPAGE_TYPE_HEADER, Elements.UI_WIZARD_V2_ATTRIBUTEPAGE_NONE);
            if (inputElement instanceof ProgramCall) {
                ProgramCall call = (ProgramCall)inputElement;
                CommandType type = call.getCommandType();
                map.put(Elements.UI_WIZARD_V2_ATTRIBUTEPAGE_TYPE_HEADER, this.getTypeString(type));
                if (type == CommandType.EXECUTABLE) {
                    map.put(Elements.UI_WIZARD_V2_ATTRIBUTEPAGE_EXECUTABLE_HEADER, call.getCommand());
                    map.put(Elements.UI_WIZARD_V2_ATTRIBUTEPAGE_ARGUMENTS_HEADER, call.getArguments());
                    map.put(Elements.UI_WIZARD_V2_ATTRIBUTEPAGE_SUCCESSRC_HEADER, this.getSuccessRcString(call));
                } else if (type == CommandType.ANTSCRIPT) {
                    map.put(Elements.UI_WIZARD_V2_ATTRIBUTEPAGE_SCRIPT_HEADER, call.getCommand());
                    map.put(Elements.UI_WIZARD_V2_ATTRIBUTEPAGE_TARGETS_HEADER, call.getTargets());
                    map.put(Elements.UI_WIZARD_V2_ATTRIBUTEPAGE_SUCCESSRC_HEADER, this.getSuccessRcString(call));
                } else if (type == CommandType.JCL) {
                    map.put(Elements.UI_WIZARD_V2_ATTRIBUTEPAGE_JOB_STREAM_HEADER, call.getCommand());
                }
            }
            return map.entrySet().toArray();
        }

        private String getTypeString(CommandType type) {
            String result;
            switch (type) {
                case ANTSCRIPT: {
                    result = Elements.UI_WIZARD_V2_ATTRIBUTEPAGE_TYPE_ANT_LABEL;
                    break;
                }
                case EXECUTABLE: {
                    result = Elements.UI_WIZARD_V2_ATTRIBUTEPAGE_TYPE_EXECUTABLE_LABEL;
                    break;
                }
                case JCL: {
                    result = Elements.UI_WIZARD_V2_ATTRIBUTEPAGE_TYPE_JCL_LABEL;
                    break;
                }
                default: {
                    result = type.toString();
                }
            }
            return result;
        }

        private String getSuccessRcString(ProgramCall call) {
            String success = call.getSuccesRC();
            String result = success != null && success.length() > 0 ? (success.charAt(0) == '<' ? String.valueOf(Elements.UI_WIZARD_V2_INVOCATION_DIALOG_IS_LESS_THAN) + ' ' + success.substring(1) : (success.charAt(0) == '!' ? String.valueOf(Elements.UI_WIZARD_V2_INVOCATION_DIALOG_DOES_NOT_EQUAL) + ' ' + success.substring(1) : (success.charAt(0) == '>' ? String.valueOf(Elements.UI_WIZARD_V2_INVOCATION_DIALOG_IS_GREATER_THAN) + ' ' + success.substring(1) : String.valueOf(Elements.UI_WIZARD_V2_INVOCATION_DIALOG_EQUALS) + ' ' + success))) : null;
            return result;
        }
    }

    private class InvocationLabelProvider
    implements ITableLabelProvider {
        private InvocationLabelProvider() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)element;
                String result = columnIndex == 0 ? (entry.getKey() == null ? "" : entry.getKey().toString()) : (entry.getValue() == null ? "" : entry.getValue().toString());
                return result;
            }
            return null;
        }
    }
}

