/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wmqfte.explorer.wizards.pages;

import com.ibm.wmqfte.explorer.Elements;
import com.ibm.wmqfte.explorer.Icons;
import com.ibm.wmqfte.utils.xmlmessage.transfer.ItemSpecification;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;

class TransferLabelProvider
implements ITableLabelProvider {
    private static final String binary = Elements.UI_WIZARD_BINARY_LABEL;
    private static final String text = Elements.UI_WIZARD_TEXT_LABEL;

    TransferLabelProvider() {
    }

    public Image getColumnImage(Object element, int columnIndex) {
        Image image = null;
        if (element instanceof ItemSpecification) {
            ItemSpecification tfr = (ItemSpecification)element;
            switch (columnIndex) {
                case 0: {
                    if (tfr.getSourceType() == ItemSpecification.SourceType.FILE) {
                        image = Icons.fileObj;
                        break;
                    }
                    if (tfr.getSourceType() != ItemSpecification.SourceType.QUEUE) break;
                    image = Icons.localQueueObj;
                    break;
                }
                case 1: {
                    if (tfr.getDestinationType() == ItemSpecification.DestinationType.FILE) {
                        image = Icons.fileObj;
                        break;
                    }
                    if (tfr.getDestinationType() == ItemSpecification.DestinationType.DIRECTORY) {
                        image = Icons.directoryObj;
                        break;
                    }
                    if (tfr.getDestinationType() == ItemSpecification.DestinationType.DATASET) {
                        image = Icons.datasetObj;
                        break;
                    }
                    if (tfr.getDestinationType() == ItemSpecification.DestinationType.PDS) {
                        image = Icons.pdsObj;
                        break;
                    }
                    if (tfr.getDestinationType() == ItemSpecification.DestinationType.QUEUE) {
                        image = Icons.localQueueObj;
                        break;
                    }
                    if (tfr.getDestinationType() != ItemSpecification.DestinationType.FILESPACE) break;
                    image = Icons.filespaceObj;
                }
            }
        }
        return image;
    }

    public String getColumnText(Object element, int columnIndex) {
        String result = "";
        if (element instanceof String) {
            result = (String)element;
        } else if (element instanceof ItemSpecification) {
            ItemSpecification tfr = (ItemSpecification)element;
            switch (columnIndex) {
                case 0: {
                    result = tfr.getSourceName();
                    break;
                }
                case 1: {
                    result = tfr.getDestinationName();
                    break;
                }
                case 2: {
                    if (ItemSpecification.TransferMode.TEXT == tfr.getTransferModeType()) {
                        result = text;
                        break;
                    }
                    result = binary;
                    break;
                }
                case 3: {
                    result = ItemSpecification.SourceDisposition.DELETE.name().equalsIgnoreCase(tfr.getSourceDispositionStr()) ? Elements.UI_WIZARD_DISPOSITION_REMOVE_LABEL : Elements.UI_WIZARD_DISPOSITION_KEEP_LABEL;
                    break;
                }
                case 4: {
                    result = ItemSpecification.DestinationExist.OVERWRITE.name().equalsIgnoreCase(tfr.getDestinationExistsStr()) ? Elements.UI_WIZARD_YES_LABEL : Elements.UI_WIZARD_NO_LABEL;
                    break;
                }
                case 5: {
                    result = ItemSpecification.ChecksumMethod.NONE.name().equalsIgnoreCase(tfr.getChecksumMethod()) ? Elements.UI_WIZARD_NO_LABEL : Elements.UI_WIZARD_YES_LABEL;
                }
            }
        }
        return result;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

