/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wmqfte.explorer.wizards.pages;

import com.ibm.wmqfte.explorer.Elements;
import com.ibm.wmqfte.explorer.data.Subscription;
import com.ibm.wmqfte.explorer.utils.PageUtils;
import com.ibm.wmqfte.explorer.wizards.pages.AgentContentProvider;
import com.ibm.wmqfte.explorer.wizards.pages.AgentLabelProvider;
import com.ibm.wmqfte.utils.AgentStatusDetails;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;

public class StopAgentPage
extends WizardPage {
    Combo agentCombo;

    public StopAgentPage(String pageName) {
        super(pageName);
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, false));
        Group agent = new Group(composite, 0);
        agent.setText(Elements.UI_WIZARD_HOST_LABEL);
        agent.setLayout((Layout)new GridLayout(3, false));
        GridData agentGd = new GridData(4, 4, false, false);
        agent.setLayoutData((Object)agentGd);
        this.agentCombo = PageUtils.createCombo((Composite)agent, Elements.UI_WIZARD_HOST_LABEL, Elements.UI_WIZARD_HOST_SOURCE_TOOLTIP, 8);
        this.addComboListener(this.agentCombo);
        ComboViewer agentViewer = new ComboViewer(this.agentCombo);
        agentViewer.setContentProvider((IContentProvider)new AgentContentProvider());
        agentViewer.setLabelProvider((IBaseLabelProvider)new AgentLabelProvider());
        Set<AgentStatusDetails> availableAgents = Subscription.getAgentStatusDetailsProvider().getAvailableAgents();
        agentViewer.setInput(availableAgents);
        this.checkPageForErrors();
        IWorkbenchHelpSystem helpSystem = PlatformUI.getWorkbench().getHelpSystem();
        helpSystem.setHelp((Control)composite, "com.ibm.wmqfte.explorer.context.UI_StopAgentListHelp");
        this.setControl((Control)composite);
    }

    private void checkPageForErrors() {
        Status status = new Status(0, "com.ibm.wmqfte.explorer", "");
        if (Subscription.getAgentStatusDetailsProvider().getAvailableAgents().size() == 0) {
            status = new Status(2, "com.ibm.wmqfte.explorer", Elements.UI_WIZARD_AGENTSLIST_FAIL_DIALOG);
        }
        PageUtils.setStatusLine(this, (IStatus)status);
    }

    private void addComboListener(Combo combo) {
        combo.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                StopAgentPage.this.checkPageComplete();
            }
        });
    }

    public void checkPageComplete() {
        this.setPageComplete(this.getAgentName().length() > 0);
    }

    public String getAgentName() {
        return this.agentCombo == null ? "" : this.agentCombo.getText();
    }
}

