/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wmqfte.explorer.wizards.pages;

import com.ibm.wmqfte.api.CommandScheduleSpecification;
import com.ibm.wmqfte.explorer.Elements;
import com.ibm.wmqfte.explorer.ExplorerPlugin;
import com.ibm.wmqfte.explorer.content.TransferTemplatesPage;
import com.ibm.wmqfte.explorer.utils.PageUtils;
import com.ibm.wmqfte.explorer.wizards.pages.NewMonitorSummaryPage;
import com.ibm.wmqfte.explorer.wizards.pages.NewTransferMetadataPage;
import com.ibm.wmqfte.explorer.wizards.pages.NewTransferPage;
import com.ibm.wmqfte.explorer.wizards.pages.NewTransferScheduleTriggersPage;
import com.ibm.wmqfte.explorer.wizards.pages.TransferContentProvider;
import com.ibm.wmqfte.explorer.wizards.pages.TransferLabelProvider;
import com.ibm.wmqfte.utils.xmlmessage.transfer.ItemSpecification;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public class NewTransferSummaryPage
extends WizardPage {
    private Text srcHost;
    private Text destHost;
    private Text scheduleInfo;
    private Group schedule;
    private Group triggers;
    private Group metadata;
    private Composite parent;
    private Composite composite;
    private ScrolledComposite sc;
    private final boolean isTemplate;
    private Button save;
    private Combo templateName;
    private String defaultTemplateName;
    private TableViewer tbv;
    private TableViewer tbvTriggers;
    private TableViewer tbvMetadata;
    private final NewTransferPage transferPage;
    private final NewTransferScheduleTriggersPage scheduleTriggersPage;
    private final NewTransferMetadataPage metadataPage;
    private boolean visible;

    public String getTemplateName() {
        return this.templateName.getText();
    }

    public NewTransferSummaryPage(String title, boolean isTemplate, NewTransferPage transferPage, NewTransferScheduleTriggersPage scheduleTriggersPage, NewTransferMetadataPage metadataPage) {
        super(NewTransferSummaryPage.class.getName(), title, null);
        this.isTemplate = isTemplate;
        if (isTemplate) {
            this.setDescription(Elements.UI_WIZARD_ENTER_TEMPLATE_NAME_LABEL);
        }
        this.transferPage = transferPage;
        this.scheduleTriggersPage = scheduleTriggersPage;
        this.metadataPage = metadataPage;
        this.setPageComplete(!isTemplate);
    }

    public NewTransferSummaryPage(String title, boolean isTemplate, NewTransferPage transferPage, NewTransferScheduleTriggersPage scheduleTriggersPage, NewTransferMetadataPage metadataPage, String name) {
        this(title, isTemplate, transferPage, scheduleTriggersPage, metadataPage);
        this.defaultTemplateName = name;
    }

    public void createControl(Composite parent) {
        this.parent = parent;
        this.composite = new Composite(parent, 0);
        this.composite.setLayout((Layout)new GridLayout(2, false));
        this.composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.composite.layout();
        this.setControl((Control)this.composite);
    }

    public void updateControl() {
        Map<String, String> md;
        List<ItemSpecification> transfers;
        if (this.sc != null) {
            this.sc.dispose();
        }
        if (this.composite != null) {
            this.composite.dispose();
        }
        this.sc = new ScrolledComposite(this.parent, 768);
        this.sc.setExpandHorizontal(true);
        this.sc.setExpandVertical(true);
        this.sc.setLayout((Layout)new GridLayout(1, true));
        this.sc.setLayoutData((Object)new GridData(4, 4, true, true));
        this.composite = new Composite((Composite)this.sc, 2048);
        this.composite.setLayout((Layout)new GridLayout(2, false));
        this.composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.sc.setContent((Control)this.composite);
        this.setControl((Control)this.sc);
        if (this.transferPage.getSourceHost().length() > 0) {
            Group from = new Group(this.composite, 0);
            from.setText(Elements.UI_WIZARD_FROM_LABEL);
            from.setLayout((Layout)new GridLayout(2, false));
            from.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
            Label srcHostKey = new Label((Composite)from, 0);
            srcHostKey.setText(Elements.UI_WIZARD_HOST_LABEL);
            PageUtils.makeBold((Control)srcHostKey);
            this.srcHost = new Text((Composite)from, 8);
            this.srcHost.setBackground(Display.getCurrent().getSystemColor(22));
            this.srcHost.setText(this.transferPage.getSourceHost());
        }
        if (this.transferPage.getDestHost().length() > 0) {
            Group to = new Group(this.composite, 0);
            to.setText(Elements.UI_WIZARD_TO_LABEL);
            to.setLayout((Layout)new GridLayout(2, false));
            to.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
            Label destHostKey = new Label((Composite)to, 0);
            destHostKey.setText(Elements.UI_WIZARD_HOST_LABEL);
            PageUtils.makeBold((Control)destHostKey);
            this.destHost = new Text((Composite)to, 8);
            this.destHost.setBackground(Display.getCurrent().getSystemColor(22));
            this.destHost.setText(this.transferPage.getDestHost());
        }
        if ((transfers = this.transferPage.getTransfers()).size() > 0) {
            Group files = new Group(this.composite, 0);
            files.setText(Elements.UI_WIZARD_FILE_LABEL);
            files.setLayout((Layout)new GridLayout(2, false));
            files.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
            this.tbv = new TableViewer((Composite)files, 68354);
            this.tbv.setContentProvider((IContentProvider)new TransferContentProvider());
            this.tbv.setLabelProvider((IBaseLabelProvider)new TransferLabelProvider());
            Table table = this.tbv.getTable();
            table.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
            TableColumn f = new TableColumn(table, 16384);
            f.setText(Elements.UI_WIZARD_FROM_LABEL);
            TableColumn t = new TableColumn(table, 16384);
            t.setText(Elements.UI_WIZARD_TO_LABEL);
            TableColumn m = new TableColumn(table, 16384);
            m.setText(Elements.UI_WIZARD_MODE_LABEL);
            TableColumn s = new TableColumn(table, 16384);
            s.setText(Elements.UI_WIZARD_DISPOSITION_LABEL);
            TableColumn o = new TableColumn(table, 16384);
            o.setText(Elements.UI_WIZARD_OVERWRITE_LABEL);
            TableColumn c = new TableColumn(table, 16384);
            c.setText(Elements.UI_WIZARD_CHECKSUM_LABEL);
            this.tbv.setInput(transfers);
            PageUtils.setupTable(table);
        }
        if (this.scheduleTriggersPage != null && this.scheduleTriggersPage.isScheduled() && this.scheduleTriggersPage.getStartSchedule() != null) {
            try {
                this.schedule = new Group(this.composite, 0);
                this.schedule.setText(Elements.UI_WIZARD_SCHEDULE_LABEL);
                this.schedule.setLayout((Layout)new GridLayout(2, false));
                this.schedule.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
                this.scheduleInfo = new Text((Composite)this.schedule, 8);
                this.scheduleInfo.setBackground(Display.getCurrent().getSystemColor(22));
                CommandScheduleSpecification s = new CommandScheduleSpecification(this.scheduleTriggersPage.getStartSchedule(), this.scheduleTriggersPage.getTimeBase(), this.scheduleTriggersPage.getRepeatInterval(), this.scheduleTriggersPage.getRepeatFrequency(), this.scheduleTriggersPage.getRepeatCount(), this.scheduleTriggersPage.getEndSchedule());
                String startSchedule = TransferTemplatesPage.df.format(TransferTemplatesPage.iso8601.parse(s.getStartSchedule()));
                String text = MessageFormat.format(Elements.UI_WIZARD_SCHEDULE_STARTING_AT, startSchedule);
                if (s.getRepeatFrequency() > 0) {
                    text = String.valueOf(text) + ' ' + MessageFormat.format(Elements.UI_WIZARD_SCHEDULE_REPEATING_EVERY, s.getRepeatFrequency(), this.scheduleTriggersPage.getRepeatIntervalType());
                    if (s.getRepeatCount() > 0) {
                        text = String.valueOf(text) + MessageFormat.format(Elements.UI_WIZARD_SCHEDULE_REPETITIONS_SUMMARY, s.getRepeatCount());
                    } else if (s.getEndSchedule() == null) {
                        text = String.valueOf(text) + Elements.UI_WIZARD_SCHEDULE_FOREVER_SUMMARY;
                    } else {
                        String timestamp = TransferTemplatesPage.df.format(TransferTemplatesPage.iso8601.parse(s.getEndSchedule()));
                        text = String.valueOf(text) + MessageFormat.format(Elements.UI_WIZARD_SCHEDULE_UNTIL_SUMMARY, timestamp);
                    }
                }
                this.scheduleInfo.setText(text);
                this.scheduleInfo.pack(true);
            }
            catch (ParseException parseException) {}
        }
        if (this.scheduleTriggersPage != null && this.scheduleTriggersPage.isTriggered() && this.scheduleTriggersPage.getTriggers() != null && this.scheduleTriggersPage.getTriggers().size() > 0) {
            this.triggers = new Group(this.composite, 0);
            this.triggers.setText(Elements.UI_WIZARD_TRIGGERS_TAB_TITLE);
            this.triggers.setLayout((Layout)new GridLayout(1, true));
            this.triggers.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
            this.tbvTriggers = new TableViewer((Composite)this.triggers, 68354);
            this.tbvTriggers.setContentProvider((IContentProvider)new NewTransferScheduleTriggersPage.TriggerContentProvider());
            this.tbvTriggers.setLabelProvider((IBaseLabelProvider)new NewTransferScheduleTriggersPage.TriggerLabelProvider());
            Table triggerTable = this.tbvTriggers.getTable();
            triggerTable.setLayoutData((Object)new GridData(4, 4, true, true));
            TableColumn ch = new TableColumn(triggerTable, 16384);
            ch.setText(Elements.UI_WIZARD_TRIGGER_CHECK_LABEL);
            TableColumn co = new TableColumn(triggerTable, 16384);
            co.setText(Elements.UI_WIZARD_TRIGGER_COMPARISON_LABEL);
            TableColumn qu = new TableColumn(triggerTable, 16384);
            qu.setText(Elements.UI_WIZARD_TRIGGER_QUALIFIER_LABEL);
            TableColumn n = new TableColumn(triggerTable, 16384);
            n.setText(Elements.UI_WIZARD_TRIGGER_NAMES_LABEL);
            this.tbvTriggers.setInput(this.scheduleTriggersPage.getTriggers());
            PageUtils.setupTable(triggerTable);
        }
        if ((md = this.metadataPage.getTransferMetadata()).size() > 0) {
            this.metadata = new Group(this.composite, 0);
            this.metadata.setText(Elements.UI_WIZARD_NEW_TRANSFER_METADATA_TITLE);
            this.metadata.setLayout((Layout)new GridLayout(1, true));
            this.metadata.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
            this.tbvMetadata = new TableViewer((Composite)this.metadata, 68354);
            this.tbvMetadata.setContentProvider((IContentProvider)new NewTransferMetadataPage.MetaDataContentProvider());
            this.tbvMetadata.setLabelProvider((IBaseLabelProvider)new NewTransferMetadataPage.MetaDataLabelProvider());
            Table tableMetadata = this.tbvMetadata.getTable();
            tableMetadata.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
            TableColumn name = new TableColumn(tableMetadata, 16384);
            name.setText(Elements.UI_WIZARD_ATTRIBUTE_NAME_LABEL);
            TableColumn val = new TableColumn(tableMetadata, 16384);
            val.setText(Elements.UI_WIZARD_ATTRIBUTE_VALUE_LABEL);
            this.tbvMetadata.setInput(md);
            PageUtils.setupTable(tableMetadata);
        }
        if (this.transferPage.getPriority() > 0) {
            Group advanced = new Group(this.composite, 0);
            advanced.setText(Elements.UI_WIZARD_ADV_TAB_TITLE);
            advanced.setLayout((Layout)new GridLayout(2, false));
            advanced.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
            Label priorityKey = new Label((Composite)advanced, 0);
            priorityKey.setText(Elements.UI_WIZARD_PRIORITY_LABEL);
            PageUtils.makeBold((Control)priorityKey);
            Text priority = new Text((Composite)advanced, 8);
            priority.setBackground(Display.getCurrent().getSystemColor(22));
            priority.setText(Integer.toString(this.transferPage.getPriority()));
        }
        if (!(this instanceof NewMonitorSummaryPage)) {
            this.save = new Button(this.composite, 32);
            this.save.setText(Elements.UI_WIZARD_SAVE_TEMPLATE_BUTTON);
            this.save.setLayoutData((Object)new GridData(1, 0x1000008, true, true, 2, 1));
            this.save.setSelection(this.isTemplate);
            this.save.setEnabled(!this.isTemplate);
            this.templateName = PageUtils.createCombo(this.composite, Elements.UI_WIZARD_NAME_LABEL, null, 1);
            this.templateName.setEnabled(this.save.getSelection());
            if (this.defaultTemplateName != null) {
                this.templateName.setText(this.defaultTemplateName);
            }
            this.setPageComplete(!this.save.getSelection() || this.templateName.getText().length() > 0);
            this.save.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.toggleCombo(NewTransferSummaryPage.this.save.getSelection());
                }

                public void widgetSelected(SelectionEvent e) {
                    this.toggleCombo(NewTransferSummaryPage.this.save.getSelection());
                }

                private void toggleCombo(boolean enabled) {
                    NewTransferSummaryPage.this.templateName.setEnabled(enabled);
                    if (enabled) {
                        NewTransferSummaryPage.this.setDescription(Elements.UI_WIZARD_ENTER_TEMPLATE_NAME_LABEL);
                    } else {
                        NewTransferSummaryPage.this.setDescription("");
                    }
                    NewTransferSummaryPage.this.setPageComplete(!enabled || NewTransferSummaryPage.this.templateName.getText().length() > 0);
                }
            });
            this.templateName.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    NewTransferSummaryPage.this.setPageComplete(!NewTransferSummaryPage.this.save.getSelection() || NewTransferSummaryPage.this.templateName.getText().length() > 0);
                }
            });
        }
        this.composite.layout();
        this.sc.layout();
        this.parent.layout();
        this.sc.setMinSize(this.composite.computeSize(-1, -1));
    }

    public boolean isSaveEnabled() {
        return this.save != null && this.save.getSelection();
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.visible = visible;
        if (visible) {
            this.setPageComplete(!this.isTemplate || this.save == null || !this.save.getSelection() || this.templateName != null && this.templateName.getText().length() > 0);
            String id = this.isTemplate ? "com.ibm.wmqfte.explorer.context.UI_NewTemplateSummaryHelp" : "com.ibm.wmqfte.explorer.context.UI_NewTransferSummaryHelp";
            ExplorerPlugin.setHelp((Control)this.getContainer().getShell(), id);
            this.updateControl();
        }
    }
}

