/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wmqfte.explorer.wizards.pages;

import com.ibm.wmqfte.api.CommandScheduleSpecification;
import com.ibm.wmqfte.api.ConfigurationException;
import com.ibm.wmqfte.command.impl.TriggerParameter;
import com.ibm.wmqfte.explorer.Elements;
import com.ibm.wmqfte.explorer.ExplorerPlugin;
import com.ibm.wmqfte.explorer.Icons;
import com.ibm.wmqfte.explorer.utils.PageUtils;
import com.ibm.wmqfte.explorer.wizards.pages.NewTransferPage;
import com.ibm.wmqfte.explorer.wizards.pages.TableComparator;
import com.ibm.wmqfte.monitor.impl.MonitorTriggerCondition;
import com.ibm.wmqfte.monitor.impl.MonitorTriggerOperator;
import com.ibm.wmqfte.trigger.FTETriggerMultiplerUnits;
import com.ibm.wmqfte.utils.AgentStatusDetails;
import com.ibm.wmqfte.utils.xmlescape.XMLEscape;
import com.ibm.wmqfte.utils.xmlmessage.transfer.ScheduleSpecification;
import com.ibm.wmqfte.utils.xmlmessage.transfer.TriggerParameterSpecification;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public class NewTransferScheduleTriggersPage
extends WizardPage {
    private static final int defaultType = 3;
    private static final Map<String, ScheduleSpecification.RepeatInterval> intervalTypes = new LinkedHashMap<String, ScheduleSpecification.RepeatInterval>();
    private Button enableSchedule;
    private Button enableTriggers;
    private final List<TriggerParameterSpecification> triggers = new ArrayList<TriggerParameterSpecification>();
    private DateTime date;
    private DateTime time;
    private Spinner num;
    private Combo repeatIntervalType;
    private Spinner numRepeats;
    private DateTime dateUntil;
    private DateTime timeUntil;
    private Button repeatBtn;
    private Button until;
    private Button freq;
    private Button forever;
    private Combo timeBaseCombo;
    private final NewTransferPage transferPage;
    private Combo sourceFile;
    private Button exists;
    private Button notExist;
    private Button exceed;
    private Spinner sizeValue;
    private Combo sizeType;
    private CommandScheduleSpecification defaultSchedule;
    private List<TriggerParameterSpecification> defaultTriggers;
    private TableViewer tbv;

    static {
        intervalTypes.put(Elements.UI_WIZARD_SCHEDULE_MINUTES, ScheduleSpecification.RepeatInterval.MINUTES);
        intervalTypes.put(Elements.UI_WIZARD_SCHEDULE_HOURS, ScheduleSpecification.RepeatInterval.HOURS);
        intervalTypes.put(Elements.UI_WIZARD_SCHEDULE_DAYS, ScheduleSpecification.RepeatInterval.DAYS);
        intervalTypes.put(Elements.UI_WIZARD_SCHEDULE_WEEKS, ScheduleSpecification.RepeatInterval.WEEKS);
        intervalTypes.put(Elements.UI_WIZARD_SCHEDULE_MONTHS, ScheduleSpecification.RepeatInterval.MONTHS);
        intervalTypes.put(Elements.UI_WIZARD_SCHEDULE_YEARS, ScheduleSpecification.RepeatInterval.YEARS);
    }

    public NewTransferScheduleTriggersPage(String title, String description, boolean isTemplate, NewTransferPage transferPage) {
        super(NewTransferScheduleTriggersPage.class.getName(), title, null);
        this.setDescription(description);
        this.setPageComplete(true);
        this.transferPage = transferPage;
    }

    public NewTransferScheduleTriggersPage(String title, String description, boolean isTemplate, NewTransferPage transferPage, CommandScheduleSpecification scheduleSpec, List<TriggerParameterSpecification> triggers) {
        this(title, description, isTemplate, transferPage);
        this.defaultSchedule = scheduleSpec;
        this.defaultTriggers = triggers;
    }

    public void createControl(Composite parent) {
        final TabFolder tabFolder = new TabFolder(parent, 128);
        tabFolder.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite scheduleComp = new Composite((Composite)tabFolder, 0);
        scheduleComp.setLayout((Layout)new GridLayout(1, true));
        scheduleComp.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createScheduleControl(scheduleComp);
        final TabItem schedule = new TabItem(tabFolder, 0);
        schedule.setText(Elements.UI_WIZARD_SCHEDULE_TAB_TITLE);
        schedule.setControl((Control)scheduleComp);
        Composite triggersComp = new Composite((Composite)tabFolder, 0);
        triggersComp.setLayout((Layout)new GridLayout(1, true));
        triggersComp.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createTriggersControl(triggersComp);
        TabItem triggersTab = new TabItem(tabFolder, 0);
        triggersTab.setText(Elements.UI_WIZARD_TRIGGERS_TAB_TITLE);
        triggersTab.setControl((Control)triggersComp);
        tabFolder.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                TabItem[] selection = tabFolder.getSelection();
                if (selection != null) {
                    Shell shell = NewTransferScheduleTriggersPage.this.getContainer().getShell();
                    String contextId = "";
                    contextId = selection[0] == schedule ? "com.ibm.wmqfte.explorer.context.UI_NewTransferScheduleHelp" : "com.ibm.wmqfte.explorer.context.UI_NewTransferTriggerHelp";
                    ExplorerPlugin.setHelp((Control)shell, contextId);
                    PageUtils.displayHelp(tabFolder.getDisplay(), contextId);
                }
            }
        });
        tabFolder.pack();
        tabFolder.layout();
        tabFolder.setVisible(true);
        if (this.defaultTriggers != null && this.defaultTriggers.size() > 0) {
            this.triggers.addAll(this.defaultTriggers);
            this.enableTriggers.setSelection(true);
            this.enableTriggers.notifyListeners(13, new Event());
            this.tbv.setInput(this.triggers);
            Display.getCurrent().asyncExec(new Runnable(){

                @Override
                public void run() {
                    NewTransferScheduleTriggersPage.this.tbv.refresh();
                    Table table = NewTransferScheduleTriggersPage.this.tbv.getTable();
                    if (!table.isDisposed()) {
                        PageUtils.setupTable(table);
                    }
                }
            });
        }
        this.setControl((Control)tabFolder);
    }

    private TableViewer addTriggerGroupBox(Composite parent) {
        Composite buttons = new Composite(parent, 0);
        buttons.setLayout((Layout)new GridLayout(2, false));
        buttons.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false));
        Button addToGroup = new Button(buttons, 8);
        addToGroup.setText(Elements.UI_WIZARD_ADD_TO_GROUP_BUTTON);
        addToGroup.setLayoutData((Object)new GridData(0x1000008, 0x1000000, true, false));
        final Button removeFromGroup = new Button(buttons, 8);
        removeFromGroup.setText(Elements.UI_WIZARD_REMOVE_FROM_GROUP_BUTTON);
        removeFromGroup.setLayoutData((Object)new GridData(1, 0x1000000, true, false));
        removeFromGroup.setEnabled(false);
        final TableViewer tbv = new TableViewer(parent, 68354);
        tbv.setContentProvider((IContentProvider)new TriggerContentProvider());
        tbv.setLabelProvider((IBaseLabelProvider)new TriggerLabelProvider());
        final Table table = tbv.getTable();
        tbv.setInput(PageUtils.getEmptyList(5));
        table.setLayoutData((Object)new GridData(4, 4, true, true));
        TableColumn ch = new TableColumn(table, 16384);
        ch.setText(Elements.UI_WIZARD_TRIGGER_CHECK_LABEL);
        TableColumn co = new TableColumn(table, 16384);
        co.setText(Elements.UI_WIZARD_TRIGGER_COMPARISON_LABEL);
        TableColumn qu = new TableColumn(table, 16384);
        qu.setText(Elements.UI_WIZARD_TRIGGER_QUALIFIER_LABEL);
        TableColumn n = new TableColumn(table, 16384);
        n.setText(Elements.UI_WIZARD_TRIGGER_NAMES_LABEL);
        SelectionListener sortListener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                TableColumn sortColumn = table.getSortColumn();
                TableColumn currentColumn = (TableColumn)e.widget;
                int dir = table.getSortDirection();
                if (sortColumn.equals(currentColumn)) {
                    dir = dir == 128 ? 1024 : 128;
                } else {
                    table.setSortColumn(currentColumn);
                    dir = 128;
                }
                table.setSortDirection(dir);
                if (tbv.getComparator() instanceof TableComparator) {
                    tbv.refresh();
                } else {
                    tbv.setComparator((ViewerComparator)new TableComparator());
                }
            }
        };
        ch.addSelectionListener(sortListener);
        co.addSelectionListener(sortListener);
        n.addSelectionListener(sortListener);
        tbv.setComparator((ViewerComparator)new TableComparator());
        tbv.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                removeFromGroup.setEnabled(!event.getSelection().isEmpty());
            }
        });
        final Display display = parent.getDisplay();
        addToGroup.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                if (tbv.getInput() != NewTransferScheduleTriggersPage.this.triggers) {
                    tbv.setInput((Object)NewTransferScheduleTriggersPage.this.triggers);
                }
                try {
                    NewTransferScheduleTriggersPage.this.triggers.add(NewTransferScheduleTriggersPage.this.createTriggerParameter());
                    NewTransferScheduleTriggersPage.this.clearComboValues();
                    if (!display.isDisposed()) {
                        display.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                tbv.refresh();
                                Table table = tbv.getTable();
                                if (!table.isDisposed()) {
                                    PageUtils.setupTable(table);
                                }
                            }
                        });
                    }
                    NewTransferScheduleTriggersPage.this.checkPageComplete();
                }
                catch (ConfigurationException configurationException) {}
            }
        });
        removeFromGroup.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                ISelection s = tbv.getSelection();
                if (s instanceof IStructuredSelection) {
                    for (Object o : ((IStructuredSelection)s).toList()) {
                        NewTransferScheduleTriggersPage.this.triggers.remove(o);
                    }
                    tbv.refresh();
                    if (NewTransferScheduleTriggersPage.this.triggers.isEmpty()) {
                        NewTransferScheduleTriggersPage.this.checkPageComplete();
                    }
                }
            }
        });
        return tbv;
    }

    public void clearComboValues() {
        String empty = "";
        this.sourceFile.setText(empty);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            if (visible && this.transferPage.getTransfers().size() == 0 && this.transferPage.isFormFilled()) {
                this.transferPage.addCurrent();
            }
            ExplorerPlugin.setHelp((Control)this.getContainer().getShell(), "com.ibm.wmqfte.explorer.context.UI_NewTransferScheduleHelp");
        }
    }

    public boolean isScheduled() {
        return this.enableSchedule.getSelection();
    }

    public boolean isTriggered() {
        return this.enableTriggers.getSelection();
    }

    public List<TriggerParameterSpecification> getTriggers() {
        if (this.isTriggered()) {
            if (this.triggers.size() == 0 && this.isPageComplete()) {
                try {
                    TriggerParameter tp = this.createTriggerParameter();
                    this.triggers.add((TriggerParameterSpecification)tp);
                }
                catch (ConfigurationException configurationException) {}
            }
            return this.triggers;
        }
        return null;
    }

    private TriggerParameter createTriggerParameter() throws ConfigurationException {
        String tpStr = "File";
        if (this.exceed.getSelection()) {
            tpStr = String.valueOf(tpStr) + "Size>=" + this.sizeValue.getSelection() + this.sizeType.getText();
        } else {
            tpStr = String.valueOf(tpStr) + (this.exists.getSelection() ? "=" : "!=");
            tpStr = String.valueOf(tpStr) + "Exist";
        }
        tpStr = String.valueOf(tpStr) + ',' + this.sourceFile.getText();
        return new TriggerParameter(tpStr);
    }

    private void checkPageComplete() {
        this.setPageComplete(true);
        if (this.isTriggered()) {
            boolean triggerFormFilled = this.sourceFile.getText().length() > 0;
            this.setPageComplete(triggerFormFilled || this.triggers.size() > 0);
        }
    }

    public String getStartSchedule() {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm");
        Calendar cal = Calendar.getInstance();
        cal.set(this.date.getYear(), this.date.getMonth(), this.date.getDay(), this.time.getHours(), this.time.getMinutes());
        return df.format(cal.getTime());
    }

    public void setStartSchedule(String startSchedule) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm");
        try {
            Date ss = df.parse(startSchedule);
            Calendar cal = Calendar.getInstance();
            cal.setTime(ss);
            this.date.setYear(cal.get(1));
            this.date.setMonth(cal.get(2));
            this.date.setDay(cal.get(5));
            this.date.setHours(cal.get(10));
            this.date.setMinutes(cal.get(12));
            this.date.notifyListeners(13, new Event());
        }
        catch (ParseException parseException) {}
    }

    public String getRepeatIntervalType() {
        return this.repeatIntervalType.getText();
    }

    public ScheduleSpecification.RepeatInterval getRepeatInterval() {
        if (this.repeatBtn.getSelection()) {
            return intervalTypes.get(this.repeatIntervalType.getText());
        }
        return null;
    }

    public int getRepeatFrequency() {
        if (this.repeatBtn.getSelection()) {
            return this.num.getSelection();
        }
        return -1;
    }

    public int getRepeatCount() {
        if (this.repeatBtn.getSelection() && this.freq.getSelection()) {
            return this.numRepeats.getSelection();
        }
        return -1;
    }

    public String getEndSchedule() {
        if (this.repeatBtn.getSelection() && this.until.getSelection()) {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm");
            Calendar cal = Calendar.getInstance();
            cal.set(this.dateUntil.getYear(), this.dateUntil.getMonth(), this.dateUntil.getDay(), this.timeUntil.getHours(), this.timeUntil.getMinutes());
            return df.format(cal.getTime());
        }
        return null;
    }

    public void setEndSchedule(String endSchedule) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm");
        try {
            Date ss = df.parse(endSchedule);
            Calendar cal = Calendar.getInstance();
            cal.setTime(ss);
            this.dateUntil.setYear(cal.get(1));
            this.dateUntil.setMonth(cal.get(2));
            this.dateUntil.setDay(cal.get(5));
            this.dateUntil.setHours(cal.get(10));
            this.dateUntil.setMinutes(cal.get(12));
            this.dateUntil.notifyListeners(13, new Event());
        }
        catch (ParseException parseException) {}
    }

    public String getTimeBase() {
        return this.timeBaseCombo.getText();
    }

    private void createScheduleControl(Composite parent) {
        Composite c = new Composite(parent, 0);
        c.setLayout((Layout)new GridLayout(1, false));
        this.enableSchedule = new Button(c, 32);
        this.enableSchedule.setText(Elements.UI_WIZARD_ENABLE_SCHEDULE_BUTTON);
        this.enableSchedule.setSelection(false);
        final Composite schedule = new Composite(parent, 0);
        schedule.setLayout((Layout)new GridLayout(3, false));
        schedule.setVisible(this.enableSchedule.getSelection());
        this.enableSchedule.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                schedule.setVisible(NewTransferScheduleTriggersPage.this.enableSchedule.getSelection());
            }
        });
        Label timeBase = new Label(schedule, 0);
        timeBase.setText(Elements.UI_WIZARD_SCHEDULE_TIMEBASE_LABEL);
        timeBase.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        PageUtils.makeBold((Control)timeBase);
        this.timeBaseCombo = new Combo(schedule, 8);
        this.timeBaseCombo.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.timeBaseCombo.setItems(new String[]{ScheduleSpecification.TimeBase.ADMIN.toString(), ScheduleSpecification.TimeBase.SOURCE.toString(), ScheduleSpecification.TimeBase.UTC.toString()});
        final Text timeBaseDetails = new Text(schedule, 8);
        timeBaseDetails.setBackground(parent.getDisplay().getSystemColor(22));
        timeBaseDetails.setText(Elements.UI_WIZARD_SCHEDULE_TIMEBASE_LABEL);
        timeBaseDetails.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.timeBaseCombo.select(0);
        timeBaseDetails.setText(String.valueOf(Elements.UI_WIZARD_SCHEDULE_TIMEBASE_ADMIN) + " (" + TimeZone.getDefault().getID() + ')');
        this.timeBaseCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                String text = NewTransferScheduleTriggersPage.this.timeBaseCombo.getText() == null ? "" : NewTransferScheduleTriggersPage.this.timeBaseCombo.getText();
                try {
                    ScheduleSpecification.TimeBase base = Enum.valueOf(ScheduleSpecification.TimeBase.class, text);
                    TimeZone tz = null;
                    if (base == ScheduleSpecification.TimeBase.ADMIN) {
                        timeBaseDetails.setText(String.valueOf(Elements.UI_WIZARD_SCHEDULE_TIMEBASE_ADMIN) + " (" + TimeZone.getDefault().getID() + ')');
                        tz = TimeZone.getDefault();
                    } else if (base == ScheduleSpecification.TimeBase.SOURCE) {
                        String val = Elements.UI_WIZARD_SCHEDULE_TIMEBASE_SOURCE;
                        AgentStatusDetails srcAgentPub = NewTransferScheduleTriggersPage.this.transferPage.getSrcAgentPub();
                        if (srcAgentPub != null) {
                            val = String.valueOf(val) + " (" + srcAgentPub.getAgentTimeZone().getID() + ')';
                        }
                        timeBaseDetails.setText(val);
                        tz = srcAgentPub.getAgentTimeZone();
                    } else if (base == ScheduleSpecification.TimeBase.UTC) {
                        timeBaseDetails.setText(String.valueOf(Elements.UI_WIZARD_SCHEDULE_TIMEBASE_UTC) + " (" + TimeZone.getTimeZone("UTC").getID() + ')');
                        tz = TimeZone.getTimeZone("UTC");
                    }
                    timeBaseDetails.pack();
                    if (tz != null) {
                        if (NewTransferScheduleTriggersPage.this.time != null && !NewTransferScheduleTriggersPage.this.time.isDisposed()) {
                            NewTransferScheduleTriggersPage.this.roundTime(NewTransferScheduleTriggersPage.this.time, tz);
                        }
                        if (NewTransferScheduleTriggersPage.this.timeUntil != null && !NewTransferScheduleTriggersPage.this.timeUntil.isDisposed()) {
                            NewTransferScheduleTriggersPage.this.roundTime(NewTransferScheduleTriggersPage.this.timeUntil, tz);
                        }
                    }
                    schedule.getParent().layout(true);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        });
        Label start = new Label(schedule, 0);
        start.setText(Elements.UI_WIZARD_SCHEDULE_START);
        start.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        PageUtils.makeBold((Control)start);
        final Composite dateAndCal = new Composite(schedule, 0);
        dateAndCal.setLayout((Layout)new GridLayout(2, false));
        dateAndCal.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.date = new DateTime(dateAndCal, 2080);
        final Button dateCal = new Button(dateAndCal, 2048);
        dateCal.setImage(Icons.datePicker);
        dateCal.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = Elements.UI_WIZARD_CHOOSE_DATE_TOOLTIP;
            }
        });
        dateCal.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private Shell dialog;

            public void widgetSelected(SelectionEvent e) {
                if (this.dialog != null) {
                    return;
                }
                Shell parentShell = dateCal.getShell();
                this.dialog = new Shell(parentShell, 2048);
                this.dialog.setLayout((Layout)new GridLayout(2, false));
                final DateTime cal = new DateTime((Composite)this.dialog, 1024);
                cal.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
                Button cancel = new Button((Composite)this.dialog, 8);
                cancel.setText(Elements.UI_WIZARD_SCHEDULE_CANCEL);
                cancel.setLayoutData((Object)new GridData(0x1000008, 0x1000000, true, false));
                cancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        dialog.close();
                        dialog = null;
                    }
                });
                Button ok = new Button((Composite)this.dialog, 8);
                ok.setText(Elements.UI_WIZARD_SCHEDULE_OK);
                ok.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
                ok.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        NewTransferScheduleTriggersPage.this.date.setYear(cal.getYear());
                        NewTransferScheduleTriggersPage.this.date.setMonth(cal.getMonth());
                        NewTransferScheduleTriggersPage.this.date.setDay(cal.getDay());
                        dialog.close();
                        dialog = null;
                    }
                });
                this.dialog.setDefaultButton(ok);
                this.dialog.pack();
                Point pt = dateAndCal.toDisplay(dateCal.getLocation());
                this.dialog.setLocation(pt.x, pt.y + dateCal.getBounds().height);
                this.dialog.open();
            }
        });
        this.time = new DateTime(schedule, 34944);
        this.roundTime(this.time, TimeZone.getDefault());
        this.repeatBtn = new Button(schedule, 0x4000020);
        this.repeatBtn.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 3, 1));
        if ("win32".equals(SWT.getPlatform())) {
            this.repeatBtn.setText(String.valueOf(Elements.UI_WIZARD_SCHEDULE_REPEAT) + ':');
        } else {
            this.repeatBtn.setText(String.valueOf(':') + Elements.UI_WIZARD_SCHEDULE_REPEAT);
        }
        PageUtils.makeBold((Control)this.repeatBtn);
        final Composite repeatOptions = new Composite(schedule, 0);
        repeatOptions.setLayout((Layout)new GridLayout(3, false));
        repeatOptions.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 3, 1));
        this.createScheduleRepeatControl(repeatOptions, this.date);
        repeatOptions.setVisible(this.repeatBtn.getSelection());
        Label spacer = new Label(schedule, 0);
        spacer.setVisible(false);
        final Composite expiry = new Composite(schedule, 0);
        expiry.setLayout((Layout)new GridLayout(3, false));
        expiry.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        this.createScheduleExpiryControl(expiry);
        expiry.setVisible(this.repeatBtn.getSelection());
        this.repeatBtn.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                boolean selection = NewTransferScheduleTriggersPage.this.repeatBtn.getSelection();
                repeatOptions.setVisible(selection);
                expiry.setVisible(selection);
            }
        });
        if (this.defaultSchedule != null) {
            this.enableSchedule.setSelection(true);
            this.enableSchedule.notifyListeners(13, new Event());
            this.setStartSchedule(this.defaultSchedule.getStartSchedule());
            int i = 0;
            String[] stringArray = this.timeBaseCombo.getItems();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String tb = stringArray[n2];
                if (tb.equalsIgnoreCase(this.defaultSchedule.getTimeBase())) {
                    this.timeBaseCombo.select(i);
                    this.timeBaseCombo.notifyListeners(13, new Event());
                    break;
                }
                ++i;
                ++n2;
            }
            if (this.defaultSchedule.getRepeatInterval() != null) {
                ScheduleSpecification.RepeatInterval defaultRi = ScheduleSpecification.RepeatInterval.valueOf((String)this.defaultSchedule.getRepeatInterval().toUpperCase());
                this.repeatBtn.setSelection(true);
                this.repeatBtn.notifyListeners(13, new Event());
                i = 0;
                for (ScheduleSpecification.RepeatInterval ri : intervalTypes.values()) {
                    if (ri.equals((Object)defaultRi)) {
                        this.repeatIntervalType.select(i);
                        this.repeatIntervalType.notifyListeners(13, new Event());
                        break;
                    }
                    ++i;
                }
            }
            if (this.defaultSchedule.getRepeatFrequency() > 0) {
                this.repeatBtn.setSelection(true);
                this.repeatBtn.notifyListeners(13, new Event());
                this.num.setSelection(this.defaultSchedule.getRepeatFrequency());
                this.num.notifyListeners(13, new Event());
            }
            this.until.setSelection(false);
            this.freq.setSelection(false);
            this.forever.setSelection(false);
            if (this.defaultSchedule.getRepeatCount() > 0) {
                this.repeatBtn.setSelection(true);
                this.repeatBtn.notifyListeners(13, new Event());
                this.freq.setSelection(true);
                this.freq.notifyListeners(13, new Event());
                this.numRepeats.setSelection(this.defaultSchedule.getRepeatCount());
                this.numRepeats.notifyListeners(13, new Event());
            } else if (this.defaultSchedule.getEndSchedule() != null) {
                this.repeatBtn.setSelection(true);
                this.repeatBtn.notifyListeners(13, new Event());
                this.until.setSelection(true);
                this.until.notifyListeners(13, new Event());
                this.setEndSchedule(this.defaultSchedule.getEndSchedule());
            } else {
                this.forever.setSelection(true);
                this.forever.notifyListeners(13, new Event());
            }
        }
    }

    private void createScheduleExpiryControl(Composite parent) {
        this.until = new Button(parent, 16);
        this.until.setText(Elements.UI_WIZARD_SCHEDULE_UNTIL);
        final Composite untilComposite = new Composite(parent, 0);
        untilComposite.setLayout((Layout)new GridLayout(2, false));
        untilComposite.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        final Composite dateAndCalUntil = new Composite(untilComposite, 0);
        dateAndCalUntil.setLayout((Layout)new GridLayout(2, false));
        dateAndCalUntil.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.dateUntil = new DateTime(dateAndCalUntil, 2080);
        final Button dateCalUntil = new Button(dateAndCalUntil, 2048);
        dateCalUntil.setImage(Icons.datePicker);
        dateCalUntil.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = Elements.UI_WIZARD_CHOOSE_DATE_TOOLTIP;
            }
        });
        dateCalUntil.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private Shell dialog;

            public void widgetSelected(SelectionEvent e) {
                if (this.dialog != null) {
                    return;
                }
                Shell parentShell = dateCalUntil.getShell();
                this.dialog = new Shell(parentShell, 2048);
                this.dialog.setLayout((Layout)new GridLayout(2, false));
                final DateTime cal = new DateTime((Composite)this.dialog, 1024);
                cal.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
                Button cancel = new Button((Composite)this.dialog, 8);
                cancel.setText(Elements.UI_WIZARD_SCHEDULE_CANCEL);
                cancel.setLayoutData((Object)new GridData(0x1000008, 0x1000000, true, false));
                cancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        dialog.close();
                        dialog = null;
                    }
                });
                Button ok = new Button((Composite)this.dialog, 8);
                ok.setText(Elements.UI_WIZARD_SCHEDULE_OK);
                ok.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
                ok.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        NewTransferScheduleTriggersPage.this.dateUntil.setYear(cal.getYear());
                        NewTransferScheduleTriggersPage.this.dateUntil.setMonth(cal.getMonth());
                        NewTransferScheduleTriggersPage.this.dateUntil.setDay(cal.getDay());
                        dialog.close();
                        dialog = null;
                    }
                });
                this.dialog.setDefaultButton(ok);
                this.dialog.pack();
                Point pt = dateAndCalUntil.toDisplay(dateCalUntil.getLocation());
                this.dialog.setLocation(pt.x, pt.y + dateCalUntil.getBounds().height);
                this.dialog.open();
            }
        });
        this.timeUntil = new DateTime(untilComposite, 2176);
        this.roundTime(this.timeUntil, TimeZone.getDefault());
        this.freq = new Button(parent, 16);
        this.freq.setText(Elements.UI_WIZARD_SCHEDULE_FOR);
        final Composite freqComposite = new Composite(parent, 0);
        freqComposite.setLayout((Layout)new GridLayout(3, false));
        freqComposite.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        this.numRepeats = new Spinner(freqComposite, 2048);
        this.numRepeats.setMinimum(1);
        this.numRepeats.setIncrement(1);
        this.numRepeats.setMaximum(9999);
        freqComposite.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                super.getName(e);
                e.result = String.valueOf(NewTransferScheduleTriggersPage.this.numRepeats.getSelection()) + " " + Elements.UI_WIZARD_SCHEDULE_REPETITIONS;
            }
        });
        Text repetitions = new Text(freqComposite, 8);
        repetitions.setBackground(parent.getDisplay().getSystemColor(22));
        repetitions.setText(Elements.UI_WIZARD_SCHEDULE_REPETITIONS);
        this.forever = new Button(parent, 16);
        this.forever.setText(Elements.UI_WIZARD_SCHEDULE_FOREVER);
        SelectionListener scheduleRadioListener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                if (NewTransferScheduleTriggersPage.this.until.getSelection()) {
                    NewTransferScheduleTriggersPage.this.enableCompositeChildren(untilComposite, true);
                    NewTransferScheduleTriggersPage.this.enableCompositeChildren(freqComposite, false);
                } else if (NewTransferScheduleTriggersPage.this.freq.getSelection()) {
                    NewTransferScheduleTriggersPage.this.enableCompositeChildren(untilComposite, false);
                    NewTransferScheduleTriggersPage.this.enableCompositeChildren(freqComposite, true);
                } else if (NewTransferScheduleTriggersPage.this.forever.getSelection()) {
                    NewTransferScheduleTriggersPage.this.enableCompositeChildren(untilComposite, false);
                    NewTransferScheduleTriggersPage.this.enableCompositeChildren(freqComposite, false);
                }
            }
        };
        this.until.addSelectionListener(scheduleRadioListener);
        this.freq.addSelectionListener(scheduleRadioListener);
        this.forever.addSelectionListener(scheduleRadioListener);
        this.freq.setSelection(true);
        scheduleRadioListener.widgetDefaultSelected(null);
    }

    private void createScheduleRepeatControl(Composite schedule, final DateTime date) {
        Label every = new Label(schedule, 0);
        every.setText(Elements.UI_WIZARD_SCHEDULE_EVERY);
        every.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        PageUtils.makeBold((Control)every);
        Composite numAndType = new Composite(schedule, 0);
        numAndType.setLayout((Layout)new GridLayout(2, false));
        numAndType.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        this.num = new Spinner(numAndType, 2048);
        this.num.setMinimum(1);
        this.num.setIncrement(1);
        this.num.setMaximum(this.getMaximums(date.getYear(), date.getMonth(), date.getDay())[3]);
        this.repeatIntervalType = new Combo(numAndType, 8);
        this.repeatIntervalType.setItems(intervalTypes.keySet().toArray(new String[0]));
        this.repeatIntervalType.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                Object s = e.getSource();
                if (s instanceof Combo) {
                    int[] maximums = NewTransferScheduleTriggersPage.this.getMaximums(date.getYear(), date.getMonth(), date.getDay());
                    int index = ((Combo)s).getSelectionIndex();
                    NewTransferScheduleTriggersPage.this.num.setMaximum(maximums[index]);
                }
            }
        });
        this.repeatIntervalType.select(3);
        date.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                int[] maximums = NewTransferScheduleTriggersPage.this.getMaximums(date.getYear(), date.getMonth(), date.getDay());
                int index = NewTransferScheduleTriggersPage.this.repeatIntervalType.getSelectionIndex();
                NewTransferScheduleTriggersPage.this.num.setMaximum(maximums[index]);
            }
        });
    }

    private void createTriggersControl(Composite parent) {
        Composite c = new Composite(parent, 0);
        c.setLayout((Layout)new GridLayout(1, false));
        this.enableTriggers = new Button(c, 32);
        this.enableTriggers.setText(Elements.UI_WIZARD_ENABLE_TRIGGERS_BUTTON);
        this.enableTriggers.setSelection(false);
        final Composite triggers = new Composite(parent, 0);
        triggers.setLayout((Layout)new GridLayout(2, false));
        triggers.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        triggers.setVisible(this.enableTriggers.getSelection());
        this.enableTriggers.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                triggers.setVisible(NewTransferScheduleTriggersPage.this.enableTriggers.getSelection());
                NewTransferScheduleTriggersPage.this.checkPageComplete();
            }
        });
        Group ftGroup = new Group(triggers, 0);
        ftGroup.setLayout((Layout)new GridLayout(3, false));
        ftGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        ftGroup.setText(Elements.UI_WIZARD_SCHEDULE_FILE_TRIGGER);
        ftGroup.setVisible(true);
        this.sourceFile = PageUtils.createCombo((Composite)ftGroup, Elements.UI_WIZARD_FILE_LABEL, null, 0);
        this.sourceFile.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewTransferScheduleTriggersPage.this.checkPageComplete();
            }
        });
        this.sourceFile.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                NewTransferScheduleTriggersPage.this.checkPageComplete();
            }
        });
        Button browseSrc = new Button((Composite)ftGroup, 8);
        browseSrc.setText(Elements.UI_WIZARD_BROWSE_LABEL);
        browseSrc.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        browseSrc.setEnabled(false);
        browseSrc.setVisible(false);
        Group triggerGroup = new Group((Composite)ftGroup, 0);
        triggerGroup.setLayout((Layout)new GridLayout(1, true));
        triggerGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        triggerGroup.setText(Elements.UI_WIZARD_TRIGGER_ATTRIBUTE_LABEL);
        Text when = new Text((Composite)triggerGroup, 8);
        when.setBackground(parent.getDisplay().getSystemColor(22));
        when.setText(Elements.UI_WIZARD_TRIGGER_FILE_WHEN_LABEL);
        Composite buttons = new Composite((Composite)triggerGroup, 0);
        buttons.setLayout((Layout)new GridLayout(3, false));
        buttons.setLayoutData((Object)PageUtils.getIndentGridData());
        this.exists = new Button(buttons, 16);
        this.exists.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 3, 1));
        this.exists.setText(Elements.UI_WIZARD_TRIGGER_FILE_EXISTS_BUTTON);
        this.exists.setSelection(true);
        this.notExist = new Button(buttons, 16);
        this.notExist.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 3, 1));
        this.notExist.setText(Elements.UI_WIZARD_TRIGGER_FILE_NOT_EXIST_BUTTON);
        this.exceed = new Button(buttons, 16);
        this.exceed.setText(Elements.UI_WIZARD_TRIGGER_FILE_EXCEED_BUTTON);
        this.exceed.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.sizeValue = new Spinner(buttons, 2048);
        this.sizeValue.setMinimum(0);
        this.sizeValue.setIncrement(1);
        this.sizeValue.setMaximum(1024);
        this.sizeValue.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.sizeType = new Combo(buttons, 8);
        this.sizeType.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        Set unitMultipliers = FTETriggerMultiplerUnits.getUnitMultipliers();
        if (unitMultipliers != null) {
            this.sizeType.setItems(unitMultipliers.toArray(new String[0]));
            this.sizeType.select(0);
        }
        SelectionListener triggerRadioListener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                boolean enable = NewTransferScheduleTriggersPage.this.exceed.getSelection();
                NewTransferScheduleTriggersPage.this.sizeValue.setEnabled(enable);
                NewTransferScheduleTriggersPage.this.sizeType.setEnabled(enable);
            }
        };
        this.exists.addSelectionListener(triggerRadioListener);
        this.notExist.addSelectionListener(triggerRadioListener);
        this.exceed.addSelectionListener(triggerRadioListener);
        this.exists.notifyListeners(13, new Event());
        Composite groupBox = new Composite(triggers, 0);
        groupBox.setLayout((Layout)new GridLayout(1, true));
        groupBox.setLayoutData((Object)new GridData(4, 0x1000000, true, true, 2, 1));
        this.tbv = this.addTriggerGroupBox(groupBox);
    }

    private void enableCompositeChildren(Composite parent, boolean enable) {
        Control[] controlArray = parent.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            if (c instanceof Composite && ((Composite)c).getChildren().length > 0) {
                this.enableCompositeChildren((Composite)c, enable);
            } else {
                c.setEnabled(enable);
            }
            ++n2;
        }
    }

    private int[] getMaximums(int year, int month, int day) {
        Calendar c = Calendar.getInstance();
        c.set(year, month, day);
        return new int[]{60, 24, c.getActualMaximum(6), c.getActualMaximum(3), 12, 100};
    }

    private void roundTime(DateTime time, TimeZone tz) {
        Calendar cal = Calendar.getInstance(tz);
        cal.clear(14);
        cal.clear(13);
        cal.clear(12);
        cal.roll(11, true);
        time.setSeconds(cal.get(13));
        time.setMinutes(cal.get(12));
        time.setHours(cal.get(11));
    }

    public static class TriggerContentProvider
    implements IStructuredContentProvider {
        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Collection) {
                return ((Collection)inputElement).toArray();
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    public static class TriggerLabelProvider
    implements ITableLabelProvider {
        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            String result = "";
            if (element instanceof TriggerParameter) {
                TriggerParameter tp = (TriggerParameter)element;
                switch (columnIndex) {
                    case 0: {
                        result = tp.getCheck().name();
                        break;
                    }
                    case 1: {
                        result = tp.getComparison().name();
                        break;
                    }
                    case 2: {
                        result = tp.getQualifier();
                        break;
                    }
                    case 3: {
                        result = tp.getXMLNameList();
                    }
                }
            } else if (element instanceof MonitorTriggerCondition) {
                MonitorTriggerCondition tc = (MonitorTriggerCondition)element;
                switch (columnIndex) {
                    case 0: {
                        result = tc.getTriggerOperator().name();
                        break;
                    }
                    case 1: {
                        if (MonitorTriggerOperator.FILE_SIZE != tc.getTriggerOperator()) break;
                        result = XMLEscape.removeEscapeSeq((String)tc.getComparsionXML());
                        break;
                    }
                    case 2: {
                        if (MonitorTriggerOperator.FILE_SIZE != tc.getTriggerOperator()) break;
                        result = String.valueOf(String.valueOf(tc.getSize())) + tc.getUnits();
                        break;
                    }
                    case 3: {
                        result = tc.getPattern().getPattern();
                    }
                }
            }
            return result;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

