/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wmqfte.explorer.wizards.pages;

import com.ibm.wmqfte.command.impl.CmdLinePropertyValueValidator;
import com.ibm.wmqfte.explorer.Elements;
import com.ibm.wmqfte.explorer.ExplorerPlugin;
import com.ibm.wmqfte.explorer.Messages;
import com.ibm.wmqfte.explorer.data.Subscription;
import com.ibm.wmqfte.explorer.utils.History;
import com.ibm.wmqfte.explorer.utils.PageUtils;
import com.ibm.wmqfte.explorer.wizards.pages.AgentContentProvider;
import com.ibm.wmqfte.explorer.wizards.pages.AgentLabelProvider;
import com.ibm.wmqfte.explorer.wizards.pages.NewMonitorPage;
import com.ibm.wmqfte.explorer.wizards.pages.TableComparator;
import com.ibm.wmqfte.explorer.wizards.pages.TransferContentProvider;
import com.ibm.wmqfte.explorer.wizards.pages.TransferLabelProvider;
import com.ibm.wmqfte.io.queue.FTEQueueDelimiter;
import com.ibm.wmqfte.monitor.MonitorPattern;
import com.ibm.wmqfte.utils.AgentStatusDetails;
import com.ibm.wmqfte.utils.ProductVersion;
import com.ibm.wmqfte.utils.xmlmessage.transfer.ItemSpecification;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public class NewTransferPage
extends WizardPage {
    private static final String DEST_PATH_HISTORY = "DESTINATION_DIRECTORY_HISTORY";
    private static final String DEST_FILE_HISTORY = "DESTINATION_FILENAME_HISTORY";
    private static final String DEST_QUEUE_HISTORY = "DESTINATION_QUEUE_HISTORY";
    private static final String DEST_FILESPACE_HISTORY = "DESTINATION_FILESPACE_HISTORY";
    private static final String DEST_CD_NODE_HISTORY = "DEST_CD_NODE_HISTORY";
    private static final String SOURCE_FILE_HISTORY = "SOURCE_FILENAME_HISTORY";
    private static final String SOURCE_QUEUE_HISTORY = "SOURCE_QUEUE_HISTORY";
    private static final String SOURCE_CD_NODE_HISTORY = "SOURCE_CD_NODE_HISTORY";
    private static final Pattern VALID_MQ_OBJECT_NAME = Pattern.compile("[A-Za-z0-9._/%]+");
    private static final Pattern VALID_CD_NODE_NAME = Pattern.compile("[A-Za-z0-9@#$._-]+");
    private IDialogSettings settings;
    private Set<AgentStatusDetails> availableAgents;
    private Combo sourceFile;
    private Combo sourceQueue;
    private Combo sourceType;
    private final String[] srcTypes = new String[]{Elements.UI_WIZARD_DEST_FILE_TYPE, Elements.UI_WIZARD_DEST_DIRECTORY_TYPE, Elements.UI_WIZARD_DEST_DATASET_TYPE, Elements.UI_WIZARD_DEST_MESSAGE_TYPE};
    private Combo sourceCDNode;
    private Label sourceCDNodeLabel;
    private final String[] srcCDTypes = new String[]{Elements.UI_WIZARD_DEST_FILE_TYPE, Elements.UI_WIZARD_DEST_DATASET_TYPE};
    private Combo destPath;
    private Combo sourceHost;
    private ComboViewer srcHostViewer;
    private TableViewer tbv;
    private String defaultSrcHost;
    private String defaultDestHost;
    private int defaultPriority = 0;
    private Combo destFile;
    private Combo destQueue;
    private Combo destFileSpace;
    private Combo destHost;
    private ComboViewer destHostViewer;
    private Combo destType;
    private final String[] destTypes = new String[]{Elements.UI_WIZARD_DEST_FILE_TYPE, Elements.UI_WIZARD_DEST_DIRECTORY_TYPE, Elements.UI_WIZARD_DEST_DATASET_TYPE, Elements.UI_WIZARD_DEST_MESSAGE_TYPE, Elements.UI_WIZARD_DEST_FILESPACE_TYPE};
    private Combo destCDNode;
    private Label destCDNodeLabel;
    private final String[] destCDTypes = new String[]{Elements.UI_WIZARD_DEST_FILE_TYPE, Elements.UI_WIZARD_DEST_DIRECTORY_TYPE, Elements.UI_WIZARD_DEST_DATASET_TYPE};
    private Combo priority;
    private Button binary;
    private Button text;
    private Button addToGroup;
    private Button recurse;
    private Button disableChecksum;
    private Button overwrite;
    private Button remove;
    private TransferPageType pageType;
    private Status status = new Status(0, "com.ibm.wmqfte.explorer", "");
    private final GridLayout singleColumn = new GridLayout(1, true);
    private final List<ItemSpecification> transfers = new LinkedList<ItemSpecification>();
    private long visibleTime;
    private Button sqMsgGrouping;
    private Button sqMsgDelimiterButton;
    private Combo sqMsgDelimiterType;
    private Combo sqMsgDelimiterPosition;
    private Text sqMsgDelimiter;
    private Button sqMsgWait;
    private Spinner sqMsgWaitValue;
    private String[] sqDelimiterTypes;
    private Button dqMsgPersistence;
    private Button dqMsgProperties;
    private Button dqMsgIncludeDelimitersButton;
    private Button dqMsgSplittingButton;
    private Combo dqMsgSplittingType;
    private Combo dqMsgDelimiterPosition;
    private Text dqMsgSplittingDelimiter;
    private Spinner dqSizeValue;
    private Combo dqSizeType;
    private String[] dqDelimiterTypes;
    private Group sourceQueueOptionsGroup;
    private Group destQueueOptionsGroup;

    public NewTransferPage(String title, String description, TransferPageType pageType) {
        super(NewTransferPage.class.getName(), title, null);
        this.setDescription(description);
        this.pageType = pageType;
        this.setPageComplete(pageType == TransferPageType.TEMPLATE);
        this.setupHistory();
    }

    public NewTransferPage(String title, String description, TransferPageType pageType, String sourceAgentName, String destinationAgentName, List<ItemSpecification> fileSpecs, int priority) {
        this(title, description, pageType);
        this.defaultSrcHost = sourceAgentName;
        this.defaultDestHost = destinationAgentName;
        this.transfers.addAll(fileSpecs);
        this.defaultPriority = Math.max(0, priority % 10);
    }

    private void setupHistory() {
        IDialogSettings dialogSettings = ExplorerPlugin.getDefault().getDialogSettings();
        this.settings = dialogSettings.getSection("UI_WIZARD_NEW_TRANSFER_SETTINGS");
        if (this.settings == null) {
            this.settings = dialogSettings.addNewSection("UI_WIZARD_NEW_TRANSFER_SETTINGS");
        }
    }

    public void createControl(final Composite parent) {
        this.availableAgents = Subscription.getAgentStatusDetailsProvider().getAvailableAgents();
        final TabFolder tabFolder = new TabFolder(parent, 128);
        tabFolder.setLayoutData((Object)new FillLayout());
        ScrolledComposite basicScrolledComposite = new ScrolledComposite((Composite)tabFolder, 768);
        final Composite basicComposite = new Composite((Composite)basicScrolledComposite, 0);
        basicComposite.setLayout((Layout)this.singleColumn);
        basicComposite.setLayoutData((Object)this.getFillGridData());
        this.createBasicTabControl(basicComposite);
        basicScrolledComposite.setContent((Control)basicComposite);
        TabItem basic = new TabItem(tabFolder, 0);
        basic.setText(Elements.UI_WIZARD_BASIC_TAB_TITLE);
        basic.setControl((Control)basicScrolledComposite);
        final Composite advancedComposite = new Composite((Composite)tabFolder, 0);
        advancedComposite.setLayout((Layout)this.singleColumn);
        advancedComposite.setLayoutData((Object)this.getFillGridData());
        this.createAdvancedTabControl(advancedComposite);
        final TabItem advanced = new TabItem(tabFolder, 0);
        advanced.setText(Elements.UI_WIZARD_ADV_TAB_TITLE);
        advanced.setControl((Control)advancedComposite);
        tabFolder.addSelectionListener(new SelectionListener(){
            private final String desc;
            {
                this.desc = NewTransferPage.this.getDescription();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                TabItem[] selection = tabFolder.getSelection();
                if (selection != null) {
                    Shell shell = NewTransferPage.this.getContainer().getShell();
                    String contextId = "";
                    if (selection[0] == advanced) {
                        contextId = NewTransferPage.this.pageType == TransferPageType.TEMPLATE ? "com.ibm.wmqfte.explorer.context.UI_NewTemplateAdvancedHelp" : "com.ibm.wmqfte.explorer.context.UI_NewTransferSingleAdvancedHelp";
                        NewTransferPage.this.setDescription(Elements.UI_WIZARD_NEW_TRANSFER_ADVANCED_DESC);
                        advancedComposite.layout();
                    } else {
                        contextId = NewTransferPage.this.pageType == TransferPageType.TEMPLATE ? "com.ibm.wmqfte.explorer.context.UI_NewTemplateBasicHelp" : (NewTransferPage.this.pageType == TransferPageType.MONITOR ? "com.ibm.wmqfte.explorer.context.UI_NewMonitorTransferBasicHelp" : "com.ibm.wmqfte.explorer.context.UI_NewTransferSingleBasicHelp");
                        NewTransferPage.this.setDescription(this.desc);
                        basicComposite.layout();
                    }
                    ExplorerPlugin.setHelp((Control)shell, contextId);
                    PageUtils.displayHelp(tabFolder.getDisplay(), contextId);
                }
            }
        });
        AgentStatusDetails agent = this.getSrcAgentPub();
        if (agent == null || !agent.isCDBridge()) {
            ((GridData)this.sourceCDNode.getLayoutData()).exclude = true;
            this.sourceCDNode.setVisible(false);
            ((GridData)this.sourceCDNodeLabel.getLayoutData()).exclude = true;
            this.sourceCDNodeLabel.setVisible(false);
        }
        if (agent != null && agent.isCDBridge()) {
            this.sourceType.setItems(this.srcCDTypes);
            this.sourceType.select(0);
            this.sourceType.notifyListeners(13, new Event());
            this.recurse.setVisible(false);
            ((GridData)this.recurse.getLayoutData()).exclude = true;
        }
        if ((agent = this.getDestAgentPub()) == null || !agent.isCDBridge()) {
            ((GridData)this.destCDNode.getLayoutData()).exclude = true;
            this.destCDNode.setVisible(false);
            ((GridData)this.destCDNodeLabel.getLayoutData()).exclude = true;
            this.destCDNodeLabel.setVisible(false);
        }
        if (agent != null && agent.isCDBridge()) {
            this.destType.setItems(this.destCDTypes);
            this.destType.select(0);
            this.destType.notifyListeners(13, new Event());
        }
        basicComposite.layout();
        basicScrolledComposite.setMinSize(basicComposite.computeSize(-1, -1));
        basicScrolledComposite.setExpandHorizontal(true);
        basicScrolledComposite.setExpandVertical(true);
        tabFolder.layout();
        tabFolder.pack();
        tabFolder.setVisible(true);
        this.setControl((Control)tabFolder);
        this.sourceType.notifyListeners(13, new Event());
        this.destType.notifyListeners(13, new Event());
        this.tbv.setInput(this.transfers);
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                NewTransferPage.this.tbv.refresh();
                Table table = NewTransferPage.this.tbv.getTable();
                if (!table.isDisposed()) {
                    PageUtils.setupTable(table);
                }
            }
        });
        for (ItemSpecification item : this.transfers) {
            this.text.setSelection(item.getTransferModeType() == ItemSpecification.TransferMode.TEXT);
            this.binary.setSelection(item.getTransferModeType() == ItemSpecification.TransferMode.BINARY);
            if (item.getSourceType() == ItemSpecification.SourceType.QUEUE) {
                this.setSourceQueueProps(item.getSourceQueueProps());
            }
            if (item.getDestinationType() != ItemSpecification.DestinationType.QUEUE) continue;
            this.setDestQueueProps(item.getDestinationProps());
        }
        Thread pollingThread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Display display = parent.getDisplay();
                while (!tabFolder.isDisposed()) {
                    final boolean wasEmpty = NewTransferPage.this.availableAgents.size() == 0;
                    Set<AgentStatusDetails> publishedAgents = Subscription.getAgentStatusDetailsProvider().getAvailableAgents();
                    boolean newPublishedAgents = publishedAgents.size() != NewTransferPage.this.availableAgents.size();
                    NewTransferPage.this.availableAgents = publishedAgents;
                    if (newPublishedAgents && !display.isDisposed()) {
                        display.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (NewTransferPage.this.srcHostViewer.getControl().isDisposed() || NewTransferPage.this.destHostViewer.getControl().isDisposed()) {
                                    return;
                                }
                                ISelection srcSelection = NewTransferPage.this.srcHostViewer.getSelection();
                                NewTransferPage.this.srcHostViewer.refresh();
                                if (!srcSelection.isEmpty()) {
                                    NewTransferPage.this.srcHostViewer.setSelection(srcSelection);
                                }
                                ISelection destSelection = NewTransferPage.this.destHostViewer.getSelection();
                                NewTransferPage.this.destHostViewer.refresh();
                                if (!destSelection.isEmpty()) {
                                    NewTransferPage.this.destHostViewer.setSelection(destSelection);
                                }
                                if (wasEmpty) {
                                    NewTransferPage.this.setDefaultSrcAgent();
                                    NewTransferPage.this.setDefaultDestAgent();
                                }
                                NewTransferPage.this.checkPageForErrors();
                                NewTransferPage.this.checkPageComplete();
                            }
                        });
                    }
                    try {
                        3 var5_5 = this;
                        synchronized (var5_5) {
                            this.wait(5000L);
                            if (!display.isDisposed()) {
                                display.asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (NewTransferPage.this.srcHostViewer.getControl().isDisposed() || NewTransferPage.this.destHostViewer.getControl().isDisposed()) {
                                            return;
                                        }
                                        NewTransferPage.this.checkPageForErrors();
                                        NewTransferPage.this.checkPageComplete();
                                    }
                                });
                            }
                            this.wait(5000L);
                        }
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        };
        pollingThread.start();
    }

    public GridData getFillGridData() {
        return new GridData(4, 4, true, true);
    }

    private void createAdvancedTabControl(Composite parent) {
        for (AgentStatusDetails agent : this.availableAgents) {
            if (!agent.getAgentName().equals(this.defaultSrcHost)) continue;
            StructuredSelection selection = new StructuredSelection((Object)agent);
            this.srcHostViewer.setSelection((ISelection)selection);
            break;
        }
        Group genericOptionsGroup = new Group(parent, 0);
        genericOptionsGroup.setText(Elements.UI_WIZARD_GENERIC_ADVANCED_OPTIONS_LABEL);
        genericOptionsGroup.setLayout((Layout)new GridLayout(2, false));
        genericOptionsGroup.setLayoutData((Object)new GridData(4, 1, true, false));
        Composite priorityComp = new Composite((Composite)genericOptionsGroup, 0);
        priorityComp.setLayout((Layout)new GridLayout(2, false));
        this.priority = this.createCombo(priorityComp, Elements.UI_WIZARD_PRIORITY_LABEL, null, 8);
        String[] priorities = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9"};
        this.priority.setItems(priorities);
        this.priority.select(this.defaultPriority);
        this.sourceQueueOptionsGroup = new Group(parent, 0);
        this.sourceQueueOptionsGroup.setText(Elements.UI_WIZARD_SOURCE_QUEUE_ADVANCED_OPTIONS_LABEL);
        this.sourceQueueOptionsGroup.setLayout((Layout)new GridLayout(4, false));
        this.sourceQueueOptionsGroup.setLayoutData((Object)new GridData(4, 1, true, false));
        this.sqMsgGrouping = new Button((Composite)this.sourceQueueOptionsGroup, 32);
        this.sqMsgGrouping.setText(Elements.UI_WIZARD_SOURCE_MESSAGE_GROUPING_BUTTON);
        this.sqMsgGrouping.setEnabled(true);
        this.sqMsgGrouping.setLayoutData((Object)new GridData(1, 0x1000000, true, false, 4, 1));
        this.sqMsgWait = new Button((Composite)this.sourceQueueOptionsGroup, 32);
        this.sqMsgWait.setText(Elements.UI_WIZARD_SOURCE_MESSAGE_WAIT_BUTTON);
        this.sqMsgWait.setEnabled(true);
        this.sqMsgWait.setLayoutData((Object)new GridData(1, 0x1000000, true, false, 4, 1));
        final Composite sqMsgWaitGroup = new Composite((Composite)this.sourceQueueOptionsGroup, 0);
        sqMsgWaitGroup.setLayout((Layout)new GridLayout(2, false));
        sqMsgWaitGroup.setLayoutData((Object)new GridData(1, 0x1000000, true, false, 4, 1));
        this.sqMsgWaitValue = new Spinner(sqMsgWaitGroup, 2048);
        this.sqMsgWaitValue.setValues(10, 1, 2147483, 0, 1, 10);
        GridData gd = new GridData(1, 0x1000000, true, false);
        gd.horizontalIndent = 48;
        this.sqMsgWaitValue.setLayoutData((Object)gd);
        final Label sqMsgWaitUnits = new Label(sqMsgWaitGroup, 0);
        sqMsgWaitUnits.setLayoutData((Object)new GridData(1, 0x1000000, true, false));
        sqMsgWaitUnits.setText(Elements.UI_WIZARD_SCHEDULE_SECONDS);
        this.sqMsgWait.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                boolean isSelected = NewTransferPage.this.sqMsgWait.getSelection();
                Control[] controlArray = new Control[]{NewTransferPage.this.sqMsgWaitValue, sqMsgWaitUnits, sqMsgWaitGroup};
                int n = controlArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Control c = controlArray[n2];
                    c.setVisible(isSelected);
                    ((GridData)c.getLayoutData()).exclude = !isSelected;
                    ++n2;
                }
                NewTransferPage.this.sourceQueueOptionsGroup.layout(true);
                NewTransferPage.this.sourceQueueOptionsGroup.setSize(NewTransferPage.this.sourceQueueOptionsGroup.computeSize(((NewTransferPage)NewTransferPage.this).sourceQueueOptionsGroup.getSize().x, -1, true));
                Composite parent = NewTransferPage.this.sourceQueueOptionsGroup.getParent();
                parent.setSize(parent.computeSize(parent.getSize().x, -1, true));
                parent.getParent().layout(true);
                NewTransferPage.this.checkPageForErrors();
                NewTransferPage.this.checkPageComplete();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.sqMsgWait.notifyListeners(13, new Event());
        this.sqMsgDelimiterButton = new Button((Composite)this.sourceQueueOptionsGroup, 32);
        this.sqMsgDelimiterButton.setText(Elements.UI_WIZARD_MESSAGE_DELIMITER_INSERTION_BUTTON);
        this.sqMsgDelimiterButton.setLayoutData((Object)new GridData(1, 0x1000000, true, false, 4, 1));
        final Label sqMsgDelimiterPositionLabel = new Label((Composite)this.sourceQueueOptionsGroup, 0);
        sqMsgDelimiterPositionLabel.setText(Elements.UI_WIZARD_MESSAGE_DELIMITER_POSITION_LABEL);
        GridData gd2 = new GridData(0x1000008, 0x1000000, false, false);
        gd2.horizontalIndent = 48;
        sqMsgDelimiterPositionLabel.setLayoutData((Object)gd2);
        this.sqMsgDelimiterPosition = new Combo((Composite)this.sourceQueueOptionsGroup, -1);
        this.sqMsgDelimiterPosition.setItems(new String[]{Elements.UI_WIZARD_MESSAGE_DELIMITER_PREFIX_LABEL, Elements.UI_WIZARD_MESSAGE_DELIMITER_POSTFIX_LABEL});
        this.sqMsgDelimiterPosition.select(1);
        this.sqMsgDelimiterPosition.setLayoutData((Object)new GridData(1, 0x1000000, true, false, 3, 1));
        final Label sqMsgSplittingLabel = new Label((Composite)this.sourceQueueOptionsGroup, 0);
        sqMsgSplittingLabel.setText(Elements.UI_WIZARD_MESSAGE_DELIMITER_LABEL);
        GridData gd3 = new GridData(0x1000008, 0x1000000, false, false);
        gd3.horizontalIndent = 48;
        sqMsgSplittingLabel.setLayoutData((Object)gd3);
        this.sqMsgDelimiterType = new Combo((Composite)this.sourceQueueOptionsGroup, -1);
        this.sqDelimiterTypes = new String[]{Elements.UI_WIZARD_SPLIT_BINARY_DELIMITER, Elements.UI_WIZARD_SPLIT_TEXT_SEQUENCE};
        this.sqMsgDelimiterType.setItems(this.sqDelimiterTypes);
        this.sqMsgDelimiterType.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        final Composite srcDelimiterGroup = new Composite((Composite)this.sourceQueueOptionsGroup, 0);
        srcDelimiterGroup.setLayout((Layout)new GridLayout(2, false));
        srcDelimiterGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        srcDelimiterGroup.setVisible(true);
        this.sqMsgDelimiterButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                Object s = e.getSource();
                if (s instanceof Button) {
                    boolean splittingEnabled = ((Button)s).getSelection();
                    sqMsgDelimiterPositionLabel.setVisible(splittingEnabled);
                    NewTransferPage.this.sqMsgDelimiterPosition.setVisible(splittingEnabled);
                    sqMsgSplittingLabel.setVisible(splittingEnabled);
                    NewTransferPage.this.sqMsgDelimiterType.setVisible(splittingEnabled);
                    if (!splittingEnabled) {
                        NewTransferPage.this.setVisibleRecursive(srcDelimiterGroup, false);
                    }
                    NewTransferPage.this.sqMsgDelimiterType.notifyListeners(13, new Event());
                }
            }
        });
        this.sqMsgDelimiterButton.notifyListeners(13, new Event());
        this.sqMsgDelimiter = new Text(srcDelimiterGroup, 2048);
        this.sqMsgDelimiter.setVisible(false);
        this.sqMsgDelimiter.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.sqMsgDelimiter.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewTransferPage.this.checkPageForErrors();
                NewTransferPage.this.checkPageComplete();
            }
        });
        this.sqMsgDelimiterType.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Object s = e.getSource();
                if (s instanceof Combo) {
                    if (!NewTransferPage.this.sqMsgDelimiterButton.getSelection()) {
                        return;
                    }
                    String selectedType = ((Combo)s).getText();
                    Control[] controlArray = srcDelimiterGroup.getChildren();
                    int n = controlArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Combo combo;
                        Control c = controlArray[n2];
                        c.setVisible(false);
                        if (c instanceof Composite) {
                            NewTransferPage.this.setVisibleRecursive((Composite)c, false);
                        }
                        if (c instanceof Combo && ((combo = (Combo)c).getStyle() & 8) == 0) {
                            combo.setText("");
                            combo.notifyListeners(13, new Event());
                        }
                        ((GridData)c.getLayoutData()).exclude = true;
                        ++n2;
                    }
                    NewTransferPage.this.sqMsgDelimiter.setText("");
                    NewTransferPage.this.sqMsgDelimiter.notifyListeners(13, new Event());
                    Control[] enabledControls = new Control[]{};
                    if (Elements.UI_WIZARD_SPLIT_BINARY_DELIMITER.equals(selectedType)) {
                        enabledControls = new Control[]{NewTransferPage.this.sqMsgDelimiter};
                    } else if (Elements.UI_WIZARD_SPLIT_TEXT_SEQUENCE.equals(selectedType)) {
                        enabledControls = new Control[]{NewTransferPage.this.sqMsgDelimiter};
                    }
                    Control[] controlArray2 = enabledControls;
                    int n3 = enabledControls.length;
                    n = 0;
                    while (n < n3) {
                        Control c = controlArray2[n];
                        c.setVisible(true);
                        ((GridData)c.getLayoutData()).exclude = false;
                        ++n;
                    }
                    srcDelimiterGroup.layout(true);
                    srcDelimiterGroup.setVisible(enabledControls.length > 0);
                    srcDelimiterGroup.setSize(srcDelimiterGroup.computeSize(srcDelimiterGroup.getSize().x, -1, true));
                    Composite parent = srcDelimiterGroup.getParent();
                    parent.setSize(parent.computeSize(parent.getSize().x, -1, true));
                    parent.getParent().layout(true);
                    NewTransferPage.this.checkPageForErrors();
                    NewTransferPage.this.checkPageComplete();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                NewTransferPage.this.sourceType.select(0);
            }
        });
        this.sqMsgDelimiterType.notifyListeners(13, new Event());
        this.sqMsgDelimiterButton.notifyListeners(13, new Event());
        this.destQueueOptionsGroup = new Group(parent, 0);
        this.destQueueOptionsGroup.setText(Elements.UI_WIZARD_DESTINATION_QUEUE_ADVANCED_OPTIONS_LABEL);
        this.destQueueOptionsGroup.setLayout((Layout)new GridLayout(4, false));
        this.destQueueOptionsGroup.setLayoutData((Object)new GridData(4, 1, true, false));
        this.dqMsgPersistence = new Button((Composite)this.destQueueOptionsGroup, 32);
        this.dqMsgPersistence.setText(Elements.UI_WIZARD_MESSAGE_PERSISTENCE_BUTTON);
        this.dqMsgPersistence.setEnabled(true);
        this.dqMsgPersistence.setSelection(true);
        this.dqMsgPersistence.setLayoutData((Object)new GridData(1, 0x1000000, true, false, 4, 1));
        this.dqMsgProperties = new Button((Composite)this.destQueueOptionsGroup, 32);
        this.dqMsgProperties.setText(Elements.UI_WIZARD_MESSAGE_PROPERTIES_BUTTON);
        this.dqMsgProperties.setEnabled(true);
        this.dqMsgProperties.setLayoutData((Object)new GridData(1, 0x1000000, true, false, 4, 1));
        this.dqMsgSplittingButton = new Button((Composite)this.destQueueOptionsGroup, 32);
        this.dqMsgSplittingButton.setText(Elements.UI_WIZARD_MESSAGE_SPLIT_BUTTON);
        this.dqMsgSplittingButton.setLayoutData((Object)new GridData(1, 0x1000000, true, false, 4, 1));
        final Label dqMsgDelimiterPositionLabel = new Label((Composite)this.destQueueOptionsGroup, 0);
        dqMsgDelimiterPositionLabel.setText(Elements.UI_WIZARD_MESSAGE_DELIMITER_POSITION_LABEL);
        GridData gd4 = new GridData(0x1000008, 0x1000000, false, false);
        gd4.horizontalIndent = 48;
        dqMsgDelimiterPositionLabel.setLayoutData((Object)gd4);
        this.dqMsgDelimiterPosition = new Combo((Composite)this.destQueueOptionsGroup, -1);
        this.dqMsgDelimiterPosition.setItems(new String[]{Elements.UI_WIZARD_MESSAGE_DELIMITER_PREFIX_LABEL, Elements.UI_WIZARD_MESSAGE_DELIMITER_POSTFIX_LABEL});
        this.dqMsgDelimiterPosition.select(1);
        this.dqMsgDelimiterPosition.setLayoutData((Object)new GridData(1, 0x1000000, true, false, 3, 1));
        final Label dqMsgSplittingLabel = new Label((Composite)this.destQueueOptionsGroup, 0);
        dqMsgSplittingLabel.setText(Elements.UI_WIZARD_MESSAGE_DELIMITER_LABEL);
        GridData gd5 = new GridData(0x1000008, 0x1000000, false, false);
        gd5.horizontalIndent = 48;
        dqMsgSplittingLabel.setLayoutData((Object)gd5);
        this.dqMsgSplittingType = new Combo((Composite)this.destQueueOptionsGroup, -1);
        this.dqDelimiterTypes = new String[]{Elements.UI_WIZARD_SPLIT_SIZE, Elements.UI_WIZARD_SPLIT_BINARY_DELIMITER, Elements.UI_WIZARD_SPLIT_TEXT_PATTERN};
        this.dqMsgSplittingType.setItems(this.dqDelimiterTypes);
        this.dqMsgSplittingType.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        final Composite destDelimiterGroup = new Composite((Composite)this.destQueueOptionsGroup, 0);
        destDelimiterGroup.setLayout((Layout)new GridLayout(2, false));
        destDelimiterGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        destDelimiterGroup.setVisible(true);
        this.dqSizeValue = new Spinner(destDelimiterGroup, 2048);
        this.dqSizeValue.setMinimum(1);
        this.dqSizeValue.setIncrement(1);
        this.dqSizeValue.setMaximum(1024);
        this.dqSizeValue.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.dqSizeType = new Combo(destDelimiterGroup, 8);
        this.dqSizeType.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.dqSizeType.setItems(new String[]{"B", "K", "M"});
        this.dqSizeType.select(0);
        this.dqMsgSplittingButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                Object s = e.getSource();
                if (s instanceof Button) {
                    boolean splittingEnabled = ((Button)s).getSelection();
                    dqMsgDelimiterPositionLabel.setVisible(splittingEnabled);
                    NewTransferPage.this.dqMsgDelimiterPosition.setVisible(splittingEnabled);
                    dqMsgSplittingLabel.setVisible(splittingEnabled);
                    NewTransferPage.this.dqMsgSplittingType.setVisible(splittingEnabled);
                    if (!splittingEnabled) {
                        NewTransferPage.this.setVisibleRecursive(destDelimiterGroup, false);
                    }
                    NewTransferPage.this.dqMsgSplittingType.notifyListeners(13, new Event());
                    if (NewTransferPage.this.dqMsgIncludeDelimitersButton != null) {
                        NewTransferPage.this.dqMsgIncludeDelimitersButton.setVisible(splittingEnabled);
                    }
                }
            }
        });
        this.dqMsgSplittingButton.notifyListeners(13, new Event());
        this.dqMsgSplittingDelimiter = new Text(destDelimiterGroup, 2048);
        this.dqMsgSplittingDelimiter.setVisible(false);
        this.dqMsgSplittingDelimiter.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.dqMsgSplittingDelimiter.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewTransferPage.this.checkPageForErrors();
                NewTransferPage.this.checkPageComplete();
            }
        });
        this.dqMsgSplittingType.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Object s = e.getSource();
                if (s instanceof Combo) {
                    if (!NewTransferPage.this.dqMsgSplittingButton.getSelection()) {
                        return;
                    }
                    String selectedType = ((Combo)s).getText();
                    Control[] controlArray = destDelimiterGroup.getChildren();
                    int n = controlArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Combo combo;
                        Control c = controlArray[n2];
                        c.setVisible(false);
                        if (c instanceof Composite) {
                            NewTransferPage.this.setVisibleRecursive((Composite)c, false);
                        }
                        if (c instanceof Combo && ((combo = (Combo)c).getStyle() & 8) == 0) {
                            combo.setText("");
                            combo.notifyListeners(13, new Event());
                        }
                        ((GridData)c.getLayoutData()).exclude = true;
                        ++n2;
                    }
                    NewTransferPage.this.dqMsgSplittingDelimiter.setText("");
                    NewTransferPage.this.dqMsgSplittingDelimiter.notifyListeners(13, new Event());
                    Control[] enabledControls = new Control[]{};
                    if (Elements.UI_WIZARD_SPLIT_SIZE.equals(selectedType)) {
                        enabledControls = new Control[]{NewTransferPage.this.dqSizeValue, NewTransferPage.this.dqSizeType};
                    } else if (Elements.UI_WIZARD_SPLIT_BINARY_DELIMITER.equals(selectedType)) {
                        enabledControls = new Control[]{NewTransferPage.this.dqMsgSplittingDelimiter};
                    } else if (Elements.UI_WIZARD_SPLIT_TEXT_PATTERN.equals(selectedType)) {
                        enabledControls = new Control[]{NewTransferPage.this.dqMsgSplittingDelimiter};
                    }
                    Control[] controlArray2 = enabledControls;
                    int n3 = enabledControls.length;
                    n = 0;
                    while (n < n3) {
                        Control c = controlArray2[n];
                        c.setVisible(true);
                        ((GridData)c.getLayoutData()).exclude = false;
                        ++n;
                    }
                    destDelimiterGroup.layout(true);
                    destDelimiterGroup.setVisible(enabledControls.length > 0);
                    destDelimiterGroup.setSize(destDelimiterGroup.computeSize(destDelimiterGroup.getSize().x, -1, true));
                    Composite parent = destDelimiterGroup.getParent();
                    parent.setSize(parent.computeSize(parent.getSize().x, -1, true));
                    parent.getParent().layout(true);
                    NewTransferPage.this.checkPageForErrors();
                    NewTransferPage.this.checkPageComplete();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                NewTransferPage.this.destType.select(0);
            }
        });
        this.dqMsgIncludeDelimitersButton = new Button((Composite)this.destQueueOptionsGroup, 32);
        this.dqMsgIncludeDelimitersButton.setVisible(false);
        this.dqMsgIncludeDelimitersButton.setText(Elements.UI_WIZARD_MESSAGE_INCLUDE_DELIMITERS_BUTTON);
        GridData gd6 = new GridData(1, 0x1000000, true, false, 4, 1);
        gd6.horizontalIndent = 96;
        this.dqMsgIncludeDelimitersButton.setLayoutData((Object)gd6);
        this.dqMsgSplittingType.notifyListeners(13, new Event());
        this.dqMsgSplittingButton.notifyListeners(13, new Event());
    }

    private void setVisibleRecursive(Composite parent, boolean visible) {
        Control[] controlArray = parent.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            if (c instanceof Composite) {
                this.setVisibleRecursive((Composite)c, visible);
            }
            c.setVisible(visible);
            Object ld = c.getLayoutData();
            if (ld instanceof GridData) {
                ((GridData)ld).exclude = !visible;
            }
            ++n2;
        }
    }

    private int getFirstColumnWidth(Composite parent) {
        GC gc = new GC((Drawable)parent);
        String[] labels = new String[]{Elements.UI_WIZARD_HOST_LABEL, Elements.UI_WIZARD_FILE_LABEL, Elements.UI_WIZARD_PATH_LABEL, Elements.UI_WIZARD_FILENAME_LABEL, Elements.UI_WIZARD_QUEUE_LABEL, Elements.UI_WIZARD_FILESPACE_LABEL};
        int max = 0;
        String[] stringArray = labels;
        int n = labels.length;
        int n2 = 0;
        while (n2 < n) {
            String label = stringArray[n2];
            max = Math.max(gc.stringExtent((String)label).x, max);
            ++n2;
        }
        return max;
    }

    private void createBasicTabControl(Composite parent) {
        this.addFromGroup(parent);
        this.addToGroup(parent);
        this.addBasicSettingsGroup(parent);
        this.addGroupBox(parent);
        this.sourceFile.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String basename;
                if (NewTransferPage.this.isWildcard(NewTransferPage.this.getSourceFile()) || NewTransferPage.this.recurse.getSelection() || NewTransferPage.this.isSrcDirectory()) {
                    NewTransferPage.this.destFile.setText("");
                    NewTransferPage.this.destFile.setEnabled(false);
                    NewTransferPage.this.destPath.setEnabled(true);
                    return;
                }
                String text = NewTransferPage.this.sourceFile.getText();
                boolean isSrcDataSet = NewTransferPage.this.isSrcDataSet();
                String string = basename = isSrcDataSet ? text : PageUtils.basename(text);
                if (!text.equals(basename) || isSrcDataSet) {
                    NewTransferPage.this.destFile.setText(basename);
                }
                NewTransferPage.this.destFile.setEnabled(!NewTransferPage.this.recurse.getSelection());
            }
        });
    }

    private void addGroupBox(Composite parent) {
        Composite buttons = new Composite(parent, 0);
        buttons.setLayout((Layout)new GridLayout(2, false));
        buttons.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false));
        this.addToGroup = new Button(buttons, 8);
        this.addToGroup.setText(Elements.UI_WIZARD_ADD_TO_GROUP_BUTTON);
        this.addToGroup.setLayoutData((Object)new GridData(0x1000008, 0x1000000, true, false));
        final Button removeFromGroup = new Button(buttons, 8);
        removeFromGroup.setText(Elements.UI_WIZARD_REMOVE_FROM_GROUP_BUTTON);
        removeFromGroup.setLayoutData((Object)new GridData(1, 0x1000000, true, false));
        removeFromGroup.setEnabled(false);
        this.tbv = new TableViewer(parent, 68354);
        this.tbv.setContentProvider((IContentProvider)new TransferContentProvider());
        this.tbv.setLabelProvider((IBaseLabelProvider)new TransferLabelProvider());
        final Table table = this.tbv.getTable();
        this.tbv.setInput(PageUtils.getEmptyList(5));
        table.setLayoutData((Object)new GridData(4, 4, true, true));
        TableColumn f = new TableColumn(table, 16384);
        f.setText(Elements.UI_WIZARD_FROM_LABEL);
        TableColumn t = new TableColumn(table, 16384);
        t.setText(Elements.UI_WIZARD_TO_LABEL);
        TableColumn m = new TableColumn(table, 16384);
        m.setText(Elements.UI_WIZARD_MODE_LABEL);
        TableColumn s = new TableColumn(table, 16384);
        s.setText(Elements.UI_WIZARD_DISPOSITION_LABEL);
        TableColumn o = new TableColumn(table, 16384);
        o.setText(Elements.UI_WIZARD_OVERWRITE_LABEL);
        TableColumn c = new TableColumn(table, 16384);
        c.setText(Elements.UI_WIZARD_CHECKSUM_LABEL);
        SelectionListener sortListener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                TableColumn sortColumn = table.getSortColumn();
                TableColumn currentColumn = (TableColumn)e.widget;
                int dir = table.getSortDirection();
                if (sortColumn.equals(currentColumn)) {
                    dir = dir == 128 ? 1024 : 128;
                } else {
                    table.setSortColumn(currentColumn);
                    dir = 128;
                }
                table.setSortDirection(dir);
                if (NewTransferPage.this.tbv.getComparator() instanceof TableComparator) {
                    NewTransferPage.this.tbv.refresh();
                } else {
                    NewTransferPage.this.tbv.setComparator((ViewerComparator)new TableComparator());
                }
            }
        };
        f.addSelectionListener(sortListener);
        t.addSelectionListener(sortListener);
        m.addSelectionListener(sortListener);
        s.addSelectionListener(sortListener);
        o.addSelectionListener(sortListener);
        c.addSelectionListener(sortListener);
        this.tbv.setComparator((ViewerComparator)new TableComparator());
        this.tbv.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                removeFromGroup.setEnabled(!event.getSelection().isEmpty());
            }
        });
        this.addToGroup.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                if (NewTransferPage.this.tbv.getInput() != NewTransferPage.this.transfers) {
                    NewTransferPage.this.tbv.setInput((Object)NewTransferPage.this.transfers);
                }
                NewTransferPage.this.addCurrent();
                NewTransferPage.this.text.setSelection(false);
                NewTransferPage.this.binary.setSelection(true);
                NewTransferPage.this.checkPageComplete();
            }
        });
        removeFromGroup.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                ISelection s = NewTransferPage.this.tbv.getSelection();
                if (s instanceof IStructuredSelection) {
                    for (Object o : ((IStructuredSelection)s).toList()) {
                        NewTransferPage.this.transfers.remove(o);
                    }
                    NewTransferPage.this.tbv.refresh();
                    if (NewTransferPage.this.transfers.isEmpty()) {
                        NewTransferPage.this.checkPageComplete();
                    }
                }
            }
        });
    }

    public void addCurrent() {
        AgentStatusDetails destAgent;
        String source = this.getSource();
        String destination = this.getDestination();
        AgentStatusDetails srcAgent = this.getSrcAgentPub();
        if (srcAgent != null && srcAgent.isCDBridge()) {
            source = String.valueOf(this.sourceCDNode.getText()) + ":" + source;
        }
        if ((destAgent = this.getDestAgentPub()) != null && destAgent.isCDBridge()) {
            destination = String.valueOf(this.destCDNode.getText()) + ":" + destination;
        }
        ItemSpecification item = new ItemSpecification(source, this.getSourceType(), this.getRecurse(), this.getTransferMode(), this.getChecksumMethod(), destination, this.getDestinationType(), this.getSourceDispositionMethod(), this.getDestinationExistsMethod());
        if (Elements.UI_WIZARD_DEST_MESSAGE_TYPE.equals(this.sourceType.getText())) {
            item.setSourceQueueProps(this.getSourceQueueProps());
        }
        if (Elements.UI_WIZARD_DEST_MESSAGE_TYPE.equals(this.destType.getText())) {
            item.setDestinationProps(this.getDestQueueProps());
        }
        this.transfers.add(item);
        this.saveComboValues();
        this.clearComboValues();
        if (!Display.getCurrent().isDisposed()) {
            Display.getCurrent().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (NewTransferPage.this.tbv.getControl().isDisposed()) {
                        return;
                    }
                    NewTransferPage.this.tbv.refresh();
                    Table table = NewTransferPage.this.tbv.getTable();
                    if (!table.isDisposed()) {
                        PageUtils.setupTable(table);
                    }
                }
            });
        }
    }

    private void addBasicSettingsGroup(Composite parent) {
        Group basicSettings = new Group(parent, 0);
        basicSettings.setText(Elements.UI_WIZARD_BASIC_SETTINGS_LABEL);
        basicSettings.setLayout((Layout)new GridLayout(2, false));
        basicSettings.setLayoutData((Object)new GridData(4, 1, true, false));
        Label mode = new Label((Composite)basicSettings, 0);
        mode.setText(Elements.UI_WIZARD_MODE_LABEL);
        mode.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false, 1, 2));
        this.text = new Button((Composite)basicSettings, 16);
        this.text.setText(Elements.UI_WIZARD_TEXT_TRANSFER_LABEL);
        this.text.setEnabled(true);
        this.binary = new Button((Composite)basicSettings, 16);
        this.binary.setText(Elements.UI_WIZARD_BIN_TRANSFER_LABEL);
        this.binary.setSelection(true);
        this.binary.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                NewTransferPage.this.checkPageForErrors();
                NewTransferPage.this.checkPageComplete();
            }
        });
        Label cs = new Label((Composite)basicSettings, 0);
        cs.setText(Elements.UI_WIZARD_CHECKSUM_LABEL);
        cs.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false, 1, 1));
        this.disableChecksum = new Button((Composite)basicSettings, 32);
        this.disableChecksum.setText(Elements.UI_WIZARD_CHECKSUM_BUTTON);
        this.disableChecksum.setSelection(false);
        Label rm = new Label((Composite)basicSettings, 0);
        rm.setText(Elements.UI_WIZARD_DISPOSITION_LABEL);
        rm.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false, 1, 1));
        this.remove = new Button((Composite)basicSettings, 32);
        this.remove.setText(Elements.UI_WIZARD_REMOVE_FILES_BUTTON);
    }

    private void addToGroup(Composite parent) {
        int widthHint = this.getFirstColumnWidth(parent);
        final Group to = new Group(parent, 0);
        to.setText(Elements.UI_WIZARD_TO_LABEL);
        to.setLayout((Layout)new GridLayout(2, false));
        to.setLayoutData((Object)new GridData(4, 1, true, false));
        this.destHost = this.createCombo((Composite)to, Elements.UI_WIZARD_HOST_LABEL, Elements.UI_WIZARD_HOST_DEST_TOOLTIP, 8);
        this.destHostViewer = new ComboViewer(this.destHost);
        this.destHostViewer.setContentProvider((IContentProvider)new AgentContentProvider());
        this.destHostViewer.setLabelProvider((IBaseLabelProvider)new AgentLabelProvider());
        this.destHostViewer.setInput(this.availableAgents);
        this.setDefaultDestAgent();
        this.destHost.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AgentStatusDetails agent = NewTransferPage.this.getDestAgentPub();
                if (agent != null) {
                    if (agent.isCDBridge()) {
                        Control[] enabledControls;
                        Control[] controlArray = enabledControls = new Control[]{NewTransferPage.this.destCDNodeLabel, NewTransferPage.this.destCDNode};
                        int n = enabledControls.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Control c = controlArray[n2];
                            if (c != null) {
                                c.setVisible(true);
                                if (c.getLayoutData() instanceof GridData) {
                                    ((GridData)c.getLayoutData()).exclude = false;
                                }
                            }
                            ++n2;
                        }
                        NewTransferPage.this.destType.setItems(NewTransferPage.this.destCDTypes);
                        NewTransferPage.this.destType.select(0);
                        NewTransferPage.this.destType.notifyListeners(13, new Event());
                    } else {
                        Control[] disabledControls;
                        Control[] controlArray = disabledControls = new Control[]{NewTransferPage.this.destCDNodeLabel, NewTransferPage.this.destCDNode};
                        int n = disabledControls.length;
                        int n3 = 0;
                        while (n3 < n) {
                            Control c = controlArray[n3];
                            if (c != null) {
                                c.setVisible(false);
                                if (c.getLayoutData() instanceof GridData) {
                                    ((GridData)c.getLayoutData()).exclude = true;
                                }
                            }
                            ++n3;
                        }
                        NewTransferPage.this.destType.setItems(NewTransferPage.this.destTypes);
                        NewTransferPage.this.destType.select(0);
                        NewTransferPage.this.destType.notifyListeners(13, new Event());
                    }
                    to.layout(true);
                    to.setSize(to.computeSize(to.getSize().x, -1, true));
                    Composite parent = to.getParent();
                    parent.setSize(parent.computeSize(parent.getSize().x, -1, true));
                    parent.getParent().layout(true);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                NewTransferPage.this.sourceHost.select(0);
            }
        });
        this.destCDNodeLabel = new Label((Composite)to, 131072);
        this.destCDNodeLabel.setText(Elements.UI_WIZARD_NODE_LABEL);
        this.destCDNodeLabel.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        this.destCDNode = new Combo((Composite)to, 0);
        this.destCDNode.setToolTipText(Elements.UI_WIZARD_DEST_NODE_TOOLTIP);
        String[] history = this.settings.getArray(DEST_CD_NODE_HISTORY);
        if (history != null) {
            this.destCDNode.setItems(history);
        }
        this.destCDNode.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.destCDNode.select(0);
        this.addComboListener(this.destCDNode);
        this.destType = this.createCombo((Composite)to, Elements.UI_WIZARD_TYPE_LABEL, Elements.UI_WIZARD_DEST_TYPE_TOOLTIP, 8);
        this.destType.setItems(this.destTypes);
        this.destType.select(0);
        final Composite destinations = new Composite((Composite)to, 0);
        destinations.setLayout((Layout)new GridLayout(2, false));
        destinations.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
        final Label destPathLabel = new Label(destinations, 131072);
        destPathLabel.setText(Elements.UI_WIZARD_PATH_LABEL);
        GridData gd = new GridData(0x1000008, 0x1000000, false, false);
        gd.widthHint = widthHint;
        destPathLabel.setLayoutData((Object)gd);
        this.destPath = new Combo(destinations, 0);
        String[] history2 = this.settings.getArray(DEST_PATH_HISTORY);
        if (history2 != null) {
            this.destPath.setItems(history2);
        }
        this.destPath.setToolTipText(Elements.UI_WIZARD_PATH_DEST_TOOLTIP);
        this.destPath.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.addComboListener(this.destPath);
        final Label destFileLabel = new Label(destinations, 131072);
        destFileLabel.setText(Elements.UI_WIZARD_FILENAME_LABEL);
        GridData gd2 = new GridData(0x1000008, 0x1000000, false, false);
        gd2.widthHint = widthHint;
        destFileLabel.setLayoutData((Object)gd2);
        this.destFile = new Combo(destinations, 0);
        String[] history3 = this.settings.getArray(DEST_FILE_HISTORY);
        if (history3 != null) {
            this.destFile.setItems(history3);
        }
        this.destFile.setToolTipText(Elements.UI_WIZARD_FILENAME_TOOLTIP);
        this.destFile.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.addComboListener(this.destFile);
        final Label destQueueLabel = new Label(destinations, 131072);
        destQueueLabel.setText(Elements.UI_WIZARD_QUEUE_LABEL);
        GridData gd3 = new GridData(0x1000008, 0x1000000, false, false);
        gd3.widthHint = widthHint;
        destQueueLabel.setLayoutData((Object)gd3);
        this.destQueue = new Combo(destinations, 0);
        String[] history4 = this.settings.getArray(DEST_QUEUE_HISTORY);
        if (history4 != null) {
            this.destQueue.setItems(history4);
        }
        this.destQueue.setToolTipText(Elements.UI_WIZARD_QUEUE_DEST_TOOLTIP);
        this.destQueue.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.addComboListener(this.destQueue);
        final Label destFileSpaceLabel = new Label(destinations, 131072);
        destFileSpaceLabel.setText(Elements.UI_WIZARD_FILESPACE_LABEL);
        GridData gd4 = new GridData(0x1000008, 0x1000000, false, false);
        gd4.widthHint = widthHint;
        destFileSpaceLabel.setLayoutData((Object)gd4);
        this.destFileSpace = new Combo(destinations, 0);
        String[] history5 = this.settings.getArray(DEST_FILESPACE_HISTORY);
        if (history5 != null) {
            this.destFileSpace.setItems(history5);
        }
        this.destFileSpace.setToolTipText(Elements.UI_WIZARD_FILESPACE_DEST_TOOLTIP);
        this.destFileSpace.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.addComboListener(this.destFileSpace);
        Label padding = new Label((Composite)to, 0);
        padding.setVisible(false);
        GridData gd5 = new GridData(0x1000008, 0x1000000, false, false);
        gd5.widthHint = widthHint;
        padding.setLayoutData((Object)gd5);
        this.overwrite = new Button((Composite)to, 32);
        this.overwrite.setText(Elements.UI_WIZARD_OVERWRITE_BUTTON);
        this.overwrite.setSelection(false);
        this.destType.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Object s = e.getSource();
                if (s instanceof Combo) {
                    String selectedType = ((Combo)s).getText();
                    Control[] controlArray = destinations.getChildren();
                    int n = controlArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Combo combo;
                        Control c = controlArray[n2];
                        c.setVisible(false);
                        if (c instanceof Combo && ((combo = (Combo)c).getStyle() & 8) == 0) {
                            combo.setText("");
                        }
                        ((GridData)c.getLayoutData()).exclude = true;
                        ++n2;
                    }
                    if (NewTransferPage.this.destQueueOptionsGroup != null) {
                        NewTransferPage.this.destQueueOptionsGroup.setVisible(false);
                        if (NewTransferPage.this.destQueueOptionsGroup.getLayoutData() instanceof GridData) {
                            ((GridData)((NewTransferPage)NewTransferPage.this).destQueueOptionsGroup.getLayoutData()).exclude = true;
                        }
                    }
                    Control[] enabledControls = new Control[]{};
                    if (Elements.UI_WIZARD_DEST_FILE_TYPE.equals(selectedType)) {
                        enabledControls = new Control[]{destPathLabel, NewTransferPage.this.destPath, destFileLabel, NewTransferPage.this.destFile};
                    } else if (Elements.UI_WIZARD_DEST_DIRECTORY_TYPE.equals(selectedType)) {
                        enabledControls = new Control[]{destPathLabel, NewTransferPage.this.destPath};
                    } else if (Elements.UI_WIZARD_DEST_DATASET_TYPE.equals(selectedType)) {
                        enabledControls = new Control[]{destPathLabel, NewTransferPage.this.destPath, destFileLabel, NewTransferPage.this.destFile};
                    } else if (Elements.UI_WIZARD_DEST_MESSAGE_TYPE.equals(selectedType)) {
                        enabledControls = new Control[]{destQueueLabel, NewTransferPage.this.destQueue, NewTransferPage.this.destQueueOptionsGroup};
                    } else if (Elements.UI_WIZARD_DEST_FILESPACE_TYPE.equals(selectedType)) {
                        enabledControls = new Control[]{destFileSpaceLabel, NewTransferPage.this.destFileSpace};
                    }
                    NewTransferPage.this.overwrite.setEnabled(!Elements.UI_WIZARD_DEST_MESSAGE_TYPE.equals(selectedType) && !Elements.UI_WIZARD_DEST_FILESPACE_TYPE.equals(selectedType));
                    Control[] controlArray2 = enabledControls;
                    int n3 = enabledControls.length;
                    n = 0;
                    while (n < n3) {
                        Control c = controlArray2[n];
                        if (c != null) {
                            c.setVisible(true);
                            if (c.getLayoutData() instanceof GridData) {
                                ((GridData)c.getLayoutData()).exclude = false;
                            }
                        }
                        ++n;
                    }
                    destinations.layout(true);
                    destinations.setSize(destinations.computeSize(destinations.getSize().x, -1, true));
                    Composite parent = destinations.getParent();
                    parent.setSize(parent.computeSize(parent.getSize().x, -1, true));
                    parent.getParent().layout(true);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                NewTransferPage.this.destType.select(0);
            }
        });
        int wHint = Math.max(512, this.destHost.computeSize((int)-1, (int)-1).x);
        this.sizeCombosUniformly(parent, wHint);
    }

    private void sizeCombosUniformly(Composite parent, int wHint) {
        Control[] controlArray = parent.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            if (control instanceof Composite) {
                this.sizeCombosUniformly((Composite)control, wHint);
            }
            if (control instanceof Combo) {
                GridData gd = new GridData(1, 0x1000000, true, false);
                gd.widthHint = wHint;
                control.setLayoutData((Object)gd);
                control.setSize(control.computeSize(wHint, -1));
            }
            ++n2;
        }
    }

    private void addFromGroup(Composite parent) {
        int widthHint = this.getFirstColumnWidth(parent);
        final Group from = new Group(parent, 0);
        from.setText(Elements.UI_WIZARD_FROM_LABEL);
        from.setLayout((Layout)new GridLayout(2, false));
        from.setLayoutData((Object)new GridData(4, 1, true, false));
        this.sourceHost = this.createCombo((Composite)from, Elements.UI_WIZARD_HOST_LABEL, Elements.UI_WIZARD_HOST_SOURCE_TOOLTIP, 8);
        this.srcHostViewer = new ComboViewer(this.sourceHost);
        this.srcHostViewer.setLabelProvider((IBaseLabelProvider)new AgentLabelProvider());
        this.srcHostViewer.setContentProvider((IContentProvider)new AgentContentProvider());
        this.srcHostViewer.setInput(this.availableAgents);
        this.setDefaultSrcAgent();
        this.sourceHost.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AgentStatusDetails agent = NewTransferPage.this.getSrcAgentPub();
                if (agent != null) {
                    if (agent.isCDBridge()) {
                        Control[] enabledControls;
                        Control[] controlArray = enabledControls = new Control[]{NewTransferPage.this.sourceCDNodeLabel, NewTransferPage.this.sourceCDNode};
                        int n = enabledControls.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Control c = controlArray[n2];
                            if (c != null) {
                                c.setVisible(true);
                                if (c.getLayoutData() instanceof GridData) {
                                    ((GridData)c.getLayoutData()).exclude = false;
                                }
                            }
                            ++n2;
                        }
                        NewTransferPage.this.sourceType.setItems(NewTransferPage.this.srcCDTypes);
                        NewTransferPage.this.sourceType.select(0);
                        NewTransferPage.this.sourceType.notifyListeners(13, new Event());
                        NewTransferPage.this.recurse.setVisible(false);
                        ((GridData)((NewTransferPage)NewTransferPage.this).recurse.getLayoutData()).exclude = true;
                    } else {
                        Control[] disabledControls;
                        Control[] controlArray = disabledControls = new Control[]{NewTransferPage.this.sourceCDNodeLabel, NewTransferPage.this.sourceCDNode};
                        int n = disabledControls.length;
                        int n3 = 0;
                        while (n3 < n) {
                            Control c = controlArray[n3];
                            if (c != null) {
                                c.setVisible(false);
                                if (c.getLayoutData() instanceof GridData) {
                                    ((GridData)c.getLayoutData()).exclude = true;
                                }
                            }
                            ++n3;
                        }
                        NewTransferPage.this.sourceType.setItems(NewTransferPage.this.srcTypes);
                        NewTransferPage.this.sourceType.select(0);
                        NewTransferPage.this.sourceType.notifyListeners(13, new Event());
                        NewTransferPage.this.recurse.setVisible(true);
                        ((GridData)((NewTransferPage)NewTransferPage.this).recurse.getLayoutData()).exclude = false;
                    }
                    from.layout(true);
                    from.setSize(from.computeSize(from.getSize().x, -1, true));
                    Composite parent = from.getParent();
                    parent.setSize(parent.computeSize(parent.getSize().x, -1, true));
                    parent.getParent().layout(true);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                NewTransferPage.this.sourceHost.select(0);
            }
        });
        this.sourceCDNodeLabel = new Label((Composite)from, 131072);
        this.sourceCDNodeLabel.setText(Elements.UI_WIZARD_NODE_LABEL);
        this.sourceCDNodeLabel.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        this.sourceCDNode = new Combo((Composite)from, 0);
        this.sourceCDNode.setToolTipText(Elements.UI_WIZARD_SOURCE_NODE_TOOLTIP);
        String[] history = this.settings.getArray(SOURCE_CD_NODE_HISTORY);
        if (history != null) {
            this.sourceCDNode.setItems(history);
        }
        this.sourceCDNode.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.sourceCDNode.select(0);
        this.addComboListener(this.sourceCDNode);
        this.sourceType = this.createCombo((Composite)from, Elements.UI_WIZARD_TYPE_LABEL, Elements.UI_WIZARD_SRC_TYPE_TOOLTIP, 8);
        this.sourceType.setItems(this.srcTypes);
        this.sourceType.select(0);
        final Composite sources = new Composite((Composite)from, 0);
        sources.setLayout((Layout)new GridLayout(2, false));
        sources.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
        final Label sourceFileLabel = new Label(sources, 131072);
        sourceFileLabel.setText(Elements.UI_WIZARD_FILE_LABEL);
        GridData gd = new GridData(0x1000008, 0x1000000, false, false);
        gd.widthHint = widthHint;
        sourceFileLabel.setLayoutData((Object)gd);
        this.sourceFile = new Combo(sources, 0);
        String[] history2 = this.settings.getArray(SOURCE_FILE_HISTORY);
        if (history2 != null) {
            this.sourceFile.setItems(history2);
        }
        this.sourceFile.setToolTipText(Elements.UI_WIZARD_FILE_TOOLTIP);
        this.sourceFile.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.addComboListener(this.sourceFile);
        final Label sourceQueueLabel = new Label(sources, 131072);
        sourceQueueLabel.setText(Elements.UI_WIZARD_QUEUE_LABEL);
        GridData gd2 = new GridData(0x1000008, 0x1000000, false, false);
        gd2.widthHint = widthHint;
        sourceQueueLabel.setLayoutData((Object)gd2);
        this.sourceQueue = new Combo(sources, 0);
        String[] history3 = this.settings.getArray(SOURCE_QUEUE_HISTORY);
        if (history3 != null) {
            this.sourceQueue.setItems(history3);
        }
        this.sourceQueue.setToolTipText(Elements.UI_WIZARD_QUEUE_SRC_TOOLTIP);
        this.sourceQueue.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.addComboListener(this.sourceQueue);
        Label padding = new Label((Composite)from, 0);
        padding.setVisible(false);
        GridData gd3 = new GridData(0x1000008, 0x1000000, false, false);
        gd3.widthHint = widthHint;
        padding.setLayoutData((Object)gd3);
        this.recurse = new Button((Composite)from, 32);
        this.recurse.setText(Elements.UI_WIZARD_RECURSE_LABEL);
        this.recurse.setSelection(false);
        this.recurse.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                NewTransferPage.this.sourceFile.notifyListeners(24, new Event());
            }
        });
        this.sourceType.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Object s = e.getSource();
                if (s instanceof Combo) {
                    String selectedType = ((Combo)s).getText();
                    Control[] controlArray = sources.getChildren();
                    int n = controlArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Combo combo;
                        Control c = controlArray[n2];
                        c.setVisible(false);
                        if (c instanceof Combo && ((combo = (Combo)c).getStyle() & 8) == 0) {
                            combo.setText("");
                        }
                        if (c.getLayoutData() instanceof GridData) {
                            ((GridData)c.getLayoutData()).exclude = true;
                        }
                        ++n2;
                    }
                    if (NewTransferPage.this.sourceQueueOptionsGroup != null) {
                        NewTransferPage.this.sourceQueueOptionsGroup.setVisible(false);
                        if (NewTransferPage.this.sourceQueueOptionsGroup.getLayoutData() instanceof GridData) {
                            ((GridData)((NewTransferPage)NewTransferPage.this).sourceQueueOptionsGroup.getLayoutData()).exclude = true;
                        }
                    }
                    Control[] enabledControls = new Control[]{};
                    if (Elements.UI_WIZARD_DEST_FILE_TYPE.equals(selectedType)) {
                        enabledControls = new Control[]{sourceFileLabel, NewTransferPage.this.sourceFile};
                    } else if (Elements.UI_WIZARD_DEST_DIRECTORY_TYPE.equals(selectedType)) {
                        enabledControls = new Control[]{sourceFileLabel, NewTransferPage.this.sourceFile};
                    } else if (Elements.UI_WIZARD_DEST_DATASET_TYPE.equals(selectedType)) {
                        enabledControls = new Control[]{sourceFileLabel, NewTransferPage.this.sourceFile};
                    } else if (Elements.UI_WIZARD_DEST_MESSAGE_TYPE.equals(selectedType)) {
                        enabledControls = new Control[]{sourceQueueLabel, NewTransferPage.this.sourceQueue, NewTransferPage.this.sourceQueueOptionsGroup};
                    }
                    NewTransferPage.this.recurse.setEnabled(!Elements.UI_WIZARD_DEST_MESSAGE_TYPE.equals(selectedType));
                    Control[] controlArray2 = enabledControls;
                    int n3 = enabledControls.length;
                    n = 0;
                    while (n < n3) {
                        Control c = controlArray2[n];
                        if (c != null) {
                            c.setVisible(true);
                            if (c.getLayoutData() instanceof GridData) {
                                ((GridData)c.getLayoutData()).exclude = false;
                            }
                        }
                        ++n;
                    }
                    sources.layout(true);
                    sources.setSize(sources.computeSize(sources.getSize().x, -1, true));
                    Composite parent = sources.getParent();
                    parent.setSize(parent.computeSize(parent.getSize().x, -1, true));
                    parent.getParent().layout(true);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                NewTransferPage.this.sourceType.select(0);
            }
        });
        int wHint = Math.max(512, this.sourceHost.computeSize((int)-1, (int)-1).x);
        this.sizeCombosUniformly(parent, wHint);
    }

    private Combo createCombo(Composite parent, String title, String tooltip, int style) {
        Combo combo = PageUtils.createCombo(parent, title, tooltip, style);
        this.addComboListener(combo);
        return combo;
    }

    private void addComboListener(Combo combo) {
        combo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewTransferPage.this.checkPageForErrors();
                NewTransferPage.this.checkPageComplete();
            }
        });
        combo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                NewTransferPage.this.checkPageForErrors();
                NewTransferPage.this.checkPageComplete();
            }
        });
    }

    public AgentStatusDetails getSrcAgentPub() {
        Object o;
        int i = this.sourceHost.getSelectionIndex();
        if (i >= 0 && (o = this.srcHostViewer.getElementAt(i)) instanceof AgentStatusDetails) {
            return (AgentStatusDetails)o;
        }
        return null;
    }

    public AgentStatusDetails getDestAgentPub() {
        Object o;
        int i = this.destHost.getSelectionIndex();
        if (i >= 0 && (o = this.destHostViewer.getElementAt(i)) instanceof AgentStatusDetails) {
            return (AgentStatusDetails)o;
        }
        return null;
    }

    public String getDestination() {
        String path = "";
        if (Elements.UI_WIZARD_DEST_MESSAGE_TYPE.equals(this.destType.getText())) {
            path = this.getDestQueue();
        } else if (Elements.UI_WIZARD_DEST_FILESPACE_TYPE.equals(this.destType.getText())) {
            path = this.getDestFileSpace();
        } else {
            path = this.getDestPath().trim();
            if (this.getDestFile().trim().length() > 0) {
                if (path.length() > 0 && path.charAt(path.length() - 1) != '/') {
                    AgentStatusDetails destAgentPub = this.getDestAgentPub();
                    if (destAgentPub != null && destAgentPub.getAgentOsName().startsWith("Windows") && !destAgentPub.isProtocolBridge()) {
                        if (path.charAt(path.length() - 1) != '\\') {
                            path = String.valueOf(path) + '\\';
                        }
                    } else {
                        path = String.valueOf(path) + '/';
                    }
                }
                path = String.valueOf(path) + this.getDestFile().trim();
            }
        }
        return path;
    }

    private Map<String, String> getSourceQueueProps() {
        HashMap<String, String> queueProps = new HashMap<String, String>();
        if (Elements.UI_WIZARD_DEST_MESSAGE_TYPE.equals(this.sourceType.getText())) {
            queueProps.put("useGroups", Boolean.toString(this.sqMsgGrouping.getSelection()));
            if (this.sqMsgWait.getSelection()) {
                queueProps.put("waitTime", Integer.toString(this.sqMsgWaitValue.getSelection()));
            }
            if (this.sqMsgDelimiterButton.getSelection()) {
                if (Elements.UI_WIZARD_SPLIT_BINARY_DELIMITER.equals(this.sqMsgDelimiterType.getText())) {
                    if (this.sqMsgDelimiter.getText().length() > 0) {
                        queueProps.put("delimiterType", "binary");
                        queueProps.put("delimiter", this.sqMsgDelimiter.getText());
                        if (Elements.UI_WIZARD_MESSAGE_DELIMITER_PREFIX_LABEL.equals(this.sqMsgDelimiterPosition.getText())) {
                            queueProps.put("delimiterPosition", FTEQueueDelimiter.DelimiterPosition.PREFIX.name().toLowerCase());
                        } else {
                            queueProps.put("delimiterPosition", FTEQueueDelimiter.DelimiterPosition.POSTFIX.name().toLowerCase());
                        }
                    }
                } else if (Elements.UI_WIZARD_SPLIT_TEXT_SEQUENCE.equals(this.sqMsgDelimiterType.getText()) && this.sqMsgDelimiter.getText().length() > 0) {
                    queueProps.put("delimiterType", "text");
                    queueProps.put("delimiter", this.sqMsgDelimiter.getText());
                    if (Elements.UI_WIZARD_MESSAGE_DELIMITER_PREFIX_LABEL.equals(this.sqMsgDelimiterPosition.getText())) {
                        queueProps.put("delimiterPosition", FTEQueueDelimiter.DelimiterPosition.PREFIX.name().toLowerCase());
                    } else {
                        queueProps.put("delimiterPosition", FTEQueueDelimiter.DelimiterPosition.POSTFIX.name().toLowerCase());
                    }
                }
            }
        }
        return queueProps;
    }

    private Map<String, String> getDestQueueProps() {
        HashMap<String, String> queueProps = new HashMap<String, String>();
        if (Elements.UI_WIZARD_DEST_MESSAGE_TYPE.equals(this.destType.getText())) {
            queueProps.put("persistent", Boolean.toString(this.dqMsgPersistence.getSelection()));
            queueProps.put("setMqProps", Boolean.toString(this.dqMsgProperties.getSelection()));
            if (this.dqMsgSplittingButton.getSelection()) {
                if (Elements.UI_WIZARD_SPLIT_SIZE.equals(this.dqMsgSplittingType.getText())) {
                    queueProps.put("delimiterType", "size");
                    queueProps.put("delimiter", String.valueOf(this.dqSizeValue.getSelection()) + this.dqSizeType.getText());
                } else if (Elements.UI_WIZARD_SPLIT_BINARY_DELIMITER.equals(this.dqMsgSplittingType.getText())) {
                    if (this.dqMsgSplittingDelimiter.getText().length() > 0) {
                        queueProps.put("delimiterType", "binary");
                        queueProps.put("delimiter", this.dqMsgSplittingDelimiter.getText());
                        if (Elements.UI_WIZARD_MESSAGE_DELIMITER_PREFIX_LABEL.equals(this.dqMsgDelimiterPosition.getText())) {
                            queueProps.put("delimiterPosition", FTEQueueDelimiter.DelimiterPosition.PREFIX.name().toLowerCase());
                        } else {
                            queueProps.put("delimiterPosition", FTEQueueDelimiter.DelimiterPosition.POSTFIX.name().toLowerCase());
                        }
                    }
                } else if (Elements.UI_WIZARD_SPLIT_TEXT_PATTERN.equals(this.dqMsgSplittingType.getText()) && this.dqMsgSplittingDelimiter.getText().length() > 0) {
                    queueProps.put("delimiterType", "text");
                    queueProps.put("delimiter", this.dqMsgSplittingDelimiter.getText());
                    if (Elements.UI_WIZARD_MESSAGE_DELIMITER_PREFIX_LABEL.equals(this.dqMsgDelimiterPosition.getText())) {
                        queueProps.put("delimiterPosition", FTEQueueDelimiter.DelimiterPosition.PREFIX.name().toLowerCase());
                    } else {
                        queueProps.put("delimiterPosition", FTEQueueDelimiter.DelimiterPosition.POSTFIX.name().toLowerCase());
                    }
                }
                queueProps.put("includeDelimiterInMessage", Boolean.toString(this.dqMsgIncludeDelimitersButton.getSelection()));
            }
        }
        return queueProps;
    }

    private void setSourceQueueProps(Map<String, String> queueProps) {
        if (queueProps == null || queueProps.isEmpty()) {
            return;
        }
        this.sqMsgGrouping.setSelection("true".equals(queueProps.get("useGroups")));
        this.sqMsgGrouping.notifyListeners(13, new Event());
        if (queueProps.containsKey("waitTime")) {
            this.sqMsgWait.setSelection(true);
            this.sqMsgWaitValue.setSelection(Integer.parseInt(queueProps.get("waitTime")));
            this.sqMsgWait.notifyListeners(13, new Event());
        }
        if (queueProps.containsKey("delimiterType")) {
            this.sqMsgDelimiterButton.setSelection(true);
            this.sqMsgDelimiterButton.notifyListeners(13, new Event());
            String delimiterType = queueProps.get("delimiterType");
            if ("binary".equals(delimiterType)) {
                this.sqMsgDelimiterType.select(this.sqMsgDelimiterType.indexOf(Elements.UI_WIZARD_SPLIT_BINARY_DELIMITER));
                this.sqMsgDelimiterType.notifyListeners(13, new Event());
                this.sqMsgDelimiter.setText(queueProps.get("delimiter"));
            } else if ("text".equals(delimiterType)) {
                this.sqMsgDelimiterType.select(this.sqMsgDelimiterType.indexOf(Elements.UI_WIZARD_SPLIT_TEXT_SEQUENCE));
                this.sqMsgDelimiterType.notifyListeners(13, new Event());
                this.sqMsgDelimiter.setText(queueProps.get("delimiter"));
            }
            if (FTEQueueDelimiter.DelimiterPosition.PREFIX.name().equalsIgnoreCase(queueProps.get("delimiterPosition"))) {
                this.sqMsgDelimiterPosition.select(0);
            }
        }
    }

    private void setDestQueueProps(Map<String, String> queueProps) {
        if (queueProps == null || queueProps.isEmpty()) {
            return;
        }
        this.dqMsgPersistence.setSelection("true".equals(queueProps.get("persistent")));
        this.dqMsgPersistence.notifyListeners(13, new Event());
        this.dqMsgProperties.setSelection("true".equals(queueProps.get("setMqProps")));
        this.dqMsgProperties.notifyListeners(13, new Event());
        if (queueProps.containsKey("delimiterType")) {
            this.dqMsgSplittingButton.setSelection(true);
            this.dqMsgSplittingButton.notifyListeners(13, new Event());
            String delimiterType = queueProps.get("delimiterType");
            if ("size".equals(delimiterType)) {
                this.dqMsgSplittingType.select(this.dqMsgSplittingType.indexOf(Elements.UI_WIZARD_SPLIT_SIZE));
                this.dqMsgSplittingType.notifyListeners(13, new Event());
                String sizeStr = queueProps.get("delimiter");
                int val = Integer.parseInt(sizeStr.substring(0, sizeStr.length() - 1));
                this.dqSizeValue.setSelection(val);
                String suffix = sizeStr.substring(sizeStr.length() - 1);
                this.dqSizeType.select(this.dqSizeType.indexOf(suffix));
            } else if ("binary".equals(delimiterType)) {
                this.dqMsgSplittingType.select(this.dqMsgSplittingType.indexOf(Elements.UI_WIZARD_SPLIT_BINARY_DELIMITER));
                this.dqMsgSplittingType.notifyListeners(13, new Event());
                this.dqMsgSplittingDelimiter.setText(queueProps.get("delimiter"));
            } else if ("text".equals(delimiterType)) {
                this.dqMsgSplittingType.select(this.dqMsgSplittingType.indexOf(Elements.UI_WIZARD_SPLIT_TEXT_PATTERN));
                this.dqMsgSplittingType.notifyListeners(13, new Event());
                this.dqMsgSplittingDelimiter.setText(queueProps.get("delimiter"));
            }
            if (FTEQueueDelimiter.DelimiterPosition.PREFIX.name().equalsIgnoreCase(queueProps.get("delimiterPosition"))) {
                this.dqMsgDelimiterPosition.select(0);
            }
            this.dqMsgIncludeDelimitersButton.setSelection("true".equals(queueProps.get("includeDelimiterInMessage")));
        }
    }

    public String getSource() {
        if (Elements.UI_WIZARD_DEST_MESSAGE_TYPE.equals(this.sourceType.getText())) {
            return this.getSourceQueue();
        }
        return this.getSourceFile();
    }

    public void checkPageComplete() {
        if (this.addToGroup != null && !this.isDestIdentical()) {
            this.addToGroup.setEnabled(this.status.getSeverity() < 4 && (this.isFormFilled() || this.pageType == TransferPageType.TEMPLATE && this.isPathFilled()));
        }
        if (this.pageType == TransferPageType.TEMPLATE) {
            this.setPageComplete(true);
        } else if (this.isControlCreated()) {
            this.sourceHost.setEnabled(this.transfers.isEmpty() || this.getSourceHost().length() == 0);
            this.destHost.setEnabled(this.transfers.isEmpty() || this.getDestHost().length() == 0);
            if (!this.transfers.isEmpty()) {
                this.sourceCDNode.setEnabled(!this.getSrcAgentPub().isCDBridge());
                this.destCDNode.setEnabled(!this.getDestAgentPub().isCDBridge());
            }
            this.setPageComplete(this.status.getSeverity() < 4 && (this.isFormFilled() || !this.transfers.isEmpty() && this.isAgentFilled()));
        }
    }

    private boolean isWildcard(String filePath) {
        String srcOS;
        boolean isWildcard = filePath.contains("*") || filePath.contains("?");
        String string = srcOS = this.sourceHost.getSelectionIndex() >= 0 ? this.getSrcAgentPub().getAgentOsName() : "";
        if (srcOS.startsWith("OS/390") || srcOS.startsWith("z/OS")) {
            isWildcard = isWildcard || filePath.contains("%");
        }
        return isWildcard;
    }

    private boolean isWildcardGroup() {
        for (ItemSpecification transfer : this.getTransfers()) {
            if (!this.isWildcard(transfer.getSourceName())) continue;
            return true;
        }
        return false;
    }

    private boolean isSrcDirectory() {
        AgentStatusDetails srcAgentPub = this.getSrcAgentPub();
        if (srcAgentPub != null) {
            String srcFile = this.getSourceFile();
            if (srcAgentPub.getAgentOsName().startsWith("Windows")) {
                return srcFile.endsWith("\\") || srcFile.endsWith("/");
            }
            return !this.isSrcDataSet() && srcFile.endsWith("/");
        }
        return false;
    }

    private boolean isSrcDataSet() {
        String srcOS = this.sourceHost.getSelectionIndex() >= 0 ? this.getSrcAgentPub().getAgentOsName() : "";
        boolean isSrcZ = srcOS.startsWith("OS/390") || srcOS.startsWith("z/OS");
        boolean isSrcDataSet = isSrcZ && this.getSourceFile().startsWith("//");
        return isSrcDataSet;
    }

    public boolean isFormFilled() {
        return this.isAgentFilled() && this.isPathFilled() && this.isCDNodeFilled();
    }

    private boolean isAgentFilled() {
        return this.getSourceHost().length() > 0 && this.getDestHost().length() > 0;
    }

    public boolean isPathFilled() {
        return this.getSource().length() > 0 && this.getDestination().length() > 0;
    }

    public boolean isCDNodeFilled() {
        boolean retval = true;
        if (this.getSrcAgentPub().isCDBridge()) {
            retval &= this.getSourceCDNode().length() > 0;
        }
        if (this.getDestAgentPub().isCDBridge()) {
            retval &= this.getDestCDNode().length() > 0;
        }
        return retval;
    }

    private boolean isDestIdentical() {
        return this.isFormFilled() && this.sourceHost.getText().equals(this.destHost.getText()) && this.areFilePathsEqual(this.getSourceFile(), this.getDestination());
    }

    private boolean areFilePathsEqual(String path1, String path2) {
        assert (this.sourceHost.getText().equals(this.destHost.getText()));
        AgentStatusDetails srcAgentPub = this.getSrcAgentPub();
        if (srcAgentPub.getAgentOsName().startsWith("Windows")) {
            return path1.replace('\\', '/').equalsIgnoreCase(path2.replace('\\', '/'));
        }
        return path1.equals(path2);
    }

    private void checkPageForErrors() {
        if (this.getControl() == null || this.getControl().isDisposed()) {
            return;
        }
        this.status = null;
        if (this.availableAgents.isEmpty()) {
            Exception propException = Subscription.getPropException();
            String msg = String.valueOf(Elements.UI_WIZARD_AGENTSLIST_FAIL_DIALOG) + " ";
            if (propException == null) {
                int rc = Subscription.getReasonCode();
                msg = rc == 2033 || rc == 2437 || rc == 0 ? String.valueOf(msg) + Elements.UI_WIZARD_NO_REGISTERED_AGENTS : (rc == 2059 ? String.valueOf(msg) + MessageFormat.format(Messages.BFGUI0004_Q_MGR_NOT_AVAILABLE, Subscription.getAdminQmgrName(), Subscription.getAdminQmgrHostname()) : String.valueOf(msg) + MessageFormat.format(Elements.UI_WIZARD_WMQ_RC, Integer.toString(rc)));
            } else {
                String e = propException.getLocalizedMessage();
                msg = String.valueOf(msg) + e.substring(e.lastIndexOf(58) + 1);
            }
            this.status = new Status(4, "com.ibm.wmqfte.explorer", msg);
        } else {
            boolean isDestIdentical = this.isDestIdentical();
            if (isDestIdentical) {
                this.status = new Status(4, "com.ibm.wmqfte.explorer", Elements.UI_WIZARD_SAME_SRC_DEST);
            } else {
                String destNode;
                String sourceNode;
                String msg;
                if (this.pageType != TransferPageType.TEMPLATE) {
                    long secsSinceVisible = (System.currentTimeMillis() - this.visibleTime) / 1000L;
                    if (this.visibleTime > 0L && (secsSinceVisible > 9L || !this.transfers.isEmpty() && secsSinceVisible > 0L)) {
                        if (this.sourceHost.getSelectionIndex() == -1 || this.destHost.getSelectionIndex() == -1) {
                            this.status = new Status(4, "com.ibm.wmqfte.explorer", Elements.UI_WIZARD_NEW_TRANSFER_AGENTS_MISSING);
                        } else if (this.transfers.isEmpty() && !this.isFormFilled()) {
                            this.status = new Status(4, "com.ibm.wmqfte.explorer", Elements.UI_WIZARD_NEW_TRANSFER_FILES_MISSING);
                        }
                    }
                }
                if (this.pageType == TransferPageType.MONITOR) {
                    AgentStatusDetails srcAgent = this.getSrcAgentPub();
                    if (srcAgent != null && srcAgent.isProtocolBridge()) {
                        this.status = new Status(4, "com.ibm.wmqfte.explorer", Elements.UI_WIZARD_NEW_MONITOR_BRIDGE_ILLEGAL);
                    }
                    if (srcAgent != null && srcAgent.isWebGateway()) {
                        this.status = new Status(4, "com.ibm.wmqfte.explorer", Elements.UI_WIZARD_NEW_MONITOR_WEB_ILLEGAL);
                    }
                }
                if (ItemSpecification.SourceType.QUEUE == this.getSourceType()) {
                    String source = this.getSource();
                    if (source.indexOf("@") > 0) {
                        msg = MessageFormat.format(Elements.UI_WIZARD_NEW_TRANSFER_SRC_QUEUE_BAD_FORMAT, "QNAME", "QUEUE@QUEUEMANAGER");
                        this.status = new Status(4, "com.ibm.wmqfte.explorer", msg);
                    } else if (!VALID_MQ_OBJECT_NAME.matcher(source).matches() || source.length() > 48) {
                        msg = MessageFormat.format(Elements.UI_WIZARD_NEW_TRANSFER_DEST_QUEUE_ILLEGAL, source);
                        this.status = new Status(4, "com.ibm.wmqfte.explorer", msg);
                    }
                }
                if (this.sqMsgDelimiterButton.getSelection()) {
                    String delim;
                    if (Elements.UI_WIZARD_SPLIT_BINARY_DELIMITER.equals(this.sqMsgDelimiterType.getText())) {
                        String delim2 = this.sqMsgDelimiter.getText();
                        if (delim2 != null && delim2.length() > 0) {
                            if (!this.binary.getSelection()) {
                                msg = MessageFormat.format(Elements.UI_WIZARD_NEW_TRANSFER_NONBINARY_WITH_BINARY_DELIM, delim2);
                                this.status = new Status(4, "com.ibm.wmqfte.explorer", msg);
                            }
                            if (!CmdLinePropertyValueValidator.MsgBinaryDelimiterValidator.pattern.matcher(delim2).matches()) {
                                msg = MessageFormat.format(Elements.UI_WIZARD_NEW_TRANSFER_MSG_DELIMITER_ILLEGAL, delim2);
                                this.status = new Status(4, "com.ibm.wmqfte.explorer", msg);
                            }
                        }
                    } else if (Elements.UI_WIZARD_SPLIT_TEXT_PATTERN.equals(this.dqMsgSplittingType.getText()) && (delim = this.dqMsgSplittingDelimiter.getText()) != null && delim.length() > 0 && this.binary.getSelection()) {
                        msg = MessageFormat.format(Elements.UI_WIZARD_NEW_TRANSFER_NONTEXT_WITH_TEXT_DELIM, delim);
                        this.status = new Status(4, "com.ibm.wmqfte.explorer", msg);
                    }
                }
                if (ItemSpecification.DestinationType.QUEUE == this.getDestinationType()) {
                    String dest = this.getDestination();
                    if (dest.indexOf("@") > 0) {
                        String[] queueAtQmgr = dest.split("@");
                        if (dest.indexOf("@") != dest.lastIndexOf("@") || queueAtQmgr.length > 2) {
                            String msg2 = MessageFormat.format(Elements.UI_WIZARD_NEW_TRANSFER_DEST_QUEUE_BAD_FORMAT, "QUEUE@QUEUEMANAGER");
                            this.status = new Status(4, "com.ibm.wmqfte.explorer", msg2);
                        } else if (!VALID_MQ_OBJECT_NAME.matcher(queueAtQmgr[0]).matches() || queueAtQmgr[0].length() > 48) {
                            String msg3 = MessageFormat.format(Elements.UI_WIZARD_NEW_TRANSFER_DEST_QUEUE_ILLEGAL, queueAtQmgr[0]);
                            this.status = new Status(4, "com.ibm.wmqfte.explorer", msg3);
                        } else if (!VALID_MQ_OBJECT_NAME.matcher(queueAtQmgr[1]).matches() || queueAtQmgr[1].length() > 48) {
                            String msg4 = MessageFormat.format(Elements.UI_WIZARD_NEW_TRANSFER_DEST_QUEUE_MANAGER_ILLEGAL, queueAtQmgr[1]);
                            this.status = new Status(4, "com.ibm.wmqfte.explorer", msg4);
                        }
                    } else if (!VALID_MQ_OBJECT_NAME.matcher(dest).matches() || dest.length() > 48) {
                        msg = MessageFormat.format(Elements.UI_WIZARD_NEW_TRANSFER_DEST_QUEUE_ILLEGAL, dest);
                        this.status = new Status(4, "com.ibm.wmqfte.explorer", msg);
                    }
                }
                if (this.dqMsgSplittingButton.getSelection()) {
                    String delim;
                    if (Elements.UI_WIZARD_SPLIT_SIZE.equals(this.dqMsgSplittingType.getText())) {
                        String delim3 = String.valueOf(this.dqSizeValue.getSelection()) + this.dqSizeType.getText();
                        if (delim3 != null && delim3.length() > 0 && !CmdLinePropertyValueValidator.SplitSizeValidator.pattern.matcher(delim3).matches()) {
                            msg = MessageFormat.format(Elements.UI_WIZARD_NEW_TRANSFER_MSG_DELIMITER_ILLEGAL, delim3);
                            this.status = new Status(4, "com.ibm.wmqfte.explorer", msg);
                        }
                    } else if (Elements.UI_WIZARD_SPLIT_BINARY_DELIMITER.equals(this.dqMsgSplittingType.getText())) {
                        String delim4 = this.dqMsgSplittingDelimiter.getText();
                        if (delim4 != null && delim4.length() > 0) {
                            if (!this.binary.getSelection()) {
                                msg = MessageFormat.format(Elements.UI_WIZARD_NEW_TRANSFER_NONBINARY_WITH_BINARY_DELIM, delim4);
                                this.status = new Status(4, "com.ibm.wmqfte.explorer", msg);
                            }
                            if (!CmdLinePropertyValueValidator.MsgBinaryDelimiterValidator.pattern.matcher(delim4).matches()) {
                                msg = MessageFormat.format(Elements.UI_WIZARD_NEW_TRANSFER_MSG_DELIMITER_ILLEGAL, delim4);
                                this.status = new Status(4, "com.ibm.wmqfte.explorer", msg);
                            }
                        }
                    } else if (Elements.UI_WIZARD_SPLIT_TEXT_PATTERN.equals(this.dqMsgSplittingType.getText()) && (delim = this.dqMsgSplittingDelimiter.getText()) != null && delim.length() > 0 && this.binary.getSelection()) {
                        msg = MessageFormat.format(Elements.UI_WIZARD_NEW_TRANSFER_NONTEXT_WITH_TEXT_DELIM, delim);
                        this.status = new Status(4, "com.ibm.wmqfte.explorer", msg);
                    }
                }
                if (Elements.UI_WIZARD_DEST_MESSAGE_TYPE.equals(this.sourceType.getText()) && Elements.UI_WIZARD_DEST_MESSAGE_TYPE.equals(this.destType.getText())) {
                    this.status = new Status(4, "com.ibm.wmqfte.explorer", Elements.UI_WIZARD_NEW_TRANSFER_QUEUE_TO_QUEUE);
                }
                if (this.getSrcAgentPub() != null && this.getSrcAgentPub().isCDBridge() && this.getSourceCDNode() != null && (!VALID_CD_NODE_NAME.matcher(sourceNode = this.getSourceCDNode()).matches() || sourceNode.length() > 16)) {
                    msg = MessageFormat.format(Elements.UI_WIZARD_NEW_TRANSFER_SRC_CD_NODE_ILLEGAL, sourceNode);
                    this.status = new Status(4, "com.ibm.wmqfte.explorer", msg);
                }
                if (this.getDestAgentPub() != null && this.getDestAgentPub().isCDBridge() && this.getDestCDNode() != null && (!VALID_CD_NODE_NAME.matcher(destNode = this.getDestCDNode()).matches() || destNode.length() > 16)) {
                    msg = MessageFormat.format(Elements.UI_WIZARD_NEW_TRANSFER_DEST_CD_NODE_ILLEGAL, destNode);
                    this.status = new Status(4, "com.ibm.wmqfte.explorer", msg);
                }
            }
        }
        if (this.status == null) {
            this.checkPageForWarnings();
        }
        if (this.status == null) {
            this.status = new Status(0, "com.ibm.wmqfte.explorer", "");
        }
        PageUtils.setStatusLine(this, (IStatus)this.status);
    }

    private void checkPageForWarnings() {
        IWizardPage prevPage;
        IWizardPage prevPage2;
        AgentStatusDetails destAgent;
        String interfaceLevel;
        AgentStatusDetails srcAgent;
        ItemSpecification item;
        if (this.isFormFilled() && this.transfers.contains(item = new ItemSpecification(this.getSource(), this.getSourceType(), this.getRecurse(), this.getTransferMode(), this.getChecksumMethod(), this.getDestination(), this.getDestinationType(), this.getSourceDispositionMethod(), this.getDestinationExistsMethod()))) {
            this.status = new Status(2, "com.ibm.wmqfte.explorer", Elements.UI_WIZARD_NEW_TRANSFER_DUPLICATE);
        }
        if ((srcAgent = this.getSrcAgentPub()) != null && Elements.UI_WIZARD_DEST_MESSAGE_TYPE.equals(this.sourceType.getText()) && ((interfaceLevel = srcAgent.getAgentInterfaceLevel()) == null || !ProductVersion.ProductInterfaceVersion.fromValue((String)interfaceLevel).greaterOrEqual(ProductVersion.ProductInterfaceVersion.V400))) {
            this.status = new Status(2, "com.ibm.wmqfte.explorer", Elements.UI_WIZARD_NEW_TRANSFER_SRC_BACKLEVEL);
        }
        if (!((destAgent = this.getDestAgentPub()) == null || !Elements.UI_WIZARD_DEST_MESSAGE_TYPE.equals(this.destType.getText()) && !Elements.UI_WIZARD_DEST_FILESPACE_TYPE.equals(this.destType.getText()) || (interfaceLevel = destAgent.getAgentInterfaceLevel()) != null && ProductVersion.ProductInterfaceVersion.fromValue((String)interfaceLevel).greaterOrEqual(ProductVersion.ProductInterfaceVersion.V400))) {
            this.status = new Status(2, "com.ibm.wmqfte.explorer", Elements.UI_WIZARD_NEW_TRANSFER_DEST_BACKLEVEL);
        }
        if (Elements.UI_WIZARD_DEST_FILESPACE_TYPE.equals(this.destType.getText()) && !(destAgent = this.getDestAgentPub()).isWebGateway()) {
            this.status = new Status(2, "com.ibm.wmqfte.explorer", Elements.UI_WIZARD_NEW_TRANSFER_NON_WEB_FILESPACE);
        }
        if (this.pageType == TransferPageType.MONITOR && (this.isWildcard(this.getSourceFile()) || this.isWildcardGroup()) && (prevPage2 = this.getPreviousPage()) instanceof NewMonitorPage && ((NewMonitorPage)prevPage2).isWildcard()) {
            this.status = new Status(2, "com.ibm.wmqfte.explorer", Elements.UI_WIZARD_NEW_MONITOR_WILD_WILD);
        }
        if (this.pageType == TransferPageType.MONITOR && (srcAgent = this.getSrcAgentPub()) != null && ((interfaceLevel = srcAgent.getAgentInterfaceLevel()) == null || !ProductVersion.ProductInterfaceVersion.fromValue((String)interfaceLevel).greaterOrEqual(ProductVersion.ProductInterfaceVersion.V400)) && (prevPage = this.getPreviousPage()) instanceof NewMonitorPage && ((NewMonitorPage)prevPage).getExcludePattern() != MonitorPattern.NO_PATTERN) {
            this.status = new Status(2, "com.ibm.wmqfte.explorer", Elements.UI_WIZARD_NEW_MONITOR_EXCLUDE_SRC_BACKLEVEL);
        }
    }

    public void saveComboValues() {
        if (this.settings == null) {
            return;
        }
        History.saveComboValue(this.settings, SOURCE_FILE_HISTORY, this.getSourceFile().trim());
        History.saveComboValue(this.settings, SOURCE_QUEUE_HISTORY, this.getSourceQueue().trim());
        History.saveComboValue(this.settings, SOURCE_CD_NODE_HISTORY, this.getSourceCDNode().trim());
        History.saveComboValue(this.settings, DEST_PATH_HISTORY, this.getDestPath().trim());
        History.saveComboValue(this.settings, DEST_FILE_HISTORY, this.getDestFile().trim());
        History.saveComboValue(this.settings, DEST_QUEUE_HISTORY, this.getDestQueue().trim());
        History.saveComboValue(this.settings, DEST_FILESPACE_HISTORY, this.getDestFileSpace().trim());
        History.saveComboValue(this.settings, DEST_CD_NODE_HISTORY, this.getDestCDNode().trim());
    }

    public void clearComboValues() {
        String empty = "";
        this.sourceFile.setText(empty);
        this.destPath.setText(empty);
        this.destFile.setText(empty);
        this.destQueue.setText(empty);
    }

    public IDialogSettings getSettings() {
        return this.settings;
    }

    private String getDestPath() {
        return this.destPath == null ? "" : this.destPath.getText();
    }

    private String getSourceQueue() {
        return this.sourceQueue == null ? "" : this.sourceQueue.getText();
    }

    private String getDestQueue() {
        return this.destQueue == null ? "" : this.destQueue.getText();
    }

    private String getDestFileSpace() {
        return this.destFileSpace == null ? "" : this.destFileSpace.getText();
    }

    public String getSourceHost() {
        if (this.sourceHost == null || this.sourceHost.isDisposed() || this.sourceHost.getText().length() == 0) {
            return "";
        }
        return this.sourceHost.getText().split(" ")[0];
    }

    private String getSourceFile() {
        return this.sourceFile == null ? "" : this.sourceFile.getText().trim();
    }

    private String getDestFile() {
        return this.destFile == null ? "" : this.destFile.getText();
    }

    public String getDestHost() {
        if (this.destHost == null || this.destHost.isDisposed() || this.destHost.getText().length() == 0) {
            return "";
        }
        return this.destHost.getText().split(" ")[0];
    }

    private String getSourceCDNode() {
        return this.sourceCDNode == null ? "" : this.sourceCDNode.getText();
    }

    private String getDestCDNode() {
        return this.destCDNode == null ? "" : this.destCDNode.getText();
    }

    public ItemSpecification.TransferMode getTransferMode() {
        ItemSpecification.TransferMode transferMode = null;
        transferMode = this.binary.getSelection() ? ItemSpecification.TransferMode.BINARY : (this.text.getSelection() ? ItemSpecification.TransferMode.TEXT : ItemSpecification.TransferMode.BINARY);
        return transferMode;
    }

    public ItemSpecification.ChecksumMethod getChecksumMethod() {
        return this.disableChecksum.getSelection() ? ItemSpecification.ChecksumMethod.NONE : ItemSpecification.ChecksumMethod.MD5;
    }

    public ItemSpecification.DestinationExist getDestinationExistsMethod() {
        return this.overwrite.getSelection() ? ItemSpecification.DestinationExist.OVERWRITE : ItemSpecification.DestinationExist.ERROR;
    }

    public ItemSpecification.SourceDisposition getSourceDispositionMethod() {
        return Elements.UI_WIZARD_DEST_MESSAGE_TYPE.equals(this.sourceType.getText()) || this.remove.getSelection() ? ItemSpecification.SourceDisposition.DELETE : ItemSpecification.SourceDisposition.LEAVE;
    }

    public boolean getRecurse() {
        return this.recurse.getSelection();
    }

    public int getPriority() {
        String val = this.priority.getText();
        return val.length() > 0 ? Integer.valueOf(val) : this.defaultPriority;
    }

    public ItemSpecification.SourceType getSourceType() {
        if (Elements.UI_WIZARD_DEST_MESSAGE_TYPE.equals(this.sourceType.getText())) {
            return ItemSpecification.SourceType.QUEUE;
        }
        return ItemSpecification.SourceType.FILE;
    }

    public ItemSpecification.DestinationType getDestinationType() {
        String fullPath = this.getDestination();
        String filename = this.getDestFile();
        ItemSpecification.DestinationType type = this.destQueue.getText().length() > 0 ? ItemSpecification.DestinationType.QUEUE : (this.destFileSpace.getText().length() > 0 ? ItemSpecification.DestinationType.FILESPACE : (fullPath.startsWith("//") ? (filename.length() == 0 ? ItemSpecification.DestinationType.PDS : ItemSpecification.DestinationType.DATASET) : (filename.length() == 0 ? ItemSpecification.DestinationType.DIRECTORY : ItemSpecification.DestinationType.FILE)));
        return type;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            String contextId = this.pageType == TransferPageType.TEMPLATE ? "com.ibm.wmqfte.explorer.context.UI_NewTemplateBasicHelp" : (this.pageType == TransferPageType.MONITOR ? "com.ibm.wmqfte.explorer.context.UI_NewMonitorTransferBasicHelp" : "com.ibm.wmqfte.explorer.context.UI_NewTransferSingleBasicHelp");
            ExplorerPlugin.setHelp((Control)this.getContainer().getShell(), contextId);
            this.visibleTime = System.currentTimeMillis();
            if (this.status != null && this.status.getSeverity() != 0) {
                this.checkPageForErrors();
            }
        }
    }

    public List<ItemSpecification> getTransfers() {
        for (ItemSpecification item : this.transfers) {
            if (item.getSourceType() == ItemSpecification.SourceType.QUEUE) {
                this.sourceType.select(this.sourceType.indexOf(Elements.UI_WIZARD_DEST_MESSAGE_TYPE));
                item.setSourceQueueProps(this.getSourceQueueProps());
            }
            if (item.getDestinationType() != ItemSpecification.DestinationType.QUEUE) continue;
            this.destType.select(this.destType.indexOf(Elements.UI_WIZARD_DEST_MESSAGE_TYPE));
            item.setDestinationProps(this.getDestQueueProps());
        }
        return this.transfers;
    }

    private void setDefaultSrcAgent() {
        if (this.defaultSrcHost != null) {
            for (AgentStatusDetails agent : this.availableAgents) {
                if (!agent.getAgentName().equals(this.defaultSrcHost)) continue;
                StructuredSelection selection = new StructuredSelection((Object)agent);
                this.srcHostViewer.setSelection((ISelection)selection);
                break;
            }
        }
    }

    private void setDefaultDestAgent() {
        if (this.defaultDestHost != null) {
            for (AgentStatusDetails agent : this.availableAgents) {
                if (!agent.getAgentName().equals(this.defaultDestHost)) continue;
                StructuredSelection selection = new StructuredSelection((Object)agent);
                this.destHostViewer.setSelection((ISelection)selection);
                break;
            }
        }
    }

    public static enum TransferPageType {
        NORMAL,
        TEMPLATE,
        MONITOR;

    }
}

