/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wmqfte.explorer.wizards.pages;

import com.ibm.wmqfte.explorer.Elements;
import com.ibm.wmqfte.explorer.ExplorerPlugin;
import com.ibm.wmqfte.explorer.utils.PageUtils;
import com.ibm.wmqfte.explorer.wizards.pages.NewTransferPage;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public class NewTransferMetadataPage
extends WizardPage {
    Map<String, String> metadata = new TreeMap<String, String>();
    final NewTransferPage.TransferPageType pageType;

    public NewTransferMetadataPage(String title, String description, NewTransferPage.TransferPageType pageType) {
        super(NewTransferMetadataPage.class.getName(), title, null);
        this.setDescription(description);
        this.setPageComplete(true);
        this.pageType = pageType;
    }

    public NewTransferMetadataPage(String title, String description, NewTransferPage.TransferPageType pageType, Map<String, String> metadata) {
        this(title, description, pageType);
        this.metadata.putAll(metadata);
    }

    public void createControl(Composite parent) {
        Composite c = new Composite(parent, 0);
        c.setLayout((Layout)new GridLayout(2, false));
        c.setLayoutData((Object)new GridData(4, 4, true, true));
        Label attrNameLabel = new Label(c, 0);
        attrNameLabel.setText(String.valueOf(Elements.UI_WIZARD_ATTRIBUTE_NAME_LABEL) + ':');
        PageUtils.makeBold((Control)attrNameLabel);
        final Text attrName = new Text(c, 2048);
        attrName.setLayoutData((Object)new GridData(4, 4, true, false));
        Label attrValueLabel = new Label(c, 0);
        attrValueLabel.setText(String.valueOf(Elements.UI_WIZARD_ATTRIBUTE_VALUE_LABEL) + ':');
        PageUtils.makeBold((Control)attrValueLabel);
        final Text attrValue = new Text(c, 2048);
        attrValue.setLayoutData((Object)new GridData(4, 4, true, false));
        Composite buttons = new Composite(c, 0);
        buttons.setLayout((Layout)new GridLayout(2, false));
        buttons.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false, 2, 1));
        final Button add = new Button(buttons, 8);
        add.setText(Elements.UI_WIZARD_ADD_BUTTON);
        add.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        add.setEnabled(false);
        final Button remove = new Button(buttons, 8);
        remove.setText(Elements.UI_WIZARD_REMOVE_BUTTON);
        remove.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        remove.setEnabled(false);
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                add.setEnabled(attrName.getText().trim().length() > 0 && attrValue.getText().trim().length() > 0);
            }
        };
        attrName.addModifyListener(modifyListener);
        attrValue.addModifyListener(modifyListener);
        final TableViewer tbv = new TableViewer(c, 68354);
        tbv.setContentProvider((IContentProvider)new MetaDataContentProvider());
        tbv.setLabelProvider((IBaseLabelProvider)new MetaDataLabelProvider());
        Table table = tbv.getTable();
        table.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        TableColumn f = new TableColumn(table, 16384);
        f.setText(Elements.UI_WIZARD_ATTRIBUTE_NAME_LABEL);
        TableColumn t = new TableColumn(table, 16384);
        t.setText(Elements.UI_WIZARD_ATTRIBUTE_VALUE_LABEL);
        tbv.setInput(this.metadata);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        tbv.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                remove.setEnabled(!event.getSelection().isEmpty());
            }
        });
        final Display display = parent.getDisplay();
        add.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                if (tbv.getInput() != NewTransferMetadataPage.this.metadata) {
                    tbv.setInput(NewTransferMetadataPage.this.metadata);
                }
                NewTransferMetadataPage.this.metadata.put(attrName.getText(), attrValue.getText());
                attrName.setText("");
                attrValue.setText("");
                if (!display.isDisposed()) {
                    display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            tbv.refresh();
                            Table table = tbv.getTable();
                            if (!table.isDisposed()) {
                                PageUtils.setupTable(table);
                            }
                        }
                    });
                }
            }
        });
        remove.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                ISelection s = tbv.getSelection();
                if (s instanceof IStructuredSelection) {
                    for (Object o : ((IStructuredSelection)s).toList()) {
                        if (!(o instanceof Map.Entry)) continue;
                        NewTransferMetadataPage.this.metadata.remove(((Map.Entry)o).getKey().toString());
                    }
                    tbv.refresh();
                    Table table = tbv.getTable();
                    if (!table.isDisposed()) {
                        PageUtils.setupTable(table);
                    }
                }
            }
        });
        c.layout();
        PageUtils.setupTable(table);
        this.setControl((Control)c);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            String id = "com.ibm.wmqfte.explorer.context" + (this.pageType == NewTransferPage.TransferPageType.TEMPLATE ? ".UI_NewTemplateMetadataHelp" : ".UI_NewTransferMetadataHelp");
            ExplorerPlugin.setHelp((Control)this.getContainer().getShell(), id);
        }
    }

    public Map<String, String> getTransferMetadata() {
        return this.metadata;
    }

    public static class MetaDataContentProvider
    implements IStructuredContentProvider {
        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Map) {
                return ((Map)inputElement).entrySet().toArray();
            }
            if (inputElement instanceof Collection) {
                return ((Collection)inputElement).toArray();
            }
            return null;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    public static class MetaDataLabelProvider
    implements ITableLabelProvider {
        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)element;
                if (columnIndex == 0) {
                    return entry.getKey().toString();
                }
                return entry.getValue().toString();
            }
            if (element instanceof String) {
                return (String)element;
            }
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

