/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wmqfte.explorer.wizards.pages;

import com.ibm.wmqfte.api.InternalException;
import com.ibm.wmqfte.explorer.Elements;
import com.ibm.wmqfte.explorer.ExplorerPlugin;
import com.ibm.wmqfte.explorer.utils.History;
import com.ibm.wmqfte.explorer.utils.PageUtils;
import com.ibm.wmqfte.explorer.wizards.pages.NewTransferMetadataPage;
import com.ibm.wmqfte.explorer.wizards.pages.NewTransferScheduleTriggersPage;
import com.ibm.wmqfte.explorer.wizards.pages.TableComparator;
import com.ibm.wmqfte.monitor.MonitorConstants;
import com.ibm.wmqfte.monitor.MonitorPattern;
import com.ibm.wmqfte.monitor.impl.MonitorRequest;
import com.ibm.wmqfte.monitor.impl.MonitorTriggerCondition;
import com.ibm.wmqfte.trigger.FTETriggerMultiplerUnits;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public class NewMonitorPage
extends WizardPage {
    private static final String DIRECTORY_HISTORY = "MONITOR_DIRECTORY_HISTORY";
    private static final String QUEUE_HISTORY = "MONITOR_QUEUE_HISTORY";
    private static final String TRIGGER_FILE_PATTERN_HISTORY = "TRIGGER_FILE_PATTERN_HISTORY";
    private static final String TRIGGER_EXCLUDE_PATTERN_HISTORY = "TRIGGER_EXCLUDE_PATTERN_HISTORY";
    private IDialogSettings settings;
    private Spinner pollIntervalValue;
    private Spinner batchSizeValue;
    private Combo pollIntervalType;
    private Spinner recursionValue;
    private final String[] types = new String[]{Elements.UI_WIZARD_DEST_DIRECTORY_TYPE, Elements.UI_WIZARD_DEST_MESSAGE_TYPE};
    private Text name;
    private Combo type;
    private Combo directory;
    private Combo queue;
    private Group fileTriggerGroup;
    private Group queueTriggerGroup;
    private final List<MonitorTriggerCondition> triggers = new ArrayList<MonitorTriggerCondition>();
    private Button addToGroup;
    private Combo triggerFilePattern;
    private Combo triggerFileExcludePattern;
    private Button patternsAreRegex;
    private Button shouldMatch;
    private Button notExist;
    private Button exceed;
    private Spinner sizeValue;
    private Combo sizeType;
    private Button sizeUnchanged;
    private Spinner sizeUnchangedValue;
    private Button queueNotEmpty;
    private Button completeGroups;
    private static final int defaultType = 1;
    private static final Map<String, MonitorConstants.PollIntervalUnits> intervalTypes = new LinkedHashMap<String, MonitorConstants.PollIntervalUnits>();
    private static final int[] maximums;
    private Group directoryMonitorOptionsGroup;
    private Group queueMonitorOptionsGroup;
    private Group advancedComposite;
    private Map<String, String> defaultVariableSubs;

    static {
        intervalTypes.put(Elements.UI_WIZARD_SCHEDULE_SECONDS, MonitorConstants.PollIntervalUnits.SECOND);
        intervalTypes.put(Elements.UI_WIZARD_SCHEDULE_MINUTES, MonitorConstants.PollIntervalUnits.MINUTE);
        intervalTypes.put(Elements.UI_WIZARD_SCHEDULE_HOURS, MonitorConstants.PollIntervalUnits.HOUR);
        intervalTypes.put(Elements.UI_WIZARD_SCHEDULE_DAYS, MonitorConstants.PollIntervalUnits.DAY);
        maximums = new int[]{60, 60, 48, 365};
    }

    public NewMonitorPage(String title, String description) {
        super(NewMonitorPage.class.getName(), title, null);
        this.setDescription(description);
        this.setPageComplete(false);
        this.setupHistory();
    }

    private void setupHistory() {
        IDialogSettings dialogSettings = ExplorerPlugin.getDefault().getDialogSettings();
        this.settings = dialogSettings.getSection("UI_WIZARD_NEW_MONITOR_SETTINGS");
        if (this.settings == null) {
            this.settings = dialogSettings.addNewSection("UI_WIZARD_NEW_MONITOR_SETTINGS");
        }
    }

    public void saveComboValues() {
        if (this.settings == null) {
            return;
        }
        History.saveComboValue(this.settings, DIRECTORY_HISTORY, this.getDirectory().trim());
        History.saveComboValue(this.settings, QUEUE_HISTORY, this.getQueue().trim());
        History.saveComboValue(this.settings, TRIGGER_FILE_PATTERN_HISTORY, this.triggerFilePattern.getText().trim());
        History.saveComboValue(this.settings, TRIGGER_EXCLUDE_PATTERN_HISTORY, this.triggerFileExcludePattern.getText().trim());
    }

    public void createControl(Composite parent) {
        TabFolder tabFolder = new TabFolder(parent, 128);
        tabFolder.setLayout((Layout)new GridLayout(1, true));
        Composite basicComposite = this.createBasicControl((Composite)tabFolder);
        TabItem basic = new TabItem(tabFolder, 0);
        basic.setText(Elements.UI_WIZARD_BASIC_TAB_TITLE);
        basic.setControl((Control)basicComposite);
        Composite advancedComposite = this.createAdvancedControl((Composite)tabFolder);
        TabItem advanced = new TabItem(tabFolder, 0);
        advanced.setText(Elements.UI_WIZARD_ADV_TAB_TITLE);
        advanced.setControl((Control)advancedComposite);
        this.setControl((Control)tabFolder);
    }

    private Composite createBasicControl(final Composite parent) {
        final Group g = new Group(parent, 0);
        g.setLayout((Layout)new GridLayout(2, false));
        g.setLayoutData((Object)new GridData(4, 4, true, true));
        Label label = new Label((Composite)g, 131072);
        label.setText(Elements.UI_WIZARD_NAME_LABEL);
        label.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        PageUtils.makeBold((Control)label);
        this.name = new Text((Composite)g, 2048);
        this.name.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.name.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewMonitorPage.this.checkPageComplete();
            }
        });
        this.type = PageUtils.createCombo((Composite)g, Elements.UI_WIZARD_TYPE_LABEL, null, 9);
        this.type.setItems(this.types);
        this.type.select(0);
        final Label directoryLabel = new Label((Composite)g, 131072);
        directoryLabel.setText(Elements.UI_WIZARD_DIRECTORY_LABEL);
        GridData gd = new GridData(0x1000008, 0x1000000, false, false);
        directoryLabel.setLayoutData((Object)gd);
        PageUtils.makeBold((Control)directoryLabel);
        this.directory = new Combo((Composite)g, 0);
        String[] history = this.settings.getArray(DIRECTORY_HISTORY);
        if (history != null) {
            this.directory.setItems(history);
        }
        this.directory.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewMonitorPage.this.checkPageComplete();
            }
        });
        final Label queueLabel = new Label((Composite)g, 131072);
        queueLabel.setText(Elements.UI_WIZARD_QUEUE_LABEL);
        GridData gd2 = new GridData(0x1000008, 0x1000000, false, false);
        queueLabel.setLayoutData((Object)gd2);
        PageUtils.makeBold((Control)queueLabel);
        this.queue = new Combo((Composite)g, 0);
        String[] history2 = this.settings.getArray(QUEUE_HISTORY);
        if (history2 != null) {
            this.queue.setItems(history2);
        }
        this.queue.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewMonitorPage.this.checkPageComplete();
            }
        });
        this.createTriggersControl((Composite)g);
        this.type.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Control[] resources = new Control[]{directoryLabel, NewMonitorPage.this.directory, NewMonitorPage.this.fileTriggerGroup, NewMonitorPage.this.directoryMonitorOptionsGroup, queueLabel, NewMonitorPage.this.queue, NewMonitorPage.this.queueTriggerGroup, NewMonitorPage.this.queueMonitorOptionsGroup};
                Object s = e.getSource();
                if (s instanceof Combo) {
                    String selectedType = ((Combo)s).getText();
                    Control[] controlArray = resources;
                    int n = resources.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Control c = controlArray[n2];
                        if (c != null) {
                            Combo combo;
                            c.setVisible(false);
                            if (c instanceof Combo && ((combo = (Combo)c).getStyle() & 8) == 0) {
                                combo.setText("");
                            }
                            if (c.getLayoutData() instanceof GridData) {
                                ((GridData)c.getLayoutData()).exclude = true;
                            }
                        }
                        ++n2;
                    }
                    Control[] enabledControls = new Control[]{};
                    if (Elements.UI_WIZARD_DEST_DIRECTORY_TYPE.equals(selectedType)) {
                        enabledControls = new Control[]{directoryLabel, NewMonitorPage.this.directory, NewMonitorPage.this.fileTriggerGroup, NewMonitorPage.this.directoryMonitorOptionsGroup};
                    } else if (Elements.UI_WIZARD_DEST_MESSAGE_TYPE.equals(selectedType)) {
                        enabledControls = new Control[]{queueLabel, NewMonitorPage.this.queue, NewMonitorPage.this.queueTriggerGroup, NewMonitorPage.this.queueMonitorOptionsGroup};
                    }
                    Control[] controlArray2 = enabledControls;
                    int n3 = enabledControls.length;
                    n = 0;
                    while (n < n3) {
                        Control c = controlArray2[n];
                        if (c != null) {
                            c.setVisible(true);
                            if (c.getLayoutData() instanceof GridData) {
                                ((GridData)c.getLayoutData()).exclude = false;
                            }
                        }
                        ++n;
                    }
                    if (NewMonitorPage.this.advancedComposite != null) {
                        NewMonitorPage.this.advancedComposite.layout(true);
                        NewMonitorPage.this.advancedComposite.setSize(NewMonitorPage.this.advancedComposite.computeSize(parent.getSize().x, -1, true));
                        NewMonitorPage.this.advancedComposite.getParent().layout(true);
                    }
                    g.layout(true);
                    g.setSize(g.computeSize(g.getSize().x, -1, true));
                    Composite parent2 = g.getParent();
                    parent2.setSize(parent2.computeSize(parent2.getSize().x, -1, true));
                    parent2.getParent().layout(true);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.type.notifyListeners(13, new Event());
        return g;
    }

    private Composite createAdvancedControl(Composite parent) {
        this.advancedComposite = new Group(parent, -1);
        this.advancedComposite.setLayout((Layout)new GridLayout(1, true));
        this.advancedComposite.setLayoutData((Object)new GridData(4, 1, true, false));
        final Group genericOptionsGroup = new Group((Composite)this.advancedComposite, 0);
        genericOptionsGroup.setText(Elements.UI_WIZARD_MONITOR_GENERIC_ADVANCED_OPTIONS_LABEL);
        genericOptionsGroup.setLayout((Layout)new GridLayout(3, false));
        genericOptionsGroup.setLayoutData((Object)new GridData(4, 1, true, false));
        Label pollInterval = new Label((Composite)genericOptionsGroup, 0);
        pollInterval.setText(Elements.UI_WIZARD_POLL_INTERVAL);
        pollInterval.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        this.pollIntervalValue = new Spinner((Composite)genericOptionsGroup, 2048);
        this.pollIntervalType = new Combo((Composite)genericOptionsGroup, 8);
        this.pollIntervalType.setItems(intervalTypes.keySet().toArray(new String[0]));
        this.pollIntervalType.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                Object s = e.getSource();
                if (s instanceof Combo) {
                    int index = ((Combo)s).getSelectionIndex();
                    NewMonitorPage.this.pollIntervalValue.setMaximum(maximums[index]);
                    NewMonitorPage.this.pollIntervalValue.pack();
                    genericOptionsGroup.layout();
                }
            }
        });
        this.pollIntervalType.select(1);
        this.pollIntervalValue.setMinimum(1);
        this.pollIntervalValue.setIncrement(1);
        this.pollIntervalValue.setMaximum(maximums[1]);
        Label batchSize = new Label((Composite)genericOptionsGroup, 0);
        batchSize.setText(Elements.UI_WIZARD_MONITOR_DIRECTORY_MAX_BATCH_SIZE);
        batchSize.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        this.batchSizeValue = new Spinner((Composite)genericOptionsGroup, 0);
        this.batchSizeValue.setMinimum(1);
        this.batchSizeValue.setIncrement(1);
        this.batchSizeValue.setMaximum(Integer.MAX_VALUE);
        this.directoryMonitorOptionsGroup = new Group((Composite)this.advancedComposite, 0);
        this.directoryMonitorOptionsGroup.setText(Elements.UI_WIZARD_MONITOR_DIRECTORY_ADVANCED_OPTIONS_LABEL);
        this.directoryMonitorOptionsGroup.setLayout((Layout)new GridLayout(3, false));
        this.directoryMonitorOptionsGroup.setLayoutData((Object)new GridData(4, 1, true, false));
        Label recursionDepth = new Label((Composite)this.directoryMonitorOptionsGroup, 0);
        recursionDepth.setText(Elements.UI_WIZARD_RECURSION_DEPTH);
        recursionDepth.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        this.recursionValue = new Spinner((Composite)this.directoryMonitorOptionsGroup, 2048);
        this.recursionValue.setMinimum(0);
        this.recursionValue.setIncrement(1);
        this.recursionValue.setMaximum(99);
        this.queueMonitorOptionsGroup = new Group((Composite)this.advancedComposite, 0);
        this.queueMonitorOptionsGroup.setText(Elements.UI_WIZARD_MONITOR_QUEUE_ADVANCED_OPTIONS_LABEL);
        this.queueMonitorOptionsGroup.setLayout((Layout)new GridLayout(2, false));
        this.queueMonitorOptionsGroup.setLayoutData((Object)new GridData(4, 1, true, false));
        this.defaultVariableSubs = new TreeMap<String, String>();
        Label attrNameLabel = new Label((Composite)this.queueMonitorOptionsGroup, 0);
        attrNameLabel.setText(String.valueOf(Elements.UI_WIZARD_SUBSTITUTION_VARIABLE_NAME_LABEL) + ':');
        final Text attrName = new Text((Composite)this.queueMonitorOptionsGroup, 2048);
        attrName.setLayoutData((Object)new GridData(4, 4, true, false));
        Label attrValueLabel = new Label((Composite)this.queueMonitorOptionsGroup, 0);
        attrValueLabel.setText(String.valueOf(Elements.UI_WIZARD_SUBSTITUTION_VARIABLE_VALUE_LABEL) + ':');
        final Text attrValue = new Text((Composite)this.queueMonitorOptionsGroup, 2048);
        attrValue.setLayoutData((Object)new GridData(4, 4, true, false));
        Composite buttons = new Composite((Composite)this.queueMonitorOptionsGroup, 0);
        buttons.setLayout((Layout)new GridLayout(2, false));
        buttons.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false, 2, 1));
        final Button add = new Button(buttons, 8);
        add.setText(Elements.UI_WIZARD_ADD_BUTTON);
        add.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        add.setEnabled(false);
        final Button remove = new Button(buttons, 8);
        remove.setText(Elements.UI_WIZARD_REMOVE_BUTTON);
        remove.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        remove.setEnabled(false);
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                add.setEnabled(attrName.getText().trim().length() > 0 && attrValue.getText().trim().length() > 0);
            }
        };
        attrName.addModifyListener(modifyListener);
        attrValue.addModifyListener(modifyListener);
        final TableViewer tbv = new TableViewer((Composite)this.queueMonitorOptionsGroup, 68354);
        tbv.setContentProvider((IContentProvider)new NewTransferMetadataPage.MetaDataContentProvider());
        tbv.setLabelProvider((IBaseLabelProvider)new NewTransferMetadataPage.MetaDataLabelProvider());
        Table table = tbv.getTable();
        table.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        TableColumn f = new TableColumn(table, 16384);
        f.setText(Elements.UI_WIZARD_SUBSTITUTION_VARIABLE_NAME_LABEL);
        TableColumn t = new TableColumn(table, 16384);
        t.setText(Elements.UI_WIZARD_SUBSTITUTION_VARIABLE_VALUE_LABEL);
        tbv.setInput(PageUtils.getEmptyList(5));
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        tbv.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                remove.setEnabled(!event.getSelection().isEmpty());
            }
        });
        final Display display = parent.getDisplay();
        add.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                if (tbv.getInput() != NewMonitorPage.this.defaultVariableSubs) {
                    tbv.setInput((Object)NewMonitorPage.this.defaultVariableSubs);
                }
                NewMonitorPage.this.defaultVariableSubs.put(attrName.getText(), attrValue.getText());
                attrName.setText("");
                attrValue.setText("");
                if (!display.isDisposed()) {
                    display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            tbv.refresh();
                            Table table = tbv.getTable();
                            if (!table.isDisposed()) {
                                PageUtils.setupTable(table);
                            }
                        }
                    });
                }
            }
        });
        remove.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                ISelection s = tbv.getSelection();
                if (s instanceof IStructuredSelection) {
                    for (Object o : ((IStructuredSelection)s).toList()) {
                        if (!(o instanceof Map.Entry)) continue;
                        NewMonitorPage.this.defaultVariableSubs.remove(((Map.Entry)o).getKey().toString());
                    }
                    tbv.refresh();
                    Table table = tbv.getTable();
                    if (!table.isDisposed()) {
                        PageUtils.setupTable(table);
                    }
                }
            }
        });
        this.queueMonitorOptionsGroup.layout();
        PageUtils.setupTable(table);
        this.type.notifyListeners(13, new Event());
        return this.advancedComposite;
    }

    public String getMonitorName() {
        return this.name == null ? "" : this.name.getText();
    }

    public String getDirectory() {
        return this.directory == null ? "" : this.directory.getText();
    }

    public String getQueue() {
        return this.queue == null ? "" : this.queue.getText();
    }

    public String getResource() {
        if (this.getResourceType() == MonitorRequest.MonitorResourceType.QUEUE) {
            return this.getQueue();
        }
        return this.getDirectory();
    }

    public MonitorRequest.MonitorResourceType getResourceType() {
        if (Elements.UI_WIZARD_DEST_MESSAGE_TYPE.equals(this.type.getText())) {
            return MonitorRequest.MonitorResourceType.QUEUE;
        }
        return MonitorRequest.MonitorResourceType.DIRECTORY;
    }

    public MonitorPattern getExcludePattern() {
        String excludePattern;
        MonitorPattern result = MonitorPattern.NO_PATTERN;
        if (this.triggerFileExcludePattern != null && (excludePattern = this.triggerFileExcludePattern.getText().trim()).length() > 0) {
            MonitorPattern.Type excludeType = this.patternsAreRegex != null && this.patternsAreRegex.getSelection() ? MonitorPattern.Type.REGEX : MonitorPattern.Type.WILDCARD;
            result = new MonitorPattern(excludePattern, excludeType);
        }
        return result;
    }

    public List<MonitorTriggerCondition> getTriggers() throws InternalException {
        boolean triggerFormFilled;
        boolean bl = triggerFormFilled = this.triggerFilePattern.getText().length() > 0 || this.queue.getText().length() > 0;
        if (triggerFormFilled && this.triggers.isEmpty()) {
            return Arrays.asList(this.createTriggerParameter());
        }
        return this.triggers;
    }

    private void checkPageComplete() {
        boolean triggerFormFilled;
        this.setPageComplete(true);
        boolean nameChosen = this.name.getText().length() > 0;
        boolean resourceChosen = this.directory.getText().length() > 0 || this.queue.getText().length() > 0;
        boolean bl = triggerFormFilled = this.triggerFilePattern.getText().length() > 0 || this.queue.getText().length() > 0;
        if (this.directory != null) {
            this.directory.setEnabled(this.triggers.isEmpty() || !resourceChosen);
        }
        if (this.queue != null) {
            this.queue.setEnabled(this.triggers.isEmpty() || !resourceChosen);
        }
        if (this.addToGroup != null) {
            this.addToGroup.setEnabled(this.triggerFilePattern.getText().length() > 0);
        }
        boolean errors = true;
        try {
            errors = this.doesPageContainErrors();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setPageComplete(!errors && nameChosen && resourceChosen && (triggerFormFilled || !this.triggers.isEmpty()));
    }

    private boolean doesPageContainErrors() {
        if (this.getControl() == null || this.getControl().isDisposed()) {
            return false;
        }
        boolean result = false;
        Status status = null;
        if (this.name != null && this.name.getText().length() > 0 && !MonitorRequest.isValidMonitorName((String)this.name.getText())) {
            String msg = MessageFormat.format(Elements.UI_WIZARD_INVALID_MONITOR_NAME, MonitorRequest.getInvalidMonitorNameChar((String)this.name.getText()));
            status = new Status(4, "com.ibm.wmqfte.explorer", msg);
        }
        if (this.patternsAreRegex != null && this.patternsAreRegex.getSelection()) {
            try {
                if (this.triggerFilePattern != null && !"".equals(this.triggerFilePattern.getText().trim())) {
                    Pattern.compile(this.triggerFilePattern.getText().trim());
                }
                try {
                    if (this.triggerFileExcludePattern != null && !"".equals(this.triggerFileExcludePattern.getText().trim())) {
                        Pattern.compile(this.triggerFileExcludePattern.getText().trim());
                    }
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    status = new Status(4, "com.ibm.wmqfte.explorer", Elements.UI_WIZARD_MONITOR_INVALID_IGNORE_MESSAGE);
                }
            }
            catch (PatternSyntaxException patternSyntaxException) {
                status = new Status(4, "com.ibm.wmqfte.explorer", Elements.UI_WIZARD_MONITOR_INVALID_PATTERN_MESSAGE);
            }
        }
        if (status == null) {
            status = new Status(0, "com.ibm.wmqfte.explorer", "");
        } else {
            result = true;
        }
        PageUtils.setStatusLine(this, status);
        return result;
    }

    public boolean isWildcard() {
        String trigger = this.triggerFilePattern.getText();
        return trigger.contains("*") || trigger.contains("?");
    }

    private void createTriggersControl(Composite parent) {
        Composite triggers = new Composite(parent, 0);
        triggers.setLayout((Layout)new GridLayout(2, false));
        triggers.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.fileTriggerGroup = new Group(triggers, 0);
        this.fileTriggerGroup.setLayout((Layout)new GridLayout(3, false));
        this.fileTriggerGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.fileTriggerGroup.setText(Elements.UI_WIZARD_MONITOR_TRIGGER_CONDITIONS_TITLE);
        this.fileTriggerGroup.setVisible(true);
        Group matchingGroup = new Group((Composite)this.fileTriggerGroup, 0);
        matchingGroup.setLayout((Layout)new GridLayout(3, false));
        matchingGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, true, 2, 1));
        matchingGroup.setText(Elements.UI_WIZARD_FILE_MATCHING_LABEL);
        matchingGroup.setVisible(true);
        this.triggerFilePattern = PageUtils.createCombo((Composite)matchingGroup, Elements.UI_WIZARD_FILE_PATTERN_LABEL, null, this.settings, TRIGGER_FILE_PATTERN_HISTORY, 0);
        this.triggerFilePattern.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewMonitorPage.this.checkPageComplete();
            }
        });
        this.triggerFilePattern.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                NewMonitorPage.this.checkPageComplete();
            }
        });
        Button browseSrc = new Button((Composite)matchingGroup, 8);
        browseSrc.setText(Elements.UI_WIZARD_BROWSE_LABEL);
        browseSrc.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        browseSrc.setEnabled(false);
        browseSrc.setVisible(false);
        this.triggerFileExcludePattern = PageUtils.createCombo((Composite)matchingGroup, Elements.UI_WIZARD_IGNORE_PATTERN_LABEL, null, this.settings, TRIGGER_EXCLUDE_PATTERN_HISTORY, 0);
        this.triggerFileExcludePattern.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewMonitorPage.this.checkPageComplete();
            }
        });
        this.triggerFileExcludePattern.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                NewMonitorPage.this.checkPageComplete();
            }
        });
        Button excludeSrc = new Button((Composite)matchingGroup, 8);
        excludeSrc.setEnabled(false);
        excludeSrc.setVisible(false);
        new Label((Composite)matchingGroup, 0);
        this.patternsAreRegex = new Button((Composite)matchingGroup, 32);
        this.patternsAreRegex.setText(Elements.UI_WIZARD_INTERPRET_PATTERNS_LABEL);
        this.patternsAreRegex.setSelection(false);
        this.patternsAreRegex.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                NewMonitorPage.this.checkPageComplete();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        Group triggerGroup = new Group((Composite)this.fileTriggerGroup, 0);
        triggerGroup.setLayout((Layout)new GridLayout(1, true));
        triggerGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        triggerGroup.setText(Elements.UI_WIZARD_TRIGGER_ATTRIBUTE_LABEL);
        Text when = new Text((Composite)triggerGroup, 8);
        when.setBackground(parent.getDisplay().getSystemColor(22));
        when.setText(Elements.UI_WIZARD_TRIGGER_FILES_WHEN_LABEL);
        Composite buttons = new Composite((Composite)triggerGroup, 0);
        buttons.setLayout((Layout)new GridLayout(3, false));
        buttons.setLayoutData((Object)PageUtils.getIndentGridData());
        this.shouldMatch = new Button(buttons, 16);
        this.shouldMatch.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 3, 1));
        this.shouldMatch.setText(Elements.UI_WIZARD_TRIGGER_FILE_EXISTS_BUTTON);
        this.shouldMatch.setSelection(true);
        this.exceed = new Button(buttons, 16);
        this.exceed.setText(Elements.UI_WIZARD_TRIGGER_FILE_EXCEED_BUTTON);
        this.exceed.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.sizeValue = new Spinner(buttons, 2048);
        this.sizeValue.setMinimum(0);
        this.sizeValue.setIncrement(1);
        this.sizeValue.setMaximum(1024);
        this.sizeValue.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.sizeType = new Combo(buttons, 8);
        this.sizeType.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        Set unitMultipliers = FTETriggerMultiplerUnits.getUnitMultipliers();
        if (unitMultipliers != null) {
            this.sizeType.setItems(unitMultipliers.toArray(new String[0]));
            this.sizeType.select(0);
        }
        this.sizeUnchanged = new Button(buttons, 16);
        this.sizeUnchanged.setText(Elements.UI_WIZARD_FILE_SIZE_UNCHANGED1_LABEL);
        this.sizeUnchanged.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.sizeUnchangedValue = new Spinner(buttons, 2048);
        this.sizeUnchangedValue.setMinimum(1);
        this.sizeUnchangedValue.setIncrement(1);
        this.sizeUnchangedValue.setMaximum(1024);
        this.sizeUnchangedValue.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        new Label(buttons, 0);
        this.notExist = new Button(buttons, 16);
        this.notExist.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 3, 1));
        this.notExist.setText(Elements.UI_WIZARD_TRIGGER_FILE_NOT_EXIST_BUTTON);
        SelectionListener triggerRadioListener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                boolean exceedEnabled = NewMonitorPage.this.exceed.getSelection();
                NewMonitorPage.this.sizeValue.setEnabled(exceedEnabled);
                NewMonitorPage.this.sizeType.setEnabled(exceedEnabled);
                NewMonitorPage.this.sizeUnchangedValue.setEnabled(NewMonitorPage.this.sizeUnchanged.getSelection());
                NewMonitorPage.this.triggerFileExcludePattern.setEnabled(!NewMonitorPage.this.notExist.getSelection());
            }
        };
        this.shouldMatch.addSelectionListener(triggerRadioListener);
        this.notExist.addSelectionListener(triggerRadioListener);
        this.exceed.addSelectionListener(triggerRadioListener);
        this.sizeUnchanged.addSelectionListener(triggerRadioListener);
        this.shouldMatch.notifyListeners(13, new Event());
        this.queueTriggerGroup = new Group(triggers, 0);
        this.queueTriggerGroup.setLayout((Layout)new GridLayout(3, false));
        this.queueTriggerGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.queueTriggerGroup.setText(Elements.UI_WIZARD_MONITOR_TRIGGER_CONDITIONS_TITLE);
        this.queueTriggerGroup.setVisible(true);
        Group triggerGroup2 = new Group((Composite)this.queueTriggerGroup, 0);
        triggerGroup2.setLayout((Layout)new GridLayout(1, true));
        triggerGroup2.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        triggerGroup2.setText(Elements.UI_WIZARD_TRIGGER_ATTRIBUTE_LABEL);
        Text when2 = new Text((Composite)triggerGroup2, 8);
        when2.setBackground(parent.getDisplay().getSystemColor(22));
        when2.setText(Elements.UI_WIZARD_TRIGGER_QUEUE_WHEN_LABEL);
        Composite buttons2 = new Composite((Composite)triggerGroup2, 0);
        buttons2.setLayout((Layout)new GridLayout(3, false));
        buttons2.setLayoutData((Object)PageUtils.getIndentGridData());
        this.queueNotEmpty = new Button(buttons2, 16);
        this.queueNotEmpty.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 3, 1));
        this.queueNotEmpty.setText(Elements.UI_WIZARD_TRIGGER_QUEUE_NOT_EMPTY_BUTTON);
        this.queueNotEmpty.setSelection(true);
        this.completeGroups = new Button(buttons2, 16);
        this.completeGroups.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 3, 1));
        this.completeGroups.setText(Elements.UI_WIZARD_TRIGGER_QUEUE_COMPLETE_GROUPS_BUTTON);
    }

    private void addTriggerGroupBox(Composite parent) {
        Composite buttons = new Composite(parent, 0);
        buttons.setLayout((Layout)new GridLayout(2, false));
        buttons.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false));
        this.addToGroup = new Button(buttons, 8);
        this.addToGroup.setText(Elements.UI_WIZARD_ADD_TO_GROUP_BUTTON);
        this.addToGroup.setLayoutData((Object)new GridData(0x1000008, 0x1000000, true, false));
        final Button removeFromGroup = new Button(buttons, 8);
        removeFromGroup.setText(Elements.UI_WIZARD_REMOVE_FROM_GROUP_BUTTON);
        removeFromGroup.setLayoutData((Object)new GridData(1, 0x1000000, true, false));
        removeFromGroup.setEnabled(false);
        final TableViewer tbv = new TableViewer(parent, 68354);
        tbv.setContentProvider((IContentProvider)new NewTransferScheduleTriggersPage.TriggerContentProvider());
        tbv.setLabelProvider((IBaseLabelProvider)new NewTransferScheduleTriggersPage.TriggerLabelProvider());
        final Table table = tbv.getTable();
        tbv.setInput(PageUtils.getEmptyList(5));
        table.setLayoutData((Object)new GridData(4, 4, true, true));
        TableColumn ch = new TableColumn(table, 16384);
        ch.setText(Elements.UI_WIZARD_TRIGGER_CHECK_LABEL);
        TableColumn co = new TableColumn(table, 16384);
        co.setText(Elements.UI_WIZARD_TRIGGER_COMPARISON_LABEL);
        TableColumn qu = new TableColumn(table, 16384);
        qu.setText(Elements.UI_WIZARD_TRIGGER_QUALIFIER_LABEL);
        TableColumn n = new TableColumn(table, 16384);
        n.setText(Elements.UI_WIZARD_TRIGGER_NAMES_LABEL);
        SelectionListener sortListener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                TableColumn sortColumn = table.getSortColumn();
                TableColumn currentColumn = (TableColumn)e.widget;
                int dir = table.getSortDirection();
                if (sortColumn.equals(currentColumn)) {
                    dir = dir == 128 ? 1024 : 128;
                } else {
                    table.setSortColumn(currentColumn);
                    dir = 128;
                }
                table.setSortDirection(dir);
                if (tbv.getComparator() instanceof TableComparator) {
                    tbv.refresh();
                } else {
                    tbv.setComparator((ViewerComparator)new TableComparator());
                }
            }
        };
        ch.addSelectionListener(sortListener);
        co.addSelectionListener(sortListener);
        n.addSelectionListener(sortListener);
        tbv.setComparator((ViewerComparator)new TableComparator());
        tbv.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                removeFromGroup.setEnabled(!event.getSelection().isEmpty());
            }
        });
        final Display display = parent.getDisplay();
        this.addToGroup.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                if (tbv.getInput() != NewMonitorPage.this.triggers) {
                    tbv.setInput((Object)NewMonitorPage.this.triggers);
                }
                try {
                    NewMonitorPage.this.triggers.add(NewMonitorPage.this.createTriggerParameter());
                    NewMonitorPage.this.clearComboValues();
                    if (!display.isDisposed()) {
                        display.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                tbv.refresh();
                                Table table = tbv.getTable();
                                if (!table.isDisposed()) {
                                    PageUtils.setupTable(table);
                                }
                            }
                        });
                    }
                    NewMonitorPage.this.checkPageComplete();
                }
                catch (InternalException internalException) {}
            }
        });
        removeFromGroup.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                ISelection s = tbv.getSelection();
                if (s instanceof IStructuredSelection) {
                    for (Object o : ((IStructuredSelection)s).toList()) {
                        NewMonitorPage.this.triggers.remove(o);
                    }
                    tbv.refresh();
                    if (NewMonitorPage.this.triggers.isEmpty()) {
                        NewMonitorPage.this.checkPageComplete();
                    }
                }
            }
        });
    }

    public void clearComboValues() {
        String empty = "";
        this.triggerFilePattern.setText(empty);
    }

    private MonitorTriggerCondition createTriggerParameter() throws InternalException {
        MonitorRequest.MonitorResourceType monitorType;
        String tpStr = "";
        if (Elements.UI_WIZARD_DEST_MESSAGE_TYPE.equals(this.type.getText())) {
            monitorType = MonitorRequest.MonitorResourceType.QUEUE;
            tpStr = this.completeGroups.getSelection() ? String.valueOf(tpStr) + "completeGroups" : String.valueOf(tpStr) + "queueNotEmpty";
        } else {
            monitorType = MonitorRequest.MonitorResourceType.DIRECTORY;
            tpStr = this.exceed.getSelection() ? String.valueOf(tpStr) + "fileSize>=" + this.sizeValue.getSelection() + this.sizeType.getText() : (this.sizeUnchanged.getSelection() ? String.valueOf(tpStr) + "noSizeChange=" + this.sizeUnchangedValue.getSelection() : String.valueOf(tpStr) + (this.shouldMatch.getSelection() ? "match" : "noMatch"));
            tpStr = String.valueOf(tpStr) + ',' + this.triggerFilePattern.getText();
        }
        MonitorPattern.Type type = this.patternsAreRegex != null && this.patternsAreRegex.getSelection() ? MonitorPattern.Type.REGEX : MonitorPattern.Type.WILDCARD;
        MonitorTriggerCondition mtc = new MonitorTriggerCondition(monitorType, tpStr, type);
        return mtc;
    }

    public int getPollIntervalValue() {
        return this.pollIntervalValue == null ? -1 : this.pollIntervalValue.getSelection();
    }

    public String getPollIntervalType() {
        return this.pollIntervalType == null ? null : intervalTypes.get(this.pollIntervalType.getText()).getXML();
    }

    public int getMaximumBatchSize() {
        return this.batchSizeValue == null ? 1 : this.batchSizeValue.getSelection();
    }

    public int getRecursionValue() {
        return this.recursionValue == null ? -1 : this.recursionValue.getSelection();
    }

    public Map<String, String> getDefaultVariableSubs() {
        if (this.getResourceType().equals((Object)MonitorRequest.MonitorResourceType.QUEUE)) {
            return this.defaultVariableSubs;
        }
        return null;
    }
}

