/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wmqfte.explorer.wizards.pages;

import com.ibm.wmqfte.explorer.Elements;
import com.ibm.wmqfte.explorer.ExplorerPlugin;
import com.ibm.wmqfte.explorer.utils.AgentControlCommands;
import com.ibm.wmqfte.explorer.wizards.AgentControlWizard;
import com.ibm.wmqfte.explorer.wizards.pages.AgentControlReport;
import com.ibm.wmqfte.utils.AgentStatusDetails;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;

public class AgentControlPage
extends WizardPage {
    private AgentStatusDetails selectedItem;
    private AgentControlReport reportPanel;
    private Label pingTimeoutLabel;
    private Label pingTimeoutUnits;
    private AgentControlCommands commandHandler;
    private Spinner pingTimeoutValue;

    public AgentControlPage(AgentStatusDetails selectedItem, AgentControlWizard wizard) {
        super(AgentControlPage.class.getName(), AgentControlPage.getFirstLine(selectedItem), null);
        this.setDescription(Elements.UI_WIZARD_AGENT_PING_DESCRIPTION);
        this.setPageComplete(false);
        this.selectedItem = selectedItem;
    }

    private static String getFirstLine(AgentStatusDetails selectedItem) {
        String agentName = selectedItem == null ? "" : selectedItem.getAgentName();
        return MessageFormat.format(Elements.UI_WIZARD_AGENT_PING_TITLE, agentName);
    }

    public AgentControlReport getReportPanel() {
        return this.reportPanel;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        this.createAgentPingControl(parent);
        this.setControl((Control)parent);
        this.setPageComplete(true);
        Group g = new Group(parent, 0);
        g.setLayout((Layout)new GridLayout(1, false));
        g.setLayoutData((Object)new GridData(4, 4, true, true));
        this.reportPanel = new AgentControlReport((Composite)g);
        Button clearButton = new Button((Composite)g, 8);
        clearButton.setText(Elements.UI_STATUS_CLEAR_BUTTON);
        clearButton.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        clearButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
                this.widgetSelected(event);
            }

            public void widgetSelected(SelectionEvent event) {
                AgentControlPage.this.performClearReport();
            }
        });
        this.commandHandler = new AgentControlCommands(this.reportPanel);
        String contextId = "com.ibm.wmqfte.explorer.context.UI_AgentStatusCommandHelp";
        ExplorerPlugin.setHelp((Control)this.getContainer().getShell(), contextId);
    }

    private void createAgentPingControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, false));
        parent.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite buttons = new Composite(parent, 0);
        buttons.setLayout((Layout)new GridLayout(2, true));
        buttons.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Composite pingTimeout = new Composite(buttons, 0);
        pingTimeout.setLayout((Layout)new GridLayout(3, false));
        pingTimeout.setLayoutData((Object)new GridData(1, 0x1000000, true, false, 1, 1));
        this.pingTimeoutLabel = new Label(pingTimeout, 0);
        this.pingTimeoutLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.pingTimeoutLabel.setText(String.valueOf(Elements.UI_WIZARD_AGENT_CONTROL_PING_TIMEOUT) + ':');
        this.pingTimeoutValue = new Spinner(pingTimeout, 2048);
        this.pingTimeoutValue.setMinimum(0);
        this.pingTimeoutValue.setIncrement(1);
        this.pingTimeoutValue.setMaximum(99);
        this.pingTimeoutValue.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.pingTimeoutValue.setSelection(5);
        this.pingTimeoutUnits = new Label(pingTimeout, 0);
        this.pingTimeoutUnits.setLayoutData((Object)new GridData(131072, 0x1000000, true, false));
        this.pingTimeoutUnits.setText(Elements.UI_WIZARD_AGNT_CONTROL_SECONDS);
        final Button testButton = new Button(buttons, 8);
        this.getShell().setDefaultButton(testButton);
        testButton.setText(Elements.UI_WIZARD_AGENT_CONTROL_ISSUE_COMMAND);
        GridData gd = new GridData(131072, 0x1000000, true, false);
        gd.widthHint = this.convertHorizontalDLUsToPixels(61);
        testButton.setLayoutData((Object)gd);
        SelectionListener commandRadioListener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                final String timeoutValue = "" + AgentControlPage.this.pingTimeoutValue.getSelection();
                Job job = new Job(MessageFormat.format(Elements.UI_STATUS_PING_COMMAND, AgentControlPage.this.selectedItem.getAgentName().toUpperCase())){

                    protected IStatus run(IProgressMonitor monitor) {
                        AgentControlPage.this.toggleButton(testButton, false);
                        boolean agentResponded = AgentControlPage.this.commandHandler.performAgentPingCommand(AgentControlPage.this.selectedItem.getAgentName(), AgentControlPage.this.selectedItem.getQueueManagerName(), timeoutValue);
                        AgentControlPage.this.toggleButton(testButton, true);
                        if (agentResponded) {
                            return Status.OK_STATUS;
                        }
                        String msg = MessageFormat.format(Elements.UI_STATUS_PING_TIMEOUT, AgentControlPage.this.selectedItem.getAgentName(), timeoutValue);
                        return new Status(2, "com.ibm.wmqfte.explorer", msg);
                    }
                };
                job.setUser(true);
                job.schedule();
            }
        };
        testButton.addSelectionListener(commandRadioListener);
    }

    public void toggleButton(final Button button, final boolean enabled) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!button.isDisposed()) {
                    button.setEnabled(enabled);
                }
            }
        });
    }

    public void performClearReport() {
        this.reportPanel.clear();
    }
}

