/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wmqfte.explorer.wizards;

import com.ibm.wmqfte.api.ApiException;
import com.ibm.wmqfte.api.CommandScheduleSpecification;
import com.ibm.wmqfte.api.CreateTransfer;
import com.ibm.wmqfte.explorer.Elements;
import com.ibm.wmqfte.explorer.data.Subscription;
import com.ibm.wmqfte.explorer.views.TransferProgressView;
import com.ibm.wmqfte.explorer.wizards.pages.NewTransferMetadataPage;
import com.ibm.wmqfte.explorer.wizards.pages.NewTransferPage;
import com.ibm.wmqfte.explorer.wizards.pages.NewTransferScheduleTriggersPage;
import com.ibm.wmqfte.explorer.wizards.pages.NewTransferSummaryPage;
import com.ibm.wmqfte.objects.TransferTemplate;
import com.ibm.wmqfte.utils.AgentStatusDetails;
import com.ibm.wmqfte.utils.xmlmessage.transfer.AgentClientSpecification;
import com.ibm.wmqfte.utils.xmlmessage.transfer.AgentSpecification;
import com.ibm.wmqfte.utils.xmlmessage.transfer.DestinationAgentSpecification;
import com.ibm.wmqfte.utils.xmlmessage.transfer.ItemSpecification;
import com.ibm.wmqfte.utils.xmlmessage.transfer.JobSpecification;
import com.ibm.wmqfte.utils.xmlmessage.transfer.ManagedTransferSpecification;
import com.ibm.wmqfte.utils.xmlmessage.transfer.OriginatorSpecification;
import com.ibm.wmqfte.utils.xmlmessage.transfer.ScheduleSpecification;
import com.ibm.wmqfte.utils.xmlmessage.transfer.SourceAgentSpecification;
import com.ibm.wmqfte.utils.xmlmessage.transfer.TransferSetSpecification;
import com.ibm.wmqfte.utils.xmlmessage.transfer.TriggerParameterSpecification;
import com.ibm.wmqfte.utils.xmlmessage.transfer.TriggerSpecification;
import com.ibm.wmqfte.wmqiface.WMQApiException;
import com.ibm.wmqfte.wmqiface.WMQConnectionData;
import com.ibm.wmqfte.wmqiface.WMQPublicationData;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class NewTransferWizard
extends Wizard
implements INewWizard {
    private boolean isTemplate = false;
    private TransferTemplate template;
    private NewTransferPage newTransferPage;
    NewTransferMetadataPage metadataPage;
    private NewTransferSummaryPage summaryPage;
    private NewTransferScheduleTriggersPage scheduleTriggersPage;

    public NewTransferWizard() {
        this.setWindowTitle(Elements.UI_WIZARD_MFT_CREATE_TITLE);
    }

    public NewTransferWizard(boolean isTemplate) {
        this();
        this.isTemplate = isTemplate;
        if (isTemplate) {
            this.setWindowTitle(Elements.UI_WIZARD_MFT_CREATE_TEMPLATE_TITLE);
        } else {
            this.setWindowTitle(Elements.UI_WIZARD_MFT_CREATE_TITLE);
        }
    }

    public NewTransferWizard(boolean isTemplate, TransferTemplate template) {
        this(isTemplate);
        this.template = template;
    }

    public String getHelpId() {
        return this.isTemplate ? "com.ibm.wmqfte.explorer.context.UI_NewTemplateBasicHelp" : "com.ibm.wmqfte.explorer.context.UI_NewTransferSingleBasicHelp";
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void addPages() {
        NewTransferPage.TransferPageType pageType;
        String title = this.isTemplate ? Elements.UI_WIZARD_NEW_TEMPLATE_TITLE : Elements.UI_WIZARD_NEW_TRANSFER_TITLE;
        String desc = this.isTemplate ? Elements.UI_WIZARD_NEW_TEMPLATE_DESC : Elements.UI_WIZARD_NEW_TRANSFER_DESC;
        NewTransferPage.TransferPageType transferPageType = pageType = this.isTemplate ? NewTransferPage.TransferPageType.TEMPLATE : NewTransferPage.TransferPageType.NORMAL;
        if (this.template == null) {
            this.newTransferPage = new NewTransferPage(title, desc, pageType);
            this.scheduleTriggersPage = new NewTransferScheduleTriggersPage(title, Elements.UI_WIZARD_SCHEDULE_TRIGGERS_DESC, this.isTemplate, this.newTransferPage);
            this.metadataPage = new NewTransferMetadataPage(title, Elements.UI_WIZARD_NEW_TRANSFER_METADATA_DESC, pageType);
            this.summaryPage = new NewTransferSummaryPage(Elements.UI_WIZARD_SUMMARY_INFO_TITLE, this.isTemplate, this.newTransferPage, this.scheduleTriggersPage, this.metadataPage);
        } else {
            this.newTransferPage = new NewTransferPage(title, desc, pageType, this.template.getSourceAgent() == null ? null : this.template.getSourceAgent().getAgentName(), this.template.getDestinationAgent() == null ? null : this.template.getDestinationAgent().getAgentName(), this.template.getFileSpecs(), this.template.getPriority());
            this.metadataPage = new NewTransferMetadataPage(title, Elements.UI_WIZARD_NEW_TRANSFER_METADATA_DESC, pageType, this.template.getMetadata());
            this.scheduleTriggersPage = new NewTransferScheduleTriggersPage(title, Elements.UI_WIZARD_SCHEDULE_TRIGGERS_DESC, this.isTemplate, this.newTransferPage, this.template.getScheduleSpec(), this.template.getTriggerSpec() == null ? null : this.template.getTriggerSpec().getTriggerSet());
            this.summaryPage = new NewTransferSummaryPage(Elements.UI_WIZARD_SUMMARY_INFO_TITLE, this.isTemplate, this.newTransferPage, this.scheduleTriggersPage, this.metadataPage, this.template.getName());
        }
        this.addPage((IWizardPage)this.newTransferPage);
        this.addPage((IWizardPage)this.scheduleTriggersPage);
        this.addPage((IWizardPage)this.metadataPage);
        this.addPage((IWizardPage)this.summaryPage);
    }

    public boolean performFinish() {
        this.newTransferPage.saveComboValues();
        if (this.newTransferPage.getTransfers().isEmpty() && this.newTransferPage.isFormFilled()) {
            this.newTransferPage.addCurrent();
        }
        this.isTemplate |= this.summaryPage.isSaveEnabled();
        boolean success = this.isTemplate ? this.startTemplate() : this.startTransfer();
        return success;
    }

    private boolean startTemplate() {
        String uuid = this.template == null ? UUID.randomUUID().toString() : this.template.getUUID();
        AgentStatusDetails srcAgent = this.newTransferPage.getSrcAgentPub();
        AgentStatusDetails destAgent = this.newTransferPage.getDestAgentPub();
        List<ItemSpecification> transfers = this.newTransferPage.getTransfers();
        CommandScheduleSpecification scheduleOptions = null;
        if (this.scheduleTriggersPage.isScheduled()) {
            scheduleOptions = new CommandScheduleSpecification(this.scheduleTriggersPage.getStartSchedule(), this.scheduleTriggersPage.getTimeBase(), this.scheduleTriggersPage.getRepeatInterval(), this.scheduleTriggersPage.getRepeatFrequency(), this.scheduleTriggersPage.getRepeatCount(), this.scheduleTriggersPage.getEndSchedule());
        }
        List<TriggerParameterSpecification> triggers = null;
        if (this.scheduleTriggersPage.isTriggered()) {
            triggers = this.scheduleTriggersPage.getTriggers();
        }
        TriggerSpecification triggerSpec = new TriggerSpecification(true, triggers);
        Map<String, String> metadata = this.metadataPage.getTransferMetadata();
        int priority = this.newTransferPage.getPriority();
        JobSpecification jobSpec = this.template == null ? new JobSpecification(this.summaryPage.getTemplateName()) : this.template.getJobSpec();
        TransferTemplate template = new TransferTemplate(uuid, this.summaryPage.getTemplateName(), srcAgent, destAgent, transfers, jobSpec, scheduleOptions, triggerSpec, metadata, priority);
        try {
            WMQConnectionData adminData = Subscription.getAdminConnectionData();
            WMQPublicationData pubData = new WMQPublicationData(adminData.getQueueManagerName(), adminData.getCcsid(), adminData.getCcsidName());
            Subscription.publishXML("Templates/" + uuid, "SYSTEM.FTE", template.toXML(), pubData);
            return true;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (WMQApiException e) {
            e.printStackTrace();
        }
        return false;
    }

    private boolean startTransfer() {
        try {
            AgentStatusDetails srcAgent = this.newTransferPage.getSrcAgentPub();
            AgentStatusDetails destAgent = this.newTransferPage.getDestAgentPub();
            List<ItemSpecification> transfers = this.newTransferPage.getTransfers();
            CommandScheduleSpecification scheduleOptions = null;
            if (this.scheduleTriggersPage.isScheduled()) {
                scheduleOptions = new CommandScheduleSpecification(this.scheduleTriggersPage.getStartSchedule(), this.scheduleTriggersPage.getTimeBase(), this.scheduleTriggersPage.getRepeatInterval(), this.scheduleTriggersPage.getRepeatFrequency(), this.scheduleTriggersPage.getRepeatCount(), this.scheduleTriggersPage.getEndSchedule());
            }
            List<TriggerParameterSpecification> triggers = null;
            if (this.scheduleTriggersPage.isTriggered()) {
                triggers = this.scheduleTriggersPage.getTriggers();
            }
            TriggerSpecification triggerSpec = new TriggerSpecification(true, triggers);
            Map<String, String> metadata = this.metadataPage.getTransferMetadata();
            int priority = this.newTransferPage.getPriority();
            WMQConnectionData cmd = Subscription.getCmdConnectionData();
            ArrayList<ItemSpecification> transfersList = new ArrayList<ItemSpecification>();
            transfersList.addAll(transfers);
            TransferSetSpecification transferSet = new TransferSetSpecification(metadata, transfersList, priority);
            ManagedTransferSpecification transferSpec = new ManagedTransferSpecification(new OriginatorSpecification(CreateTransfer.getHostName(), CreateTransfer.getUserId()), (ScheduleSpecification)scheduleOptions, (AgentSpecification)new SourceAgentSpecification(srcAgent.getAgentName(), srcAgent.getQueueManagerName()), (AgentClientSpecification)new DestinationAgentSpecification(destAgent.getAgentName(), destAgent.getQueueManagerName()), triggerSpec, null, transferSet, null);
            CreateTransfer.createTransfer((ManagedTransferSpecification)transferSpec, (WMQConnectionData)cmd);
            TransferProgressView.refreshView(true);
            return true;
        }
        catch (ApiException e) {
            MessageDialog.openError((Shell)this.getShell(), (String)Elements.UI_WIZARD_TRANSFER_TITLE, (String)e.getLocalizedMessage());
            return false;
        }
    }

    @Deprecated
    public boolean openFinishDialog(Shell parent) {
        if (this.newTransferPage.isPageComplete()) {
            Object[] messageArgs = new Object[]{this.newTransferPage.getSourceHost(), this.newTransferPage.getSource(), this.newTransferPage.getDestHost(), this.newTransferPage.getDestination()};
            return MessageDialog.openConfirm((Shell)parent, (String)Elements.UI_WIZARD_CONFIRMATION_TITLE, (String)MessageFormat.format(Elements.UI_WIZARD_CONFIRM_TRANSFER_DIALOG, messageArgs));
        }
        MessageDialog.openError((Shell)parent, (String)"Error", (String)Elements.UI_WIZARD_PAGE_INCOMPLETE_TITLE);
        return false;
    }
}

