/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wmqfte.explorer.wizards;

import com.ibm.wmqfte.api.ApiException;
import com.ibm.wmqfte.api.CreateMonitorRequest;
import com.ibm.wmqfte.api.CreateTransfer;
import com.ibm.wmqfte.api.InternalException;
import com.ibm.wmqfte.explorer.Elements;
import com.ibm.wmqfte.explorer.data.Subscription;
import com.ibm.wmqfte.explorer.wizards.pages.NewMonitorPage;
import com.ibm.wmqfte.explorer.wizards.pages.NewMonitorSummaryPage;
import com.ibm.wmqfte.explorer.wizards.pages.NewTransferMetadataPage;
import com.ibm.wmqfte.explorer.wizards.pages.NewTransferPage;
import com.ibm.wmqfte.utils.AgentStatusDetails;
import com.ibm.wmqfte.utils.xmlmessage.transfer.AgentClientSpecification;
import com.ibm.wmqfte.utils.xmlmessage.transfer.AgentSpecification;
import com.ibm.wmqfte.utils.xmlmessage.transfer.DestinationAgentSpecification;
import com.ibm.wmqfte.utils.xmlmessage.transfer.ItemSpecification;
import com.ibm.wmqfte.utils.xmlmessage.transfer.ManagedTransferSpecification;
import com.ibm.wmqfte.utils.xmlmessage.transfer.OriginatorSpecification;
import com.ibm.wmqfte.utils.xmlmessage.transfer.SourceAgentSpecification;
import com.ibm.wmqfte.utils.xmlmessage.transfer.TransferSetSpecification;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class NewMonitorWizard
extends Wizard
implements INewWizard {
    private NewMonitorPage monitorPage;
    private NewTransferPage newTransferPage;
    private NewTransferMetadataPage metadataPage;
    private NewMonitorSummaryPage summaryPage;

    public NewMonitorWizard() {
        this.setWindowTitle(Elements.UI_WIZARD_MONITOR_CREATE_TITLE);
    }

    public void addPages() {
        String title = Elements.UI_WIZARD_NEW_MONITOR_TITLE;
        String desc = Elements.UI_WIZARD_NEW_MONITOR_DESC;
        this.monitorPage = new NewMonitorPage(title, desc);
        this.newTransferPage = new NewTransferPage(title, Elements.UI_WIZARD_NEW_TRANSFER_MONITOR_DESC, NewTransferPage.TransferPageType.MONITOR);
        this.metadataPage = new NewTransferMetadataPage(title, Elements.UI_WIZARD_NEW_TRANSFER_METADATA_DESC, NewTransferPage.TransferPageType.MONITOR);
        this.summaryPage = new NewMonitorSummaryPage(Elements.UI_WIZARD_SUMMARY_INFO_TITLE, this.newTransferPage, null, this.metadataPage);
        this.summaryPage.setDescription(Elements.UI_WIZARD_NEW_TRANSFER_MONITOR_SUMMARY_DESC);
        this.addPage((IWizardPage)this.monitorPage);
        this.addPage((IWizardPage)this.newTransferPage);
        this.addPage((IWizardPage)this.metadataPage);
        this.addPage((IWizardPage)this.summaryPage);
    }

    private String getTaskXML() {
        AgentStatusDetails srcAgent = this.newTransferPage.getSrcAgentPub();
        AgentStatusDetails destAgent = this.newTransferPage.getDestAgentPub();
        if (this.newTransferPage.getTransfers().isEmpty() && this.newTransferPage.isFormFilled()) {
            this.newTransferPage.addCurrent();
        }
        List<ItemSpecification> transfers = this.newTransferPage.getTransfers();
        Map<String, String> metadata = this.metadataPage.getTransferMetadata();
        int priority = this.newTransferPage.getPriority();
        StringBuilder taskXML = new StringBuilder();
        taskXML.append('\n');
        taskXML.append("<tasks>\n");
        taskXML.append("<task>\n");
        taskXML.append("<name>").append(this.monitorPage.getMonitorName()).append("</name>\n");
        taskXML.append("<description>.</description>\n");
        taskXML.append("<transfer>\n");
        try {
            ArrayList<ItemSpecification> transfersList = new ArrayList<ItemSpecification>();
            transfersList.addAll(transfers);
            TransferSetSpecification transferSet = new TransferSetSpecification(metadata, transfersList, priority);
            ManagedTransferSpecification transferSpec = new ManagedTransferSpecification(new OriginatorSpecification(CreateTransfer.getHostName(), CreateTransfer.getUserId()), null, (AgentSpecification)new SourceAgentSpecification(srcAgent.getAgentName(), srcAgent.getQueueManagerName()), (AgentClientSpecification)new DestinationAgentSpecification(destAgent.getAgentName(), destAgent.getQueueManagerName()), null, null, transferSet, null);
            byte[] b = CreateTransfer.buildCreateTransferMessagePayload((ManagedTransferSpecification)transferSpec, null);
            taskXML.append(new String(b, "UTF-8"));
        }
        catch (InternalException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        taskXML.append("</transfer>\n");
        taskXML.append("</task>\n");
        taskXML.append("</tasks>\n");
        String result = taskXML.toString().replaceAll("<\\?xml version=\"1.0\" encoding=\"UTF-8\"\\?>", "");
        return result;
    }

    public String getHelpId() {
        return "com.ibm.wmqfte.explorer.context.UI_NewMonitorHelp";
    }

    public boolean performFinish() {
        if (this.monitorPage.isPageComplete()) {
            this.monitorPage.saveComboValues();
            this.newTransferPage.saveComboValues();
            try {
                AgentStatusDetails agent = this.newTransferPage.getSrcAgentPub();
                CreateMonitorRequest req = new CreateMonitorRequest(this.monitorPage.getMonitorName().toUpperCase(), agent.getAgentName(), this.monitorPage.getResourceType(), this.monitorPage.getResource(), this.getTaskXML(), this.monitorPage.getTriggers(), this.monitorPage.getExcludePattern(), this.monitorPage.getRecursionValue(), this.monitorPage.getPollIntervalValue(), this.monitorPage.getPollIntervalType(), this.monitorPage.getMaximumBatchSize(), this.monitorPage.getDefaultVariableSubs(), null);
                req.send(Subscription.getCmdConnectionData(), agent.getQueueManagerName());
                return true;
            }
            catch (ApiException e) {
                MessageDialog.openError((Shell)this.getShell(), (String)Elements.UI_WIZARD_TRANSFER_TITLE, (String)e.getLocalizedMessage());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }
}

