/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wmqfte.explorer.views;

import com.ibm.wmqfte.explorer.objects.TransferStatus;
import java.util.Date;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.TreeColumn;

public abstract class TransferProgressViewSorter
extends ViewerSorter {
    private boolean direction = true;

    public void setColumn(TreeViewer tv, TreeColumn column) {
        ViewerSorter currentSorter = tv.getSorter();
        if (currentSorter != null && currentSorter.equals((Object)this)) {
            this.direction = !this.direction;
        } else {
            tv.setSorter((ViewerSorter)this);
            this.direction = true;
        }
        tv.getTree().setSortColumn(column);
        tv.getTree().setSortDirection(this.direction ? 1024 : 128);
    }

    public int applyDirection(int rc) {
        return this.direction ? rc : -rc;
    }

    public int compare(Viewer viewer, Object o1, Object o2) {
        if (o1 instanceof TransferStatus && o2 instanceof TransferStatus) {
            TransferStatus ts1 = (TransferStatus)o1;
            TransferStatus ts2 = (TransferStatus)o2;
            return this.compare(ts1, ts2);
        }
        return 0;
    }

    public abstract int compare(TransferStatus var1, TransferStatus var2);

    public int compare(String s1, String s2) {
        if (s1 == null) {
            return this.applyDirection(-1);
        }
        if (s2 == null) {
            return this.applyDirection(1);
        }
        int rc = s1.compareTo(s2);
        return this.applyDirection(rc);
    }

    public int compare(Integer i1, Integer i2) {
        if (i1 == null && i2 != null) {
            return this.applyDirection(-1);
        }
        if (i1 != null && i2 == null) {
            return this.applyDirection(1);
        }
        if (i1 == null && i2 == null) {
            return this.applyDirection(0);
        }
        int rc = i1.compareTo(i2);
        return this.applyDirection(rc);
    }

    public int compare(long parm1, long parm2) {
        int rc = 0;
        if (parm1 < parm2) {
            rc = -1;
        } else if (parm1 > parm2) {
            rc = 1;
        }
        return this.applyDirection(rc);
    }

    public int compare(Date date1, Date date2) {
        if (date1 == null) {
            return -1;
        }
        if (date2 == null) {
            return 1;
        }
        int rc = date1.compareTo(date2);
        return this.applyDirection(rc);
    }
}

