/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wmqfte.explorer.views;

import com.ibm.mq.explorer.ui.Icons;
import com.ibm.wmqfte.api.AbstractCommand;
import com.ibm.wmqfte.api.CancelTransfer;
import com.ibm.wmqfte.explorer.Elements;
import com.ibm.wmqfte.explorer.ExplorerPlugin;
import com.ibm.wmqfte.explorer.Messages;
import com.ibm.wmqfte.explorer.content.IFTEContentPage;
import com.ibm.wmqfte.explorer.content.TransferLogPage;
import com.ibm.wmqfte.explorer.data.Subscription;
import com.ibm.wmqfte.explorer.objects.TransferStatus;
import com.ibm.wmqfte.explorer.treenode.CoordTreeNode;
import com.ibm.wmqfte.explorer.treenode.MFTETreeNodeFactory;
import com.ibm.wmqfte.explorer.utils.ColumnTitleMapper;
import com.ibm.wmqfte.explorer.utils.PageUtils;
import com.ibm.wmqfte.explorer.utils.ProviderSorter;
import com.ibm.wmqfte.explorer.views.CurrentFileLabelProvider;
import com.ibm.wmqfte.explorer.views.DestinationLabelProvider;
import com.ibm.wmqfte.explorer.views.ItemCountLabelProvider;
import com.ibm.wmqfte.explorer.views.ProgressLabelProvider;
import com.ibm.wmqfte.explorer.views.RateLabelProvider;
import com.ibm.wmqfte.explorer.views.SourceLabelProvider;
import com.ibm.wmqfte.explorer.views.StartTimeLabelProvider;
import com.ibm.wmqfte.explorer.views.TransferProgressContentProvider;
import com.ibm.wmqfte.explorer.views.TransferProgressCurrentFileSorter;
import com.ibm.wmqfte.explorer.views.TransferProgressDestinationSorter;
import com.ibm.wmqfte.explorer.views.TransferProgressItemCountSorter;
import com.ibm.wmqfte.explorer.views.TransferProgressRateSorter;
import com.ibm.wmqfte.explorer.views.TransferProgressSorter;
import com.ibm.wmqfte.explorer.views.TransferProgressSourceSorter;
import com.ibm.wmqfte.explorer.views.TransferProgressStartedSorter;
import com.ibm.wmqfte.explorer.views.TransferProgressViewSorter;
import com.ibm.wmqfte.wmqiface.WMQConnectionData;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.TimeZone;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class TransferProgressView
extends ViewPart
implements ColumnTitleMapper,
IFTEContentPage,
Observer {
    private final Set<TransferStatus> statuses = Collections.synchronizedSet(new LinkedHashSet());
    static final LinkedList<String> cancelled = new LinkedList();
    static final String padding = "   ";
    private Thread pollingThread;
    private Action clearCompleted;
    private Action refreshToolbarAction;
    protected static final DateFormat df = DateFormat.getDateTimeInstance(3, 1);
    public static final DateFormat iso8601 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    private int transferProgressMax = ExplorerPlugin.getTransferProgressMax();
    private static final List<String> COLUMNS_WITH_TIMEZONE;
    private static final ProviderSorter ps;
    private static final ProgressViewColumns[] DEFAULT_COLUMN_ORDER;
    private static final String[] DEFAULT_COLUMN_ORDER_AS_STRING;
    private static final String TRANSFER_PROGRESS_VIEW_SETTINGS = "TRANSFER_PROGRESS_VIEW_SETTINGS";
    private final List<TreeViewerColumn> availableColumns = new LinkedList<TreeViewerColumn>();
    private TreeViewer tbv;
    private final IPropertyChangeListener transferProgressPrefsListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            Object val;
            if ("com.ibm.wmqfte.explorer.timezone".equals(event.getProperty())) {
                Object val2 = event.getNewValue();
                if (val2 instanceof String) {
                    String oldTz = String.valueOf(df.getTimeZone().getID()) + ')';
                    String newTz = (String)event.getNewValue();
                    for (TreeViewerColumn c : TransferProgressView.this.availableColumns) {
                        String t = c.getColumn().getText();
                        if (t == null || !t.endsWith(oldTz)) continue;
                        c.getColumn().setText(t.replace(oldTz, String.valueOf(newTz) + ')'));
                    }
                    df.setTimeZone(TimeZone.getTimeZone(newTz));
                    TransferProgressView.this.tbv.refresh();
                    Tree tree = TransferProgressView.this.tbv.getTree();
                    if (!tree.isDisposed()) {
                        TransferProgressView.this.setupTree(tree);
                    }
                }
            } else if ("com.ibm.wmqfte.explorer.transferprogress.max".equals(event.getProperty()) && (val = event.getNewValue()) instanceof Integer) {
                TransferProgressView.this.transferProgressMax = (Integer)val;
                TransferProgressView.this.checkMaxStatuses();
            }
        }
    };
    final Calendar cal = Calendar.getInstance();
    private long lastRefreshCompleteTime = 0L;
    private volatile int refreshRequestQueuedCount = 0;
    private Object refreshRequestLock = new Object();

    static {
        iso8601.setTimeZone(TimeZone.getTimeZone("UTC"));
        df.setTimeZone(ExplorerPlugin.getTimeZone());
        COLUMNS_WITH_TIMEZONE = new ArrayList<String>();
        COLUMNS_WITH_TIMEZONE.add(Elements.UI_VIEW_TRANSFER_PROGRESS_STARTED_TITLE);
        ps = new ProviderSorter(COLUMNS_WITH_TIMEZONE);
        ps.add(Elements.UI_CONTENT_SRC_TITLE, new SourceLabelProvider(), new TransferProgressSourceSorter());
        ps.add(Elements.UI_CONTENT_DEST_TITLE, new DestinationLabelProvider(), new TransferProgressDestinationSorter());
        ps.add(Elements.UI_VIEW_TRANSFER_PROGRESS_CURRENT_FILE_TITLE, new CurrentFileLabelProvider(), new TransferProgressCurrentFileSorter());
        ps.add(Elements.UI_VIEW_TRANSFER_PROGRESS_NUMFILES_TITLE, new ItemCountLabelProvider(), new TransferProgressItemCountSorter());
        ps.add(Elements.UI_VIEW_TRANSFER_PROGRESS_PROGRESS_TITLE, null, new TransferProgressSorter());
        ps.add(Elements.UI_VIEW_TRANSFER_PROGRESS_RATE_TITLE, new RateLabelProvider(), new TransferProgressRateSorter());
        ps.add(Elements.UI_VIEW_TRANSFER_PROGRESS_STARTED_TITLE, new StartTimeLabelProvider(), new TransferProgressStartedSorter());
        DEFAULT_COLUMN_ORDER = new ProgressViewColumns[]{ProgressViewColumns.EMPTY, ProgressViewColumns.SOURCE, ProgressViewColumns.DESTINATION, ProgressViewColumns.CURRENT_FILE, ProgressViewColumns.FILE_NUMBER, ProgressViewColumns.PROGRESS, ProgressViewColumns.RATE, ProgressViewColumns.STARTED};
        DEFAULT_COLUMN_ORDER_AS_STRING = new String[]{ProgressViewColumns.EMPTY.toString(), ProgressViewColumns.SOURCE.toString(), ProgressViewColumns.DESTINATION.toString(), ProgressViewColumns.CURRENT_FILE.toString(), ProgressViewColumns.FILE_NUMBER.toString(), ProgressViewColumns.PROGRESS.toString(), ProgressViewColumns.RATE.toString(), ProgressViewColumns.STARTED.toString()};
    }

    @Override
    public String[] getColumnPersistableOrderFromDisplayTitles(String[] columnTitles) {
        ProgressViewColumns[] columns = this.getColumnsFromTitles(columnTitles);
        String[] persistableColumnTitles = new String[columns.length];
        int i = 0;
        while (i < columns.length) {
            persistableColumnTitles[i] = columns[i].toString();
            ++i;
        }
        return persistableColumnTitles;
    }

    private ProgressViewColumns[] getColumnsFromTitles(String[] columnTitles) {
        ArrayList<ProgressViewColumns> columns = new ArrayList<ProgressViewColumns>();
        String[] stringArray = columnTitles;
        int n = columnTitles.length;
        int n2 = 0;
        while (n2 < n) {
            String title = stringArray[n2];
            ProgressViewColumns column = ProgressViewColumns.findByColumnTitle(title);
            if (column == null) {
                for (String timezoneCol : COLUMNS_WITH_TIMEZONE) {
                    if (!title.startsWith(timezoneCol) || !title.endsWith(")")) continue;
                    column = ProgressViewColumns.findByColumnTitle(timezoneCol);
                }
            }
            if (column != null) {
                columns.add(column);
            }
            ++n2;
        }
        return columns.toArray(new ProgressViewColumns[0]);
    }

    public void createPartControl(final Composite parent) {
        ProgressViewColumns[] columnsToDisplay;
        final Shell shell = parent.getShell();
        final Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, true));
        composite.setLayoutData((Object)new GridData(1, 0x1000000, true, false));
        this.tbv = new TreeViewer(composite, 68354);
        this.tbv.setContentProvider((IContentProvider)new TransferProgressContentProvider());
        this.tbv.setInput(this.statuses);
        this.tbv.setComparator((ViewerComparator)new TransferStatusComparator());
        IWorkbench workbench = PlatformUI.getWorkbench();
        final Display display = workbench.getDisplay();
        this.tbv.addTreeListener(new ITreeViewerListener(){

            public void treeCollapsed(TreeExpansionEvent event) {
                this.updateTree();
            }

            public void treeExpanded(TreeExpansionEvent event) {
                this.updateTree();
            }

            private void updateTree() {
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        Tree tree = TransferProgressView.this.tbv.getTree();
                        if (!tree.isDisposed()) {
                            TransferProgressView.this.setupTree(tree);
                        }
                    }
                });
            }
        });
        Tree tree = this.tbv.getTree();
        TreeViewerColumn emptyTVC = new TreeViewerColumn(this.tbv, 16384);
        emptyTVC.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public Image getImage(Object element) {
                return null;
            }

            public String getText(Object element) {
                return "";
            }

            public Color getBackground(Object element) {
                return TransferLogPage.getBackground(element);
            }
        });
        TreeColumn empty = emptyTVC.getColumn();
        empty.setText("");
        empty.setWidth(0);
        empty.setMoveable(false);
        empty.setResizable(false);
        ProgressViewColumns[] progressViewColumnsArray = columnsToDisplay = this.loadDefaultColumns();
        int n = columnsToDisplay.length;
        int n2 = 0;
        while (n2 < n) {
            ProgressViewColumns col = progressViewColumnsArray[n2];
            switch (col) {
                case EMPTY: {
                    break;
                }
                case SOURCE: 
                case DESTINATION: 
                case CURRENT_FILE: 
                case FILE_NUMBER: 
                case RATE: 
                case STARTED: {
                    this.addColumn(ps.adjustColumnName(col.columnTitle), ps.getProvider(col.columnTitle), ps.getSorter(col.columnTitle));
                    break;
                }
                case PROGRESS: {
                    this.addColumn(ps.adjustColumnName(col.columnTitle), new ProgressLabelProvider(this.tbv), ps.getSorter(col.columnTitle));
                }
            }
            ++n2;
        }
        tree.setHeaderVisible(true);
        tree.setLayoutData((Object)new GridData(4, 4, true, true));
        this.setupTree(tree);
        tree.setVisible(true);
        this.addContextMenu(this.tbv);
        composite.layout();
        composite.setVisible(true);
        for (TreeViewerColumn tvc : this.availableColumns) {
            TreeColumn c = tvc.getColumn();
            c.addControlListener(new ControlListener(){

                public void controlMoved(ControlEvent e) {
                    TransferProgressView.this.saveDefaultColumns();
                }

                public void controlResized(ControlEvent e) {
                }
            });
        }
        this.saveDefaultColumns();
        this.pollingThread = new Thread("TransferProgressView"){

            @Override
            public void run() {
                while (!shell.isDisposed()) {
                    if (composite.isDisposed() || parent.isDisposed() || parent.getDisplay().isDisposed()) {
                        return;
                    }
                    TransferProgressView.this.requestRefresh(false);
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        };
        this.pollingThread.start();
        this.clearCompleted = new Action(){

            public void run() {
                LinkedHashSet temp = new LinkedHashSet(TransferProgressView.this.statuses);
                for (TransferStatus status : temp) {
                    if (!status.isCompleted() || !Elements.UI_CONTENT_AUDIT_COMPLETED_SUCCESS_LABEL.equals(status.getLogState(false))) continue;
                    TransferProgressView.this.statuses.remove(status);
                }
                if (temp.size() > 0 && !parent.getDisplay().isDisposed()) {
                    parent.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            TransferProgressView.this.tbv.refresh();
                            Tree tree = TransferProgressView.this.tbv.getTree();
                            if (!tree.isDisposed()) {
                                TransferProgressView.this.setupTree(tree);
                            }
                        }
                    });
                }
            }
        };
        this.clearCompleted.setText(Elements.UI_CONTENT_REMOVE_COMPLETE_BUTTON);
        this.clearCompleted.setToolTipText(Elements.UI_CONTENT_REMOVE_COMPLETE_BUTTON);
        ImageDescriptor image = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.debug.ui", (String)"$nl$/icons/full/elcl16/rem_all_co.gif");
        this.clearCompleted.setImageDescriptor(image);
        this.clearCompleted.setId("CLEAR_COMPLETED_ACTION");
        this.refreshToolbarAction = new Action(){

            public void run() {
                TransferProgressView.this.requestRefresh(true);
            }
        };
        this.refreshToolbarAction.setText(Elements.UI_CONTENT_REFRESH_BUTTON);
        this.refreshToolbarAction.setToolTipText(Elements.UI_CONTENT_REFRESH_BUTTON);
        this.refreshToolbarAction.setImageDescriptor(Icons.getDescriptor((String)Icons.iconkeyRefresh));
        this.contributeToActionBar();
        ExplorerPlugin.setHelp((Control)composite, "com.ibm.wmqfte.explorer.context.UI_MonitorTransferProgressHelp");
        ExplorerPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.transferProgressPrefsListener);
        CoordTreeNode connectedCoordQmgr = MFTETreeNodeFactory.getConnectedCoordQmgr();
        if (connectedCoordQmgr != null && connectedCoordQmgr.isConnected()) {
            this.startup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(Observable observable, Object data) {
        if (data instanceof String) {
            String statusXML = (String)data;
            TransferProgressView transferProgressView = this;
            synchronized (transferProgressView) {
                this.cal.setTimeInMillis(System.currentTimeMillis());
                TransferStatus status = TransferStatus.fromXML(statusXML, this.cal.getTime());
                if (!cancelled.contains(status.getId())) {
                    if (this.statuses.contains(status)) {
                        this.statuses.remove(status);
                    }
                    this.statuses.add(status);
                    this.checkMaxStatuses();
                }
                this.requestRefresh(false);
            }
        }
    }

    private void addColumn(String title, ColumnLabelProvider l, ViewerSorter vs) {
        TreeViewerColumn tvc = new TreeViewerColumn(this.tbv, 16384);
        if (l != null) {
            tvc.setLabelProvider((CellLabelProvider)l);
        }
        final TreeColumn c = tvc.getColumn();
        c.setMoveable(true);
        c.setResizable(false);
        c.setText(title);
        this.availableColumns.add(tvc);
        if (vs != null && vs instanceof TransferProgressViewSorter) {
            final TransferProgressViewSorter tlSorter = (TransferProgressViewSorter)vs;
            c.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    tlSorter.setColumn(TransferProgressView.this.tbv, c);
                    TransferProgressView.this.requestRefresh(true);
                }
            });
        }
    }

    public void dispose() {
        ExplorerPlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this.transferProgressPrefsListener);
        this.shutdown();
        super.dispose();
    }

    public List<TreeViewerColumn> getAvailableColumns() {
        return this.availableColumns;
    }

    private ProgressViewColumns[] loadDefaultColumns() {
        String[] savedColumnOrder = PageUtils.loadDefaultColumns(TRANSFER_PROGRESS_VIEW_SETTINGS, DEFAULT_COLUMN_ORDER_AS_STRING);
        if (savedColumnOrder.length != DEFAULT_COLUMN_ORDER.length) {
            return DEFAULT_COLUMN_ORDER;
        }
        ArrayList<ProgressViewColumns> savedColumnOrderConverted = new ArrayList<ProgressViewColumns>();
        String[] stringArray = savedColumnOrder;
        int n = savedColumnOrder.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            ProgressViewColumns column = ProgressViewColumns.findByPersistedString(s);
            if (column != null) {
                savedColumnOrderConverted.add(column);
            }
            ++n2;
        }
        if (savedColumnOrderConverted.size() == savedColumnOrder.length) {
            return savedColumnOrderConverted.toArray(new ProgressViewColumns[0]);
        }
        ProgressViewColumns[] columns = this.getColumnsFromTitles(savedColumnOrder);
        if (columns.length == savedColumnOrder.length) {
            return columns;
        }
        return DEFAULT_COLUMN_ORDER;
    }

    private void saveDefaultColumns() {
        if (PageUtils.getVisibleColumns((Viewer)this.tbv).length == DEFAULT_COLUMN_ORDER.length) {
            PageUtils.saveDefaultColumns(TRANSFER_PROGRESS_VIEW_SETTINGS, this, (Viewer)this.tbv);
        }
    }

    private void addContextMenu(final TreeViewer tv) {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                TransferProgressView.this.fillContextMenu(tv, manager);
            }
        });
        Menu menu = menuMgr.createContextMenu((Control)tv.getTree());
        tv.getTree().setMenu(menu);
    }

    private void fillContextMenu(final TreeViewer tv, IMenuManager manager) {
        boolean hasSelection;
        final List selectionList = ((IStructuredSelection)tv.getSelection()).toList();
        boolean bl = hasSelection = tv.getSelection() instanceof IStructuredSelection && selectionList.size() > 0;
        if (hasSelection) {
            Action cancel = new Action(){

                public void run() {
                    ISelection s = tv.getSelection();
                    if (s instanceof IStructuredSelection) {
                        for (Object o : ((IStructuredSelection)s).toList()) {
                            if (!(o instanceof TransferStatus)) continue;
                            TransferStatus t = (TransferStatus)o;
                            if (100L == t.getProgress()) {
                                MessageDialog.openError((Shell)tv.getControl().getShell(), (String)Elements.UI_WIZARD_TRANSFER_CANCEL_TITLE, (String)Messages.BFGUI0002_CANCEL_ALREADY_COMPLETE_TRANSFER);
                                continue;
                            }
                            if (cancelled.contains(t.getId())) {
                                MessageDialog.openError((Shell)tv.getControl().getShell(), (String)Elements.UI_WIZARD_TRANSFER_CANCEL_TITLE, (String)Messages.BFGUI0007_CANCEL_ALREADY_CANCELLED_TRANSFER);
                                continue;
                            }
                            WMQConnectionData conn = Subscription.getCmdConnectionData();
                            try {
                                String cancelAgentName = t.getSrcAgent();
                                String cancelAgentQmgr = t.getSrcAgentQmgr();
                                if (cancelAgentName == null || cancelAgentName.length() == 0 || cancelAgentQmgr == null || cancelAgentQmgr.length() == 0) {
                                    cancelAgentName = t.getDestAgent();
                                    cancelAgentQmgr = t.getDestAgentQmgr();
                                }
                                CancelTransfer.cancelTransfer((String)cancelAgentName, (String)cancelAgentQmgr, (WMQConnectionData)conn, (String)Subscription.getDynamicQueuePrefix(), (String)Subscription.getModelQueueName(), (String)AbstractCommand.getHostName(), (String)AbstractCommand.getUserId(), (String)t.getId());
                                cancelled.add(t.getId());
                            }
                            catch (Exception e) {
                                MessageDialog.openError((Shell)tv.getControl().getShell(), (String)Elements.UI_WIZARD_TRANSFER_CANCEL_TITLE, (String)e.getLocalizedMessage());
                            }
                        }
                        while (cancelled.size() > 99) {
                            cancelled.removeFirst();
                        }
                        tv.refresh();
                    }
                }
            };
            cancel.setText(Elements.UI_WIZARD_TRANSFER_CANCEL_TITLE);
            Action delete = new Action(){

                public void run() {
                    ISelection s = tv.getSelection();
                    if (s instanceof IStructuredSelection) {
                        for (Object o : ((IStructuredSelection)s).toList()) {
                            if (!(o instanceof TransferStatus)) continue;
                            TransferStatus t = (TransferStatus)o;
                            TransferProgressView.this.statuses.remove(t);
                        }
                        tv.refresh();
                    }
                }
            };
            delete.setText(Elements.UI_CONTENT_TRANSFER_TEMPLATES_DELETE_BUTTON);
            Action copyID = new Action(){

                public void run() {
                    Object o;
                    ISelection s = tv.getSelection();
                    if (s instanceof IStructuredSelection && (o = selectionList.get(0)) instanceof TransferStatus) {
                        TransferStatus t = (TransferStatus)o;
                        Clipboard clipboard = new Clipboard(tv.getControl().getDisplay());
                        clipboard.setContents((Object[])new String[]{t.getId()}, new Transfer[]{TextTransfer.getInstance()});
                        clipboard.dispose();
                    }
                }
            };
            copyID.setText(Elements.UI_CONTENT_TRANSFER_LOG_COPY_ID_BUTTON);
            cancel.setEnabled(true);
            delete.setEnabled(true);
            copyID.setEnabled(false);
            if (selectionList.size() == 1) {
                Object o = selectionList.get(0);
                copyID.setEnabled(o instanceof TransferStatus);
            }
            manager.add((IAction)cancel);
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)delete);
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)copyID);
        }
    }

    private void contributeToActionBar() {
        IActionBars bars = this.getViewSite().getActionBars();
        IToolBarManager manager = bars.getToolBarManager();
        manager.add((IAction)this.clearCompleted);
        manager.add((IAction)this.refreshToolbarAction);
    }

    public static void refreshView(final boolean auto) {
        final IWorkbench workbench = PlatformUI.getWorkbench();
        workbench.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    IViewPart viewPart = workbench.getActiveWorkbenchWindow().getActivePage().showView("com.ibm.wmqfte.explorer.views.TransferProgressView", null, 2);
                    if (viewPart instanceof TransferProgressView) {
                        ((TransferProgressView)viewPart).requestRefresh(!auto);
                    }
                }
                catch (PartInitException partInitException) {}
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestRefresh(boolean forceRefresh) {
        Object object = this.refreshRequestLock;
        synchronized (object) {
            IWorkbench workbench;
            Display display;
            long timeElapsedSinceLastRefresh = System.currentTimeMillis() - this.lastRefreshCompleteTime;
            if ((forceRefresh || this.refreshRequestQueuedCount == 0 && timeElapsedSinceLastRefresh > 2000L) && (display = (workbench = PlatformUI.getWorkbench()).getDisplay()) != null && !display.isDisposed()) {
                ++this.refreshRequestQueuedCount;
                display.asyncExec(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        block15: {
                            if (TransferProgressView.this.tbv != null && !TransferProgressView.this.tbv.getControl().isDisposed()) break block15;
                            Object object = TransferProgressView.this.refreshRequestLock;
                            synchronized (object) {
                                TransferProgressView.this.lastRefreshCompleteTime = System.currentTimeMillis();
                                TransferProgressView transferProgressView = TransferProgressView.this;
                                transferProgressView.refreshRequestQueuedCount = transferProgressView.refreshRequestQueuedCount - 1;
                            }
                            return;
                        }
                        try {
                            Tree tree = TransferProgressView.this.tbv.getTree();
                            if (tree != null && !tree.isDisposed()) {
                                TransferProgressView.this.tbv.refresh();
                                TransferProgressView.this.setupTree(tree);
                            }
                        }
                        catch (Throwable throwable) {
                            Object object = TransferProgressView.this.refreshRequestLock;
                            synchronized (object) {
                                TransferProgressView.this.lastRefreshCompleteTime = System.currentTimeMillis();
                                TransferProgressView transferProgressView = TransferProgressView.this;
                                transferProgressView.refreshRequestQueuedCount = transferProgressView.refreshRequestQueuedCount - 1;
                            }
                            throw throwable;
                        }
                        Object object = TransferProgressView.this.refreshRequestLock;
                        synchronized (object) {
                            TransferProgressView.this.lastRefreshCompleteTime = System.currentTimeMillis();
                            TransferProgressView transferProgressView = TransferProgressView.this;
                            transferProgressView.refreshRequestQueuedCount = transferProgressView.refreshRequestQueuedCount - 1;
                        }
                    }
                });
            }
        }
    }

    public void clear() {
        if (this.statuses != null) {
            this.statuses.clear();
        }
        this.requestRefresh(true);
    }

    @Override
    public void startup() {
        Subscription.getTransferStatusProvider().addObserver(this);
    }

    @Override
    public void shutdown() {
        Subscription.getTransferStatusProvider().deleteObserver(this);
        this.clear();
    }

    public void setFocus() {
    }

    public void setupTree(Tree tree) {
        int columnCount = tree.getColumnCount();
        int i = 0;
        while (i < columnCount) {
            TreeColumn column = tree.getColumn(i);
            column.pack();
            TreeColumn sortedColumn = tree.getSortColumn();
            if (sortedColumn != null && sortedColumn.equals(column)) {
                column.setWidth(column.getWidth() + 25);
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkMaxStatuses() {
        Set<TransferStatus> set = this.statuses;
        synchronized (set) {
            int s = this.statuses.size();
            if (s > this.transferProgressMax) {
                Iterator<TransferStatus> it = this.statuses.iterator();
                int i = 0;
                while (i < s - this.transferProgressMax) {
                    TransferStatus o = it.next();
                    if (o != null) {
                        it.remove();
                    }
                    ++i;
                }
            }
        }
    }

    static String formatBytes(long bytes) {
        String type;
        long value;
        if (bytes < 1024L) {
            value = bytes;
            type = "B";
        } else if (bytes < 0x100000L) {
            value = bytes / 1024L;
            type = "KiB";
        } else if (bytes < 0x40000000L) {
            value = bytes / 0x100000L;
            type = "MiB";
        } else if (bytes < 0x10000000000L) {
            value = bytes / 0x40000000L;
            type = "GiB";
        } else {
            value = bytes / 0x10000000000L;
            type = "TiB";
        }
        return String.valueOf(value) + type;
    }

    static enum ProgressViewColumns {
        EMPTY(""),
        SOURCE(Elements.UI_CONTENT_SRC_TITLE),
        DESTINATION(Elements.UI_CONTENT_DEST_TITLE),
        CURRENT_FILE(Elements.UI_VIEW_TRANSFER_PROGRESS_CURRENT_FILE_TITLE),
        FILE_NUMBER(Elements.UI_VIEW_TRANSFER_PROGRESS_NUMFILES_TITLE),
        PROGRESS(Elements.UI_VIEW_TRANSFER_PROGRESS_PROGRESS_TITLE),
        RATE(Elements.UI_VIEW_TRANSFER_PROGRESS_RATE_TITLE),
        STARTED(Elements.UI_VIEW_TRANSFER_PROGRESS_STARTED_TITLE);

        private final String columnTitle;

        private ProgressViewColumns(String columnTitle) {
            this.columnTitle = columnTitle;
        }

        public static ProgressViewColumns findByPersistedString(String str) {
            ProgressViewColumns[] progressViewColumnsArray = ProgressViewColumns.values();
            int n = progressViewColumnsArray.length;
            int n2 = 0;
            while (n2 < n) {
                ProgressViewColumns col = progressViewColumnsArray[n2];
                if (col.toString().equals(str)) {
                    return col;
                }
                ++n2;
            }
            return null;
        }

        public static ProgressViewColumns findByColumnTitle(String title) {
            ProgressViewColumns[] progressViewColumnsArray = ProgressViewColumns.values();
            int n = progressViewColumnsArray.length;
            int n2 = 0;
            while (n2 < n) {
                ProgressViewColumns col = progressViewColumnsArray[n2];
                if (col.columnTitle.equals(title)) {
                    return col;
                }
                ++n2;
            }
            return null;
        }
    }

    class TransferStatusComparator
    extends ViewerComparator {
        TransferStatusComparator() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (viewer instanceof TreeViewer) {
                boolean ascending;
                TreeViewer tbv = (TreeViewer)viewer;
                Tree t = tbv.getTree();
                boolean bl = ascending = t.getSortDirection() == 128;
                if (e1 instanceof TransferStatus && e2 instanceof TransferStatus) {
                    int result = ((TransferStatus)e1).getProgress() == 100L || ((TransferStatus)e1).getLogState(false) != null ? 100 : 0;
                    if ((result -= ((TransferStatus)e2).getProgress() == 100L || ((TransferStatus)e2).getLogState(false) != null ? 100 : 0) == 0) {
                        result = ((TransferStatus)e2).getStartTime().compareTo(((TransferStatus)e1).getStartTime());
                    }
                    return ascending ? result : -1 * result;
                }
            }
            return super.compare(viewer, e1, e2);
        }
    }
}

