/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wmqfte.explorer.views;

import com.ibm.wmqfte.explorer.Elements;
import com.ibm.wmqfte.explorer.objects.TransferStatus;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;

class ProgressLabelProvider
extends ColumnLabelProvider {
    private final ProgressBar bar;
    private final Shell s;
    private final GC gc;
    private final int width = 80;
    private final int height = 16;
    private static Map<Integer, Image> cache = new LinkedHashMap<Integer, Image>();

    public String getText(Object element) {
        String result = "";
        if (element instanceof TransferStatus) {
            TransferStatus status = (TransferStatus)element;
            result = status.getProgress() >= 0L ? String.valueOf(status.getProgress()) + "%" : Elements.UI_WIZARD_TRANSFER_PROGRESS_UNKNOWN_LABEL;
        }
        return String.valueOf(result) + "   ";
    }

    public Image getImage(Object element) {
        if (element instanceof TransferStatus) {
            return this.getProgressImage((TransferStatus)element);
        }
        return null;
    }

    public ProgressLabelProvider(TreeViewer viewer) {
        this.s = new Shell(viewer.getControl().getShell(), 8);
        Rectangle bounds = Display.getCurrent().getBounds();
        this.s.setLocation(bounds.width - 80, bounds.height / 2);
        this.s.setSize(80, 16);
        this.bar = new ProgressBar((Composite)this.s, 256);
        this.bar.setLocation(1, 1);
        this.bar.setSize(78, 14);
        this.gc = new GC((Drawable)this.s);
        this.s.open();
        int i = 0;
        while (i <= 100) {
            this.s.forceActive();
            this.generateImage(i);
            i += 5;
        }
        this.bar.setVisible(false);
        this.s.setVisible(false);
        this.generateIndeterminateImage(viewer);
    }

    private void generateIndeterminateImage(TreeViewer viewer) {
        Image image = new Image((Device)this.s.getDisplay(), cache.get(100), 2);
        cache.put(-1, image);
    }

    private static int roundToNearestFive(int i) {
        return i + 2 - (i + 2) % 5;
    }

    public Image getProgressImage(TransferStatus status) {
        int percent;
        int progress = (int)status.getProgress();
        int n = percent = progress > 0 ? ProgressLabelProvider.roundToNearestFive(progress) : progress;
        if (cache.containsKey(percent)) {
            return cache.get(percent);
        }
        this.s.setVisible(true);
        this.bar.setVisible(true);
        Image img = this.generateImage(percent);
        this.bar.setVisible(false);
        this.s.setVisible(false);
        return img;
    }

    private Image generateImage(Integer percent) {
        Image image = new Image((Device)this.s.getDisplay(), 80, 16);
        this.bar.setSelection(percent.intValue());
        this.gc.copyArea(image, 0, 0);
        cache.put(percent, image);
        return image;
    }

    public void dispose() {
        for (Image i : cache.values()) {
            i.dispose();
        }
        this.gc.dispose();
        this.s.close();
    }
}

