/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wmqfte.explorer.utils.v2;

import com.ibm.wmqfte.explorer.Elements;
import com.ibm.wmqfte.explorer.ExplorerPlugin;
import com.ibm.wmqfte.explorer.Icons;
import com.ibm.wmqfte.explorer.dialogs.ItemDialogAttributes;
import com.ibm.wmqfte.explorer.utils.v2.DatasetAttributes;
import com.ibm.wmqfte.explorer.utils.v2.QueueProperties;
import com.ibm.wmqfte.explorer.utils.v2.Tools;
import com.ibm.wmqfte.utils.xmlmessage.transfer.ItemSpecification;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.graphics.Image;

public class TransferItem {
    public static final String VIRTUAL_SRC_AGENT_QMGR = "";
    private static final IPreferenceStore ps = ExplorerPlugin.getDefault().getPreferenceStore();
    private static Pattern PatternDataSet = null;
    private static Pattern PatternDataSetVarSt = null;
    private static Pattern PatternDataSetName = null;
    private static Pattern PatternDataSetNameVarSt = null;
    private static Pattern PatternPDSName = null;
    private static Pattern PatternPDSNameVarSt = null;
    private static Pattern PatternQueueName = null;
    private static Pattern PatternQueueNameVarSt = null;
    private static Pattern PatternQMgrName = null;
    private static Pattern PatternQMgrNameVarSt = null;
    private static Pattern PatternFileNames = null;
    private static Pattern PatternWindowsPath = null;
    private static final String GDG = "\\((?:[+-])?\\d+\\)";
    private static final String START = "//";
    private static final String ATTR = "(?:;(?:.*))*";
    private static final String QUALIFIER = "[@#\\$A-Za-z][@#\\$A-Za-z0-9]{0,7}";
    private static final String QUALIFIER_WITH_VAR = "(?:[@#\\$A-Za-z][@#\\$A-Za-z0-9]{0,7}|\\$\\{.*\\})";
    private static final String WINDOWS_PATH = "[A-Za-z]:[\\\\/]";
    private static final int MAX_DATASET_LENGTH = 44;
    private ChecksumType checksum = ChecksumType.getInitialName();
    private SourceDispositionType sourceDisposition = SourceDispositionType.getInitialName();
    private DestinationDispositionType destinationDisposition = DestinationDispositionType.getInitialName();
    private OversizeDatasetRecord oversizeDatasetRecord = OversizeDatasetRecord.WRAP;
    private String destinationSpecificDistributionType = null;
    private TransferModeType transferMode = TransferModeType.getInitialName();
    private BaseItem source;
    private BaseItem destination;
    private IStatus status = null;

    static {
        try {
            PatternDataSet = TransferItem.generateDataSetRegEx(false, QUALIFIER, ATTR);
            PatternDataSetName = TransferItem.generateDataSetRegEx(false, QUALIFIER, null);
            PatternDataSetVarSt = TransferItem.generateDataSetRegEx(false, QUALIFIER_WITH_VAR, ATTR);
            PatternDataSetNameVarSt = TransferItem.generateDataSetRegEx(false, QUALIFIER_WITH_VAR, null);
            PatternPDSName = TransferItem.generateDataSetRegEx(true, QUALIFIER, null);
            PatternPDSNameVarSt = TransferItem.generateDataSetRegEx(true, QUALIFIER_WITH_VAR, null);
            String Q001 = "([A-Za-z0-9._/%])";
            String Q002 = "([A-Za-z0-9._/%]|\\$\\{.*\\})";
            PatternQueueName = Pattern.compile(String.valueOf(Q001) + "{1,48}");
            PatternQMgrName = Pattern.compile(String.valueOf(Q001) + "{1,48}");
            PatternQueueNameVarSt = Pattern.compile(String.valueOf(Q002) + "{1,48}");
            PatternQMgrNameVarSt = Pattern.compile(String.valueOf(Q002) + "{1,48}");
            String NamePattern = "\"([^\"]*)\"";
            PatternFileNames = Pattern.compile("^(?:" + NamePattern + ",)*" + NamePattern + "$|([^\"].*)");
        }
        catch (PatternSyntaxException ex) {
            Tools.internalError(ex, Elements.UI_WIZARD_V2_INTERR_PATTERN, new Object[0]);
        }
    }

    private static Pattern generateDataSetRegEx(boolean asPDS, String nameletRegEx, String attrRegEx) {
        String dataSetName;
        String withoutQuotes;
        String member = "\\(" + nameletRegEx + "\\)";
        String seqStandard = String.valueOf(nameletRegEx) + "(?:\\." + nameletRegEx + ")*";
        String seqMember = String.valueOf(nameletRegEx) + "(?:\\." + nameletRegEx + ")*" + member;
        String seqGDG = String.valueOf(nameletRegEx) + "(?:\\." + nameletRegEx + ")*" + GDG;
        if (asPDS) {
            withoutQuotes = "(?:" + seqStandard + ")";
            String withQuotes = "'(?:" + seqStandard + ")'";
            dataSetName = "//(?:" + withoutQuotes + "|" + withQuotes + ")";
        } else {
            withoutQuotes = "(?:" + seqStandard + "|" + seqMember + "|" + seqGDG + ")";
            String withQuotes = "'(?:" + seqStandard + "|" + seqMember + "|" + seqGDG + ")'";
            dataSetName = "//(?:" + withoutQuotes + "|" + withQuotes + ")";
        }
        String patternStr = attrRegEx == null ? "(" + dataSetName + ")" : "(" + dataSetName + ")(" + attrRegEx + ")?";
        return Pattern.compile(patternStr);
    }

    public TransferItem(BaseItem source, BaseItem destination) {
        this.source = source;
        this.destination = destination;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TransferItem(ItemSpecification itemSpec) throws InternalException {
        String destinationName;
        String sourceCodePage = itemSpec.getSourceEncoding();
        if (itemSpec.getSourceType() == ItemSpecification.SourceType.FILE) {
            this.source = new FileItem(itemSpec.getSourceName(), itemSpec.isRecursive(), null, sourceCodePage);
        } else if (itemSpec.getSourceType() == ItemSpecification.SourceType.QUEUE) {
            QueueProperties.SchemaSet templateSet;
            QueueProperties.MessageSource templateSource;
            String[] parts = itemSpec.getSourceName().split("@");
            if (parts.length == 1) {
                templateSource = QueueProperties.MessageSource.createMessage(itemSpec.getSourceQueueProps());
                templateSet = new QueueProperties.SchemaSet(Elements.UI_PREFS_V2_QUEUE_TEMPLATES_NAME_CUST, templateSource, null);
                this.source = new QueueItem(parts[0], null, templateSet, null, sourceCodePage);
            } else {
                if (parts.length != 2) throw new InternalException(MessageFormat.format(Elements.UI_WIZARD_V2_INTERR_BAD_QUEUE_NAME, itemSpec.getSourceName()));
                templateSource = QueueProperties.MessageSource.createMessage(itemSpec.getSourceQueueProps());
                templateSet = new QueueProperties.SchemaSet(Elements.UI_PREFS_V2_QUEUE_TEMPLATES_NAME_CUST, templateSource, null);
                this.source = new QueueItem(parts[0], parts[1], templateSet, null, sourceCodePage);
            }
        } else if (DataSetItem.isDataSetValid(itemSpec.getSourceName(), true)) {
            String trailSpacesStr;
            String positionStr = TransferItem.getSourceProps(itemSpec, "delimiterPosition");
            ItemDialogAttributes.DataSetDelimiterPosition position = positionStr == null ? null : ItemDialogAttributes.DataSetDelimiterPosition.getByDataSetDelimiter(positionStr);
            String delimiter = TransferItem.getSourceProps(itemSpec, "delimiter");
            DataSetItem.RecordDelimiter recordDelimiter = null;
            if (position != null && delimiter != null) {
                recordDelimiter = new DataSetItem.RecordDelimiter(position, delimiter);
            }
            boolean trailSpace = (trailSpacesStr = TransferItem.getSourceProps(itemSpec, "keepTrailingSpaces")) != null && trailSpacesStr.equalsIgnoreCase("true");
            String sourceName = itemSpec.getSourceName();
            this.source = new DataSetItem(this.getDataSetName(sourceName), false, this.getDataSetAttributesFromName(sourceName), null, sourceCodePage, recordDelimiter, trailSpace, itemSpec.isTruncateDatasetRecord());
        } else {
            this.source = new FileItem(itemSpec.getSourceName(), itemSpec.isRecursive(), null, sourceCodePage);
        }
        String destinationCodePage = itemSpec.getDestinationEncoding();
        String eol = itemSpec.getDestinationEOL();
        if (itemSpec.getDestinationType() == ItemSpecification.DestinationType.FILE) {
            if (itemSpec.getDestinationName().startsWith(START)) {
                destinationName = itemSpec.getDestinationName();
                this.destination = new DataSetItem(this.getDataSetName(destinationName), false, this.getDataSetAttributesFromName(destinationName), eol, destinationCodePage, null, false, itemSpec.isTruncateDatasetRecord());
            } else {
                this.destination = new FileItem(itemSpec.getDestinationName(), false, eol, destinationCodePage);
            }
        } else if (itemSpec.getDestinationType() == ItemSpecification.DestinationType.DIRECTORY) {
            this.destination = new DirItem(itemSpec.getDestinationName(), false, eol, destinationCodePage);
        } else if (itemSpec.getDestinationType() == ItemSpecification.DestinationType.QUEUE) {
            String[] parts = itemSpec.getDestinationName().split("@");
            if (parts.length != 2) throw new InternalException(MessageFormat.format(Elements.UI_WIZARD_V2_INTERR_BAD_QUEUE_NAME, itemSpec.getDestinationName()));
            QueueProperties.MessageDestination templateDestination = QueueProperties.MessageDestination.createMessage(itemSpec.getDestinationProps());
            QueueProperties.SchemaSet templateSet = new QueueProperties.SchemaSet(Elements.UI_PREFS_V2_QUEUE_TEMPLATES_NAME_CUST, null, templateDestination);
            this.destination = new QueueItem(parts[0], parts[1], templateSet, eol, destinationCodePage);
        } else if (itemSpec.getDestinationType() == ItemSpecification.DestinationType.FILESPACE) {
            this.destination = new FileSpaceItem(itemSpec.getDestinationName(), eol, destinationCodePage);
        } else if (itemSpec.getDestinationType() == ItemSpecification.DestinationType.DATASET) {
            destinationName = itemSpec.getDestinationName();
            this.destination = new DataSetItem(this.getDataSetName(destinationName), false, this.getDataSetAttributesFromName(destinationName), eol, destinationCodePage, null, false, itemSpec.isTruncateDatasetRecord());
        } else {
            if (itemSpec.getDestinationType() != ItemSpecification.DestinationType.PDS) throw new InternalException(MessageFormat.format(Elements.UI_WIZARD_V2_INTERR_BAD_DEST_TYPE, itemSpec.getDestinationName()));
            destinationName = itemSpec.getDestinationName();
            this.destination = new DataSetItem(this.getDataSetName(destinationName), true, this.getDataSetAttributesFromName(destinationName), eol, destinationCodePage, null, false, itemSpec.isTruncateDatasetRecord());
        }
        this.sourceDisposition = SourceDispositionType.getByAgentEnum(itemSpec.getSourceDisposition());
        this.destinationDisposition = DestinationDispositionType.getByAgentEnum(itemSpec.getDestinationExist());
        this.transferMode = TransferModeType.getByAgentEnum(itemSpec.getTransferModeType());
        this.checksum = ChecksumType.getByAgentEnum(itemSpec.getChecksumMethodType());
        Set destinationCustomAttributes = itemSpec.getDestinationCustomAttributes();
        if (destinationCustomAttributes == null) return;
        for (String customAttribute : destinationCustomAttributes) {
            if (!customAttribute.startsWith("DIST(")) continue;
            this.destinationSpecificDistributionType = customAttribute;
            return;
        }
    }

    private String getDataSetName(String dataSetNameAndAttributes) {
        if (dataSetNameAndAttributes == null) {
            return VIRTUAL_SRC_AGENT_QMGR;
        }
        String normalisedDataSetNameAndAttributes = dataSetNameAndAttributes.replaceAll(";", ":");
        int nameEndIndex = normalisedDataSetNameAndAttributes.indexOf(":");
        if (nameEndIndex < 0) {
            nameEndIndex = normalisedDataSetNameAndAttributes.length();
        }
        String dataSetName = normalisedDataSetNameAndAttributes.substring(0, nameEndIndex);
        return dataSetName;
    }

    private DatasetAttributes getDataSetAttributesFromName(String dataSetNameAndAttributes) {
        DatasetAttributes dataSetAttrs = null;
        if (dataSetNameAndAttributes == null) {
            return dataSetAttrs;
        }
        String normalisedDataSetNameAndAttributes = dataSetNameAndAttributes.replaceAll(";", ":");
        int nameEndIndex = normalisedDataSetNameAndAttributes.indexOf(":");
        if (nameEndIndex >= 0 && normalisedDataSetNameAndAttributes.length() > nameEndIndex + 1) {
            String dataSetAttrStr = normalisedDataSetNameAndAttributes.substring(nameEndIndex + 1, normalisedDataSetNameAndAttributes.length());
            dataSetAttrs = new DatasetAttributes(Elements.UI_PREFS_V2_DIALOG_CUSTOMIZED, dataSetAttrStr);
        }
        return dataSetAttrs;
    }

    public BaseItem getSource() {
        return this.source;
    }

    public BaseItem getDestination() {
        return this.destination;
    }

    public SourceDispositionType getSourceDisposition() {
        return this.sourceDisposition;
    }

    public DestinationDispositionType getDestinationDisposition() {
        return this.destinationDisposition;
    }

    public TransferModeType getTransferMode() {
        return this.transferMode;
    }

    public ChecksumType getCheckSum() {
        return this.checksum;
    }

    public void setSourceDispositionByPosition(int position) {
        this.sourceDisposition = SourceDispositionType.getByPositon(position);
    }

    public void setSourceDisposition(SourceDispositionType sourceDisposition) {
        this.sourceDisposition = sourceDisposition;
    }

    public void setDestinationDispositionByPosition(int position) {
        this.destinationDisposition = DestinationDispositionType.getByPositon(position);
    }

    public void setDestinationDisposition(DestinationDispositionType destinationDisposition) {
        this.destinationDisposition = destinationDisposition;
    }

    public void setDestinationOversizeRec(OversizeDatasetRecord oversizeDatasetRecord) {
        this.oversizeDatasetRecord = oversizeDatasetRecord;
    }

    public void setDestinationSpecificDistributionType(String distributionType) {
        this.destinationSpecificDistributionType = distributionType;
    }

    public String getDestinationSpecificDistributionType() {
        return this.destinationSpecificDistributionType;
    }

    public void setTransferModeByPosition(int position) {
        this.transferMode = TransferModeType.getByPositon(position);
    }

    public void setTransferMode(TransferModeType transferMode) {
        this.transferMode = transferMode;
    }

    public void setCheckSumByPosition(int position) {
        this.checksum = ChecksumType.getByPositon(position);
    }

    public String toString() {
        return "TransferItem [checksum=" + (Object)((Object)this.checksum) + ", destination=" + this.destination + ", destinationDisposition=" + (Object)((Object)this.destinationDisposition) + ", source=" + this.source + ", sourceDisposition=" + (Object)((Object)this.sourceDisposition) + ", status=" + this.status + ", transferMode=" + (Object)((Object)this.transferMode) + "]";
    }

    public ItemSpecification createItemSpecification(String sourceEndPoint, String destinationEndPoint) {
        QueueProperties.MessageDestination messageDest;
        QueueProperties.SchemaSet attributes;
        QueueProperties.MessageSource messageSource;
        boolean recursive = this.source instanceof FileItem ? ((FileItem)this.source).doesRecurse() : false;
        String sourceName = this.source instanceof DataSetItem ? ((DataSetItem)this.source).getNameWithAttr() : this.source.getName();
        String destinationName = this.destination instanceof DataSetItem ? ((DataSetItem)this.destination).getNameWithAttr() : this.destination.getName();
        sourceName = this.stripEndpointFromName(sourceName);
        destinationName = this.stripEndpointFromName(destinationName);
        if (sourceEndPoint != null) {
            sourceName = String.valueOf(sourceEndPoint) + ":" + sourceName;
        }
        if (destinationEndPoint != null) {
            destinationName = String.valueOf(destinationEndPoint) + ":" + destinationName;
        }
        ItemSpecification.DestinationExist destinationExist = this.destinationDisposition == null ? null : this.destinationDisposition.getAgentEnum();
        ItemSpecification.SourceDisposition agentSourceDisposition = this.sourceDisposition == null ? null : this.sourceDisposition.getAgentEnum();
        ItemSpecification is = new ItemSpecification(sourceName, this.source.getSourceType(), recursive, this.transferMode.getAgentEnum(), this.checksum.getAgentEnum(), destinationName, this.destination.getDestinationType(), agentSourceDisposition, destinationExist);
        if (this.transferMode == TransferModeType.TEXT) {
            is.setSourceAttributes(null, this.source.getCodePage(), null);
            is.setDestinationAttributes(this.destination.getEOL(), this.destination.getCodePage());
        }
        if (this.destinationSpecificDistributionType != null) {
            is.addDestinationCustomAttribute(this.destinationSpecificDistributionType);
        }
        if (this.source instanceof QueueItem && (messageSource = (attributes = ((QueueItem)this.source).getAttributes()).getSource()) != null) {
            boolean useGroups;
            Map<String, String> sourceQueueProperties = messageSource.getAttributes();
            String useGroupStr = sourceQueueProperties.get("useGroups");
            boolean bl = useGroups = useGroupStr != null && useGroupStr.equalsIgnoreCase("true");
            if (useGroups) {
                sourceQueueProperties.put("groupId", "${GROUPID}");
            }
            is.setSourceQueueProps(sourceQueueProperties);
        }
        if (this.destination instanceof QueueItem && (messageDest = (attributes = ((QueueItem)this.destination).getAttributes()).getDestination()) != null) {
            is.setDestinationProps(messageDest.getAttributes());
        }
        if (this.source instanceof DataSetItem) {
            DataSetItem item = (DataSetItem)this.source;
            if (item.getRecordDelimiter() != null) {
                is.setSourceProps(item.getRecordDelimiter().generateAsProperties());
            }
            if (item.includeTrailingSpaces()) {
                is.putSourceProps("keepTrailingSpaces", "true");
            }
        }
        if (this.destination instanceof DataSetItem && ((DataSetItem)this.destination).oversizeDatasetRecord == OversizeDatasetRecord.TRUNCATE) {
            HashMap<String, String> destProps = is.getDestinationProps();
            if (destProps == null) {
                destProps = new HashMap<String, String>();
            }
            destProps.put("truncateRecords", this.oversizeDatasetRecord.getTruncateRecordsValue());
            is.setDestinationProps(destProps);
        }
        return is;
    }

    public void setStatus(IStatus status) {
        this.status = status;
    }

    public IStatus getStatus() {
        return this.status;
    }

    private static String getSourceProps(ItemSpecification itemSpec, String propName) {
        String retValue = null;
        Map map = itemSpec.getSourceProps();
        if (map != null) {
            retValue = (String)map.get(propName);
        }
        return retValue;
    }

    private String stripEndpointFromName(String name) {
        int delimiterIndex = name.indexOf(58);
        if (delimiterIndex > 0) {
            if (delimiterIndex == 1) {
                if (PatternWindowsPath == null) {
                    PatternWindowsPath = Pattern.compile(WINDOWS_PATH);
                }
                if (PatternWindowsPath.matcher(name.substring(0, 3)).lookingAt()) {
                    return name;
                }
            }
            return name.substring(delimiterIndex + 1);
        }
        return name;
    }

    public static interface BaseItem {
        public void setName(String var1);

        public String getName();

        public Image getImage();

        public boolean dispositionApplies();

        public ItemSpecification.SourceType getSourceType();

        public ItemSpecification.DestinationType getDestinationType();

        public Object getAttributes();

        public boolean validate(boolean var1);

        public String getEOL();

        public String getCodePage();
    }

    public static enum ChecksumType {
        NONE(Elements.UI_PREFS_V2_CHECKSUM_NONE, ItemSpecification.ChecksumMethod.NONE),
        MD5(Elements.UI_PREFS_V2_CHECKSUM_MD5, ItemSpecification.ChecksumMethod.MD5);

        static final String STORE_NAME = "com.ibm.wmqfte.explorer.7041.item.checksum.type";
        static final ChecksumType defaultValue;
        private final String nlsName;
        final ItemSpecification.ChecksumMethod agentEnum;

        static {
            defaultValue = MD5;
        }

        private ChecksumType(String nlsName, ItemSpecification.ChecksumMethod agentEnum) {
            this.nlsName = nlsName;
            this.agentEnum = agentEnum;
        }

        public String getName() {
            return this.nlsName;
        }

        public int getPosition() {
            return this.ordinal();
        }

        public ItemSpecification.ChecksumMethod getAgentEnum() {
            return this.agentEnum;
        }

        public static String[] getAllNames() {
            ArrayList<String> names = new ArrayList<String>();
            ChecksumType[] checksumTypeArray = ChecksumType.values();
            int n = checksumTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ChecksumType e = checksumTypeArray[n2];
                names.add(e.getName());
                ++n2;
            }
            return names.toArray(new String[0]);
        }

        public static ChecksumType getInitialName() {
            String value = ps.getString(STORE_NAME);
            if (value != null) {
                ChecksumType[] checksumTypeArray = ChecksumType.values();
                int n = checksumTypeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ChecksumType e = checksumTypeArray[n2];
                    if (value.equals(e.getName())) {
                        return e;
                    }
                    ++n2;
                }
            }
            return defaultValue;
        }

        public static int getInitialNameByPosition() {
            return ChecksumType.getInitialName().getPosition();
        }

        public static int getDefaultPosition() {
            return defaultValue.getPosition();
        }

        public static String getDefaultName() {
            return defaultValue.getName();
        }

        public static ChecksumType getByPositon(int position) {
            return position >= 0 && position < ChecksumType.values().length ? ChecksumType.values()[position] : ChecksumType.getInitialName();
        }

        public static ChecksumType getByAgentEnum(ItemSpecification.ChecksumMethod agentEnum) {
            ChecksumType[] checksumTypeArray = ChecksumType.values();
            int n = checksumTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ChecksumType tm = checksumTypeArray[n2];
                if (tm.agentEnum == agentEnum) {
                    return tm;
                }
                ++n2;
            }
            return null;
        }
    }

    public static class DataSetItem
    implements BaseItem {
        private String dataSetName;
        private boolean isPDS;
        private DatasetAttributes dsp;
        private String eol;
        private String codePage;
        private RecordDelimiter recordDelimiter = null;
        private boolean includeTrailingSpace = false;
        private OversizeDatasetRecord oversizeDatasetRecord;

        public DataSetItem(String dataSetSpec, boolean isPDS) {
            this.isPDS = isPDS;
            Matcher m = PatternDataSet.matcher(dataSetSpec);
            if (m.find()) {
                if (m.group(1) != null) {
                    this.dataSetName = m.group(1);
                    this.dsp = new DatasetAttributes(Elements.UI_PREFS_V2_DIALOG_CUSTOMIZED, m.group(2));
                } else if (m.group(3) != null) {
                    this.dataSetName = m.group(3);
                    this.dsp = new DatasetAttributes(Elements.UI_PREFS_V2_DIALOG_CUSTOMIZED, m.group(4));
                }
                this.dataSetName = this.normaliseName(this.dataSetName);
            } else {
                this.dataSetName = TransferItem.VIRTUAL_SRC_AGENT_QMGR;
                this.dsp = null;
                Tools.internalError(Elements.UI_WIZARD_V2_INTERR_BAD_DATASET_SPEC, dataSetSpec);
            }
        }

        public DataSetItem(String dataSetName, boolean isPDS, DatasetAttributes dsp, String eol, String codePage, RecordDelimiter recordDelimiter, boolean includeTrailingSpace, boolean isTruncate) {
            this.dataSetName = this.normaliseName(dataSetName);
            this.isPDS = isPDS;
            this.dsp = dsp != null ? dsp : new DatasetAttributes();
            this.eol = eol;
            this.codePage = codePage;
            this.recordDelimiter = recordDelimiter;
            this.includeTrailingSpace = includeTrailingSpace;
            this.oversizeDatasetRecord = isTruncate ? OversizeDatasetRecord.TRUNCATE : OversizeDatasetRecord.WRAP;
        }

        public DataSetItem(String dataSetName, DatasetAttributes dsp) {
            this.dataSetName = this.normaliseName(dataSetName);
            this.dsp = dsp;
        }

        @Override
        public void setName(String dataSetPath) {
            this.dataSetName = this.normaliseName(dataSetPath);
        }

        @Override
        public String getName() {
            return this.dataSetName;
        }

        public String getNameWithAttr() {
            return this.dsp == null || this.dsp.isEmpty() ? this.dataSetName : String.valueOf(this.dataSetName) + ";" + this.dsp.getAsAttributes(false);
        }

        @Override
        public Image getImage() {
            return Icons.datasetObj;
        }

        @Override
        public boolean dispositionApplies() {
            return true;
        }

        @Override
        public DatasetAttributes getAttributes() {
            return this.dsp;
        }

        @Override
        public ItemSpecification.SourceType getSourceType() {
            return ItemSpecification.SourceType.FILE;
        }

        public RecordDelimiter getRecordDelimiter() {
            return this.recordDelimiter;
        }

        public boolean includeTrailingSpaces() {
            return this.includeTrailingSpace;
        }

        public OversizeDatasetRecord getOversizeDatasetRecord() {
            return this.oversizeDatasetRecord;
        }

        @Override
        public boolean validate(boolean withVarSt) {
            boolean retBool = true;
            if (this.dataSetName == null || this.dataSetName.length() == 0) {
                retBool = false;
            } else if (!withVarSt && this.dataSetName.length() > 44) {
                retBool = false;
            } else {
                Pattern pat = this.isPDS ? (withVarSt ? PatternPDSNameVarSt : PatternPDSName) : (withVarSt ? PatternDataSetNameVarSt : PatternDataSetName);
                Matcher m = pat.matcher(this.dataSetName);
                if (!m.find()) {
                    retBool = false;
                }
            }
            return retBool;
        }

        @Override
        public ItemSpecification.DestinationType getDestinationType() {
            return this.isPDS ? ItemSpecification.DestinationType.PDS : ItemSpecification.DestinationType.DATASET;
        }

        public static boolean isDataSetValid(String name, boolean withVarSt) {
            Pattern pat;
            boolean retBool = false;
            Pattern pattern = pat = withVarSt ? PatternDataSetVarSt : PatternDataSet;
            if (name != null && name.length() <= 44) {
                retBool = pat.matcher(name).matches();
            }
            return retBool;
        }

        public static boolean isDataSetNameValid(String name, boolean withVarSt) {
            Pattern pat;
            boolean retBool = false;
            Pattern pattern = pat = withVarSt ? PatternDataSetNameVarSt : PatternDataSetName;
            if (name != null && name.length() <= 44) {
                String extendDataSetName = name.startsWith(TransferItem.START) ? name : TransferItem.START + name;
                retBool = pat.matcher(extendDataSetName).matches();
            }
            return retBool;
        }

        public static boolean isPDSNameValid(String name, boolean withVarSt) {
            Pattern pat;
            boolean retBool = false;
            Pattern pattern = pat = withVarSt ? PatternPDSNameVarSt : PatternPDSName;
            if (name != null && name.length() <= 44) {
                String extendDataSetName = name.startsWith(TransferItem.START) ? name : TransferItem.START + name;
                retBool = pat.matcher(extendDataSetName).matches();
            }
            return retBool;
        }

        @Override
        public String getEOL() {
            return this.eol;
        }

        @Override
        public String getCodePage() {
            return this.codePage;
        }

        public boolean isPartitionedDataSet() {
            return this.isPDS;
        }

        public String toString() {
            return "(DataSetItem Name: " + this.dataSetName + "[PDS:" + this.isPDS + ", Attr: " + this.dsp.getAsAttributes(false) + "])";
        }

        private String normaliseName(String dataSetName) {
            String retValue = dataSetName;
            if (dataSetName != null && !dataSetName.startsWith(TransferItem.START)) {
                retValue = TransferItem.START + dataSetName;
            }
            return retValue;
        }

        public static class RecordDelimiter {
            private ItemDialogAttributes.DataSetDelimiterPosition position;
            private String delimiterInByteFormat;

            public RecordDelimiter(ItemDialogAttributes.DataSetDelimiterPosition position, String delimiterInByteFormat) {
                this.position = position;
                this.delimiterInByteFormat = delimiterInByteFormat;
            }

            public ItemDialogAttributes.DataSetDelimiterPosition getPosition() {
                return this.position;
            }

            public String getDelimiter() {
                return this.delimiterInByteFormat;
            }

            public Map<String, String> generateAsProperties() {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("delimiter", this.delimiterInByteFormat);
                map.put("delimiterPosition", this.position.getDataSetDelimiter());
                map.put("delimiterType", "binary");
                return map;
            }
        }
    }

    public static enum DestinationDispositionType {
        ERROR(Elements.UI_PREFS_V2_DESTINATION_DISPOSITION_ERROR, ItemSpecification.DestinationExist.ERROR),
        OVERWRITE(Elements.UI_PREFS_V2_DESTINATION_DISPOSITION_OVERWRITE, ItemSpecification.DestinationExist.OVERWRITE);

        static final String STORE_NAME = "com.ibm.wmqfte.explorer.7041.item.destinationDisposition.type";
        static final DestinationDispositionType defaultValue;
        private final String nlsName;
        final ItemSpecification.DestinationExist agentEnum;

        static {
            defaultValue = ERROR;
        }

        private DestinationDispositionType(String nlsName, ItemSpecification.DestinationExist agentEnum) {
            this.nlsName = nlsName;
            this.agentEnum = agentEnum;
        }

        public String getName() {
            return this.nlsName;
        }

        public int getPosition() {
            return this.ordinal();
        }

        public ItemSpecification.DestinationExist getAgentEnum() {
            return this.agentEnum;
        }

        public static String[] getAllNames() {
            ArrayList<String> names = new ArrayList<String>();
            DestinationDispositionType[] destinationDispositionTypeArray = DestinationDispositionType.values();
            int n = destinationDispositionTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                DestinationDispositionType e = destinationDispositionTypeArray[n2];
                names.add(e.getName());
                ++n2;
            }
            return names.toArray(new String[0]);
        }

        public static DestinationDispositionType getInitialName() {
            String value = ps.getString(STORE_NAME);
            if (value != null) {
                DestinationDispositionType[] destinationDispositionTypeArray = DestinationDispositionType.values();
                int n = destinationDispositionTypeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    DestinationDispositionType e = destinationDispositionTypeArray[n2];
                    if (value.equals(e.getName())) {
                        return e;
                    }
                    ++n2;
                }
            }
            return defaultValue;
        }

        public static int getInitialNameByPosition() {
            return DestinationDispositionType.getInitialName().getPosition();
        }

        public static int getDefaultPosition() {
            return defaultValue.getPosition();
        }

        public static String getDefaultName() {
            return defaultValue.getName();
        }

        public static DestinationDispositionType getByPositon(int position) {
            return position >= 0 && position < DestinationDispositionType.values().length ? DestinationDispositionType.values()[position] : DestinationDispositionType.getInitialName();
        }

        public static DestinationDispositionType getByAgentEnum(ItemSpecification.DestinationExist agentEnum) {
            DestinationDispositionType[] destinationDispositionTypeArray = DestinationDispositionType.values();
            int n = destinationDispositionTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                DestinationDispositionType tm = destinationDispositionTypeArray[n2];
                if (tm.agentEnum == agentEnum) {
                    return tm;
                }
                ++n2;
            }
            return null;
        }
    }

    public static class DirItem
    extends FileItem {
        public DirItem(String dirPath, boolean recursion) {
            super(dirPath, recursion);
        }

        public DirItem(String dirPath, boolean recursion, String eol, String codePage) {
            super(dirPath, recursion, eol, codePage);
        }

        @Override
        public ItemSpecification.DestinationType getDestinationType() {
            return ItemSpecification.DestinationType.DIRECTORY;
        }

        @Override
        public String toString() {
            return "(DirItem Name: " + this.getName() + "[Recurse: " + this.doesRecurse() + "])";
        }
    }

    public static class FileItem
    implements BaseItem {
        private String filePath;
        private boolean recursion;
        private String eol;
        private String codePage;

        public FileItem(String filePath, String eol, String codePage) {
            this.filePath = filePath;
            this.eol = eol;
            this.codePage = codePage;
            this.recursion = false;
        }

        public FileItem(String filePath, boolean recursion, String eol, String codePage) {
            this(filePath, recursion);
            this.eol = eol;
            this.codePage = codePage;
        }

        public FileItem(String filePath, boolean recursion) {
            this.filePath = filePath;
            this.recursion = recursion;
        }

        public FileItem(String fileName, String path) {
            this.filePath = String.valueOf(path) + "/" + fileName;
            this.recursion = false;
        }

        @Override
        public void setName(String filePath) {
            this.filePath = filePath;
        }

        @Override
        public String getName() {
            return this.filePath;
        }

        public void setRecursion(boolean recursion) {
            this.recursion = recursion;
        }

        public void setRecursionByPosition(int position) {
            this.recursion = position == SubDirectoryType.INCLUDED.ordinal();
        }

        public boolean doesRecurse() {
            return this.recursion;
        }

        @Override
        public Image getImage() {
            return Icons.fileObj;
        }

        @Override
        public boolean dispositionApplies() {
            return true;
        }

        @Override
        public ItemSpecification.SourceType getSourceType() {
            return ItemSpecification.SourceType.FILE;
        }

        @Override
        public ItemSpecification.DestinationType getDestinationType() {
            return ItemSpecification.DestinationType.FILE;
        }

        public SubDirectoryType getSubDirectory() {
            return this.recursion ? SubDirectoryType.INCLUDED : SubDirectoryType.EXCLUDED;
        }

        @Override
        public Object getAttributes() {
            return null;
        }

        @Override
        public boolean validate(boolean withVarSt) {
            return FileItem.isFileNamesValid(this.filePath);
        }

        public static boolean isFileNamesValid(String fileName) {
            return PatternFileNames.matcher(fileName).matches();
        }

        public static boolean isMultiFileNames(String fileName) {
            Matcher m = PatternFileNames.matcher(fileName);
            return m.matches() && m.group(3) == null;
        }

        @Override
        public String getEOL() {
            return this.eol;
        }

        @Override
        public String getCodePage() {
            return this.codePage;
        }

        public String toString() {
            return "(FileItem Name: " + this.filePath + ")";
        }
    }

    public static class FileSpaceItem
    implements BaseItem {
        private String fileSpaceName;
        private String eol;
        private String codePage;

        public FileSpaceItem(String fileSpaceName, String eol, String codePage) {
            this.eol = eol;
            this.codePage = codePage;
            this.fileSpaceName = fileSpaceName;
        }

        public FileSpaceItem(String fileSpaceName) {
            this.fileSpaceName = fileSpaceName;
        }

        @Override
        public void setName(String fileSpaceName) {
            this.fileSpaceName = fileSpaceName;
        }

        @Override
        public String getName() {
            return this.fileSpaceName;
        }

        @Override
        public Image getImage() {
            return Icons.filespaceObj;
        }

        @Override
        public boolean dispositionApplies() {
            return false;
        }

        @Override
        public ItemSpecification.SourceType getSourceType() {
            return null;
        }

        @Override
        public ItemSpecification.DestinationType getDestinationType() {
            return ItemSpecification.DestinationType.FILESPACE;
        }

        @Override
        public Object getAttributes() {
            return null;
        }

        @Override
        public boolean validate(boolean withVarSt) {
            return true;
        }

        public static boolean isFileSpaceValid(String fileSpace, boolean withVarSt) {
            return true;
        }

        @Override
        public String getEOL() {
            return this.eol;
        }

        @Override
        public String getCodePage() {
            return this.codePage;
        }
    }

    public static class InternalException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public InternalException(String message) {
            super(message);
        }

        public InternalException(String message, Exception cause) {
            super(message, cause);
        }
    }

    public static enum OversizeDatasetRecord {
        WRAP(Elements.UI_WIZARD_V2_ITEM_DIALOG_DATASET_OVERSIZE_WRAP_BUTTON, false, "false"),
        TRUNCATE(Elements.UI_WIZARD_V2_ITEM_DIALOG_DATASET_OVERSIZE_TRUCATE_BUTTON, true, "true");

        static final OversizeDatasetRecord defaultOversizeDatasetRecord;
        private final String nlsName;
        final boolean truncate;
        final String truncateRecordsValue;

        static {
            defaultOversizeDatasetRecord = WRAP;
        }

        private OversizeDatasetRecord(String nlsName, boolean truncate, String truncateRecordsValue) {
            this.nlsName = nlsName;
            this.truncate = truncate;
            this.truncateRecordsValue = truncateRecordsValue;
        }

        public String getName() {
            return this.nlsName;
        }

        public int getPosition() {
            return this.ordinal();
        }

        public boolean isTruncate() {
            return this.truncate;
        }

        public String getTruncateRecordsValue() {
            return this.truncateRecordsValue;
        }

        public static OversizeDatasetRecord getDefault() {
            return defaultOversizeDatasetRecord;
        }

        public static OversizeDatasetRecord getByValue(boolean value) {
            return value ? TRUNCATE : WRAP;
        }

        public static OversizeDatasetRecord getByTruncateRecordsValue(String value) {
            OversizeDatasetRecord[] oversizeDatasetRecordArray = OversizeDatasetRecord.values();
            int n = oversizeDatasetRecordArray.length;
            int n2 = 0;
            while (n2 < n) {
                OversizeDatasetRecord odr = oversizeDatasetRecordArray[n2];
                if (odr.truncateRecordsValue.equals(value)) {
                    return odr;
                }
                ++n2;
            }
            return null;
        }
    }

    public static class QueueItem
    implements BaseItem {
        private String queueName;
        private String queueMgrName;
        private QueueProperties.SchemaSet queueAttr;
        private String eol;
        private String codePage;

        public QueueItem(String queueName, String queueMgrName, QueueProperties.SchemaSet queueAttr, String eol, String codePage) {
            this(queueName, queueMgrName, queueAttr);
            this.eol = eol;
            this.codePage = codePage;
        }

        public QueueItem(String queueName, String queueMgrName, QueueProperties.SchemaSet queueAttr) {
            this.queueName = queueName;
            this.queueMgrName = queueMgrName;
            this.queueAttr = queueAttr;
        }

        @Override
        public void setName(String name) {
            String[] parts = name.split("@");
            if (parts.length == 1) {
                this.queueName = name;
                this.queueMgrName = null;
            } else if (parts.length == 2) {
                this.queueName = parts[0];
                this.queueMgrName = parts[1];
            }
        }

        @Override
        public String getName() {
            return this.queueMgrName == null ? this.queueName : String.valueOf(this.queueName) + "@" + this.queueMgrName;
        }

        @Override
        public Image getImage() {
            return Icons.localQueueObj;
        }

        @Override
        public boolean dispositionApplies() {
            return false;
        }

        @Override
        public QueueProperties.SchemaSet getAttributes() {
            return this.queueAttr;
        }

        @Override
        public ItemSpecification.SourceType getSourceType() {
            return ItemSpecification.SourceType.QUEUE;
        }

        @Override
        public ItemSpecification.DestinationType getDestinationType() {
            return ItemSpecification.DestinationType.QUEUE;
        }

        @Override
        public boolean validate(boolean withVarSt) {
            boolean retBool = true;
            Pattern pat = withVarSt ? PatternQueueNameVarSt : PatternQueueName;
            retBool = pat.matcher(this.queueName).matches();
            if (retBool && this.queueMgrName != null) {
                pat = withVarSt ? PatternQMgrNameVarSt : PatternQMgrName;
                retBool = pat.matcher(this.queueMgrName).matches();
            }
            return retBool;
        }

        public boolean isQMgrDefined() {
            return this.queueMgrName != null;
        }

        public boolean isQMgr(String qMgrName) {
            return this.queueMgrName != null && this.queueMgrName.equalsIgnoreCase(qMgrName);
        }

        public static boolean isQueueNameValid(String queueName, boolean withVarSt) {
            Pattern pat = withVarSt ? PatternQueueNameVarSt : PatternQueueName;
            return pat.matcher(queueName).matches();
        }

        public static boolean isQMgrNameValid(String qMgr, boolean withVarSt) {
            Pattern pat = withVarSt ? PatternQMgrNameVarSt : PatternQMgrName;
            return pat.matcher(qMgr).matches();
        }

        @Override
        public String getEOL() {
            return this.eol;
        }

        @Override
        public String getCodePage() {
            return this.codePage;
        }

        public String toString() {
            return "QueueItem [codePage=" + this.codePage + ", eol=" + this.eol + ", queueAttr=" + this.queueAttr + ", queueMgrName=" + this.queueMgrName + ", queueName=" + this.queueName + "]";
        }
    }

    public static enum SourceDispositionType {
        LEAVE(Elements.UI_PREFS_V2_SOURCE_DISPOSITION_LEAVE, ItemSpecification.SourceDisposition.LEAVE),
        DELETE(Elements.UI_PREFS_V2_SOURCE_DISPOSITION_DELETE, ItemSpecification.SourceDisposition.DELETE);

        static final String STORE_NAME = "com.ibm.wmqfte.explorer.7041.item.sourceDisposition.type";
        static final SourceDispositionType defaultValue;
        private final String nlsName;
        final ItemSpecification.SourceDisposition agentEnum;

        static {
            defaultValue = LEAVE;
        }

        private SourceDispositionType(String nlsName, ItemSpecification.SourceDisposition agentEnum) {
            this.nlsName = nlsName;
            this.agentEnum = agentEnum;
        }

        public String getName() {
            return this.nlsName;
        }

        public int getPosition() {
            return this.ordinal();
        }

        public ItemSpecification.SourceDisposition getAgentEnum() {
            return this.agentEnum;
        }

        public static String[] getAllNames() {
            ArrayList<String> names = new ArrayList<String>();
            SourceDispositionType[] sourceDispositionTypeArray = SourceDispositionType.values();
            int n = sourceDispositionTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                SourceDispositionType e = sourceDispositionTypeArray[n2];
                names.add(e.getName());
                ++n2;
            }
            return names.toArray(new String[0]);
        }

        public static SourceDispositionType getInitialName() {
            String value = ps.getString(STORE_NAME);
            if (value != null) {
                SourceDispositionType[] sourceDispositionTypeArray = SourceDispositionType.values();
                int n = sourceDispositionTypeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    SourceDispositionType e = sourceDispositionTypeArray[n2];
                    if (value.equals(e.getName())) {
                        return e;
                    }
                    ++n2;
                }
            }
            return defaultValue;
        }

        public static int getInitialNameByPosition() {
            return SourceDispositionType.getInitialName().getPosition();
        }

        public static int getDefaultPosition() {
            return defaultValue.getPosition();
        }

        public static String getDefaultName() {
            return defaultValue.getName();
        }

        public static SourceDispositionType getByPositon(int position) {
            return position >= 0 && position < SourceDispositionType.values().length ? SourceDispositionType.values()[position] : SourceDispositionType.getInitialName();
        }

        public static SourceDispositionType getByAgentEnum(ItemSpecification.SourceDisposition agentEnum) {
            SourceDispositionType[] sourceDispositionTypeArray = SourceDispositionType.values();
            int n = sourceDispositionTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                SourceDispositionType tm = sourceDispositionTypeArray[n2];
                if (tm.agentEnum == agentEnum) {
                    return tm;
                }
                ++n2;
            }
            return null;
        }
    }

    public static enum SubDirectoryType {
        EXCLUDED(Elements.UI_PREFS_V2_EXCLUDED),
        INCLUDED(Elements.UI_PREFS_V2_INCLUDED);

        private final String nlsName;

        private SubDirectoryType(String nlsName) {
            this.nlsName = nlsName;
        }

        public String getName() {
            return this.nlsName;
        }

        public int getPosition() {
            return this.ordinal();
        }

        public static String[] getAllNames() {
            ArrayList<String> names = new ArrayList<String>();
            SubDirectoryType[] subDirectoryTypeArray = SubDirectoryType.values();
            int n = subDirectoryTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                SubDirectoryType e = subDirectoryTypeArray[n2];
                names.add(e.getName());
                ++n2;
            }
            return names.toArray(new String[0]);
        }
    }

    public static enum TransferModeType {
        BINARY(Elements.UI_PREFS_V2_TRANSFER_MODE_BINARY, ItemSpecification.TransferMode.BINARY),
        TEXT(Elements.UI_PREFS_V2_TRANSFER_MODE_TEXT, ItemSpecification.TransferMode.TEXT);

        static final String STORE_NAME = "com.ibm.wmqfte.explorer.7041.item.transferMode.type";
        static final TransferModeType defaultValue;
        private final String nlsName;
        final ItemSpecification.TransferMode agentEnum;

        static {
            defaultValue = BINARY;
        }

        private TransferModeType(String nlsName, ItemSpecification.TransferMode agentEnum) {
            this.nlsName = nlsName;
            this.agentEnum = agentEnum;
        }

        public String getName() {
            return this.nlsName;
        }

        public int getPosition() {
            return this.ordinal();
        }

        public ItemSpecification.TransferMode getAgentEnum() {
            return this.agentEnum;
        }

        public static TransferModeType getByAgentEnum(ItemSpecification.TransferMode agentEnum) {
            TransferModeType[] transferModeTypeArray = TransferModeType.values();
            int n = transferModeTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                TransferModeType tm = transferModeTypeArray[n2];
                if (tm.agentEnum == agentEnum) {
                    return tm;
                }
                ++n2;
            }
            return null;
        }

        public static String[] getAllNames() {
            ArrayList<String> names = new ArrayList<String>();
            TransferModeType[] transferModeTypeArray = TransferModeType.values();
            int n = transferModeTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                TransferModeType e = transferModeTypeArray[n2];
                names.add(e.getName());
                ++n2;
            }
            return names.toArray(new String[0]);
        }

        public static TransferModeType getInitialName() {
            String value = ps.getString(STORE_NAME);
            if (value != null) {
                TransferModeType[] transferModeTypeArray = TransferModeType.values();
                int n = transferModeTypeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TransferModeType e = transferModeTypeArray[n2];
                    if (value.equals(e.getName())) {
                        return e;
                    }
                    ++n2;
                }
            }
            return defaultValue;
        }

        public static int getInitialNameByPosition() {
            return TransferModeType.getInitialName().getPosition();
        }

        public static int getDefaultPosition() {
            return defaultValue.getPosition();
        }

        public static String getDefaultName() {
            return defaultValue.getName();
        }

        public static TransferModeType getByPositon(int position) {
            return position >= 0 && position < TransferModeType.values().length ? TransferModeType.values()[position] : TransferModeType.getInitialName();
        }
    }
}

