/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wmqfte.explorer.utils.v2;

import com.ibm.wmqfte.api.AbstractCommand;
import com.ibm.wmqfte.explorer.Elements;
import com.ibm.wmqfte.explorer.ExplorerPlugin;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.w3c.dom.Document;

public class Tools {
    public static final int INDENT = 16;

    public static GridData labelGridData(Composite parent, String[] labels) {
        int colWidth = 0;
        GC gc = new GC((Drawable)parent);
        String[] stringArray = labels;
        int n = labels.length;
        int n2 = 0;
        while (n2 < n) {
            String label = stringArray[n2];
            colWidth = Math.max(gc.stringExtent((String)label).x, colWidth);
            ++n2;
        }
        GridData labelGrid = new GridData(0x1000008, 0x1000000, false, false);
        labelGrid.widthHint = colWidth;
        return labelGrid;
    }

    public static GridData fixedWidthGridData(int width) {
        GridData comboGrid = new GridData(4, 1, false, false);
        comboGrid.widthHint = width;
        return comboGrid;
    }

    public static GridLayout noMarginGridLayout(int numColumns) {
        GridLayout gl = new GridLayout(numColumns, false);
        gl.marginLeft = 0;
        gl.marginRight = 0;
        gl.marginTop = 0;
        gl.marginBottom = 0;
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        return gl;
    }

    public static GridData comboGridData(int width, int useColumns) {
        GridData comboGrid = new GridData(4, 0x1000000, true, false, useColumns, 1);
        comboGrid.widthHint = width;
        return comboGrid;
    }

    public static void addSpacer(Composite parent, int numColumns) {
        Label label = new Label(parent, 0);
        label.setLayoutData((Object)new GridData(1, 1, false, false, numColumns, 1));
    }

    public static void internalError(Throwable ex, String nlsMessage, Object ... data) {
        String message = MessageFormat.format(nlsMessage, data);
        Status report = ex == null ? new Status(4, "com.ibm.wmqfte.explorer", message) : new Status(4, "com.ibm.wmqfte.explorer", message, ex);
        ExplorerPlugin.getDefault().getLog().log((IStatus)report);
    }

    public static void internalError(String nlsMessage, Object ... data) {
        Tools.internalError(null, nlsMessage, data);
    }

    public static int getWidth(Composite parent, String label) {
        return new GC((Drawable)parent).stringExtent((String)label).x;
    }

    public static int getWidth(Composite parent, String[] labels) {
        GC gc = new GC((Drawable)parent);
        int max = 0;
        String[] stringArray = labels;
        int n = labels.length;
        int n2 = 0;
        while (n2 < n) {
            String label = stringArray[n2];
            max = Math.max(gc.stringExtent((String)label).x, max);
            ++n2;
        }
        return max;
    }

    public static String getHostName() {
        return AbstractCommand.getHostName();
    }

    public static String[] generateNames(String textFileNamesParm) {
        ArrayList<String> names = new ArrayList<String>();
        String textFileNames = textFileNamesParm.trim();
        if (textFileNames.startsWith("\"")) {
            if (textFileNames.endsWith("\"")) {
                String[] nameSplit;
                textFileNames = textFileNames.substring(1, textFileNames.length() - 1);
                String[] stringArray = nameSplit = textFileNames.split("\",\"");
                int n = nameSplit.length;
                int n2 = 0;
                while (n2 < n) {
                    String name = stringArray[n2];
                    names.add(name);
                    ++n2;
                }
            }
        } else {
            names.add(textFileNames);
        }
        return names.size() == 0 ? null : names.toArray(new String[0]);
    }

    public static String fileBrowser(Composite parent, File hintFile, int style) {
        String[] names;
        FileDialog fd = new FileDialog(parent.getShell(), style);
        fd.setFileName(hintFile.getPath());
        String selectedFile = fd.open();
        if ((style & 2) != 0 && (names = fd.getFileNames()).length > 1) {
            File parentDir = new File(selectedFile).getParentFile();
            StringBuffer sb = new StringBuffer("\"");
            String sep = "";
            String[] stringArray = fd.getFileNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                sb.append(sep);
                sep = "\",\"";
                sb.append(new File(parentDir, name).getPath());
                ++n2;
            }
            sb.append("\"");
            selectedFile = sb.toString();
        }
        return selectedFile;
    }

    public static String directoryBrowser(Composite parent, File hintFile, int style) {
        DirectoryDialog dd = new DirectoryDialog(parent.getShell(), style);
        String selectedFile = dd.open();
        return selectedFile;
    }

    public static boolean isEmpty(Control control) {
        String value = null;
        if (control != null) {
            if (control instanceof Combo) {
                value = ((Combo)control).getText();
            }
            if (control instanceof Text) {
                value = ((Text)control).getText();
            }
        }
        return value == null || value.trim().length() == 0;
    }

    public static String beautifyXML(String origXML) {
        String retStr = origXML;
        try {
            DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = db.parse(new ByteArrayInputStream(origXML.getBytes("UTF-8")));
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "no");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", "2");
            StreamResult result = new StreamResult(new StringWriter());
            DOMSource source = new DOMSource(doc);
            transformer.transform(source, result);
            retStr = result.getWriter().toString();
        }
        catch (Exception ex) {
            Tools.internalError(ex, Elements.UI_WIZARD_V2_INTERR_XML_PARSE, ex.getLocalizedMessage());
        }
        return retStr;
    }

    public static GridLayout indentedGridLayout(int numColumns) {
        GridLayout gl = new GridLayout(numColumns, false);
        gl.marginLeft = 16;
        return gl;
    }

    public static Text accessibleLabel(Composite parent, String textValue) {
        Text text = new Text(parent, 8);
        text.setBackground(parent.getDisplay().getSystemColor(22));
        text.setText(textValue);
        return text;
    }

    public static void accessibleTextOverride(Control control, final String text) {
        control.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                super.getName(e);
                e.result = text;
            }
        });
    }

    public static boolean hasContents(String value) {
        return value != null && value.trim().length() > 0;
    }

    public static String getComboText(Combo combo) {
        String retStr = null;
        if (combo != null && (retStr = combo.getText()) != null && retStr.trim().length() == 0) {
            retStr = null;
        }
        return retStr;
    }
}

