/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wmqfte.explorer.utils.v2;

import com.ibm.wmqfte.explorer.Elements;
import com.ibm.wmqfte.explorer.ExplorerPlugin;
import com.ibm.wmqfte.explorer.utils.v2.Tools;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.widgets.Combo;

public class SectionHistory {
    private static SectionHistory inst;
    private IDialogSettings section;
    private Integer maxEntries;

    public static void initialiseHistory(String sectionName, Integer maxEntries) {
        inst = new SectionHistory(sectionName, maxEntries);
    }

    private static SectionHistory getInstance() {
        if (inst == null) {
            Tools.internalError(new Exception(), Elements.UI_WIZARD_V2_INTERR_HISTORY_INIT, new Object[0]);
        }
        return inst;
    }

    public SectionHistory(String sectionName, Integer maxEntries) {
        if (ExplorerPlugin.getDefault() != null) {
            IDialogSettings dialogSettings = ExplorerPlugin.getDefault().getDialogSettings();
            this.section = dialogSettings.getSection(sectionName);
            if (this.section == null) {
                this.section = dialogSettings.addNewSection(sectionName);
            }
            this.maxEntries = maxEntries;
        }
    }

    public String[] get(HistoryReference reference) {
        return this.section == null ? new String[]{} : this.section.getArray(reference.getSectionName());
    }

    public List<String> getAsList(HistoryReference reference) {
        String[] names = this.get(reference);
        return names == null ? null : new ArrayList<String>(Arrays.asList(names));
    }

    public void put(HistoryReference reference, String value) {
        List<String> values = this.getAsList(reference);
        if (values == null) {
            if (this.section != null) {
                this.section.put(reference.getSectionName(), new String[]{value});
            }
        } else if (!values.contains(value)) {
            values.add(0, value);
            if (this.maxEntries != null && values.size() > this.maxEntries) {
                values.remove(values.size() - 1);
            }
            if (this.section != null) {
                this.section.put(reference.getSectionName(), values.toArray(new String[0]));
            }
        }
    }

    public void clear(HistoryReference reference) {
        this.section.put(reference.getSectionName(), new String[0]);
    }

    public static enum HistoryReference {
        JOBNAME_HISTORY("JOBNAME_HISTORY"),
        SOURCE_CD_NODE_HISTORY("SOURCE_CD_NODE_HISTORY"),
        DEST_CD_NODE_HISTORY("DEST_CD_NODE_HISTORY"),
        SOURCE_PROTOCOL_BRIDGE_HISTORY("SOURCE_PROTOCOL_BRIDGE_HISTORY"),
        DEST_PROTOCOL_BRIDGE_HISTORY("DEST_PROTOCOL_BRIDGE_HISTORY"),
        SOURCE_FILE_HISTORY("SOURCE_FILENAME_HISTORY"),
        SOURCE_DIRECTORY_HISTORY("SOURCE_DIRECTORY_HISTORY"),
        SOURCE_QUEUE_HISTORY("SOURCE_QUEUE_HISTORY"),
        SOURCE_DATASET_HISTORY("SOURCE_DATASET_HISTORY"),
        DEST_FILE_HISTORY("DESTINATION_FILENAME_HISTORY"),
        DEST_DIRECTORY_HISTORY("DESTINATION_DIRECTORY_HISTORY"),
        DEST_QUEUE_HISTORY("DESTINATION_QUEUE_HISTORY"),
        DEST_FILESPACE_HISTORY("DESTINATION_FILESPACE_HISTORY"),
        DEST_DATASET_HISTORY("DESTINATION_DATASET_HISTORY"),
        DIRECTORY_HISTORY("MONITOR_DIRECTORY_HISTORY"),
        QUEUE_HISTORY("MONITOR_QUEUE_HISTORY"),
        RESMON_FILE_PATTERN_HISTORY("TRIGGER_FILE_PATTERN_HISTORY"),
        RESMON_EXCLUDE_PATTERN_HISTORY("TRIGGER_EXCLUDE_PATTERN_HISTORY"),
        RESMON_CONTENT_REGEX_HISTORY("TRIGER_CONTENT_CUSTOM_HISTORY"),
        CALL_OUT_COMMAND_EXEC("CALL_OUT_COMMAND_EXEC"),
        CALL_OUT_COMMAND_OS4690BACKGROUND("CALL_OUT_COMMAND_OS4690BACKGROUND"),
        CALL_OUT_COMMAND_ANT("CALL_OUT_COMMAND_ANT"),
        CALL_OUT_COMMAND_JCL("CALL_OUT_COMMAND_JCL"),
        CALL_OUT_ARGUMENTS_EXEC("CALL_OUT_ARGUMENT_EXEC"),
        CALL_OUT_ARGUMENTS_OS4690BACKGROUND("CALL_OUT_ARGUMENTS_OS4690BACKGROUND"),
        CALL_OUT_MESSAGE_OS4690BACKGROUND("CALL_OUT_MESSAGE_OS4690BACKGROUND"),
        CALL_OUT_ARGUMENTS_ANT("CALL_OUT_ARGUMENT_ANT"),
        CALL_OUT_SUCCESS_EXEC("CALL_OUT_SUCCESS_EXEC"),
        CALL_OUT_SUCCESS_ANT("CALL_OUT_SUCCESS_ANT"),
        CALL_OUT_SUCCESS_JCL("CALL_OUT_SUCCESS_JCL"),
        QUEUE_DELIMITER_TEXT("QUEUE_DELIMITER_TEXT"),
        QUEUE_DELIMITER_BYTE("QUEUE_DELIMITER_BYTE"),
        TEXT_ENCODING("TEXT_ENCODING"),
        MONITOR_NAME("MONITOR_NAME"),
        METADATA_NAME("METADATA_NAME"),
        METADATA_VALUE("METADATA_VALUE"),
        DATASET_DELIMITER_BYTE("DATASET_DELIMITER_BYTE"),
        RECOVERYTIMEOUT_VALUE("TRANSFER_RECOVERY_TIMEOUT");

        private final String sectionName;

        private HistoryReference(String sectionName) {
            this.sectionName = sectionName;
        }

        public String[] get() {
            SectionHistory inst = SectionHistory.getInstance();
            return inst == null ? new String[]{} : inst.get(this);
        }

        public boolean isEmpty() {
            boolean empty = true;
            SectionHistory inst = SectionHistory.getInstance();
            if (inst != null) {
                String[] names = inst.get(this);
                empty = names == null ? false : names.length == 0;
            }
            return empty;
        }

        public void put(String value) {
            SectionHistory inst = SectionHistory.getInstance();
            if (value != null & value.trim().length() > 0 && inst != null) {
                inst.put(this, value);
            }
        }

        public void put(Combo combo) {
            String value;
            String string = value = combo == null ? null : combo.getText();
            if (value != null && value.length() > 0) {
                this.put(value);
            }
        }

        public void clear() {
            SectionHistory inst = SectionHistory.getInstance();
            if (inst != null) {
                inst.clear(this);
            }
        }

        public void loadHistory(Combo combo) {
            SectionHistory inst = SectionHistory.getInstance();
            if (inst != null) {
                String[] values = inst.get(this);
                String before = combo.getText();
                if (values == null) {
                    combo.removeAll();
                } else {
                    combo.setItems(values);
                }
                if (before != null && before.length() > 0) {
                    combo.setText(before);
                }
            }
        }

        protected String getSectionName() {
            return this.sectionName;
        }
    }
}

