/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wmqfte.explorer.utils.v2;

import com.ibm.wmqfte.explorer.Elements;
import com.ibm.wmqfte.explorer.dialogs.ResMonVarStDialog;
import com.ibm.wmqfte.explorer.utils.v2.ControlGroup;
import com.ibm.wmqfte.explorer.utils.v2.Tools;
import com.ibm.wmqfte.explorer.wizards.pages.v2.ResourceMonitorPage;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class ResMonAssist {
    private List<ButtonControl> buttonList = new ArrayList<ButtonControl>();
    private boolean assistVisible;
    private ResourceMonitorPage.ResourceType resourceType = null;
    private static final ResMonAssist inst = new ResMonAssist();

    private ResMonAssist() {
    }

    public static ResMonAssist getInst() {
        return inst;
    }

    public void addButtonControl(ButtonControl buttonControl) {
        this.buttonList.add(buttonControl);
    }

    public void visible(boolean assistVisible, ResourceMonitorPage.ResourceType resourceType) {
        this.assistVisible = assistVisible;
        this.resourceType = resourceType;
        for (ButtonControl bc : this.buttonList) {
            if (bc.getButton().isDisposed()) continue;
            boolean visible = bc.getControlGroup().getVisible() && assistVisible;
            Button b = bc.getButton();
            b.setVisible(visible);
            ((GridData)b.getLayoutData()).exclude = !visible;
            b.getParent().layout(true);
        }
    }

    public boolean isAssistVisible() {
        return this.assistVisible;
    }

    private static void openAssistDialog(Combo toAssist, AssistItemType assistItemType) {
        new ResMonVarStDialog(toAssist.getShell(), toAssist, assistItemType, ResMonAssist.getInst().resourceType).open();
    }

    public static enum AssistItemType {
        FILE(Elements.UI_WIZARD_V2_RESMON_ASSIST_ITEM_FILE_TITLE),
        DIRECTORY(Elements.UI_WIZARD_V2_RESMON_ASSIST_ITEM_DIRECTORY_TITLE),
        FILESPACE(Elements.UI_WIZARD_V2_RESMON_ASSIST_ITEM_FILESPACE_TITLE),
        QUEUE(Elements.UI_WIZARD_V2_RESMON_ASSIST_ITEM_QUEUE_TITLE),
        QUEUEMGR(Elements.UI_WIZARD_V2_RESMON_ASSIST_ITEM_QUEUE_MGR_TITLE),
        DATASET(Elements.UI_WIZARD_V2_RESMON_ASSIST_ITEM_DATA_SET_TITLE);

        final String dialogTitle;

        private AssistItemType(String dialogTitle) {
            this.dialogTitle = dialogTitle;
        }

        public String getDialogTitle() {
            return this.dialogTitle;
        }
    }

    private static class ButtonControl {
        private Button button;
        private ControlGroup controlGroup;

        public ButtonControl(Button button, ControlGroup controlGroup) {
            this.button = button;
            this.controlGroup = controlGroup;
        }

        public Button getButton() {
            return this.button;
        }

        public ControlGroup getControlGroup() {
            return this.controlGroup;
        }
    }

    public static class ComboAssist
    extends Composite {
        private final ControlGroup controlGroup;
        private final int style;
        private final AssistItemType assistItemType;
        private Combo combo;

        public ComboAssist(Composite parent, int style, ControlGroup controlGroup, AssistItemType assistItemType) {
            super(parent, 0);
            this.controlGroup = controlGroup;
            this.style = style;
            this.assistItemType = assistItemType;
            GridLayout gd = new GridLayout(2, false);
            gd.marginWidth = 0;
            gd.marginHeight = 0;
            this.setLayout((Layout)gd);
            this.createContents();
            controlGroup.add((Control)this);
        }

        private void createContents() {
            this.combo = new Combo((Composite)this, this.style);
            this.controlGroup.add((Control)this.combo);
            this.combo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            Button b = new Button((Composite)this, 8);
            ResMonAssist.getInst().addButtonControl(new ButtonControl(b, this.controlGroup));
            this.controlGroup.add((Control)b);
            GridData gd = new GridData();
            gd.widthHint = Tools.getWidth((Composite)this, Elements.UI_WIZARD_V2_RESMON_ASSIST_BUTTON) + 20;
            b.setLayoutData((Object)gd);
            b.setVisible(true);
            b.setText(Elements.UI_WIZARD_V2_RESMON_ASSIST_BUTTON);
            b.setData((Object)ResMonAssist.getInst());
            b.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    ResMonAssist.openAssistDialog(combo, assistItemType);
                }
            });
        }

        public void setText(String text) {
            this.combo.setText(text);
        }

        public String getText() {
            return this.combo.getText();
        }

        public Combo getCombo() {
            return this.combo;
        }

        public void setToolTipText(String text) {
            this.combo.setToolTipText(text);
        }
    }
}

