/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wmqfte.explorer.utils.v2;

import com.ibm.wmqfte.explorer.Elements;
import com.ibm.wmqfte.explorer.utils.v2.Tools;
import com.ibm.wmqfte.explorer.utils.v2.TransferItem;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class QueueProperties {
    public static final String DEFAULT_SCHEMA = "[Default]";
    private static final String GROUP = "GRP:((?:TRUE)|(?:FALSE))";
    private static final String WAITTIME = "WT:(?:(\\d+)|NONE)";
    private static final String GROUP_SIZE_DEL = "(?:DT:SIZE,(\\d+),([B|K|M|G]))";
    private static final String POSITION = "((?:PREFIX)|(?:POSTFIX))";
    private static final String INCLUDE_DEL = "((?:TRUE)|(?:FALSE))?";
    private static final String GROUP_TEXT_DEL = "(?:DT:TEXT,((?:PREFIX)|(?:POSTFIX)),((?:TRUE)|(?:FALSE))?,(.*))";
    private static final String GROUP_BIN_DEL = "(?:DT:BINARY,((?:PREFIX)|(?:POSTFIX)),((?:TRUE)|(?:FALSE))?,(.*))";
    private static final String GROUP_DEL_NONE = "DT:NONE";
    private static final Pattern SOURCE_PATTERN = Pattern.compile("GRP:((?:TRUE)|(?:FALSE)),WT:(?:(\\d+)|NONE),(?:(?:DT:SIZE,(\\d+),([B|K|M|G]))|(?:DT:TEXT,((?:PREFIX)|(?:POSTFIX)),((?:TRUE)|(?:FALSE))?,(.*))|(?:DT:BINARY,((?:PREFIX)|(?:POSTFIX)),((?:TRUE)|(?:FALSE))?,(.*))|DT:NONE)");
    private static final int GS_GROUP_IDX = 1;
    private static final int GS_WAIT_TIME_IDX = 2;
    private static final int GS_DEL_SIZE_IDX = 3;
    private static final int GS_DEL_UNIT_IDX = 4;
    private static final int GS_DEL_TEXT_POS_IDX = 5;
    private static final int GS_DEL_TEXT_INC_DEL_IDX = 6;
    private static final int GS_DEL_TEXT_FIELD_IDX = 7;
    private static final int GS_DEL_BIN_POS_IDX = 8;
    private static final int GS_DEL_BIN_INC_DEL_IDX = 9;
    private static final int GS_DEL_BIN_FIELD_IDX = 10;
    private static final String PERSISTANCE = "PT:((?:TRUE)|(?:FALSE))";
    private static final String PROPERTIES = "PP:((?:TRUE)|(?:FALSE))";
    private static final Pattern DESTINATION_PATTERN = Pattern.compile("PT:((?:TRUE)|(?:FALSE)),PP:((?:TRUE)|(?:FALSE)),(?:(?:DT:SIZE,(\\d+),([B|K|M|G]))|(?:DT:TEXT,((?:PREFIX)|(?:POSTFIX)),((?:TRUE)|(?:FALSE))?,(.*))|(?:DT:BINARY,((?:PREFIX)|(?:POSTFIX)),((?:TRUE)|(?:FALSE))?,(.*))|DT:NONE)");
    private static final int GD_PERSISTANCE_IDX = 1;
    private static final int GD_PROPERTIES_IDX = 2;
    private static final int GD_DEL_SIZE_IDX = 3;
    private static final int GD_DEL_UNIT_IDX = 4;
    private static final int GD_DEL_TEXT_POS_IDX = 5;
    private static final int GD_DEL_TEXT_INC_DEL_IDX = 6;
    private static final int GD_DEL_TEXT_FIELD_IDX = 7;
    private static final int GD_DEL_BIN_POS_IDX = 8;
    private static final int GD_DEL_BIN_INC_DEL_IDX = 9;
    private static final int GD_DEL_BIN_FIELD_IDX = 10;
    private static final Pattern SIZE_DEL = Pattern.compile("(\\d+)([B|K|M|G])");

    public static enum DelimiterPosition {
        PREFIX(Elements.UI_WIZARD_V2_ITEM_DIALOG_SOURCE_QUEUE_DELIMITER_POSITION_PREFIX, "prefix"),
        POSTFIX(Elements.UI_WIZARD_V2_ITEM_DIALOG_SOURCE_QUEUE_DELIMITER_POSITION_POSTFIX, "postfix");

        private final String nlsMessage;
        private final String fteQueueDelimiter;

        private DelimiterPosition(String nlsMessage, String fteQueueDelimiter) {
            this.nlsMessage = nlsMessage;
            this.fteQueueDelimiter = fteQueueDelimiter;
        }

        public static String[] getAllNames() {
            ArrayList<String> names = new ArrayList<String>();
            DelimiterPosition[] delimiterPositionArray = DelimiterPosition.values();
            int n = delimiterPositionArray.length;
            int n2 = 0;
            while (n2 < n) {
                DelimiterPosition dp = delimiterPositionArray[n2];
                names.add(dp.nlsMessage);
                ++n2;
            }
            return names.toArray(new String[0]);
        }

        public static DelimiterPosition getByPosition(int position) {
            return position >= 0 && position < DelimiterPosition.values().length ? DelimiterPosition.values()[position] : null;
        }

        public static DelimiterPosition getByFTEQueueDelimiter(String fteQueueDelimiter) {
            DelimiterPosition[] delimiterPositionArray = DelimiterPosition.values();
            int n = delimiterPositionArray.length;
            int n2 = 0;
            while (n2 < n) {
                DelimiterPosition dp = delimiterPositionArray[n2];
                if (dp.fteQueueDelimiter.equalsIgnoreCase(fteQueueDelimiter)) {
                    return dp;
                }
                ++n2;
            }
            return null;
        }

        public String getNLSMessage() {
            return this.nlsMessage;
        }

        public String getFTEQueueDelimiter() {
            return this.fteQueueDelimiter;
        }

        public int getPosition() {
            return this.ordinal();
        }
    }

    public static enum DelimiterType {
        BINARY(true, "binary", Elements.UI_PREFS_V2_WIZARD_QUEUE_DEL_BINARY),
        TEXT(true, "text", Elements.UI_PREFS_V2_WIZARD_QUEUE_DEL_TEXT),
        SIZE(false, "size", Elements.UI_PREFS_V2_WIZARD_QUEUE_DEL_SIZE);

        private final boolean sourceSupported;
        private final String agentReference;
        private final String nlsMessage;

        private DelimiterType(boolean sourceSupported, String agentReference, String nlsMessage) {
            this.sourceSupported = sourceSupported;
            this.agentReference = agentReference;
            this.nlsMessage = nlsMessage;
        }

        public boolean isSupportedForSource() {
            return this.sourceSupported;
        }

        public int getPosition() {
            return this.ordinal();
        }

        public String getAgentReference() {
            return this.agentReference;
        }

        public static String[] getDestinationTypesAsStrings() {
            return new String[]{DelimiterType.BINARY.nlsMessage, DelimiterType.TEXT.nlsMessage, DelimiterType.SIZE.nlsMessage};
        }

        public static String[] getSourceTypesAsStrings() {
            return new String[]{DelimiterType.BINARY.nlsMessage, DelimiterType.TEXT.nlsMessage};
        }

        public static DelimiterType getByPosition(int position) {
            return position >= 0 && position < DelimiterType.values().length ? DelimiterType.values()[position] : null;
        }

        public static enum PersistenceType {
            PERSISTENCE("true", Elements.UI_WIZARD_V2_ITEM_DIALOG_DESTINATION_QUEUE_PERSISTENCE),
            NON_PERSISTENCE("false", Elements.UI_WIZARD_V2_ITEM_DIALOG_DESTINATION_QUEUE_NON_PERSISTENCE),
            QDEF_PERSISTENCE("qdef", Elements.UI_WIZARD_V2_ITEM_DIALOG_DESTINATION_QUEUE_DEFINE_PERSISTENCE);

            private String value;
            private String nlsMessage;

            private PersistenceType(String value, String nlsMessage) {
                this.value = value;
                this.nlsMessage = nlsMessage;
            }

            public String getValue() {
                return this.value;
            }

            public String getNLSMessage() {
                return this.nlsMessage;
            }

            public int getPosition() {
                return this.ordinal();
            }

            public static String[] getAllNLSMessages() {
                ArrayList<String> names = new ArrayList<String>();
                PersistenceType[] persistenceTypeArray = PersistenceType.values();
                int n = persistenceTypeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    PersistenceType option = persistenceTypeArray[n2];
                    names.add(option.nlsMessage);
                    ++n2;
                }
                return names.toArray(new String[0]);
            }

            public static PersistenceType getByPosition(int index) {
                return PersistenceType.values()[index];
            }

            public static PersistenceType getByValue(String parm) {
                PersistenceType[] persistenceTypeArray = PersistenceType.values();
                int n = persistenceTypeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    PersistenceType option = persistenceTypeArray[n2];
                    if (option.value.equalsIgnoreCase(parm)) {
                        return option;
                    }
                    ++n2;
                }
                return null;
            }
        }
    }

    public static abstract class MessageDelimiter {
        protected DelimiterType type;
        protected DelimiterPosition position;
        protected Boolean includeDelimiterWithMessage;

        public static MessageDelimiter clone(MessageDelimiter orig) {
            MessageDelimiter md = null;
            if (orig instanceof MessageDelimiterBinary) {
                MessageDelimiterBinary mdb = (MessageDelimiterBinary)orig;
                md = new MessageDelimiterBinary(mdb.getPostion(), mdb.getField(), mdb.includeDelimiter());
            } else if (orig instanceof MessageDelimiterText) {
                MessageDelimiterText mdt = (MessageDelimiterText)orig;
                md = new MessageDelimiterText(mdt.getPostion(), mdt.getField(), mdt.includeDelimiter());
            } else if (orig instanceof MessageDelimiterSize) {
                MessageDelimiterSize mds = (MessageDelimiterSize)orig;
                md = new MessageDelimiterSize(mds.getSize(), mds.getUnit());
            } else if (orig != null) {
                Tools.internalError(new Exception(), Elements.UI_WIZARD_V2_INTERR_BAD_DELIMITER, orig.getClass().getName());
            }
            return md;
        }

        public MessageDelimiter(DelimiterType type, DelimiterPosition position, Boolean includeDelimiterWithMessage) {
            this.type = type;
            this.position = position;
            this.includeDelimiterWithMessage = includeDelimiterWithMessage;
        }

        public MessageDelimiter(DelimiterType type, DelimiterPosition position) {
            this.type = type;
            this.position = position;
            this.includeDelimiterWithMessage = null;
        }

        public DelimiterType getType() {
            return this.type;
        }

        public DelimiterPosition getPostion() {
            return this.position;
        }

        public Boolean includeDelimiter() {
            return this.includeDelimiterWithMessage;
        }

        protected String export() {
            StringBuffer sb = new StringBuffer();
            sb.append("DT:");
            sb.append(this.type.toString());
            sb.append(",");
            sb.append(this.position.toString());
            if (this.includeDelimiterWithMessage != null) {
                sb.append(",");
                sb.append(this.includeDelimiterWithMessage != false ? "TRUE" : "FALSE");
            }
            sb.append(",");
            return sb.toString();
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("Type:" + (this.type == null ? "null" : this.type.toString()));
            sb.append(",Position:" + (this.position == null ? "null" : this.position.toString()));
            if (this.includeDelimiterWithMessage != null) {
                sb.append(",Include:" + (this.includeDelimiterWithMessage != false ? "TRUE" : "FALSE"));
            }
            return sb.toString();
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.includeDelimiterWithMessage == null ? 0 : this.includeDelimiterWithMessage.hashCode());
            result = 31 * result + (this.position == null ? 0 : this.position.hashCode());
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MessageDelimiter other = (MessageDelimiter)obj;
            if (this.includeDelimiterWithMessage == null ? other.includeDelimiterWithMessage != null : !this.includeDelimiterWithMessage.equals(other.includeDelimiterWithMessage)) {
                return false;
            }
            if (this.position == null ? other.position != null : !this.position.equals((Object)other.position)) {
                return false;
            }
            return !(this.type == null ? other.type != null : !this.type.equals((Object)other.type));
        }

        public abstract Map<String, String> getAttributes();
    }

    public static class MessageDelimiterBinary
    extends MessageDelimiter {
        private String field;

        public MessageDelimiterBinary(DelimiterPosition position, String field) {
            super(DelimiterType.BINARY, position, null);
            this.field = field;
        }

        public MessageDelimiterBinary(DelimiterPosition position, String field, Boolean includeDelimiterWithMessage) {
            super(DelimiterType.BINARY, position, includeDelimiterWithMessage);
            this.field = field;
        }

        public String getField() {
            return this.field;
        }

        @Override
        public String export() {
            return String.valueOf(super.export()) + this.field;
        }

        @Override
        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(super.toString());
            sb.append(",field:" + this.field);
            return sb.toString();
        }

        @Override
        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.field == null ? 0 : this.field.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MessageDelimiterBinary other = (MessageDelimiterBinary)obj;
            return !(this.field == null ? other.field != null : !this.field.equals(other.field));
        }

        @Override
        public Map<String, String> getAttributes() {
            HashMap<String, String> attr = new HashMap<String, String>();
            attr.put("delimiterType", this.type.getAgentReference());
            attr.put("delimiter", this.field);
            attr.put("delimiterPosition", this.position.getFTEQueueDelimiter());
            attr.put("includeDelimiterInMessage", Boolean.toString(this.includeDelimiterWithMessage));
            return attr;
        }
    }

    public static class MessageDelimiterSize
    extends MessageDelimiter {
        private int size;
        private Unit unit;

        public MessageDelimiterSize(int size, Unit unit) {
            super(DelimiterType.SIZE, null, false);
            this.size = size;
            this.unit = unit;
        }

        public int getSize() {
            return this.size;
        }

        public Unit getUnit() {
            return this.unit;
        }

        public long getSizeAsBytes() {
            return (long)this.size * this.unit.getMultiplier();
        }

        @Override
        public String export() {
            StringBuffer sb = new StringBuffer();
            sb.append("DT:");
            sb.append(DelimiterType.SIZE.toString());
            sb.append(",");
            sb.append("" + this.size);
            sb.append(",");
            sb.append(this.unit.toString());
            return sb.toString();
        }

        @Override
        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(super.toString());
            sb.append(",Size:" + this.size);
            sb.append(",Unit:" + this.unit.toString());
            return sb.toString();
        }

        @Override
        public int hashCode() {
            int result = 1;
            result = 31 * result + this.size;
            result = 31 * result + (this.unit == null ? 0 : this.unit.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MessageDelimiterSize other = (MessageDelimiterSize)obj;
            if (this.size != other.size) {
                return false;
            }
            return !(this.unit == null ? other.unit != null : !this.unit.equals((Object)other.unit));
        }

        @Override
        public Map<String, String> getAttributes() {
            HashMap<String, String> attr = new HashMap<String, String>();
            attr.put("delimiterType", this.type.getAgentReference());
            attr.put("delimiter", String.valueOf(this.size) + this.unit.toString());
            if (this.position != null) {
                attr.put("delimiterPosition", this.position.getFTEQueueDelimiter());
                attr.put("includeDelimiterInMessage", Boolean.toString(this.includeDelimiterWithMessage));
            }
            return attr;
        }
    }

    public static class MessageDelimiterText
    extends MessageDelimiter {
        private String field;

        public MessageDelimiterText(DelimiterPosition position, String field) {
            super(DelimiterType.TEXT, position, null);
            this.field = field;
        }

        public MessageDelimiterText(DelimiterPosition position, String field, Boolean includeDelimiterWithMessage) {
            super(DelimiterType.TEXT, position, includeDelimiterWithMessage);
            this.field = field;
        }

        public String getField() {
            return this.field;
        }

        @Override
        public String export() {
            return String.valueOf(super.export()) + this.field;
        }

        @Override
        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(super.toString());
            sb.append(",field:" + this.field);
            return sb.toString();
        }

        @Override
        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.field == null ? 0 : this.field.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MessageDelimiterText other = (MessageDelimiterText)obj;
            return !(this.field == null ? other.field != null : !this.field.equals(other.field));
        }

        @Override
        public Map<String, String> getAttributes() {
            HashMap<String, String> attr = new HashMap<String, String>();
            attr.put("delimiterType", this.type.getAgentReference());
            attr.put("delimiter", this.field);
            attr.put("delimiterPosition", this.position.getFTEQueueDelimiter());
            attr.put("includeDelimiterInMessage", Boolean.toString(this.includeDelimiterWithMessage));
            return attr;
        }
    }

    public static class MessageDestination {
        private DelimiterType.PersistenceType persistence;
        private boolean includeProperties;
        private MessageDelimiter delimiter;

        public MessageDestination() {
            this(null, false, null);
        }

        public MessageDestination(DelimiterType.PersistenceType persistence, boolean includeProperties, MessageDelimiter delimiter) {
            this.persistence = persistence;
            this.includeProperties = includeProperties;
            this.delimiter = delimiter;
        }

        public MessageDestination(MessageDestination md) {
            this.persistence = md.persistence;
            this.includeProperties = md.includeProperties;
            this.delimiter = MessageDelimiter.clone(md.delimiter);
        }

        public static MessageDestination createDestinationSizeDelimitedMessage(DelimiterType.PersistenceType persistence, boolean includeProperties, int size, Unit unit) {
            return new MessageDestination(persistence, includeProperties, new MessageDelimiterSize(size, unit));
        }

        public static MessageDestination createDestinationBinaryDelimitedMessage(DelimiterType.PersistenceType persistence, boolean includeProperties, DelimiterPosition position, String field, boolean includeDelimiterWithMessage) {
            return new MessageDestination(persistence, includeProperties, new MessageDelimiterBinary(position, field, (Boolean)includeDelimiterWithMessage));
        }

        public static MessageDestination createDestinationTextDelimitedMessage(DelimiterType.PersistenceType persistence, boolean includeProperties, DelimiterPosition position, String field, boolean includeDelimiterWithMessage) {
            return new MessageDestination(persistence, includeProperties, new MessageDelimiterText(position, field, (Boolean)includeDelimiterWithMessage));
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static MessageDestination createMessage(Map<String, String> attr) throws TransferItem.InternalException {
            void var6_11;
            if (attr == null) return new MessageDestination();
            if (attr.isEmpty()) {
                return new MessageDestination();
            }
            String persistenceStr = attr.get("persistent");
            DelimiterType.PersistenceType persistence = DelimiterType.PersistenceType.getByValue(persistenceStr);
            String includePropertiesStr = attr.get("setMqProps");
            boolean includeProperties = includePropertiesStr != null && includePropertiesStr.equalsIgnoreCase("true");
            String field = attr.get("delimiter");
            if (field == null) {
                Object var6_7 = null;
                return new MessageDestination(persistence, includeProperties, (MessageDelimiter)var6_11);
            } else {
                String includeStr = attr.get("includeDelimiterInMessage");
                boolean includeDelimiterWithMessage = includeStr != null && includeStr.equalsIgnoreCase("true");
                String positionType = attr.get("delimiterPosition");
                DelimiterPosition position = DelimiterPosition.getByFTEQueueDelimiter(positionType);
                String delType = attr.get("delimiterType");
                if (delType.equals("binary")) {
                    if (position == null) {
                        throw new TransferItem.InternalException(MessageFormat.format(Elements.UI_WIZARD_V2_INTERR_BAD_FIX_NAME, positionType));
                    }
                    MessageDelimiterBinary messageDelimiterBinary = new MessageDelimiterBinary(position, field, (Boolean)includeDelimiterWithMessage);
                    return new MessageDestination(persistence, includeProperties, (MessageDelimiter)var6_11);
                } else if (delType.equals("text")) {
                    if (position == null) {
                        throw new TransferItem.InternalException(MessageFormat.format(Elements.UI_WIZARD_V2_INTERR_BAD_FIX_NAME, positionType));
                    }
                    MessageDelimiterText messageDelimiterText = new MessageDelimiterText(position, field, (Boolean)includeDelimiterWithMessage);
                    return new MessageDestination(persistence, includeProperties, (MessageDelimiter)var6_11);
                } else {
                    if (!delType.equals("size")) throw new TransferItem.InternalException(MessageFormat.format(Elements.UI_WIZARD_V2_INTERR_BAD_DELIMITER, String.valueOf(delType) + ": " + field));
                    Matcher m = SIZE_DEL.matcher(field);
                    if (!m.matches()) throw new TransferItem.InternalException(MessageFormat.format(Elements.UI_WIZARD_V2_INTERR_BAD_DELIMITER, String.valueOf(delType) + ": " + field));
                    int size = Integer.parseInt(m.group(1));
                    Unit unit = Unit.getByName(m.group(2));
                    MessageDelimiterSize messageDelimiterSize = new MessageDelimiterSize(size, unit);
                }
            }
            return new MessageDestination(persistence, includeProperties, (MessageDelimiter)var6_11);
        }

        public DelimiterType.PersistenceType getPersistence() {
            return this.persistence;
        }

        public boolean includeProperties() {
            return this.includeProperties;
        }

        public MessageDelimiter getDelimiter() {
            return this.delimiter;
        }

        public static MessageDestination importMessage(String importText) throws MessageException {
            Matcher m = DESTINATION_PATTERN.matcher(importText);
            if (m.matches()) {
                DelimiterType.PersistenceType persistence = DelimiterType.PersistenceType.getByValue(m.group(1));
                boolean incProperties = m.group(2).equals("TRUE");
                if (m.group(3) != null) {
                    return new MessageDestination(persistence, incProperties, new MessageDelimiterSize(Integer.parseInt(m.group(3)), Unit.valueOf(m.group(4))));
                }
                if (m.group(5) != null) {
                    String incDel = m.group(6);
                    Boolean incDelBool = null;
                    if (incDel != null) {
                        incDelBool = incDel.equals("TRUE");
                    }
                    return new MessageDestination(persistence, incProperties, new MessageDelimiterText(DelimiterPosition.valueOf(m.group(5)), m.group(7), incDelBool));
                }
                if (m.group(8) != null) {
                    String incDel = m.group(9);
                    Boolean incDelBool = null;
                    if (incDel != null) {
                        incDelBool = incDel.equals("TRUE");
                    }
                    return new MessageDestination(persistence, incProperties, new MessageDelimiterBinary(DelimiterPosition.valueOf(m.group(8)), m.group(10), incDelBool));
                }
                return new MessageDestination(persistence, incProperties, null);
            }
            throw new MessageException("Invalid pattern: " + importText);
        }

        public String export() {
            StringBuffer sb = new StringBuffer();
            sb.append("PT:");
            sb.append(this.persistence.value);
            sb.append(",");
            sb.append("PP:");
            sb.append(this.includeProperties ? "TRUE" : "FALSE");
            sb.append(",");
            sb.append(this.delimiter == null ? QueueProperties.GROUP_DEL_NONE : this.delimiter.export());
            return sb.toString();
        }

        public String toString() {
            return "MessageDestination [delimiter=" + this.delimiter + ", includeProperties=" + this.includeProperties + ", persistence=" + (Object)((Object)this.persistence) + "]";
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.delimiter == null ? 0 : this.delimiter.hashCode());
            result = 31 * result + (this.includeProperties ? 1231 : 1237);
            result = 31 * result + (this.persistence == null ? 0 : this.persistence.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MessageDestination other = (MessageDestination)obj;
            if (this.delimiter == null ? other.delimiter != null : !this.delimiter.equals(other.delimiter)) {
                return false;
            }
            if (this.includeProperties != other.includeProperties) {
                return false;
            }
            return !(this.persistence == null ? other.persistence != null : !this.persistence.equals((Object)other.persistence));
        }

        public Map<String, String> getAttributes() {
            Map<Object, Object> attr;
            Map<Object, Object> map = attr = this.delimiter == null ? new HashMap() : this.delimiter.getAttributes();
            if (this.persistence != null) {
                attr.put("persistent", this.persistence.getValue());
            }
            attr.put("setMqProps", Boolean.toString(this.includeProperties));
            return attr;
        }
    }

    public static class MessageException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public MessageException(String description) {
            super(description);
        }

        public MessageException(String description, Exception cause) {
            super(description, cause);
        }
    }

    public static class MessageSource {
        private boolean grouping;
        private Integer waitTime;
        private MessageDelimiter delimiter;

        public MessageSource() {
            this(false, null, null);
        }

        public MessageSource(boolean grouping, Integer waitTime, MessageDelimiter delimiter) {
            this.grouping = grouping;
            this.waitTime = waitTime;
            this.delimiter = delimiter;
        }

        public MessageSource(MessageSource ms) {
            this.grouping = ms.grouping;
            this.waitTime = ms.waitTime;
            this.delimiter = MessageDelimiter.clone(ms.delimiter);
        }

        public static MessageSource createSourceBinaryDelimitedMessage(boolean grouping, Integer waitTime, DelimiterPosition position, String field, Boolean includeDelimiterWithMessage) {
            return new MessageSource(grouping, waitTime, new MessageDelimiterBinary(position, field, includeDelimiterWithMessage));
        }

        public static MessageSource createSourceTextDelimitedMessage(boolean grouping, Integer waitTime, DelimiterPosition position, String field, Boolean includeDelimiterWithMessage) {
            return new MessageSource(grouping, waitTime, new MessageDelimiterText(position, field, includeDelimiterWithMessage));
        }

        public static MessageSource createMessage(Map<String, String> attr) throws TransferItem.InternalException {
            MessageSource ms = null;
            if (attr == null) {
                ms = new MessageSource();
            } else {
                String useGroupStr = attr.get("useGroups");
                boolean useGroups = useGroupStr != null && useGroupStr.equalsIgnoreCase("true");
                String waitTimeStr = attr.get("waitTime");
                Integer waitTime = waitTimeStr != null ? Integer.valueOf(Integer.parseInt(waitTimeStr)) : null;
                String field = attr.get("delimiter");
                if (field != null) {
                    String includeStr = attr.get("includeDelimiterInMessage");
                    boolean includeDelimiterWithMessage = includeStr != null && includeStr.equalsIgnoreCase("true");
                    String positionType = attr.get("delimiterPosition");
                    DelimiterPosition position = DelimiterPosition.getByFTEQueueDelimiter(positionType);
                    if (position == null) {
                        throw new TransferItem.InternalException(MessageFormat.format(Elements.UI_WIZARD_V2_INTERR_BAD_FIX_NAME, positionType));
                    }
                    String delType = attr.get("delimiterType");
                    ms = delType.equals("binary") ? new MessageSource(useGroups, waitTime, new MessageDelimiterBinary(position, field, (Boolean)includeDelimiterWithMessage)) : (delType.equals("text") ? new MessageSource(useGroups, waitTime, new MessageDelimiterText(position, field, (Boolean)includeDelimiterWithMessage)) : new MessageSource(useGroups, waitTime, null));
                } else {
                    ms = new MessageSource(useGroups, waitTime, null);
                }
            }
            return ms;
        }

        public static MessageSource importMessage(String importText) throws MessageException {
            try {
                Matcher m = SOURCE_PATTERN.matcher(importText);
                if (m.matches()) {
                    Integer waitTime;
                    boolean includeGroup = m.group(1).equals("TRUE");
                    Integer n = waitTime = m.group(2) == null ? null : Integer.valueOf(Integer.parseInt(m.group(2)));
                    if (m.group(3) != null) {
                        return new MessageSource(includeGroup, waitTime, new MessageDelimiterSize(Integer.parseInt(m.group(3)), Unit.valueOf(m.group(4))));
                    }
                    if (m.groupCount() >= 7 && m.group(7) != null) {
                        boolean includeDelimiter = m.group(6).equals("TRUE");
                        return new MessageSource(includeGroup, waitTime, new MessageDelimiterText(DelimiterPosition.valueOf(m.group(5)), m.group(7), (Boolean)includeDelimiter));
                    }
                    if (m.groupCount() >= 10 && m.group(10) != null) {
                        boolean includeDelimiter = m.group(9).equals("TRUE");
                        return new MessageSource(includeGroup, waitTime, new MessageDelimiterBinary(DelimiterPosition.valueOf(m.group(8)), m.group(10), (Boolean)includeDelimiter));
                    }
                    return new MessageSource(includeGroup, waitTime, null);
                }
                throw new MessageException(MessageFormat.format(Elements.UI_WIZARD_V2_INTERR_INVALID_QUEUE_PATTERN, importText));
            }
            catch (IllegalArgumentException ex) {
                throw new MessageException(MessageFormat.format(Elements.UI_WIZARD_V2_INTERR_PARSER_QUEUE, importText, ex));
            }
        }

        public String export() {
            StringBuffer sb = new StringBuffer();
            sb.append("GRP:");
            sb.append(this.grouping ? "TRUE" : "FALSE");
            sb.append(",");
            sb.append("WT:");
            sb.append(this.waitTime == null ? "NONE" : "" + this.waitTime);
            sb.append(",");
            sb.append(this.delimiter == null ? QueueProperties.GROUP_DEL_NONE : this.delimiter.export());
            return sb.toString();
        }

        public boolean areMessageGrouped() {
            return this.grouping;
        }

        public Integer timeout() {
            return this.waitTime;
        }

        public MessageDelimiter getDelimiter() {
            return this.delimiter;
        }

        public String toString() {
            return "MessageSource [delimiter=" + this.delimiter + ", grouping=" + this.grouping + ", waitTime=" + this.waitTime + "]";
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.delimiter == null ? 0 : this.delimiter.hashCode());
            result = 31 * result + (this.grouping ? 1231 : 1237);
            result = 31 * result + (this.waitTime == null ? 0 : this.waitTime.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MessageSource other = (MessageSource)obj;
            if (this.delimiter == null ? other.delimiter != null : !this.delimiter.equals(other.delimiter)) {
                return false;
            }
            if (this.grouping != other.grouping) {
                return false;
            }
            return !(this.waitTime == null ? other.waitTime != null : !this.waitTime.equals(other.waitTime));
        }

        public Map<String, String> getAttributes() {
            Map<Object, Object> attr = this.delimiter == null ? new HashMap() : this.delimiter.getAttributes();
            attr.put("useGroups", Boolean.toString(this.grouping));
            if (this.waitTime != null) {
                attr.put("waitTime", "" + this.waitTime);
            }
            return attr;
        }
    }

    public static class SchemaSet {
        private String name;
        private MessageSource source;
        private MessageDestination destination;

        public SchemaSet() {
            this.name = null;
            this.source = null;
            this.destination = null;
        }

        public SchemaSet(SchemaSet ts) {
            this.name = ts.name;
            this.source = ts.source == null ? null : new MessageSource(ts.source);
            this.destination = ts.destination == null ? null : new MessageDestination(ts.destination);
        }

        public SchemaSet(String name, MessageSource source, MessageDestination destination) {
            this.name = name;
            this.source = source;
            this.destination = destination;
        }

        public void setName(String name) {
            this.name = name;
        }

        public MessageSource getSource() {
            return this.source;
        }

        public MessageDestination getDestination() {
            return this.destination;
        }

        public void set(MessageSource source) {
            this.source = source;
        }

        public void set(MessageDestination destination) {
            this.destination = destination;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return "SchemaSet [destination=" + this.destination + ", name=" + this.name + ", source=" + this.source + "]";
        }
    }

    public static enum Unit {
        B(Elements.UI_WIZARD_V2_ITEM_DIALOG_DESTINATION_QUEUE_SIZE_BYTE, 1L, 104960000),
        K(Elements.UI_WIZARD_V2_ITEM_DIALOG_DESTINATION_QUEUE_SIZE_KBYTE, 1024L, 102500),
        M(Elements.UI_WIZARD_V2_ITEM_DIALOG_DESTINATION_QUEUE_SIZE_MBYTE, 0x100000L, 100);

        private String nlsMessage;
        private long multiplier;
        private int maxFieldSize;

        private Unit(String nlsMessage, long multiplier, int maxFieldSize) {
            this.nlsMessage = nlsMessage;
            this.multiplier = multiplier;
            this.maxFieldSize = maxFieldSize;
        }

        public long getMultiplier() {
            return this.multiplier;
        }

        public int getMaxFieldSize() {
            return this.maxFieldSize;
        }

        public int getPosition() {
            return this.ordinal();
        }

        public String getNLSMessage() {
            return this.nlsMessage;
        }

        public static String[] getTypesAsStrings() {
            ArrayList<String> names = new ArrayList<String>();
            Unit[] unitArray = Unit.values();
            int n = unitArray.length;
            int n2 = 0;
            while (n2 < n) {
                Unit u = unitArray[n2];
                names.add(u.name());
                ++n2;
            }
            return names.toArray(new String[0]);
        }

        public static String[] getAllNLSmessages() {
            ArrayList<String> names = new ArrayList<String>();
            Unit[] unitArray = Unit.values();
            int n = unitArray.length;
            int n2 = 0;
            while (n2 < n) {
                Unit u = unitArray[n2];
                names.add(u.nlsMessage);
                ++n2;
            }
            return names.toArray(new String[0]);
        }

        public static Unit getByIndex(int position) {
            return position >= 0 && position < Unit.values().length ? Unit.values()[position] : null;
        }

        public static Unit getByName(String name) {
            Unit[] unitArray = Unit.values();
            int n = unitArray.length;
            int n2 = 0;
            while (n2 < n) {
                Unit unit = unitArray[n2];
                if (name.equalsIgnoreCase(unit.name())) {
                    return unit;
                }
                ++n2;
            }
            return null;
        }

        public static Unit getByPosition(int position) {
            return position >= 0 && position < Unit.values().length ? Unit.values()[position] : null;
        }
    }
}

