/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wmqfte.explorer.utils.v2;

import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.TitleAreaDialog;

public class PriorityStatus {
    private Status status = null;
    private String descMessage;
    private boolean changed;
    private boolean complete;

    public PriorityStatus(String descMessage) {
        this.descMessage = descMessage;
        this.changed = true;
        this.complete = true;
    }

    public PriorityStatus(PriorityStatus ps1, PriorityStatus ps2) {
        if (ps1 != null && ps2 != null) {
            this.status = ps1.getSeverity() >= ps2.getSeverity() ? ps1.getStatus() : ps2.getStatus();
        } else if (ps1 != null) {
            this.status = ps1.status;
        } else if (ps2 != null) {
            this.status = ps2.status;
        }
        this.descMessage = ps1.descMessage != null ? ps1.descMessage : ps2.descMessage;
        this.complete = ps1.complete && ps2.complete;
        this.changed = true;
    }

    public void setIncomplete() {
        this.complete = false;
    }

    public void setInformation(String msg) {
        if (this.status == null) {
            this.status = new Status(1, "com.ibm.wmqfte.explorer", msg);
            this.changed = true;
        }
    }

    public void setInformation(Status status) {
        if (this.status == null) {
            this.status = status;
            this.changed = true;
        }
    }

    public void setWarning(String msg) {
        if (this.status == null || this.status.getSeverity() < 2) {
            this.status = new Status(2, "com.ibm.wmqfte.explorer", msg);
            this.changed = true;
        }
    }

    public void setWarning(Status status) {
        if (this.status == null || this.status.getSeverity() < 2) {
            this.status = status;
            this.changed = true;
        }
    }

    public void setError(String msg) {
        if (this.status == null || this.status.getSeverity() < 4) {
            this.status = new Status(4, "com.ibm.wmqfte.explorer", msg);
            this.changed = true;
        }
    }

    public void setError(Status status) {
        if (this.status == null || this.status.getSeverity() < 4) {
            this.status = status;
            this.changed = true;
        }
    }

    public Status getStatus() {
        return this.status != null ? this.status : new Status(0, "com.ibm.wmqfte.explorer", "");
    }

    public int getSeverity() {
        return this.status == null ? 0 : this.status.getSeverity();
    }

    public boolean isOk() {
        return this.status == null || this.status.getSeverity() <= 1;
    }

    public boolean isComplete() {
        return this.complete && (this.status == null || this.status.getSeverity() <= 2);
    }

    public void setOK() {
        this.status = new Status(0, "com.ibm.wmqfte.explorer", "");
        this.changed = true;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Status: ");
        sb.append(this.status == null ? " null" : this.status.toString());
        sb.append(", Complete: " + this.complete);
        return sb.toString();
    }

    public void updateTitleStatus(TitleAreaDialog page) {
        if (this.changed) {
            if (this.status == null) {
                page.setMessage(this.descMessage);
                page.setErrorMessage(null);
            } else {
                int severity = this.status.getSeverity();
                if (severity == 4 || severity == 8) {
                    page.setMessage(null);
                    page.setErrorMessage(this.status.getMessage());
                } else {
                    page.setErrorMessage(null);
                    if (severity == 2) {
                        page.setMessage(this.status.getMessage(), 2);
                    } else if (severity == 1) {
                        page.setMessage(this.status.getMessage(), 1);
                    } else {
                        page.setErrorMessage(null);
                        page.setMessage(this.descMessage);
                    }
                }
            }
            this.changed = false;
        }
    }

    public void demoteErrorToInformation() {
        if (this.status != null && this.status.getSeverity() == 4) {
            this.status = new Status(1, "com.ibm.wmqfte.explorer", this.status.getMessage());
        }
    }
}

