/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wmqfte.explorer.utils.v2;

import com.ibm.wmqfte.api.CommandScheduleSpecification;
import com.ibm.wmqfte.api.CreateTransfer;
import com.ibm.wmqfte.api.InternalException;
import com.ibm.wmqfte.explorer.Elements;
import com.ibm.wmqfte.explorer.utils.v2.QueueProperties;
import com.ibm.wmqfte.explorer.utils.v2.Tools;
import com.ibm.wmqfte.monitor.MonitorPattern;
import com.ibm.wmqfte.monitor.impl.MonitorRequest;
import com.ibm.wmqfte.monitor.impl.MonitorTriggerCondition;
import com.ibm.wmqfte.objects.TransferTemplate;
import com.ibm.wmqfte.utils.Content;
import com.ibm.wmqfte.utils.Metadata;
import com.ibm.wmqfte.utils.xmlmessage.ElementSpecification;
import com.ibm.wmqfte.utils.xmlmessage.transfer.ItemSpecification;
import com.ibm.wmqfte.utils.xmlmessage.transfer.ManagedTransferSpecification;
import com.ibm.wmqfte.utils.xmlmessage.transfer.ProgramCall;
import com.ibm.wmqfte.utils.xmlmessage.transfer.RequestSpecification;
import com.ibm.wmqfte.utils.xmlmessage.transfer.TriggerParameterSpecification;
import com.ibm.wmqfte.utils.xmlmessage.transfer.TriggerSpecification;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Generator {
    private static final String EOL;
    private static final String COMMAND_SEPARATOR;
    private static final String PARAMETER_SEPARATOR = " ";
    private static final String TransferModeDefault;
    private static final String SourceDispositionDefault;
    private static final String DestinationDispositionDefault;
    private static final String ChecksumDefault;

    static {
        COMMAND_SEPARATOR = EOL = System.getProperty("line.separator");
        TransferModeDefault = ItemSpecification.TransferMode.defaultValue().toString().toLowerCase();
        SourceDispositionDefault = ItemSpecification.SourceDisposition.defaultValue().toString().toLowerCase();
        DestinationDispositionDefault = ItemSpecification.DestinationExist.defaultValue().toString().toLowerCase();
        ChecksumDefault = ItemSpecification.ChecksumMethod.defaultValue().toString().toLowerCase();
    }

    public static String showXML(TransferTemplate transferTemplate) {
        String transfer = Generator.generateXMLRequest(transferTemplate);
        return transfer == null ? "" : Tools.beautifyXML(transfer);
    }

    public static String showCommands(TransferTemplate transferTemplate) {
        String note;
        StringBuilder sb = new StringBuilder();
        List fileSpecs = transferTemplate.getFileSpecs();
        if (fileSpecs.isEmpty()) {
            sb.append(Generator.showCommand(transferTemplate, null, true, 0));
        } else if (fileSpecs.size() > 1) {
            String prevsc = null;
            Separated commands = new Separated(COMMAND_SEPARATOR);
            Separated sourceNames = new Separated(PARAMETER_SEPARATOR);
            int taskCount = 0;
            for (ItemSpecification itemSpecification : fileSpecs) {
                String sc = Generator.showCommand(transferTemplate, itemSpecification, false, ++taskCount);
                if (prevsc == null || sc.equals(prevsc)) {
                    sourceNames.append("\"" + itemSpecification.getSourceName() + "\"");
                    if (prevsc != null) continue;
                    prevsc = sc;
                    continue;
                }
                commands.append(String.valueOf(prevsc) + PARAMETER_SEPARATOR + sourceNames.toString());
                prevsc = sc;
                sourceNames.empty();
                sourceNames.append("\"" + itemSpecification.getSourceName() + "\"");
            }
            if (prevsc != null) {
                commands.append(String.valueOf(prevsc) + PARAMETER_SEPARATOR + sourceNames.toString());
            }
            sb.append(commands.toString());
        } else {
            sb.append(Generator.showCommand(transferTemplate, (ItemSpecification)fileSpecs.get(0), true, 0));
        }
        MonitorRequest monitor = transferTemplate.getResourceMonitor();
        if (monitor != null) {
            if (fileSpecs.size() > 1) {
                sb.append(EOL);
                note = MessageFormat.format(Elements.UI_WIZARD_V2_SUMMARY_TASK_XML_MERGE_LABEL, "task.xml", "fteCreateMonitor");
                sb.append(" (").append(note).append(")");
            }
            sb.append(EOL);
            sb.append(Generator.showCommand(monitor));
            sb.append(" -mt task.xml");
        }
        if (sb.toString().contains("$")) {
            sb.append(EOL);
            note = MessageFormat.format(Elements.UI_WIZARD_V2_SUMMARY_TASK_COMMAND_ESCAPE_LABEL, "$", "fteCreateTransfer");
            sb.append(" (").append(note).append(")");
        }
        return sb.toString();
    }

    public static String showCommand(TransferTemplate transferTemplate, ItemSpecification item, boolean includeSourceItem, int taskCount) {
        StringBuilder sb = new StringBuilder("fteCreateTransfer");
        if (transferTemplate.getResourceMonitor() != null) {
            sb.append(" -gt task");
            if (taskCount > 0) {
                sb.append(Integer.toString(taskCount));
            }
            sb.append(".xml");
        }
        if (transferTemplate.getTransferRecoveryTimeout() > -2) {
            sb.append(" -rt " + transferTemplate.getTransferRecoveryTimeout());
        }
        if (transferTemplate.getJobSpec() != null) {
            sb.append(" -jn \"" + transferTemplate.getJobSpec().getName() + "\"");
        }
        sb.append(" -sa " + transferTemplate.getSourceAgent().getAgentName());
        sb.append(" -sm " + transferTemplate.getSourceAgent().getAgentQMgr());
        sb.append(" -da " + transferTemplate.getDestinationAgent().getAgentName());
        sb.append(" -dm " + transferTemplate.getDestinationAgent().getAgentQMgr());
        if (transferTemplate.getMetadata() != null && transferTemplate.getMetadata().size() > 0) {
            sb.append(" -md \"");
            String sep = "";
            for (Map.Entry metaData : transferTemplate.getMetadata().entrySet()) {
                sb.append(sep);
                sep = ",";
                sb.append(String.valueOf((String)metaData.getKey()) + "=" + (String)metaData.getValue());
            }
            sb.append("\" ");
        }
        Generator.appendCallOut(sb, " -presrc", transferTemplate.getPreSourceCall());
        Generator.appendCallOut(sb, " -postsrc", transferTemplate.getPostSourceCall());
        Generator.appendCallOut(sb, " -predst", transferTemplate.getPreDestinationCall());
        Generator.appendCallOut(sb, " -postdst", transferTemplate.getPostDestinationCall());
        if (transferTemplate.getScheduleSpec() != null) {
            CommandScheduleSpecification css = transferTemplate.getScheduleSpec();
            sb.append(" -ss " + css.getStartSchedule());
            sb.append(" -tb " + css.getTimeBase());
            if (css.getEndSchedule() != null) {
                sb.append(" -es " + css.getEndSchedule());
            }
            if (css.getRepeatCount() > 0) {
                sb.append(" -oc " + css.getRepeatCount());
            }
            if (css.getRepeatFrequency() > 0) {
                sb.append(" -of " + css.getRepeatFrequency());
            }
            if (css.getRepeatInterval() != null) {
                sb.append(" -oi " + css.getRepeatInterval());
            }
        }
        if (transferTemplate.getTriggerSpec() != null) {
            TriggerSpecification ts = transferTemplate.getTriggerSpec();
            if (ts.isTriggerLogEnabled()) {
                sb.append(" -tl yes");
            }
            for (TriggerParameterSpecification tps : ts.getTriggerSet()) {
                sb.append(" -tr ");
                sb.append(tps.getCheck().getParameter());
                sb.append(tps.getComparison().getParameter());
                if (tps.getQualifier() == null || tps.getQualifier().length() == 0) {
                    sb.append("exist");
                } else {
                    sb.append(tps.getQualifier());
                }
                for (String name : tps.getNameList()) {
                    sb.append("," + name);
                }
            }
        }
        if (transferTemplate.getPriority() > 0) {
            sb.append(" -pr ");
            sb.append(Integer.toString(transferTemplate.getPriority()));
        }
        if (!transferTemplate.getFileSpecs().isEmpty() && item != null) {
            String delimiterType;
            Map props;
            Generator.addIfNotDefault(sb, " -t", item.getTransferModeStr(), TransferModeDefault);
            Generator.addIfNotDefault(sb, " -cs", item.getChecksumMethod(), ChecksumDefault);
            Generator.addIfNotDefault(sb, " -sd", item.getSourceDispositionStr(), SourceDispositionDefault);
            if (item.isRecursive()) {
                sb.append(" -r");
            }
            Generator.addIfNotDefault(sb, " -de", item.getDestinationExistsStr(), DestinationDispositionDefault);
            switch (item.getDestinationType()) {
                case FILE: {
                    sb.append(" -df ");
                    break;
                }
                case DIRECTORY: {
                    sb.append(" -dd ");
                    break;
                }
                case DATASET: {
                    sb.append(" -ds ");
                    break;
                }
                case PDS: {
                    sb.append(" -dp ");
                    break;
                }
                case QUEUE: {
                    sb.append(" -dq ");
                    break;
                }
                case FILESPACE: {
                    sb.append(" -du ");
                }
            }
            sb.append("\"").append(item.getDestinationName()).append("\"");
            if (item.getSourceType() == ItemSpecification.SourceType.QUEUE) {
                String parm2;
                props = item.getSourceQueueProps();
                delimiterType = (String)props.get("delimiterType");
                if ("text".equalsIgnoreCase(delimiterType)) {
                    sb.append(" -sqdt " + (String)props.get("delimiter"));
                    sb.append(" -sqdp " + (String)props.get("delimiterPosition"));
                } else if ("binary".equalsIgnoreCase(delimiterType)) {
                    sb.append(" -sqdb " + (String)props.get("delimiter"));
                    sb.append(" -sqdp " + (String)props.get("delimiterPosition"));
                }
                String parm1 = (String)props.get("useGroups");
                if (parm1 != null && parm1.equalsIgnoreCase("true")) {
                    sb.append(" -sqgi");
                }
                if ((parm2 = (String)props.get("waitTime")) != null) {
                    sb.append(" -sqwt " + parm2);
                }
                sb.append(" -sq ");
            }
            if (item.getSourceType() == ItemSpecification.SourceType.FILE && (props = item.getSourceProps()) != null) {
                String value = (String)props.get("delimiter");
                if (value != null) {
                    sb.append(" -srdb " + value);
                }
                if ((value = (String)props.get("delimiterPosition")) != null) {
                    sb.append(" -srdp " + value);
                }
                if ((value = (String)props.get("keepTrailingSpaces")) != null && value.equalsIgnoreCase("true")) {
                    sb.append(" -skeep");
                }
            }
            if (item.getDestinationType() == ItemSpecification.DestinationType.QUEUE && (props = item.getDestinationProps()) != null && !props.isEmpty()) {
                String setMqProps;
                String includeDelimiters;
                delimiterType = (String)props.get("delimiterType");
                if ("text".equalsIgnoreCase(delimiterType)) {
                    sb.append(" -dqdt " + (String)props.get("delimiter"));
                    sb.append(" -dqdp " + (String)props.get("delimiterPosition"));
                } else if ("binary".equalsIgnoreCase(delimiterType)) {
                    sb.append(" -dqdb " + (String)props.get("delimiter"));
                    sb.append(" -dqdp " + (String)props.get("delimiterPosition"));
                } else if ("size".equalsIgnoreCase(delimiterType)) {
                    sb.append(" -qs " + (String)props.get("delimiter"));
                }
                String persistence = (String)props.get("persistent");
                if (persistence != null && !persistence.equalsIgnoreCase(QueueProperties.DelimiterType.PersistenceType.PERSISTENCE.getValue())) {
                    sb.append(" -dqp " + persistence);
                }
                if ((includeDelimiters = (String)props.get("includeDelimiterInMessage")) != null && !includeDelimiters.equalsIgnoreCase("false")) {
                    sb.append(" -qi");
                }
                if ((setMqProps = (String)props.get("setMqProps")) != null && !setMqProps.equalsIgnoreCase("false")) {
                    sb.append(" -qmp true");
                }
            }
            if (item.getTransferModeType() == ItemSpecification.TransferMode.TEXT) {
                if (item.getSourceEncoding() != null) {
                    sb.append(" -sce " + item.getSourceEncoding());
                }
                if (item.getDestinationEncoding() != null) {
                    sb.append(" -dce " + item.getDestinationEncoding());
                }
                if (item.getDestinationEOL() != null) {
                    sb.append(" -dle " + item.getDestinationEOL());
                }
            }
            if ((item.getDestinationType() == ItemSpecification.DestinationType.DATASET || item.getDestinationType() == ItemSpecification.DestinationType.PDS) && item.isTruncateDatasetRecord()) {
                sb.append(" -dtr");
            }
            Set attributes = item.getDestinationCustomAttributes();
            boolean isFirst = true;
            if (attributes != null && !attributes.isEmpty()) {
                sb.append(" -dfa ");
                for (String attribute : attributes) {
                    if (isFirst) {
                        isFirst = false;
                    } else {
                        sb.append(";");
                    }
                    sb.append(attribute);
                }
            }
            if (includeSourceItem) {
                for (ItemSpecification specification : transferTemplate.getFileSpecs()) {
                    sb.append(' ');
                    sb.append("\"").append(specification.getSourceName()).append("\"");
                }
            }
        } else {
            Tools.internalError(Elements.UI_WIZARD_V2_INTERR_COMMAND, transferTemplate.getName());
        }
        String retStr = sb.toString();
        return retStr;
    }

    public static String showCommand(MonitorRequest monitor) {
        Metadata metadata;
        Map defaultVariables;
        MonitorTriggerCondition trigger;
        MonitorPattern.Type patternType;
        StringBuilder sb = new StringBuilder("fteCreateMonitor");
        sb.append(" -ma ").append(monitor.getAgentName());
        sb.append(" -mn ").append(monitor.getMonitorName());
        if (monitor.getResourceType() == MonitorRequest.MonitorResourceType.DIRECTORY) {
            sb.append(" -md \"").append(monitor.getResourceName());
            if (monitor.getResourceName().endsWith("\\")) {
                sb.append("\\\"");
            } else {
                sb.append("\"");
            }
            if (monitor.getRecursionLevel() > 0) {
                sb.append(" -rl ").append(monitor.getRecursionLevel());
            }
        } else if (monitor.getResourceType() == MonitorRequest.MonitorResourceType.QUEUE) {
            sb.append(" -mq ").append(monitor.getResourceName());
        }
        if (monitor.getPollInterval() != 1) {
            sb.append(" -pi ").append(monitor.getPollInterval());
            if (monitor.getPollUnits() != null && monitor.getPollUnits() != MonitorRequest.DEFAULT_POLL_UNITS) {
                sb.append(" -pu ").append(monitor.getPollUnits());
            }
        }
        if (monitor.getBatchSize() > 1) {
            sb.append(" -bs ").append(monitor.getBatchSize());
        }
        if ((patternType = (trigger = monitor.getTrigger(0)).getPattern().getType()) != MonitorPattern.Type.WILDCARD) {
            sb.append(" -pt ").append(trigger.getPattern().getType().toString());
        }
        sb.append(" -tr \"").append(trigger.getTriggerParameter()).append("\"");
        MonitorPattern excludePattern = monitor.getExcludePattern();
        if (excludePattern != null && excludePattern != MonitorPattern.NO_PATTERN) {
            sb.append(" -x \"").append(excludePattern.getPattern()).append("\"");
        }
        if (monitor.getTriggerContent() != null) {
            Content content = monitor.getTriggerContent();
            sb.append(" -tc ");
            if (!content.isContentRegExDefault()) {
                sb.append(" -tcr \"" + content.getContentRegEx() + "\"");
                if (!content.isCaptureOrderDefault()) {
                    sb.append(" -tcc " + content.getCaptureOrder().getParameter());
                }
            }
        }
        if ((defaultVariables = monitor.getDefaultVariables()) != null) {
            for (Map.Entry entry : defaultVariables.entrySet()) {
                sb.append(" -dv \"").append((String)entry.getKey()).append('=').append((String)entry.getValue()).append("\"");
            }
        }
        if ((metadata = monitor.getMetaData()) != null && metadata.getMetadata() != null) {
            for (Map.Entry entry : metadata.getMetadata().entrySet()) {
                sb.append(" -mmd \"").append((String)entry.getKey()).append('=').append((String)entry.getValue()).append("\"");
            }
        }
        if (monitor.getOverwrite()) {
            sb.append(" -f");
            if (monitor.getClearHistory()) {
                sb.append(" -c");
            }
        }
        return sb.toString();
    }

    private static void appendCallOut(StringBuilder sb, String parameterName, ProgramCall pc) {
        if (pc != null) {
            sb.append(parameterName);
            sb.append(" \"");
            pc.renderToCommand(sb);
            sb.append("\"");
        }
    }

    public static String generateXMLRequest(TransferTemplate tt) {
        String retStr = null;
        ManagedTransferSpecification transferSpec = tt.getManagedTransferSpecification();
        MonitorRequest monitor = tt.getResourceMonitor();
        if (monitor == null) {
            try {
                byte[] b = CreateTransfer.buildCreateTransferMessagePayload((ManagedTransferSpecification)transferSpec, null);
                retStr = new String(b, "UTF-8");
            }
            catch (InternalException ex) {
                Tools.internalError(ex, Elements.UI_WIZARD_V2_INTERR_XML_GENERATION, ex.getLocalizedMessage());
            }
            catch (UnsupportedEncodingException ex) {
                Tools.internalError(ex, Elements.UI_WIZARD_V2_INTERR_XML_GENERATION, ex.getLocalizedMessage());
            }
        } else {
            monitor.setHostName(CreateTransfer.getHostName());
            monitor.setUserId(CreateTransfer.getUserId());
            monitor.setTaskXML(new RequestSpecification((ElementSpecification)transferSpec).toXML());
            retStr = monitor.toXML(null);
        }
        return retStr;
    }

    private static void addIfNotDefault(StringBuilder sb, String argument, String value, String DefaultValue) {
        if (value != null && !value.equalsIgnoreCase(DefaultValue)) {
            sb.append(String.valueOf(argument) + PARAMETER_SEPARATOR + value);
        }
    }

    public static class Separated {
        private final String separator;
        private String workingSeparator = "";
        private StringBuilder sb = new StringBuilder();

        public Separated(String separator) {
            this.separator = separator;
        }

        public void append(String value) {
            this.sb.append(this.workingSeparator);
            this.workingSeparator = this.separator;
            this.sb.append(value);
        }

        public void empty() {
            this.sb = new StringBuilder();
            this.workingSeparator = "";
        }

        public String toString() {
            return this.sb.toString();
        }
    }
}

