/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wmqfte.explorer.utils.v2;

import com.ibm.wmqfte.explorer.utils.AgentDetails;
import com.ibm.wmqfte.explorer.wizards.v2.TransferWizardV2;
import com.ibm.wmqfte.utils.AgentType;

public class EnvironmentInformation {
    private final Perspective perspective;
    private final TransferWizardV2.CreateType createType;
    private final AgentDetails agentDetails;

    public static EnvironmentInformation createSourceEnvOptions(TransferWizardV2.CreateType createType, AgentDetails agentDetails) {
        return new EnvironmentInformation(Perspective.Source, createType, agentDetails);
    }

    public static EnvironmentInformation createDestinationEnvOptions(TransferWizardV2.CreateType createType, AgentDetails agentDetails) {
        return new EnvironmentInformation(Perspective.Destination, createType, agentDetails);
    }

    private EnvironmentInformation(Perspective perspective, TransferWizardV2.CreateType createType, AgentDetails agentDetails) {
        this.perspective = perspective;
        this.createType = createType;
        this.agentDetails = agentDetails;
    }

    public boolean isAgentLocalToMachine() {
        return this.agentDetails == null ? false : this.agentDetails.isAgentLocalToMachine();
    }

    public boolean isWildCardSupported() {
        AgentType type = this.agentDetails.getAgentType();
        return type != AgentType.CD_BRIDGE && type != AgentType.WEB_GATEWAY;
    }

    public String getQueueManagerName() {
        return this.agentDetails == null ? "" : this.agentDetails.getQueueManagerName();
    }

    public AgentType getAgentType() {
        return this.agentDetails == null ? null : this.agentDetails.getAgentType();
    }

    public boolean isResourceMonitor() {
        return this.createType.isResourceMonitor();
    }

    public AgentDetails getAgentDetails() {
        return this.agentDetails;
    }

    public boolean isSource() {
        return this.perspective == Perspective.Source;
    }

    public boolean isDestination() {
        return this.perspective == Perspective.Destination;
    }

    public static enum Perspective {
        Source,
        Destination;

    }
}

