/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wmqfte.explorer.utils.v2;

import com.ibm.wmqfte.explorer.Elements;
import com.ibm.wmqfte.explorer.ExplorerPlugin;
import com.ibm.wmqfte.explorer.utils.v2.Tools;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.jface.dialogs.IDialogSettings;

public class DatasetAttributes {
    private static final String ManufactureFavorites = "BLKSIZE(...);LRECL(...);DSORG(...);RECFM(...)";
    private static final String ManufactureDefaults = "BLKSIZE(...)";
    private static final String EOL = System.getProperty("line.separator");
    private static final String SEP_COLON = ":";
    private static final String SEP_SEMICOLON = ";";
    private static final String ATTRIBUTE_SEPARATOR = ";";
    private static final String ATTRIBUTE_SEPARATORS = ";|:";
    public static final String FAVORITES_SCHEMA = "[Favorites]";
    public static final String DEFAULT_SCHEMA = "[Default]";
    private String name;
    private ArrayList<DataSetParameter> attr;

    public static DatasetAttributes importMessage(String importStr) {
        int idxFirstOccurence;
        DatasetAttributes dp = null;
        int idxColon = importStr.indexOf(SEP_COLON);
        int idxSemiColon = importStr.indexOf(";");
        if (idxColon == -1) {
            idxColon = Integer.MAX_VALUE;
        }
        if (idxSemiColon == -1) {
            idxSemiColon = Integer.MAX_VALUE;
        }
        int n = idxFirstOccurence = idxColon < idxSemiColon ? idxColon : idxSemiColon;
        if (idxFirstOccurence != Integer.MAX_VALUE) {
            String name = importStr.substring(0, idxFirstOccurence);
            String itemStr = importStr.substring(idxFirstOccurence + 1);
            dp = new DatasetAttributes(name, itemStr);
        } else {
            Tools.internalError(Elements.UI_WIZARD_V2_INTERR_DATASET_TEMPLATES_INV, importStr);
        }
        return dp;
    }

    public DatasetAttributes() {
        this.name = null;
        this.attr = new ArrayList();
    }

    public DatasetAttributes(String name, String importStr) {
        this.name = name;
        this.attr = new ArrayList();
        if (importStr != null) {
            String[] parameters;
            String[] stringArray = parameters = importStr.split(ATTRIBUTE_SEPARATORS);
            int n = parameters.length;
            int n2 = 0;
            while (n2 < n) {
                String parameter = stringArray[n2];
                if (parameter.length() > 0) {
                    this.attr.add(new DataSetParameter(parameter));
                }
                ++n2;
            }
        }
    }

    public DatasetAttributes(DataSetParameter[] parameters) {
        this.name = "NotSupported";
        this.attr = new ArrayList();
        DataSetParameter[] dataSetParameterArray = parameters;
        int n = parameters.length;
        int n2 = 0;
        while (n2 < n) {
            DataSetParameter parameter = dataSetParameterArray[n2];
            this.attr.add(parameter);
            ++n2;
        }
    }

    public DatasetAttributes(DatasetAttributes dsp) {
        this.name = dsp.name;
        this.attr = (ArrayList)dsp.attr.clone();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void add(DataSetParameter parameter) {
        this.attr.add(parameter);
    }

    public void remove(DataSetParameter parameter) {
        this.attr.remove(parameter);
    }

    public String export() {
        return this.getAsAttributes(true);
    }

    public String getAsAttributes(boolean withName) {
        StringBuffer sb = new StringBuffer();
        if (withName) {
            sb.append(String.valueOf(this.name) + ";");
        }
        String sep = "";
        for (DataSetParameter item : this.attr) {
            sb.append(sep);
            sep = ";";
            sb.append(item.getName());
        }
        return sb.toString();
    }

    public List<DataSetParameter> getAsList() {
        return this.attr;
    }

    public List<String> getAsNameList() {
        ArrayList<String> names = new ArrayList<String>();
        for (DataSetParameter dsp : this.attr) {
            names.add(dsp.getName());
        }
        return names;
    }

    public String report() {
        return this.getAsAttributes(false).replace(";", EOL);
    }

    public boolean isEmpty() {
        return this.attr.isEmpty();
    }

    public void update(DatasetAttributes dsp) {
        this.attr = dsp.attr;
        this.name = dsp.name;
    }

    public String toString() {
        return this.name;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.attr == null ? 0 : this.attr.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DatasetAttributes other = (DatasetAttributes)obj;
        if (this.attr == null ? other.attr != null : !this.attr.equals(other.attr)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public static enum DSPValid {
        EMPTY(""),
        OK(Elements.UI_PREFS_V2_DIALOG_OK),
        SYNTAX(Elements.UI_PREFS_V2_DIALOG_SYNTAX),
        UNKNOWN(Elements.UI_PREFS_V2_DIALOG_UNKNOWN);

        private final String nlsMessage;

        private DSPValid(String nlsMessage) {
            this.nlsMessage = nlsMessage;
        }

        public String getNLSMessage() {
            return this.nlsMessage;
        }

        public static DSPValid getByName(String name) {
            DSPValid[] dSPValidArray = DSPValid.values();
            int n = dSPValidArray.length;
            int n2 = 0;
            while (n2 < n) {
                DSPValid enumName = dSPValidArray[n2];
                if (enumName.toString().equals(name)) {
                    return enumName;
                }
                ++n2;
            }
            return null;
        }
    }

    public static class DataSetParameter {
        private String name;
        private DSPValid validState;

        public DataSetParameter(String name) {
            this.name = name;
            this.validState = this.validate(name);
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public DSPValid getValid() {
            return this.validState;
        }

        private DSPValid validate(String name) {
            return name == null || name.length() == 0 ? DSPValid.EMPTY : DSPValid.OK;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.validState == null ? 0 : this.validState.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DataSetParameter other = (DataSetParameter)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.validState == null ? other.validState != null : !this.validState.equals((Object)other.validState));
        }
    }

    public static class DataSetSchemaLibrary {
        private static DataSetSchemaLibrary dstl = null;
        private Map<String, DatasetAttributes> datasetSchemas = new TreeMap<String, DatasetAttributes>();
        private IDialogSettings dialogSettings;
        private boolean editable;

        private DataSetSchemaLibrary() {
            IDialogSettings ds = ExplorerPlugin.getDefault().getDialogSettings();
            this.dialogSettings = ds.getSection("UI_WIZARD_DATASET_TEMPLATES_SECTION");
            if (this.dialogSettings == null) {
                this.dialogSettings = ds.addNewSection("UI_WIZARD_DATASET_TEMPLATES_SECTION");
            }
            this.loadTemplates();
            this.addDefault();
            this.editable = false;
        }

        private DataSetSchemaLibrary(DataSetSchemaLibrary orig) {
            for (Map.Entry<String, DatasetAttributes> entry : orig.datasetSchemas.entrySet()) {
                this.datasetSchemas.put(entry.getKey(), new DatasetAttributes(entry.getValue()));
            }
            this.editable = true;
        }

        public static DataSetSchemaLibrary getReadOnlyInstance() {
            if (dstl == null) {
                dstl = new DataSetSchemaLibrary();
            }
            return dstl;
        }

        public static DataSetSchemaLibrary getEditableInstance() {
            if (dstl == null) {
                dstl = new DataSetSchemaLibrary();
            }
            return new DataSetSchemaLibrary(dstl);
        }

        public boolean isNamePresent(String name) {
            return this.datasetSchemas.containsKey(name);
        }

        public void add(DatasetAttributes newDSP) {
            if (this.editable) {
                this.datasetSchemas.put(newDSP.getName(), newDSP);
            } else {
                Tools.internalError(new Exception(), Elements.UI_WIZARD_V2_INTERR_NON_EDIT_MODE, "add");
            }
        }

        public void remove(DatasetAttributes removeDSP) {
            if (this.editable) {
                this.datasetSchemas.remove(removeDSP.getName());
            } else {
                Tools.internalError(new Exception(), Elements.UI_WIZARD_V2_INTERR_NON_EDIT_MODE, "add");
            }
        }

        public void remove(String name) {
            if (this.editable) {
                this.datasetSchemas.remove(name);
            } else {
                Tools.internalError(new Exception(), Elements.UI_WIZARD_V2_INTERR_NON_EDIT_MODE, "add");
            }
        }

        public DatasetAttributes getDataSetProperties(String name) {
            return this.datasetSchemas.get(name);
        }

        public List<String> getNameList() {
            ArrayList<String> names = new ArrayList<String>();
            for (Map.Entry<String, DatasetAttributes> entry : this.datasetSchemas.entrySet()) {
                names.add(entry.getKey());
            }
            return names;
        }

        public int getNamePositionIdx(String name) {
            List<String> names = this.getNameList();
            int i = 0;
            while (i < names.size()) {
                if (names.get(i).equals(name)) {
                    return i;
                }
                ++i;
            }
            return 0;
        }

        public DatasetAttributes getFirst() {
            Iterator<DatasetAttributes> it = this.datasetSchemas.values().iterator();
            return it.hasNext() ? it.next() : null;
        }

        public List<String> getFavorites() {
            List<String> names = null;
            DatasetAttributes fsa = dstl.getDataSetProperties(DatasetAttributes.FAVORITES_SCHEMA);
            if (fsa != null) {
                names = fsa.getAsNameList();
            }
            return names == null || names.size() == 0 ? null : names;
        }

        private void loadTemplates() {
            String[] templates;
            if (!this.editable && (templates = this.dialogSettings.getArray("UI_WIZARD_DATASET_TEMPLATES")) != null) {
                String[] stringArray = templates;
                int n = templates.length;
                int n2 = 0;
                while (n2 < n) {
                    String template = stringArray[n2];
                    DatasetAttributes dsp = DatasetAttributes.importMessage(template);
                    if (dsp != null) {
                        this.datasetSchemas.put(dsp.getName(), dsp);
                    }
                    ++n2;
                }
            }
        }

        public void saveSchemas() {
            if (this.editable) {
                DataSetSchemaLibrary orig = DataSetSchemaLibrary.getReadOnlyInstance();
                orig.saveSchemas(this);
            } else {
                Tools.internalError(new Exception(), Elements.UI_WIZARD_V2_INTERR_NON_EDIT_MODE, "save");
            }
        }

        private void saveSchemas(DataSetSchemaLibrary dstl) {
            this.datasetSchemas = dstl.datasetSchemas;
            ArrayList<String> export = new ArrayList<String>();
            for (Map.Entry<String, DatasetAttributes> entry : this.datasetSchemas.entrySet()) {
                DatasetAttributes dsp = entry.getValue();
                export.add(dsp.export());
            }
            if (export.size() != 0) {
                this.dialogSettings.put("UI_WIZARD_DATASET_TEMPLATES", export.toArray(new String[0]));
            }
        }

        private void addDefault() {
            if (!this.datasetSchemas.containsKey(DatasetAttributes.FAVORITES_SCHEMA)) {
                this.datasetSchemas.put(DatasetAttributes.FAVORITES_SCHEMA, new DatasetAttributes(DatasetAttributes.FAVORITES_SCHEMA, DatasetAttributes.ManufactureFavorites));
            }
            if (!this.datasetSchemas.containsKey(DatasetAttributes.DEFAULT_SCHEMA)) {
                this.datasetSchemas.put(DatasetAttributes.DEFAULT_SCHEMA, new DatasetAttributes(DatasetAttributes.DEFAULT_SCHEMA, DatasetAttributes.ManufactureDefaults));
            }
        }
    }
}

