/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wmqfte.explorer.utils.v2;

import com.ibm.wmqfte.explorer.utils.v2.ResMonAssist;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ControlGroup {
    private List<Control> controls = new ArrayList<Control>();
    private List<ControlGroup> controlGroups = new ArrayList<ControlGroup>();
    private boolean visible = false;
    private boolean enabled = false;
    private final String name;

    public ControlGroup(String name) {
        this.name = name;
    }

    public void add(Control control) {
        this.controls.add(control);
    }

    public void add(ControlGroup controlGroup) {
        this.controlGroups.add(controlGroup);
    }

    public void visible(boolean visible) {
        this.visible = visible;
        for (ControlGroup gc : this.controlGroups) {
            gc.visible(visible);
        }
        for (Control c : this.controls) {
            boolean resMonAssistEnabled = true;
            Object assocData = c.getData();
            if (assocData != null && assocData instanceof ResMonAssist) {
                resMonAssistEnabled = ((ResMonAssist)assocData).isAssistVisible();
            }
            c.setVisible(visible && resMonAssistEnabled);
            if (!(c.getLayoutData() instanceof GridData)) continue;
            boolean bl = ((GridData)c.getLayoutData()).exclude = !visible || !resMonAssistEnabled;
        }
    }

    public void enabled(boolean enabled) {
        this.enabled = enabled;
        for (ControlGroup gc : this.controlGroups) {
            gc.enabled(enabled);
        }
        for (Control c : this.controls) {
            if (c instanceof Composite) {
                Control[] controlArray = ((Composite)c).getChildren();
                int n = controlArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Control ci = controlArray[n2];
                    ci.setEnabled(enabled);
                    ++n2;
                }
            }
            c.setEnabled(enabled);
        }
    }

    public boolean getVisible() {
        return this.visible;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public String toString() {
        return String.valueOf(this.name) + " " + this.visible;
    }
}

