/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wmqfte.explorer.utils.v2;

import com.ibm.wmqfte.explorer.Elements;
import com.ibm.wmqfte.explorer.data.Subscription;
import com.ibm.wmqfte.explorer.dialogs.ItemDialogInfo;
import com.ibm.wmqfte.explorer.utils.AgentDetails;
import com.ibm.wmqfte.explorer.utils.v2.AgentContentProvider;
import com.ibm.wmqfte.explorer.utils.v2.AgentLabelProvider;
import com.ibm.wmqfte.explorer.utils.v2.ControlGroup;
import com.ibm.wmqfte.explorer.utils.v2.PriorityStatus;
import com.ibm.wmqfte.explorer.utils.v2.SectionHistory;
import com.ibm.wmqfte.explorer.utils.v2.Tools;
import com.ibm.wmqfte.explorer.utils.v2.Validator;
import com.ibm.wmqfte.explorer.wizards.v2.TransferWizardV2;
import com.ibm.wmqfte.utils.AgentStatusDetails;
import com.ibm.wmqfte.utils.AgentType;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class AgentCombo {
    private static final Pattern CD_NODE_NAME_PATTERN = Pattern.compile("[a-zA-Z0-9@#$_.]{1,16}+");
    private static final Pattern PROTOCOL_SERVER_ENDPOINT_NAME_PATTERN = Pattern.compile("[A-Za-z0-9\\._\\/%][A-Za-z0-9\\._\\/%]+");
    private final boolean sending;
    private final TransferWizardV2.CreateType createType;
    private final Label agentLabel;
    private final Combo agentCombo;
    private final ComboViewer agentViewer;
    private final Label endPtLabel;
    private final Combo endPtCombo;
    private final Combo endPtReadOnlyCombo;
    private final Text lTypeLabel;
    private List<AgentStatusDetails> asds = null;
    private AgentDetails agentDetails = null;
    private boolean agentPresent = true;
    private SectionHistory.HistoryReference endPointHistoryReference = null;

    public AgentCombo(Composite parent, final boolean sending, TransferWizardV2.CreateType createType, final Validator validator) {
        this.sending = sending;
        this.createType = createType;
        ControlGroup cg = new ControlGroup("Agent Combo");
        cg.visible(true);
        int hintWidthLabel = Tools.getWidth(parent, new String[]{Elements.UI_WIZARD_V2_INITIAL_SENDING_AGENT, Elements.UI_WIZARD_V2_INITIAL_RECEIVING_AGENT, Elements.UI_WIZARD_V2_INITIAL_CONNECT_DIRECT_NODE, Elements.UI_WIZARD_V2_INITIAL_PROTOCOL_SERVER_NAME});
        GridData labelGridData = new GridData(0x1000008, 0x1000000, false, false);
        labelGridData.widthHint = hintWidthLabel;
        Group acGrp = new Group(parent, 0);
        acGrp.setText(sending ? Elements.UI_WIZARD_V2_INITIAL_SEND_GRP : Elements.UI_WIZARD_V2_INITIAL_RECEIVING_GRP);
        acGrp.setLayout((Layout)new GridLayout(2, false));
        acGrp.setLayoutData((Object)new GridData(4, 0x1000008, true, false));
        this.agentLabel = new Label((Composite)acGrp, 131072);
        this.agentLabel.setText(sending ? Elements.UI_WIZARD_V2_INITIAL_SENDING_AGENT : Elements.UI_WIZARD_V2_INITIAL_RECEIVING_AGENT);
        this.agentLabel.setLayoutData((Object)labelGridData);
        this.agentCombo = new Combo((Composite)acGrp, 8);
        this.agentCombo.setToolTipText(Elements.UI_WIZARD_V2_INITIAL_SENDING_AGENT_TT);
        this.agentCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.asds = this.getListOfAgents(sending);
        this.agentViewer = new ComboViewer(this.agentCombo);
        this.agentViewer.setLabelProvider((IBaseLabelProvider)new AgentLabelProvider());
        this.agentViewer.setContentProvider((IContentProvider)new AgentContentProvider());
        this.agentViewer.setInput(this.asds);
        Label lTypeLab = new Label((Composite)acGrp, 131072);
        lTypeLab.setText(Elements.UI_WIZARD_V2_INITIAL_AGENT_TYPE);
        lTypeLab.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        this.lTypeLabel = Tools.accessibleLabel((Composite)acGrp, "");
        this.lTypeLabel.setText("");
        this.lTypeLabel.setLayoutData((Object)new GridData(1, -1, false, false));
        this.endPtLabel = new Label((Composite)acGrp, 131072);
        this.endPtLabel.setLayoutData((Object)labelGridData);
        this.endPtLabel.setVisible(false);
        this.endPtCombo = new Combo((Composite)acGrp, 0);
        this.endPtCombo.setVisible(false);
        this.endPtCombo.setToolTipText(sending ? Elements.UI_WIZARD_V2_INITIAL_SENDING_ENDPT_TT : Elements.UI_WIZARD_V2_INITIAL_RECEIVING_ENDPT_TT);
        this.endPtCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.endPtReadOnlyCombo = new Combo((Composite)acGrp, 8);
        this.endPtReadOnlyCombo.setVisible(false);
        this.endPtReadOnlyCombo.setToolTipText(sending ? Elements.UI_WIZARD_V2_INITIAL_SENDING_ENDPT_TT : Elements.UI_WIZARD_V2_INITIAL_RECEIVING_ENDPT_TT);
        GridData gd = new GridData(4, 0x1000000, true, false);
        gd.exclude = true;
        this.endPtReadOnlyCombo.setLayoutData((Object)gd);
        this.agentCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                AgentCombo.this.agentDetails = AgentCombo.getAgentPub(AgentCombo.this.agentCombo, AgentCombo.this.agentViewer);
                if (AgentCombo.this.agentDetails != null) {
                    AgentCombo.this.lTypeLabel.setText(AgentCombo.this.getAgentTypeDescription(AgentCombo.this.agentDetails));
                    AgentCombo.this.agentPresent = true;
                    if (AgentCombo.this.agentDetails.getAgentType() == AgentType.CD_BRIDGE) {
                        AgentCombo.this.endPointHistoryReference = sending ? SectionHistory.HistoryReference.SOURCE_CD_NODE_HISTORY : SectionHistory.HistoryReference.DEST_CD_NODE_HISTORY;
                        AgentCombo.this.openDefinableEndPointcontents(Elements.UI_WIZARD_V2_INITIAL_CONNECT_DIRECT_NODE, AgentCombo.this.endPointHistoryReference, null);
                    } else if (AgentCombo.this.agentDetails.getAgentType() == AgentType.BRIDGE) {
                        if (AgentCombo.this.agentDetails.isProtocolBridgeEndPointDefinable()) {
                            String[] nameList = AgentCombo.this.agentDetails.getProtocolServerEndPointnames();
                            if (nameList != null) {
                                AgentCombo.this.limitedDefinableEndPointcontents(Elements.UI_WIZARD_V2_INITIAL_PROTOCOL_SERVER_NAME, nameList);
                            } else {
                                String defaultName = AgentCombo.this.agentDetails.getProtocolServerEndPointname();
                                AgentCombo.this.endPointHistoryReference = sending ? SectionHistory.HistoryReference.SOURCE_PROTOCOL_BRIDGE_HISTORY : SectionHistory.HistoryReference.DEST_PROTOCOL_BRIDGE_HISTORY;
                                AgentCombo.this.openDefinableEndPointcontents(Elements.UI_WIZARD_V2_INITIAL_PROTOCOL_SERVER_NAME, AgentCombo.this.endPointHistoryReference, defaultName);
                            }
                        } else {
                            String protocolServerName = AgentCombo.this.agentDetails.getProtocolBridgeServerName();
                            if (protocolServerName != null) {
                                AgentCombo.this.fixedEndPointcontents(Elements.UI_WIZARD_V2_INITIAL_PROTOCOL_SERVER_NAME, protocolServerName);
                                AgentCombo.this.endPointHistoryReference = null;
                            } else {
                                Tools.internalError(Elements.UI_WIZARD_V2_INTERR_NO_BRIDGE_INFO, AgentCombo.this.agentDetails.getAgentName());
                                AgentCombo.this.endPointHistoryReference = null;
                            }
                        }
                    } else {
                        AgentCombo.this.endPtLabel.setVisible(false);
                        AgentCombo.this.endPtCombo.setVisible(false);
                        AgentCombo.this.endPtReadOnlyCombo.setVisible(false);
                        AgentCombo.this.endPointHistoryReference = null;
                        AgentCombo.this.agentDetails.setEndPointName(null);
                    }
                    AgentCombo.this.endPtLabel.getParent().layout(true);
                    if (validator != null) {
                        validator.Validate();
                    }
                }
            }
        });
        this.endPtCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                AgentCombo.this.agentDetails.setEndPointName(AgentCombo.this.endPtCombo.getText());
                if (validator != null) {
                    validator.Validate();
                }
            }
        });
        this.endPtCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AgentCombo.this.agentDetails.setEndPointName(AgentCombo.this.endPtCombo.getText());
                validator.Validate();
            }
        });
    }

    public void saveHistory() {
        if (this.endPointHistoryReference != null) {
            this.endPointHistoryReference.put(this.getEndPtName());
        }
    }

    public void setAgentName(String agentName) {
        int position = this.getAgentByPosition(agentName);
        if (position != -1) {
            this.agentCombo.select(position);
            this.agentCombo.notifyListeners(13, new Event());
        }
    }

    public void setEndPoint(String endPointname) {
        if (this.endPtCombo != null) {
            this.endPtCombo.setText(endPointname);
        }
        this.agentDetails.setEndPointName(endPointname);
    }

    public boolean isRestrictedAgent() {
        boolean restricted = false;
        if (this.agentDetails != null) {
            AgentType agentType = this.agentDetails.getAgentType();
            restricted = agentType == AgentType.BRIDGE || agentType == AgentType.CD_BRIDGE;
        }
        return restricted;
    }

    public boolean hasCDEndPoint() {
        return this.agentDetails == null ? false : this.agentDetails.getAgentType() == AgentType.CD_BRIDGE;
    }

    public AgentDetails getAgentDetails() {
        return this.agentDetails;
    }

    public String getEndPtName() {
        String name = this.endPtCombo.getVisible() ? this.endPtCombo.getText() : null;
        return name != null && name.length() > 0 ? name : null;
    }

    public boolean isValid() {
        return this.agentPresent;
    }

    private void openDefinableEndPointcontents(String labelText, SectionHistory.HistoryReference historyReference, String defaultValue) {
        this.endPtLabel.setVisible(true);
        this.endPtCombo.setVisible(true);
        this.endPtReadOnlyCombo.setVisible(false);
        this.endPtLabel.setText(labelText);
        historyReference.loadHistory(this.endPtCombo);
        this.endPtCombo.select(0);
        ((GridData)this.endPtCombo.getLayoutData()).exclude = false;
        ((GridData)this.endPtReadOnlyCombo.getLayoutData()).exclude = true;
        this.endPtCombo.setText(defaultValue != null ? defaultValue : "");
    }

    private void limitedDefinableEndPointcontents(String labelText, String[] nameList) {
        this.endPtLabel.setVisible(true);
        this.endPtCombo.setVisible(false);
        this.endPtReadOnlyCombo.setVisible(true);
        this.endPtReadOnlyCombo.setEnabled(true);
        this.endPtLabel.setText(labelText);
        this.endPtReadOnlyCombo.setItems(nameList);
        this.endPtReadOnlyCombo.select(0);
        ((GridData)this.endPtCombo.getLayoutData()).exclude = true;
        ((GridData)this.endPtReadOnlyCombo.getLayoutData()).exclude = false;
    }

    private void fixedEndPointcontents(String labelText, String endPoint) {
        this.endPtLabel.setVisible(true);
        this.endPtCombo.setVisible(false);
        this.endPtReadOnlyCombo.setVisible(true);
        this.endPtReadOnlyCombo.setEnabled(false);
        this.endPtLabel.setText(labelText);
        this.endPtReadOnlyCombo.setItems(new String[]{endPoint});
        this.endPtReadOnlyCombo.select(0);
        ((GridData)this.endPtCombo.getLayoutData()).exclude = true;
        ((GridData)this.endPtReadOnlyCombo.getLayoutData()).exclude = false;
        this.agentDetails.setEndPointName(endPoint);
    }

    private List<AgentStatusDetails> getListOfAgents(boolean sendingAgent) {
        ArrayList<AgentStatusDetails> agents = new ArrayList<AgentStatusDetails>();
        Set<AgentStatusDetails> asds = Subscription.getAgentStatusDetailsProvider().getAvailableAgents();
        for (AgentStatusDetails asd : asds) {
            if (this.createType.isResourceMonitor() && this.sending && !asd.isStandardAgent() || asd.isWebGateway() && this.sending) continue;
            agents.add(asd);
        }
        return agents;
    }

    private int getAgentByPosition(String agentName) {
        if (this.asds != null) {
            int pos = 0;
            for (AgentStatusDetails asd : this.asds) {
                if (asd.getAgentName().equalsIgnoreCase(agentName)) {
                    return pos;
                }
                ++pos;
            }
        }
        return -1;
    }

    private static AgentDetails getAgentPub(Combo agent, ComboViewer viewer) {
        Object o;
        int i = agent.getSelectionIndex();
        if (i >= 0 && (o = viewer.getElementAt(i)) instanceof AgentStatusDetails) {
            return new AgentDetails((AgentStatusDetails)o);
        }
        return null;
    }

    private PriorityStatus getAgentSelectionStatus() {
        PriorityStatus status = new PriorityStatus(null);
        if (this.agentCombo.getSelectionIndex() == -1) {
            status.setIncomplete();
        }
        return status;
    }

    private PriorityStatus getEndPtSelectionStatus() {
        PriorityStatus status = new PriorityStatus(null);
        if (this.endPtCombo.getVisible()) {
            String endPointName = this.endPtCombo.getText().trim();
            if (this.agentDetails.getAgentType() == AgentType.BRIDGE) {
                if (endPointName.length() == 0) {
                    status.setIncomplete();
                } else if (!PROTOCOL_SERVER_ENDPOINT_NAME_PATTERN.matcher(endPointName).matches()) {
                    String nlsReference = this.sending ? Elements.UI_WIZARD_V2_INITIAL_SRC_PROTOCOL_SERVER_ENDPOINT_ILLEGAL : Elements.UI_WIZARD_V2_INITIAL_DEST_PROTOCOL_SERVER_ENDPOINT_ILLEGAL;
                    status.setError(MessageFormat.format(nlsReference, endPointName));
                }
            } else if (endPointName.length() == 0) {
                status.setIncomplete();
            } else if (!CD_NODE_NAME_PATTERN.matcher(endPointName).matches()) {
                String nlsReference = this.sending ? Elements.UI_WIZARD_V2_INITIAL_SRC_CD_NODE_ILLEGAL : Elements.UI_WIZARD_V2_INITIAL_DEST_CD_NODE_ILLEGAL;
                status.setError(MessageFormat.format(nlsReference, endPointName));
            }
        }
        return status;
    }

    public PriorityStatus getStatus() {
        PriorityStatus status = this.getAgentSelectionStatus();
        if (this.endPtCombo.getEnabled()) {
            status = new PriorityStatus(status, this.getEndPtSelectionStatus());
        }
        return status;
    }

    private String getAgentTypeDescription(AgentDetails agentDetails) {
        AgentType agentType = agentDetails.getAgentType();
        ItemDialogInfo.AgentInfo agentInfo = ItemDialogInfo.AgentInfo.getByDetails(agentType);
        return agentInfo.getTypeInformation(agentDetails);
    }
}

