/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wmqfte.explorer.utils;

import com.ibm.wmqfte.explorer.ExplorerPlugin;
import com.ibm.wmqfte.explorer.utils.ProviderSorterItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ViewerSorter;

public class ProviderSorter {
    private Map<String, ProviderSorterItem> psMap = new HashMap<String, ProviderSorterItem>();
    private List<String> columnsWithTimeZone = null;

    public ProviderSorter() {
    }

    public ProviderSorter(List<String> columnsWithTimeZone) {
        this.columnsWithTimeZone = columnsWithTimeZone;
    }

    public void add(String name, ColumnLabelProvider provider, ViewerSorter sorter) {
        ProviderSorterItem psi = new ProviderSorterItem(provider, sorter);
        this.psMap.put(name, psi);
    }

    public ColumnLabelProvider getProvider(String name) {
        ProviderSorterItem psi = this.psMap.get(name);
        return psi == null ? null : psi.getProvider();
    }

    public ViewerSorter getSorter(String name) {
        ProviderSorterItem psi = this.psMap.get(name);
        return psi == null ? null : psi.getSorter();
    }

    public List<String> missingList(List<String> presentList) {
        ArrayList<String> missingList = new ArrayList<String>();
        for (String name : this.psMap.keySet()) {
            if (presentList.contains(name)) continue;
            missingList.add(name);
        }
        return missingList;
    }

    public String adjustColumnName(String columnName) {
        return this.columnsWithTimeZone != null && this.columnsWithTimeZone.contains(columnName) ? String.valueOf(columnName) + " (" + ExplorerPlugin.getTimeZone().getID() + ")" : columnName;
    }
}

