/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wmqfte.explorer.utils;

import com.ibm.wmqfte.explorer.ExplorerPlugin;
import com.ibm.wmqfte.explorer.utils.ColumnTitleMapper;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class PageUtils {
    private static final DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
    private static final IDialogSettings dialogSettings = ExplorerPlugin.getDefault() == null ? null : ExplorerPlugin.getDefault().getDialogSettings();
    private static final String EOL = System.getProperty("line.separator");
    public static final ControlListener minWidthControlListener = new ControlListener(){

        public void controlMoved(ControlEvent e) {
        }

        public void controlResized(ControlEvent e) {
            TableColumn c;
            if (e.getSource() instanceof TableColumn && (c = (TableColumn)e.getSource()).getWidth() < 16) {
                c.setWidth(16);
            }
            if (e.getSource() instanceof TreeColumn && (c = (TreeColumn)e.getSource()).getWidth() < 16) {
                c.setWidth(16);
            }
        }
    };
    private static final Map<Color, Color> blendCache = new HashMap<Color, Color>();
    private static Color bgCache;

    public static String basename(String name) {
        String s = name;
        if (name.matches("^[a-zA-Z]:.*")) {
            s = s.substring(s.lastIndexOf(92) + 1);
        }
        s = s.substring(s.lastIndexOf(47) + 1);
        return s;
    }

    public static Combo createCombo(Composite parent, String title, String tooltip, IDialogSettings settings, String historyKey, int style) {
        String[] history;
        Combo combo = PageUtils.createCombo(parent, title, tooltip, style);
        if (historyKey != null && (history = settings.getArray(historyKey)) != null) {
            combo.setItems(history);
        }
        return combo;
    }

    public static Combo createCombo(Composite parent, String title, String tooltip, int style) {
        Label label = new Label(parent, 131072);
        label.setText(title);
        label.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        if ((style & 1) != 0) {
            PageUtils.makeBold((Control)label);
        }
        Combo combo = new Combo(parent, style);
        combo.setToolTipText(tooltip);
        combo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        return combo;
    }

    protected static Combo createCombo(Composite parent, String title, String tooltip, List<String> items, int style) {
        Combo combo = PageUtils.createCombo(parent, title, tooltip, style);
        if (items != null) {
            combo.setItems(items.toArray(new String[0]));
        }
        return combo;
    }

    public static List<String> getEmptyList(int size) {
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        while (i < size) {
            list.add("");
            ++i;
        }
        return list;
    }

    public static GridData getIndentGridData() {
        return PageUtils.getIndentGridData(1);
    }

    public static GridData getIndentGridData(int indents) {
        GridData gd = new GridData();
        gd.verticalIndent = -5;
        gd.horizontalIndent = indents * 10;
        return gd;
    }

    public static int getWidth(TreeItem treeItem, GC g, int column) {
        String[] text = treeItem.getText(column).split(EOL);
        int longestWidth = 0;
        String[] stringArray = text;
        int n = text.length;
        int n2 = 0;
        while (n2 < n) {
            String lines = stringArray[n2];
            longestWidth = Math.max(longestWidth, g.stringExtent((String)lines).x + 25);
            ++n2;
        }
        return longestWidth;
    }

    public static void makeBold(Control control) {
        FontData data = control.getFont().getFontData()[0];
        control.setFont(new Font(null, data.getName(), data.getHeight(), 1));
    }

    public static void setStatusLine(WizardPage page, IStatus status) {
        String message = status.getMessage();
        int severity = status.getSeverity();
        if (message.length() == 0) {
            message = null;
        } else {
            String pageMsg = page.getMessage();
            String pageErrMsg = page.getErrorMessage();
            if (message.equals(pageMsg) || message.equals(pageErrMsg)) {
                return;
            }
            if (severity == 0 && "".equals(message) && pageErrMsg == null && pageMsg == null) {
                return;
            }
        }
        if (severity == 4 || severity == 8) {
            page.setMessage(null);
            page.setErrorMessage(message);
        } else {
            page.setErrorMessage(null);
            if (severity == 0) {
                page.setMessage(message);
            } else if (severity == 2) {
                page.setMessage(message, 2);
            } else if (severity == 1) {
                page.setMessage(message, 1);
            } else {
                page.setErrorMessage(null);
                page.setMessage(null);
            }
        }
    }

    public static void setStatusLine(TitleAreaDialog page, IStatus status) {
        String message = status.getMessage();
        int severity = status.getSeverity();
        if (severity == 4 || severity == 8) {
            page.setMessage(null);
            page.setErrorMessage(message);
        } else {
            page.setErrorMessage(null);
            if (severity == 0) {
                page.setMessage(message);
            } else if (severity == 2) {
                page.setMessage(message, 2);
            } else if (severity == 1) {
                page.setMessage(message, 1);
            } else {
                page.setErrorMessage(null);
                page.setMessage(null);
            }
        }
    }

    public static void setupTable(Table table) {
        GC g = new GC((Drawable)table);
        g.setFont(table.getFont());
        int columnCount = table.getColumnCount();
        int i = 0;
        while (i < columnCount) {
            TableColumn column = table.getColumn(i);
            int longestWidth = g.stringExtent((String)column.getText()).x;
            TableItem[] tableItemArray = table.getItems();
            int n = tableItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem tableItem = tableItemArray[n2];
                String text = tableItem.getText(i);
                int width = g.stringExtent((String)text).x;
                Image image = tableItem.getImage(i);
                if (image != null) {
                    int imgWidth = image.getBounds().width;
                    width += imgWidth;
                }
                if (width > longestWidth) {
                    longestWidth = width;
                }
                ++n2;
            }
            column.setWidth(longestWidth + 10);
            ++i;
        }
        g.dispose();
        table.setHeaderVisible(table.getItemCount() > 0);
    }

    public static void setupTable(Table table, int[] headerPadding) {
        GC g = new GC((Drawable)table);
        g.setFont(table.getFont());
        int columnCount = table.getColumnCount();
        int i = 0;
        while (i < columnCount) {
            TableColumn column = table.getColumn(i);
            int longestWidth = g.stringExtent((String)column.getText()).x;
            if (headerPadding.length >= i) {
                longestWidth += headerPadding[i];
            }
            TableItem[] tableItemArray = table.getItems();
            int n = tableItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem tableItem = tableItemArray[n2];
                String text = tableItem.getText(i);
                int width = g.stringExtent((String)text).x;
                Image image = tableItem.getImage(i);
                if (image != null) {
                    int imgWidth = image.getBounds().width;
                    width += imgWidth;
                }
                if (width > longestWidth) {
                    longestWidth = width;
                }
                ++n2;
            }
            column.setWidth(longestWidth + 10);
            ++i;
        }
        g.dispose();
    }

    public static void setupTree(Tree tree) {
        GC g = new GC((Drawable)tree);
        g.setFont(tree.getFont());
        int columnCount = tree.getColumnCount();
        int i = 0;
        while (i < columnCount) {
            TreeColumn column = tree.getColumn(i);
            if (column.getWidth() == 0 || !column.getResizable()) {
                int longestWidth = g.stringExtent((String)column.getText()).x;
                int j = 0;
                while (j < tree.getItemCount()) {
                    TreeItem treeItem = tree.getItem(j);
                    int width = PageUtils.getWidth(treeItem, g, i);
                    if (width > longestWidth) {
                        longestWidth = width;
                    }
                    if (treeItem.getExpanded()) {
                        TreeItem[] treeItemArray = treeItem.getItems();
                        int n = treeItemArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            TreeItem child = treeItemArray[n2];
                            width = PageUtils.getWidth(child, g, i) + 25;
                            if (width > longestWidth) {
                                longestWidth = width;
                            }
                            ++n2;
                        }
                    }
                    ++j;
                }
                column.setWidth(longestWidth + 25);
            }
            ++i;
        }
        TreeColumn column = tree.getSortColumn();
        if (!(column == null || column.getWidth() != 0 && column.getResizable())) {
            column.setWidth(column.getWidth() + 25);
        }
        g.dispose();
    }

    public static String printXML(Document doc) throws IOException, TransformerException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", "2");
        StreamResult result = new StreamResult(new BufferedWriter(new OutputStreamWriter((OutputStream)bos, "UTF-8")));
        DOMSource source = new DOMSource(doc);
        transformer.transform(source, result);
        return new String(bos.toByteArray(), "UTF-8");
    }

    public static String printXML(String xml) throws IOException, TransformerException, ParserConfigurationException, SAXException {
        DocumentBuilder db = dbf.newDocumentBuilder();
        ByteArrayInputStream bis = new ByteArrayInputStream(xml.getBytes("UTF-8"));
        Document doc = db.parse(bis);
        return PageUtils.printXML(doc);
    }

    public static void displayHelp(Display display, final String contextId) {
        TrayDialog dialog;
        final IWorkbenchHelpSystem helpSystem = PlatformUI.getWorkbench().getHelpSystem();
        if (display.getActiveShell().getData() instanceof TrayDialog && (dialog = (TrayDialog)display.getActiveShell().getData()).getTray() != null) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    helpSystem.displayHelp(contextId);
                }
            });
        }
    }

    public static String[] loadDefaultColumns(String sectionName, String[] defaultColumns) {
        IDialogSettings settings = PageUtils.getDialogSetting(sectionName);
        String[] columns = settings.getArray("COLUMNS");
        if (columns == null || columns.length == 0) {
            settings.put("COLUMNS", defaultColumns);
            columns = defaultColumns;
        }
        return columns;
    }

    public static void saveDefaultColumns(String sectionName, ColumnTitleMapper mapper, Viewer viewer) {
        String[] columnNames = PageUtils.getVisibleColumns(viewer);
        String[] persistableColumnIds = mapper.getColumnPersistableOrderFromDisplayTitles(columnNames);
        PageUtils.getDialogSetting(sectionName).put("COLUMNS", persistableColumnIds);
    }

    private static IDialogSettings getDialogSetting(String sectionName) {
        IDialogSettings settings = null;
        if (dialogSettings != null && (settings = dialogSettings.getSection(sectionName)) == null) {
            settings = dialogSettings.addNewSection(sectionName);
        }
        return settings;
    }

    public static String[] getVisibleColumns(Viewer viewer) {
        String[] rc = null;
        if (viewer instanceof TreeViewer) {
            rc = PageUtils.getVisibleColumns((TreeViewer)viewer);
        } else if (viewer instanceof TableViewer) {
            rc = PageUtils.getVisibleColumns((TableViewer)viewer);
        }
        return rc;
    }

    private static String[] getVisibleColumns(TreeViewer treeViewer) {
        int[] k;
        ArrayList<String> visibleColumns = new ArrayList<String>();
        TreeColumn[] columns = treeViewer.getTree().getColumns();
        int[] nArray = k = treeViewer.getTree().getColumnOrder();
        int n = k.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            TreeColumn tc = columns[i];
            if (tc.getWidth() > 0) {
                visibleColumns.add(tc.getText());
            }
            ++n2;
        }
        return visibleColumns.toArray(new String[0]);
    }

    private static String[] getVisibleColumns(TableViewer tableViewer) {
        int[] k;
        ArrayList<String> visibleColumns = new ArrayList<String>();
        TableColumn[] columns = tableViewer.getTable().getColumns();
        int[] nArray = k = tableViewer.getTable().getColumnOrder();
        int n = k.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            TableColumn tc = columns[i];
            if (tc.getWidth() > 0) {
                visibleColumns.add(tc.getText());
            }
            ++n2;
        }
        return visibleColumns.toArray(new String[0]);
    }

    public static Color getListBackgroundColor(int color) {
        Display display = Display.getCurrent();
        Color bg = display.getSystemColor(25);
        if (display.getHighContrast()) {
            return bg;
        }
        Color desiredbg = display.getSystemColor(color);
        if (bgCache == null || !bg.equals((Object)bgCache)) {
            blendCache.clear();
            bgCache = bg;
        } else {
            Color cachedBlend = blendCache.get(desiredbg);
            if (cachedBlend != null) {
                return cachedBlend;
            }
        }
        Color blendedbg = new Color((Device)display, FormColors.blend((RGB)desiredbg.getRGB(), (RGB)bg.getRGB(), (int)15));
        blendCache.put(desiredbg, blendedbg);
        return blendedbg;
    }
}

