/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wmqfte.explorer.utils;

import com.ibm.wmqfte.explorer.Elements;
import com.ibm.wmqfte.utils.AgentStatusDetails;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class AgentStatus
extends AgentStatusDetails
implements IWorkbenchAdapter {
    private long timeshift = 0L;

    public AgentStatus(byte[] data) throws IOException {
        super(data);
    }

    public long getStatusAge(Date coordinationQMTime) {
        TimeZone.setDefault(TimeZone.getTimeZone("UTC"));
        Calendar calInUTC = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        Date currentTime = coordinationQMTime != null ? coordinationQMTime : calInUTC.getTime();
        long duration = currentTime.getTime() - this.getPublishedTime().getTime().getTime();
        return duration;
    }

    public void setTimeShift() {
        Calendar now = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        if (now != null && this.getPublishedTime() != null) {
            this.timeshift = this.getPublishedTime().getTimeInMillis() - now.getTimeInMillis();
        }
    }

    public String getStartTime() {
        String agentStatusValue = this.interpretAgentStatus().getAgentStatus();
        String agentStartTime = super.getAgentStartTimeAsString();
        if (agentStartTime != null && (agentStatusValue.equals(Elements.UI_CONTENT_ACTIVE_TITLE) || agentStatusValue.equals(Elements.UI_CONTENT_STARTED_TITLE) || agentStatusValue.equals(Elements.UI_CONTENT_STOPPING_TITLE) || agentStatusValue.equals(Elements.UI_CONTENT_READY_TITLE))) {
            return super.getAgentStartTimeAsString();
        }
        return Elements.UI_CONTENT_NOT_APPLICABLE;
    }

    public long getTimeShift() {
        return this.timeshift;
    }

    public AgentStatusDetails.AgentOnLineStatus interpretAgentStatus() {
        Calendar now = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        now.setTimeInMillis(now.getTimeInMillis() + this.timeshift);
        return this.interpretAgentStatus(now);
    }

    public Object[] getChildren(Object o) {
        return null;
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        return null;
    }

    public String getLabel(Object o) {
        return o instanceof AgentStatus ? ((AgentStatus)((Object)o)).getAgentName() : "";
    }

    public Object getParent(Object o) {
        return null;
    }
}

