/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wmqfte.explorer.utils;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.wmqfte.api.FTEPropertyStore;
import com.ibm.wmqfte.explorer.ExplorerPlugin;
import com.ibm.wmqfte.explorer.data.Subscription;
import com.ibm.wmqfte.explorer.treenode.MFTETreeNodeFactory;
import com.ibm.wmqfte.utils.AgentStatusDetails;
import com.ibm.wmqfte.utils.AgentType;
import com.ibm.wmqfte.utils.ProductVersion;
import java.io.File;
import java.util.TimeZone;
import java.util.logging.Level;

public class AgentDetails {
    public static final String PLATFORM_WINDOWS = "Windows";
    private final AgentStatusDetails details;
    private String endPointName = null;

    public AgentDetails(AgentStatusDetails details) {
        this.details = details;
    }

    public boolean isOSPlatform(String platformName) {
        return this.details.getAgentOsName().equals(platformName);
    }

    public String getAgentOsName() {
        return this.details.getAgentOsName();
    }

    private boolean isAgentBackLevel(ProductVersion.ProductInterfaceVersion lvl) {
        String interfaceLevel = this.details.getAgentInterfaceLevel();
        ProductVersion.ProductInterfaceVersion agentLevel = ProductVersion.ProductInterfaceVersion.fromValue((String)interfaceLevel);
        boolean retBool = interfaceLevel == null || !agentLevel.greaterOrEqual(lvl);
        return retBool;
    }

    public boolean isQueueMessagingAvailable() {
        boolean retBool = !this.isAgentBackLevel(ProductVersion.ProductInterfaceVersion.V400);
        return retBool;
    }

    public String getAgentDescription() {
        String retStr = this.details.getAgentDescription();
        return retStr;
    }

    public String getAgentName() {
        String retStr = this.details.getAgentName();
        return retStr;
    }

    public String getProtocolBridgeServerName() {
        String[] parts;
        String retStr = null;
        String serverName = this.details.getProtocolBridgeServer();
        if (serverName != null && (parts = serverName.split(":")).length >= 1) {
            retStr = parts[0];
        }
        return retStr;
    }

    public String getWebGatewayName() {
        String retStr = this.details.getWebGatewayName();
        return retStr;
    }

    public boolean isProtocolBridgeEndPointDefinable() {
        return "multiple".equalsIgnoreCase(this.details.getProtocolServerEndPoints());
    }

    public String[] getProtocolServerEndPointnames() {
        String[] retStr = this.details.getProtocolServerEndPointNames();
        return retStr;
    }

    public String getCDBridgeNodeName() {
        String retStr = this.details.getCDBridgeNodeName();
        return retStr;
    }

    public String getProtocolServerEndPointname() {
        String retStr = this.details.getProtocolServerEndPointName();
        return retStr;
    }

    public AgentType getAgentType() {
        AgentType type = this.details.getAgentType();
        if (type == null) {
            type = this.details.getProtocolBridgeType() == null ? AgentType.STANDARD : AgentType.BRIDGE;
        }
        return type;
    }

    public String getQueueManagerName() {
        String retStr = this.details.getQueueManagerName();
        return retStr;
    }

    public TimeZone getAgentTimeZone() {
        TimeZone retTZ = this.details.getAgentTimeZone();
        return retTZ;
    }

    public boolean isAgentLocalToMachine() {
        boolean local = false;
        if (this.details.getAgentType() == AgentType.STANDARD) {
            try {
                FTEPropertyStore propStore = Subscription.getPropertyFiles();
                File agentWorkingDir = propStore.getAgentWorkingDirectory(MFTETreeNodeFactory.getConnectedCoordQmgr().getName(), this.getAgentName());
                File agentLockFile = new File(agentWorkingDir, "agent.lck");
                local = agentLockFile.exists();
            }
            catch (Exception ex) {
                if (Trace.isTracing) {
                    Trace.data((Level)Level.WARNING, (String)"AgentDetails", (String)"isAgentLocalToMachine", (String)ex.toString(), (String)ExplorerPlugin.BUNDLE_SHORT_NAME);
                }
                local = false;
            }
        }
        return local;
    }

    public boolean isProgramInvocationSupported() {
        boolean isProgramInvocationSupported;
        switch (this.getAgentType()) {
            case STANDARD: 
            case BRIDGE: 
            case CD_BRIDGE: {
                isProgramInvocationSupported = true;
                break;
            }
            default: {
                isProgramInvocationSupported = false;
            }
        }
        return isProgramInvocationSupported;
    }

    public String getDescriptiveAgentName() {
        String result = this.details.getAgentName();
        if (this.details.getAgentDescription() != null && !this.details.getAgentDescription().trim().equals("")) {
            result = String.valueOf(result) + " (" + this.details.getAgentDescription() + ")";
        }
        return result;
    }

    public void setEndPointName(String endPointName) {
        this.endPointName = endPointName;
    }

    public String getEndPointName() {
        return this.endPointName;
    }
}

