/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wmqfte.explorer.utils;

import com.ibm.wmqfte.api.AbstractCommand;
import com.ibm.wmqfte.api.AgentConnection;
import com.ibm.wmqfte.api.ApiException;
import com.ibm.wmqfte.api.CommandException;
import com.ibm.wmqfte.api.CommandResult;
import com.ibm.wmqfte.api.ConfigurationException;
import com.ibm.wmqfte.api.InternalException;
import com.ibm.wmqfte.api.ParameterException;
import com.ibm.wmqfte.api.PingAgent;
import com.ibm.wmqfte.configuration.FTEProperties;
import com.ibm.wmqfte.explorer.Elements;
import com.ibm.wmqfte.explorer.data.Subscription;
import com.ibm.wmqfte.explorer.wizards.pages.AgentControlReport;
import com.ibm.wmqfte.utils.FTEPropConstant;
import com.ibm.wmqfte.utils.reply.FTEReply;
import com.ibm.wmqfte.wmqiface.WMQConnectionData;
import java.text.MessageFormat;
import org.eclipse.swt.widgets.Display;

public class AgentControlCommands
extends AbstractCommand {
    private AgentControlReport reportPanel;

    public AgentControlCommands(AgentControlReport reportPanel) {
        this.reportPanel = reportPanel;
    }

    private void addToReport(final String msg) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!AgentControlCommands.this.reportPanel.isDisposed()) {
                    AgentControlCommands.this.reportPanel.addToReport(msg);
                    AgentControlCommands.this.reportPanel.flush();
                }
            }
        });
    }

    private void performAgentStartCommand(String agentName) {
        String command = "fteStartAgent " + agentName.toUpperCase();
        String nlsMessage = String.valueOf(Elements.UI_WIZARD_AGENT_CONTROL_EXECUTING) + " : " + command;
        this.reportPanel.addExecuteReport(nlsMessage);
        this.reportPanel.addResponseReport("Command not supported");
    }

    /*
     * Exception decompiling
     */
    private void performAgentStopCommand(String agentName, String agentQMgr, boolean controlledStop) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean performAgentPingCommand(String agentName, String agentQMgr, String timeoutStr) {
        boolean completed = true;
        this.addToReport(MessageFormat.format(Elements.UI_STATUS_PING_COMMAND, agentName.toUpperCase()));
        try {
            long startTime = System.currentTimeMillis();
            int maxWaitTime = timeoutStr == null ? DEFAULT_REPLY_TIMEOUT * 1000 : Integer.parseInt(timeoutStr);
            int pingResult = PingAgent.ping((String)AgentControlCommands.getHostName(), (String)AgentControlCommands.getUserId(), (String)agentName, (String)agentQMgr, (WMQConnectionData)Subscription.getCmdConnectionData(), (String)Subscription.getDynamicQueuePrefix(), (String)Subscription.getModelQueueName(), (int)maxWaitTime);
            boolean isSuccessful = pingResult != FTEReply.ReplyResultCode.TIMEOUT.getValue() && pingResult != FTEReply.ReplyResultCode.ACK_TIMEOUT.getValue();
            double duration = isSuccessful ? (double)(System.currentTimeMillis() - startTime) / 1000.0 : (double)maxWaitTime;
            String message = isSuccessful ? Elements.UI_STATUS_PING_SUCCESSFUL : Elements.UI_STATUS_PING_TIMEOUT;
            this.addToReport(MessageFormat.format(message, agentName, Double.toString(duration)));
        }
        catch (ApiException ex) {
            this.addToReport(ex.getLocalizedMessage());
            completed = false;
        }
        return completed;
    }

    /*
     * Exception decompiling
     */
    private void performAgentTraceCommand(String agentName, String agentQMgr, boolean enabled, boolean includeMQ) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static AgentConnection getConnection(String agentName, String agentQMgr) throws ConfigurationException, InternalException, CommandException, ParameterException {
        FTEProperties connectionProperties = AgentControlCommands.getConnectionProperties((String)agentName, (String)agentQMgr, null, null, null, null, null);
        String dynamicQueuePrefix = connectionProperties.getPropertyAsString(FTEPropConstant.dynamicQueuePrefix);
        String modelQueueName = connectionProperties.getPropertyAsString(FTEPropConstant.modelQueueName);
        WMQConnectionData wmqConnectionData = Subscription.getCmdConnectionData();
        AgentConnection connection = new AgentConnection(agentName, agentQMgr, wmqConnectionData, dynamicQueuePrefix, modelQueueName);
        return connection;
    }

    private static CommandResult processCommand(AgentConnection connection, byte[] messagePayload, String maxWaitTime, ResponseType response) throws CommandException {
        long startTime = System.currentTimeMillis();
        int maxWaitTimeMillis = AgentControlCommands.convertToMillsecs(maxWaitTime, AbstractCommand.DEFAULT_REPLY_TIMEOUT);
        byte[] id = connection.sendCommand(messagePayload, -1);
        CommandResult result = new CommandResult(FTEReply.ReplyResultCode.SUCCESSFUL);
        if (response.expectAck()) {
            result = connection.waitForAck(id, AbstractCommand.DEFAULT_ACK_TIMEOUT);
        }
        if (response.expectResponse() || result != null && result.getResultCode() == FTEReply.ReplyResultCode.ACK) {
            result = connection.waitForReply(id, maxWaitTimeMillis);
        }
        if (result.getResultCode() == FTEReply.ReplyResultCode.TIMEOUT) {
            result.setDuration(maxWaitTimeMillis);
        } else {
            long endTime = System.currentTimeMillis();
            result.setDuration((int)(endTime - startTime));
        }
        return result;
    }

    private static int convertToMillsecs(String value, int defaultValue) {
        int retValue = defaultValue;
        if (value != null) {
            try {
                Integer timeout = Integer.parseInt(value);
                retValue = timeout > 0 ? timeout * 1000 : timeout;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return retValue;
    }

    private static enum ResponseType {
        NONE(false, false),
        RESPONSE(false, true),
        ACK_RESPONSE(true, true);

        boolean ack;
        boolean response;

        private ResponseType(boolean ack, boolean response) {
            this.ack = ack;
            this.response = response;
        }

        public boolean expectAck() {
            return this.ack;
        }

        public boolean expectResponse() {
            return this.response;
        }
    }
}

