/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wmqfte.explorer.treenode;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.ui.extensions.ITreeNodeFactory;
import com.ibm.mq.explorer.ui.extensions.TreeNode;
import com.ibm.wmqfte.api.AbstractCommand;
import com.ibm.wmqfte.api.ConfigurationException;
import com.ibm.wmqfte.api.FTEPropertyStore;
import com.ibm.wmqfte.configuration.FTEConfigurationException;
import com.ibm.wmqfte.configuration.FTEProperties;
import com.ibm.wmqfte.explorer.ExplorerPlugin;
import com.ibm.wmqfte.explorer.data.FTEConfigurationPersistence;
import com.ibm.wmqfte.explorer.data.Subscription;
import com.ibm.wmqfte.explorer.objects.ConfigurationSetMQExtObject;
import com.ibm.wmqfte.explorer.treenode.AgentTreeNode;
import com.ibm.wmqfte.explorer.treenode.CoordTreeNode;
import com.ibm.wmqfte.explorer.treenode.MFTETreeNode;
import com.ibm.wmqfte.explorer.treenode.MonitorTreeNode;
import com.ibm.wmqfte.explorer.treenode.TransferLogTreeNode;
import com.ibm.wmqfte.explorer.treenode.TransferScheduleTreeNode;
import com.ibm.wmqfte.explorer.treenode.TransferTemplatesTreeNode;
import com.ibm.wmqfte.explorer.wizards.v2.FTEConfigurationWizardSettings;
import com.ibm.wmqfte.utils.FTEPropConstant;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;

public class MFTETreeNodeFactory
implements ITreeNodeFactory,
IExecutableExtension {
    private static TreeNode baseNode;
    private static CoordTreeNode connectedCoordQmgr;

    public static TreeNode getBaseNode() {
        return baseNode;
    }

    public static CoordTreeNode getConnectedCoordQmgr() {
        return connectedCoordQmgr;
    }

    public static void setConnectedCoordQmgr(CoordTreeNode p1) {
        connectedCoordQmgr = p1;
    }

    public void addChildrenToTreeNode(TreeNode parent) {
        String parentId = parent.getId();
        if (parentId.equals("com.ibm.mq.explorer.treenode.wmq")) {
            if (!parent.isChildExist("com.ibm.wmqfte.explorer")) {
                baseNode = new MFTETreeNode(parent, null, "com.ibm.wmqfte.explorer");
                parent.addChildToNode(baseNode, 0);
            }
        } else if (parentId.equals("com.ibm.wmqfte.explorer")) {
            try {
                FTEPropertyStore propertyFiles = Subscription.getPropertyFiles();
                if (propertyFiles != null) {
                    String defaultCoord = propertyFiles.getCoordPropertySetName();
                    for (String name : propertyFiles.getCoordPropertySets()) {
                        if (parent.isChildExist("com.ibm.wmqfte.explorer.coordination." + name)) continue;
                        CoordTreeNode child = new CoordTreeNode(parent, new ConfigurationSetMQExtObject(name, null), "com.ibm.wmqfte.explorer", name, name.equals(defaultCoord), null);
                        FTEProperties coordinationProperties = propertyFiles.getCoordinationProperties(name);
                        try {
                            String qmName = coordinationProperties.getPropertyAsString(FTEPropConstant.adminQmgrName);
                            if (qmName == null) {
                                qmName = name;
                            }
                            AbstractCommand.checkMQEnvIsValidForCommand((String)qmName, (boolean)coordinationProperties.isPropertyPresent(FTEPropConstant.adminQmgrHostname));
                            parent.addChildToNode((TreeNode)child, 0);
                        }
                        catch (ConfigurationException e) {
                            if (!Trace.isTracing) continue;
                            Trace.data((Level)Level.FINER, (String)"MFTETreeNodeFactory", (String)"addChildrenToTreeNode", (String)e.toString(), (String)ExplorerPlugin.BUNDLE_SHORT_NAME);
                        }
                    }
                }
            }
            catch (FTEConfigurationException fTEConfigurationException) {}
            FTEConfigurationPersistence.load();
            for (Map.Entry<String, FTEConfigurationWizardSettings> entry : FTEConfigurationPersistence.getConfigurationSets().entrySet()) {
                FTEConfigurationWizardSettings settings = entry.getValue();
                String name = settings.getConfigurationName();
                if (parent.isChildExist("com.ibm.wmqfte.explorer.coordination." + name + ".user.configured")) continue;
                parent.addChildToNode((TreeNode)new CoordTreeNode(parent, new ConfigurationSetMQExtObject(name, settings), "com.ibm.wmqfte.explorer", name, false, settings), 0);
            }
        } else if (parentId.startsWith("com.ibm.wmqfte.explorer.coordination")) {
            if (!parent.isChildExist("com.ibm.wmqfte.explorer.transferlog")) {
                parent.addChildToNode((TreeNode)new TransferLogTreeNode(parent, null, "com.ibm.wmqfte.explorer"), 0);
            }
            if (!parent.isChildExist("com.ibm.wmqfte.explorer.transfertemplates")) {
                parent.addChildToNode((TreeNode)new TransferTemplatesTreeNode(parent, null, "com.ibm.wmqfte.explorer"), 0);
            }
            if (!parent.isChildExist("com.ibm.wmqfte.explorer.transferschedule")) {
                parent.addChildToNode((TreeNode)new TransferScheduleTreeNode(parent, null, "com.ibm.wmqfte.explorer"), 0);
            }
            if (!parent.isChildExist("com.ibm.wmqfte.explorer.monitor")) {
                parent.addChildToNode((TreeNode)new MonitorTreeNode(parent, null, "com.ibm.wmqfte.explorer"), 0);
            }
            if (!parent.isChildExist("com.ibm.wmqfte.explorer.agent")) {
                parent.addChildToNode((TreeNode)new AgentTreeNode(parent, null, "com.ibm.wmqfte.explorer"), 0);
            }
        }
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
    }

    public static void connectCoordination() {
        if (connectedCoordQmgr != null) {
            connectedCoordQmgr.connect();
        }
    }

    public static void disconnectCoordination() {
        if (connectedCoordQmgr != null) {
            connectedCoordQmgr.disconnect();
        }
    }
}

