/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wmqfte.explorer.treenode;

import com.ibm.mq.commonservices.Common;
import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.extensions.TreeNode;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.views.ExplorerViewPart;
import com.ibm.mq.explorer.ui.internal.views.MQContentView;
import com.ibm.wmqfte.explorer.Elements;
import com.ibm.wmqfte.explorer.ExplorerPlugin;
import com.ibm.wmqfte.explorer.Icons;
import com.ibm.wmqfte.explorer.Messages;
import com.ibm.wmqfte.explorer.content.AgentContentFactory;
import com.ibm.wmqfte.explorer.content.AgentContentPage;
import com.ibm.wmqfte.explorer.content.CoordContentPage;
import com.ibm.wmqfte.explorer.content.CoordContentPageFactory;
import com.ibm.wmqfte.explorer.content.MonitorContentFactory;
import com.ibm.wmqfte.explorer.content.MonitorContentPage;
import com.ibm.wmqfte.explorer.content.TransferLogFactory;
import com.ibm.wmqfte.explorer.content.TransferLogPage;
import com.ibm.wmqfte.explorer.content.TransferScheduleFactory;
import com.ibm.wmqfte.explorer.content.TransferSchedulePage;
import com.ibm.wmqfte.explorer.content.TransferTemplatesFactory;
import com.ibm.wmqfte.explorer.content.TransferTemplatesPage;
import com.ibm.wmqfte.explorer.data.FTEConfigurationPersistence;
import com.ibm.wmqfte.explorer.data.Subscription;
import com.ibm.wmqfte.explorer.treenode.MFTETreeNodeFactory;
import com.ibm.wmqfte.explorer.utils.v2.Tools;
import com.ibm.wmqfte.explorer.views.TransferProgressView;
import com.ibm.wmqfte.explorer.wizards.v2.FTEConfigurationWizardSettings;
import com.ibm.wmqfte.explorer.wizards.v2.TransferWizardStarterV2;
import com.ibm.wmqfte.wmqiface.WMQApiException;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyDialogAction;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class CoordTreeNode
extends TreeNode
implements IWorkbenchAdapter {
    private boolean isConnected = false;
    private final String name;
    private FTEConfigurationWizardSettings configuration;

    public CoordTreeNode(TreeNode parent, MQExtObject object, String plugin_id, String name, boolean isDefault, FTEConfigurationWizardSettings configuration) {
        super(parent, object, plugin_id);
        this.name = name;
        this.configuration = configuration;
    }

    public void appendToContextMenu(final Shell shell, IMenuManager manager) {
        final CoordTreeNode node = this;
        if (this.isConnected) {
            Action newTransfer = new Action(){

                public void run() {
                    TransferWizardStarterV2.createTransfer(shell);
                }
            };
            newTransfer.setText(String.valueOf(Elements.UI_CONTENT_TRANSFER_TEMPLATES_NEW_TRANSFER_BUTTON) + "...");
            manager.add((IAction)newTransfer);
            manager.add((IContributionItem)new Separator());
            Action disconnect = new Action(){

                public void run() {
                    CoordTreeNode.this.disconnect();
                    CoordTreeNode.this.getParent().refresh();
                }
            };
            disconnect.setText(Elements.UI_NODE_MFT_DISCONNECT_LABEL);
            manager.add((IAction)disconnect);
        } else {
            Action connect = new Action(){

                public void run() {
                    CoordTreeNode.this.connect();
                }
            };
            connect.setText(Elements.UI_NODE_MFT_CONNECT_LABEL);
            connect.setEnabled(this.configuration == null || this.configuration.isComplete());
            manager.add((IAction)connect);
        }
        manager.add((IContributionItem)new Separator());
        Action delete = new Action(){

            public void run() {
                if (MessageDialog.openConfirm((Shell)shell, (String)Elements.UI_WIZARD_CONFIRM_DELETE_CONFIGURATION_DIALOG_TITLE, (String)(String.valueOf(MessageFormat.format(Elements.UI_WIZARD_CONFIRM_DELETE_CONFIGURATION_DIALOG_QUESTION, node.getName())) + Common.LINE_SEPARATOR + Common.LINE_SEPARATOR + Messages.BFGUI0008_CONFIRM_DELETE_CONFIGURATION))) {
                    FTEConfigurationPersistence.remove(CoordTreeNode.this.configuration);
                    try {
                        FTEConfigurationPersistence.save();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    node.getParent().removeChildFromNode((TreeNode)node);
                    MFTETreeNodeFactory.getBaseNode().getParent().refresh();
                }
            }
        };
        delete.setText(Elements.UI_NODE_MFT_DELETE_LABEL);
        delete.setEnabled(this.configuration != null && !this.isConnected());
        manager.add((IAction)delete);
        ISelectionProvider selectionProvider = new ISelectionProvider(){

            public void addSelectionChangedListener(ISelectionChangedListener listener) {
            }

            public ISelection getSelection() {
                return new IStructuredSelection(){

                    public boolean isEmpty() {
                        return false;
                    }

                    public Object getFirstElement() {
                        return node;
                    }

                    public Iterator iterator() {
                        return this.toList().iterator();
                    }

                    public int size() {
                        return 1;
                    }

                    public Object[] toArray() {
                        return new Object[]{node};
                    }

                    public List toList() {
                        return Arrays.asList(this.toArray());
                    }
                };
            }

            public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            }

            public void setSelection(ISelection selection) {
            }
        };
        PropertyDialogAction propertyDialog = new PropertyDialogAction(shell, selectionProvider);
        propertyDialog.setEnabled(true);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)propertyDialog);
    }

    public int compare(TreeNode child1, TreeNode child2) {
        return CoordTreeNode.compareByName((TreeNode)child1, (TreeNode)child2);
    }

    public void connect() {
        this.connect(false);
    }

    private void connect(boolean silent) {
        block15: {
            MFTETreeNodeFactory.disconnectCoordination();
            try {
                AgentContentPage agentPage;
                TransferTemplatesPage templatesPage;
                MonitorContentPage monitorPage;
                TransferSchedulePage transferSchedulePage;
                TransferLogPage transferLogPage;
                if (this.configuration == null) {
                    Subscription.updateProperties(this.name);
                } else {
                    Subscription.updateProperties(this.configuration);
                }
                Subscription.connect();
                MFTETreeNodeFactory.setConnectedCoordQmgr(this);
                final IWorkbench workbench = PlatformUI.getWorkbench();
                Display display = PlatformUI.getWorkbench().getDisplay();
                CoordContentPage coordContentPage = CoordContentPageFactory.getCoordContentPage();
                if (coordContentPage != null) {
                    ExplorerViewPart viewPart = coordContentPage.getViewPart();
                    if (TransferLogFactory.getTransferLogPage() == null && viewPart instanceof MQContentView) {
                        ((MQContentView)viewPart).showContentPage(Trace.getInstance(), "com.ibm.wmqfte.explorer.transferlog", null);
                        ((MQContentView)viewPart).showContentPage(Trace.getInstance(), "com.ibm.wmqfte.explorer.coordination", null);
                    }
                }
                if ((transferLogPage = TransferLogFactory.getTransferLogPage()) != null) {
                    transferLogPage.startup();
                }
                if ((transferSchedulePage = TransferScheduleFactory.getTransferSchedulePage()) != null) {
                    transferSchedulePage.startup();
                }
                if ((monitorPage = MonitorContentFactory.getMonitorContentPage()) != null) {
                    monitorPage.startup();
                }
                if ((templatesPage = TransferTemplatesFactory.getTransferTemplatesPage()) != null) {
                    templatesPage.startup();
                }
                if ((agentPage = AgentContentFactory.getAgentContentPage()) != null) {
                    agentPage.startup();
                }
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            IViewPart viewPart = workbench.getActiveWorkbenchWindow().getActivePage().showView("com.ibm.wmqfte.explorer.views.TransferProgressView", null, 2);
                            if (viewPart instanceof TransferProgressView) {
                                ((TransferProgressView)viewPart).startup();
                            }
                        }
                        catch (PartInitException partInitException) {}
                    }
                });
                this.isConnected = true;
                this.setChildrenVisibility(true);
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        CoordTreeNode.this.getParent().refresh();
                    }
                });
            }
            catch (WMQApiException e) {
                if (!silent) {
                    this.displayWMQApiException(e);
                }
                if (Trace.isTracing) {
                    Trace.data((Level)Level.WARNING, (String)"CoordTreeNode", (String)"connect", (String)e.toString(), (String)ExplorerPlugin.BUNDLE_SHORT_NAME);
                }
            }
            catch (Subscription.SubscriptionUserCancelException subscriptionUserCancelException) {
            }
            catch (Subscription.SubscriptionException se) {
                Tools.internalError(se.getLocalizedMessage(), new Object[0]);
                if (silent) break block15;
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        Display display = Display.getCurrent();
                        String title = MessageFormat.format(Elements.UI_NODE_CONNECT_FAILED_TITLE, se.getQmgrName(), se.getHostName());
                        Status msg = new Status(4, "com.ibm.wmqfte.explorer", se.getLocalizedMessage(), (Throwable)se);
                        ErrorDialog.openError((Shell)display.getActiveShell(), (String)title, null, (IStatus)msg);
                    }
                });
            }
        }
    }

    public void displayWMQApiException(WMQApiException e) {
        MultiStatus msg = null;
        Exception coordinationException = Subscription.getCoordinationException();
        Exception commandException = Subscription.getCommandException();
        if (e.getReasonCode() == 2035) {
            if (this.configuration == null && coordinationException != null) {
                msg = new MultiStatus("com.ibm.wmqfte.explorer", 1, Messages.BFGUI0013_COORD_SECURITY_ISSUE, null);
                msg.add((IStatus)new Status(4, "com.ibm.wmqfte.explorer", coordinationException.getLocalizedMessage()));
            } else if (this.configuration == null && commandException != null) {
                msg = new MultiStatus("com.ibm.wmqfte.explorer", 1, Messages.BFGUI0014_COMMAND_SECURITY_ISSUE, null);
                msg.add((IStatus)new Status(4, "com.ibm.wmqfte.explorer", commandException.getLocalizedMessage()));
            } else {
                msg = new MultiStatus("com.ibm.wmqfte.explorer", 1, Messages.BFGUI0015_SECURITY_ISSUE, null);
                msg.add((IStatus)new Status(4, "com.ibm.wmqfte.explorer", e.getLocalizedMessage()));
            }
        }
        Exception propException = Subscription.getPropException();
        if (msg == null && this.configuration == null && propException != null) {
            msg = new MultiStatus("com.ibm.wmqfte.explorer", 1, propException.getLocalizedMessage(), (Throwable)propException);
        }
        if (msg == null) {
            int rc = e.getReasonCode();
            String mqrc = MessageFormat.format(Elements.UI_WIZARD_WMQ_RC, Integer.toString(rc));
            switch (rc) {
                case 2059: 
                case 2538: {
                    msg = new MultiStatus("com.ibm.wmqfte.explorer", 1, Messages.BFGUI0004_Q_MGR_NOT_AVAILABLE, null);
                    msg.add((IStatus)new Status(4, "com.ibm.wmqfte.explorer", Messages.BFGUI0004_Q_MGR_NOT_AVAILABLE));
                    msg.add((IStatus)new Status(4, "com.ibm.wmqfte.explorer", mqrc));
                    msg.add((IStatus)new Status(4, "com.ibm.wmqfte.explorer", Messages.BFGUI0004_Q_MGR_NOT_AVAILABLE$explanation));
                    msg.add((IStatus)new Status(4, "com.ibm.wmqfte.explorer", Messages.BFGUI0004_Q_MGR_NOT_AVAILABLE$useraction));
                    break;
                }
                case 2085: {
                    String error = MessageFormat.format(Messages.BFGUI0005_UNKNOWN_OBJECT_NAME, Subscription.SYSTEM_FTE);
                    msg = new MultiStatus("com.ibm.wmqfte.explorer", 1, error, null);
                    msg.add((IStatus)new Status(4, "com.ibm.wmqfte.explorer", error));
                    msg.add((IStatus)new Status(4, "com.ibm.wmqfte.explorer", mqrc));
                    msg.add((IStatus)new Status(4, "com.ibm.wmqfte.explorer", Messages.BFGUI0005_UNKNOWN_OBJECT_NAME$explanation));
                    msg.add((IStatus)new Status(4, "com.ibm.wmqfte.explorer", Messages.BFGUI0005_UNKNOWN_OBJECT_NAME$useraction));
                    break;
                }
                case 2009: {
                    String error = MessageFormat.format(Messages.BFGUI0010_Q_MGR_CONNECTION_BROKEN, Subscription.getAdminQmgrName(), Subscription.getAdminQmgrHostname());
                    msg = new MultiStatus("com.ibm.wmqfte.explorer", 1, error, null);
                    msg.add((IStatus)new Status(4, "com.ibm.wmqfte.explorer", error));
                    msg.add((IStatus)new Status(4, "com.ibm.wmqfte.explorer", mqrc));
                    break;
                }
                case 2161: 
                case 2162: 
                case 2202: {
                    String error = MessageFormat.format(Messages.BFGUI0011_Q_MGR_CONNECTION_SHUTTING_DOWN, Subscription.getAdminQmgrName(), Subscription.getAdminQmgrHostname());
                    msg = new MultiStatus("com.ibm.wmqfte.explorer", 1, error, null);
                    msg.add((IStatus)new Status(4, "com.ibm.wmqfte.explorer", error));
                    msg.add((IStatus)new Status(4, "com.ibm.wmqfte.explorer", mqrc));
                    break;
                }
                default: {
                    String error = MessageFormat.format(Messages.BFGUI0006_GENERIC_CONNECTION_FAILED, Integer.toString(rc));
                    msg = new MultiStatus("com.ibm.wmqfte.explorer", 1, error, null);
                    msg.add((IStatus)new Status(4, "com.ibm.wmqfte.explorer", error));
                    msg.add((IStatus)new Status(4, "com.ibm.wmqfte.explorer", mqrc));
                }
            }
        }
        MultiStatus finalmsg = msg;
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable((Status)finalmsg){
            private final /* synthetic */ Status val$finalmsg;
            {
                this.val$finalmsg = status;
            }

            @Override
            public void run() {
                String title = MessageFormat.format(Elements.UI_NODE_CONNECT_FAILED_TITLE, Subscription.getAdminQmgrName(), Subscription.getAdminQmgrHostname());
                ErrorDialog.openError((Shell)UiPlugin.getShell(), (String)title, null, (IStatus)this.val$finalmsg);
            }
        });
    }

    public void disconnect() {
        AgentContentPage agentPage;
        TransferTemplatesPage templatesPage;
        MonitorContentPage monitorPage;
        TransferSchedulePage transferSchedulePage;
        Subscription.shutdown();
        TransferLogPage transferLogPage = TransferLogFactory.getTransferLogPage();
        if (transferLogPage != null) {
            transferLogPage.shutdown();
        }
        if ((transferSchedulePage = TransferScheduleFactory.getTransferSchedulePage()) != null) {
            transferSchedulePage.shutdown();
        }
        if ((monitorPage = MonitorContentFactory.getMonitorContentPage()) != null) {
            monitorPage.shutdown();
        }
        if ((templatesPage = TransferTemplatesFactory.getTransferTemplatesPage()) != null) {
            templatesPage.shutdown();
        }
        if ((agentPage = AgentContentFactory.getAgentContentPage()) != null) {
            agentPage.shutdown();
        }
        final IWorkbench workbench = PlatformUI.getWorkbench();
        Display display = workbench.getDisplay();
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                IViewPart viewPart = workbench.getActiveWorkbenchWindow().getActivePage().findView("com.ibm.wmqfte.explorer.views.TransferProgressView");
                if (viewPart instanceof TransferProgressView) {
                    ((TransferProgressView)viewPart).shutdown();
                }
            }
        });
        MFTETreeNodeFactory.setConnectedCoordQmgr(null);
        this.isConnected = false;
        this.setChildrenVisibility(false);
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                CoordTreeNode.this.getParent().refresh();
            }
        });
    }

    public FTEConfigurationWizardSettings getConfiguration() {
        return this.configuration;
    }

    public TreeNode[] getChildren() {
        this.setChildrenVisibility(this.isConnected);
        return super.getChildren();
    }

    public String getContentPageId() {
        return "com.ibm.wmqfte.explorer.coordination";
    }

    public String getHelpId() {
        return "";
    }

    public Image getIcon() {
        if (this.configuration != null && this.configuration.getCommandQueueManager() == null) {
            return this.isConnected ? Icons.warningOverlayWMQFTE : Icons.warningOverlayUnconnectedWMQFTE;
        }
        return this.isConnected ? Icons.WMQFTE : Icons.unconnectedWMQFTE;
    }

    public String getId() {
        String id = "com.ibm.wmqfte.explorer.coordination." + this.name;
        if (this.configuration != null) {
            id = String.valueOf(id) + ".user.configured";
        }
        return id;
    }

    public String getSequence() {
        return "300.1000";
    }

    public boolean hasChildren() {
        this.setChildrenVisibility(this.isConnected);
        return super.hasChildren();
    }

    public boolean isAddChildrenWhenExpanded() {
        return false;
    }

    public boolean isContextMenuFromUiObject() {
        return false;
    }

    public String toString() {
        boolean isShowObjectStatus;
        String str = "";
        str = String.valueOf(str) + this.name;
        if (this.configuration == null) {
            if (this.getParent().isChildExist("com.ibm.wmqfte.explorer.coordination." + this.name + ".user.configured")) {
                str = String.valueOf(str) + " (" + Elements.UI_NODE_USING_GLOBAL_CONFIGURATION_LABEL + ")";
            }
        } else if (this.getParent().isChildExist("com.ibm.wmqfte.explorer.coordination." + this.name)) {
            str = String.valueOf(str) + " (" + Elements.UI_NODE_USING_LOCAL_CONFIGURATION_LABEL + ")";
        }
        if (this.configuration != null && this.configuration.getCommandQueueManager() == null) {
            str = String.valueOf(str) + " [" + Elements.UI_NODE_MFT_STATUS_INCOMPLETE_LABEL + ']';
        }
        if (isShowObjectStatus = UiPlugin.isShowObjectStatus()) {
            str = String.valueOf(str) + " [" + (this.isConnected ? Elements.UI_NODE_MFT_STATUS_CONNECTED_LABEL : Elements.UI_NODE_MFT_STATUS_DISCONNECTED_LABEL) + ']';
        }
        return str;
    }

    public String getName() {
        return this.name;
    }

    public Object[] getChildren(Object o) {
        return this.getChildren();
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        return null;
    }

    public String getLabel(Object o) {
        return this.getName();
    }

    public Object getParent(Object o) {
        return this.getParent();
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.configuration == null ? 0 : this.configuration.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        CoordTreeNode other = (CoordTreeNode)((Object)obj);
        if (this.configuration == null ? other.configuration != null : !this.configuration.equals(other.configuration)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

