/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wmqfte.explorer.ras;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.trace.weaving.TraceAspect;
import com.ibm.wmqfte.ras.impl.FteLogRecord;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class ExplorerTraceHandler
extends Handler {
    private static final String BUNDLE_SHORT_NAME = TraceAspect.getBundleShortName((String)"com.ibm.wmqfte.runtime");

    @Override
    public void close() {
    }

    @Override
    public void flush() {
    }

    @Override
    public void publish(LogRecord record) {
        String sourceClassName;
        if (record instanceof FteLogRecord) {
            ((FteLogRecord)record).getObjectReference();
        }
        if ((sourceClassName = record.getSourceClassName()).lastIndexOf(46) > 0) {
            sourceClassName = sourceClassName.substring(sourceClassName.lastIndexOf(46) + 1);
        }
        String sourceMethodName = String.valueOf(record.getSourceMethodName()) + "()";
        if (record.getMessage().startsWith("ENTRY")) {
            Trace.entry((String)sourceClassName, (String)(String.valueOf(sourceMethodName) + '(' + TraceAspect.argsToString((Object[])record.getParameters()) + ')'), (String)BUNDLE_SHORT_NAME);
        } else if (record.getMessage().startsWith("RETURN")) {
            Object parameter = null;
            if (record.getParameters() != null && record.getParameters().length >= 1) {
                parameter = record.getParameters()[0];
            }
            Trace.exit((String)sourceClassName, (String)(String.valueOf(sourceMethodName) + (parameter == null ? "" : "(" + parameter.toString() + ")")), (String)BUNDLE_SHORT_NAME);
        } else if (record.getMessage().startsWith("THROW")) {
            Trace.exit((String)sourceClassName, (String)sourceMethodName, (String)BUNDLE_SHORT_NAME, (Throwable)record.getThrown());
        } else if (record.getMessage().startsWith("DATA")) {
            Object parameter = record.getParameters();
            if (parameter != null && record.getParameters().length == 1) {
                parameter = record.getParameters()[0];
            }
            Trace.data((Level)record.getLevel(), (String)sourceClassName, (String)sourceMethodName, (String)parameter.toString(), (String)BUNDLE_SHORT_NAME);
        }
    }
}

