/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wmqfte.explorer.properties;

import com.ibm.wmqfte.explorer.Elements;
import com.ibm.wmqfte.explorer.objects.TransferLog;
import com.ibm.wmqfte.explorer.utils.PageUtils;
import com.ibm.wmqfte.explorer.wizards.pages.NewTransferMetadataPage;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.dialogs.PropertyPage;

public class TransferLogMetadataPage
extends PropertyPage {
    protected Control createContents(Composite parent) {
        Composite c = new Composite(parent, 0);
        c.setLayout((Layout)new GridLayout(1, false));
        c.setLayoutData((Object)new GridData(4, 4, true, true));
        IAdaptable a = this.getElement();
        TransferLog log = (TransferLog)a.getAdapter(TransferLog.class);
        TableViewer tbv = new TableViewer(c, 68354);
        tbv.setContentProvider((IContentProvider)new NewTransferMetadataPage.MetaDataContentProvider());
        tbv.setLabelProvider((IBaseLabelProvider)new NewTransferMetadataPage.MetaDataLabelProvider());
        tbv.setInput(log.getMetaData());
        Table table = tbv.getTable();
        table.setLayoutData((Object)new GridData(4, 4, true, true));
        TableColumn f = new TableColumn(table, 16384);
        f.setText(Elements.UI_WIZARD_ATTRIBUTE_NAME_LABEL);
        TableColumn t = new TableColumn(table, 16384);
        t.setText(Elements.UI_WIZARD_ATTRIBUTE_VALUE_LABEL);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        tbv.refresh();
        PageUtils.setupTable(table);
        this.addContextMenu(tbv);
        c.layout();
        return c;
    }

    private void addContextMenu(final TableViewer tbv) {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                boolean hasSelection;
                final List selectionList = ((IStructuredSelection)tbv.getSelection()).toList();
                boolean bl = hasSelection = tbv.getSelection() instanceof IStructuredSelection && selectionList.size() > 0;
                if (hasSelection) {
                    Action copy = new Action(){

                        public void run() {
                            ISelection s = tbv.getSelection();
                            if (s instanceof IStructuredSelection) {
                                StringBuilder sb = new StringBuilder();
                                String newline = System.getProperty("line.separator");
                                for (Object o : ((IStructuredSelection)s).toList()) {
                                    if (!(o instanceof Map.Entry)) continue;
                                    Map.Entry entry = (Map.Entry)o;
                                    sb.append((String)entry.getKey()).append('=').append((String)entry.getValue());
                                    if (selectionList.size() <= 1) continue;
                                    sb.append(newline);
                                }
                                Clipboard clipboard = new Clipboard(tbv.getControl().getDisplay());
                                clipboard.setContents((Object[])new String[]{sb.toString()}, new Transfer[]{TextTransfer.getInstance()});
                                clipboard.dispose();
                            }
                        }
                    };
                    copy.setEnabled(selectionList.get(0) instanceof Map.Entry);
                    copy.setText(Elements.UI_CONTENT_TRANSFER_LOG_TABLE_ROW_COPY_BUTTON);
                    manager.add((IAction)copy);
                }
            }
        });
        Menu menu = menuMgr.createContextMenu((Control)tbv.getTable());
        tbv.getTable().setMenu(menu);
    }
}

