/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wmqfte.explorer.properties;

import com.ibm.wmqfte.explorer.Elements;
import com.ibm.wmqfte.explorer.utils.AgentStatus;
import com.ibm.wmqfte.utils.AgentType;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;

public class AgentStatusPropertyPage
extends PropertyPage {
    protected Control createContents(Composite parent) {
        Composite outer = new Composite(parent, 0);
        outer.setLayout((Layout)new GridLayout(2, false));
        outer.setLayoutData((Object)new GridData(4, 4, false, false));
        this.noDefaultAndApplyButton();
        IAdaptable a = this.getElement();
        AgentStatus agentStatus = (AgentStatus)((Object)a.getAdapter(AgentStatus.class));
        this.informationTextLine(outer, Elements.UI_CONTENT_AGENT_NAME, agentStatus.getAgentName());
        this.informationTextLine(outer, Elements.UI_CONTENT_AGENT_DESC, agentStatus.getAgentDescription());
        this.informationTextLine(outer, Elements.UI_CONTENT_AGENT_STATUS, agentStatus.interpretAgentStatus().getAgentStatus());
        this.informationTextLine(outer, Elements.UI_CONTENT_AGENT_START_TIME, agentStatus.getStartTime());
        AgentType agentType = agentStatus.getAgentType();
        this.informationTextLine(outer, Elements.UI_CONTENT_AGENT_TYPE, agentType == null ? "" : agentType.getDisplayValue());
        this.separator(outer);
        this.informationTextLine(outer, Elements.UI_CONTENT_AGENT_QMGR, agentStatus.getQueueManagerName());
        if (agentStatus.isQMgrBinding()) {
            this.informationTextLine(outer, Elements.UI_CONTENT_AGENT_QMGR_TYPE, Elements.UI_CONTENT_AGENT_QMGR_BIND_TYPE);
        } else {
            this.informationTextLine(outer, Elements.UI_CONTENT_AGENT_QMGR_TYPE, Elements.UI_CONTENT_AGENT_QMGR_CLIENT_TYPE);
            this.informationTextLine(outer, Elements.UI_CONTENT_AGENT_HOST, agentStatus.getQueueManagerHost());
            this.informationTextLine(outer, Elements.UI_CONTENT_AGENT_PORT, "" + agentStatus.getQueueManagerPort());
            this.informationTextLine(outer, Elements.UI_CONTENT_AGENT_CHANNEL, agentStatus.getQueueManagerChannel());
        }
        this.informationTextLine(outer, Elements.UI_CONTENT_AGENT_QMGR_STANDBY, agentStatus.getQueueManagerStandby());
        this.separator(outer);
        this.informationTextLine(outer, Elements.UI_CONTENT_AGENT_PUBLISH_TIME, agentStatus.getPublishedTimeAsString());
        this.informationTextLine(outer, Elements.UI_CONTENT_AGENT_STATUS_AGE, agentStatus.getAgeOfAgentStatus(null));
        this.informationTextLine(outer, Elements.UI_CONTENT_AGENT_COMMAND_HANDLER_TIME, agentStatus.getCommandHandlerTimeAsString());
        this.informationTextLine(outer, Elements.UI_CONTENT_AGENT_TIMEZONE, agentStatus.getAgentTimeZone().getDisplayName());
        this.informationTextLine(outer, Elements.UI_CONTENT_AGENT_PUBLISH_RATE, agentStatus.getPublishRate(), Elements.UI_WIZARD_AGNT_CONTROL_SECONDS);
        if (Math.abs(agentStatus.getTimeShift()) >= 1000L) {
            this.informationTextLine(outer, Elements.UI_CONTENT_AGENT_PUBLISH_TIME_DRIFT, "" + agentStatus.getTimeShift() / 1000L, Elements.UI_WIZARD_AGNT_CONTROL_SECONDS);
        }
        this.separator(outer);
        this.informationTextLine(outer, Elements.UI_CONTENT_AGENT_OS, agentStatus.getAgentOsName());
        this.informationTextLine(outer, Elements.UI_CONTENT_AGENT_BUILD_LEVEL, agentStatus.getAgentBuildLevel());
        if (agentStatus.isProtocolBridge()) {
            this.separator(outer);
            this.informationTextLine(outer, Elements.UI_CONTENT_AGENT_BRIDGE_TYPE, agentStatus.getProtocolBridgeType());
            this.informationTextLine(outer, Elements.UI_CONTENT_AGENT_BRIDGE_SERVER_HOST, agentStatus.getProtocolBridgeServer());
        } else if (agentStatus.isCDBridge()) {
            this.separator(outer);
            this.informationTextLine(outer, Elements.UI_CONTENT_AGENT_CD_BRIDGE_NODE_NAME, agentStatus.getCDBridgeNodeName());
            this.informationTextLine(outer, Elements.UI_CONTENT_AGENT_CD_BRIDGE_NODE_HOST, agentStatus.getCDBridgeNodeHost());
        }
        outer.layout();
        return outer;
    }

    protected void informationTextLine(Composite parent, String name, String value) {
        this.informationTextLine(parent, name, value, null);
    }

    protected void informationTextLine(Composite parent, String name, String value, String units) {
        if (value != null) {
            Label nameLabel = new Label(parent, 0);
            nameLabel.setText(name);
            Label valueLabel = new Label(parent, 8);
            valueLabel.setLayoutData((Object)new GridData(1, 0x1000000, true, false));
            valueLabel.setText(String.valueOf(value) + (units != null ? " " + units : ""));
        }
    }

    protected void separator(Composite parent) {
        GridLayout layout = (GridLayout)parent.getLayout();
        int i = 0;
        while (i < layout.numColumns) {
            Label separator = new Label(parent, 259);
            GridData gd = new GridData(768);
            separator.setLayoutData((Object)gd);
            ++i;
        }
    }
}

