/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wmqfte.explorer.properties;

import com.ibm.wmqfte.explorer.Elements;
import com.ibm.wmqfte.explorer.utils.AgentStatus;
import com.ibm.wmqfte.utils.AgentStandbyStatus;
import com.ibm.wmqfte.utils.AgentStatusDetails;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;

public class AgentHighAvailablityStatusPropertyPage
extends PropertyPage {
    protected Control createContents(Composite parent) {
        Composite outer = new Composite(parent, 0);
        outer.setLayout((Layout)new GridLayout(2, false));
        outer.setLayoutData((Object)new GridData(4, 4, false, false));
        this.noDefaultAndApplyButton();
        IAdaptable a = this.getElement();
        AgentStatus agentStatus = (AgentStatus)((Object)a.getAdapter(AgentStatus.class));
        AgentStatusDetails.AgentOnLineStatus aols = agentStatus.interpretAgentStatus();
        if (!(agentStatus.isDeleted() || aols != AgentStatusDetails.AgentOnLineStatus.ACTIVE && aols != AgentStatusDetails.AgentOnLineStatus.IDLE || !agentStatus.isStandardAgent() && !agentStatus.isProtocolBridge())) {
            List standbyInstances = agentStatus.getStandbyInstances();
            if (standbyInstances != null) {
                this.informationTextLine(outer, Elements.UI_CONTENT_AGENT_HA_STATUS_HOSTNAME, agentStatus.getAgentDeclaredHostname());
                this.informationTextLine(outer, Elements.UI_CONTENT_AGENT_HA_STATUS_TYPE, Elements.UI_CONTENT_AGENT_HA_STATUS_TYPE_ACTIVE);
                this.informationTextLine(outer, Elements.UI_CONTENT_AGENT_HA_STATUS_STANDBY_VERSION, agentStatus.getAgentProductVersion());
                this.separator(outer);
                for (AgentStandbyStatus stdby : standbyInstances) {
                    this.informationTextLine(outer, Elements.UI_CONTENT_AGENT_HA_STATUS_HOSTNAME, stdby.getHost());
                    this.informationTextLine(outer, Elements.UI_CONTENT_AGENT_HA_STATUS_TYPE, Elements.UI_CONTENT_AGENT_HA_STATUS_TYPE_STANDBY);
                    this.informationTextLine(outer, Elements.UI_CONTENT_AGENT_HA_STATUS_STANDBY_VERSION, stdby.getVersion());
                    this.separator(outer);
                }
            } else {
                this.informationTextLine(outer, Elements.UI_CONTENT_AGENT_HA_STATUS_NA, "");
            }
        } else {
            this.informationTextLine(outer, Elements.UI_CONTENT_NOT_APPLICABLE, "");
        }
        outer.layout();
        return outer;
    }

    protected void informationTextLine(Composite parent, String name, String value) {
        this.informationTextLine(parent, name, value, null);
    }

    protected void informationTextLine(Composite parent, String name, String value, String units) {
        if (value != null) {
            Label nameLabel = new Label(parent, 0);
            nameLabel.setText(name);
            Label valueLabel = new Label(parent, 8);
            valueLabel.setLayoutData((Object)new GridData(1, 0x1000000, true, false));
            valueLabel.setText(String.valueOf(value) + (units != null ? " " + units : ""));
        }
    }

    protected void separator(Composite parent) {
        GridLayout layout = (GridLayout)parent.getLayout();
        int i = 0;
        while (i < layout.numColumns) {
            Label separator = new Label(parent, 259);
            GridData gd = new GridData(768);
            separator.setLayoutData((Object)gd);
            ++i;
        }
    }
}

