/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wmqfte.explorer.objects;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.wmqfte.explorer.Elements;
import com.ibm.wmqfte.explorer.ExplorerPlugin;
import com.ibm.wmqfte.explorer.content.TransferLogPage;
import com.ibm.wmqfte.explorer.utils.PageUtils;
import com.ibm.wmqfte.explorer.views.TransferProgressView;
import java.io.ByteArrayInputStream;
import java.util.Date;
import java.util.logging.Level;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class TransferStatus {
    private static final Date now = new Date();
    private static final DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
    private static final XPath xPath = XPathFactory.newInstance().newXPath();
    private static final String UTC_FORMAT = "yyyy-MM-dd'T'HH:mm:ssZ";
    private static XPathExpression xPathBytes;
    private static XPathExpression xPathCurrentItem;
    private static XPathExpression xPathCurrentSize;
    private static XPathExpression xPathCurrentTransferred;
    private static XPathExpression xPathDestAgent;
    private static XPathExpression xPathDestAgentQmgr;
    private static XPathExpression xPathDestFile;
    private static XPathExpression xPathDestAgentBridgeURL;
    private static XPathExpression xPathID;
    private static XPathExpression xPathSeconds;
    private static XPathExpression xPathSrcAgent;
    private static XPathExpression xPathSrcAgentQmgr;
    private static XPathExpression xPathSrcAgentBridgeURL;
    private static XPathExpression xPathSrcFile;
    private static XPathExpression xPathTime;
    private static XPathExpression xPathTotalItems;
    private final String id;
    private final Date startTime;
    private final Date reportTime;
    private final long rate;
    private final int currentItem;
    private final int totalItems;
    private final String srcAgent;
    private final String srcAgentQmgr;
    private final String srcAgentBridgeURL;
    private final String srcFile;
    private final String destFile;
    private final String sourceType;
    private final String destAgent;
    private final String destAgentQmgr;
    private final String destAgentBridgeURL;
    private final long currBytes;
    private final long currTotal;
    private final long progress;
    private String logState;

    static {
        try {
            xPathID = xPath.compile("/transaction/@ID");
            xPathSrcAgent = xPath.compile("/transaction/sourceAgent/@agent");
            xPathSrcAgentQmgr = xPath.compile("/transaction/sourceAgent/@QMgr");
            xPathSrcAgentBridgeURL = xPath.compile("/transaction/sourceAgent/@bridgeURL");
            xPathDestAgent = xPath.compile("/transaction/destinationAgent/@agent");
            xPathDestAgentQmgr = xPath.compile("/transaction/destinationAgent/@QMgr");
            xPathDestAgentBridgeURL = xPath.compile("/transaction/destinationAgent/@bridgeURL");
            xPathTime = xPath.compile("/transaction/transferSet/@time");
            xPathCurrentItem = xPath.compile("/transaction/transferSet/stats/@currentItem");
            xPathTotalItems = xPath.compile("/transaction/transferSet/stats/@totalItems");
            xPathBytes = xPath.compile("/transaction/transferSet/stats/@bytes");
            xPathSeconds = xPath.compile("/transaction/transferSet/stats/@seconds");
            xPathSrcFile = xPath.compile("/transaction/transferSet/current/source/file | /transaction/transferSet/current/source/queue");
            xPathDestFile = xPath.compile("/transaction/transferSet/current/destination/file | /transaction/transferSet/current/destination/queue");
            xPathCurrentTransferred = xPath.compile("/transaction/transferSet/current/@transferred");
            xPathCurrentSize = xPath.compile("/transaction/transferSet/current/@size");
        }
        catch (XPathExpressionException xPathExpressionException) {}
    }

    public static TransferStatus fromXML(String xml, Date reportTime) throws IllegalArgumentException {
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            ByteArrayInputStream bis = new ByteArrayInputStream(xml.getBytes("UTF-8"));
            Document doc = db.parse(bis);
            if (Trace.isTracing) {
                Trace.data((Level)Level.FINEST, (String)"TransferStatus", (String)"fromXML", (String)PageUtils.printXML(doc), (String)ExplorerPlugin.BUNDLE_SHORT_NAME);
            }
            String id = xPathID.evaluate(doc);
            String srcAgent = xPathSrcAgent.evaluate(doc);
            String srcAgentQmgr = xPathSrcAgentQmgr.evaluate(doc);
            String srcAgentBridgeURL = xPathSrcAgentBridgeURL.evaluate(doc);
            String destAgent = xPathDestAgent.evaluate(doc);
            String destAgentQmgr = xPathDestAgentQmgr.evaluate(doc);
            String destAgentBridgeURL = xPathDestAgentBridgeURL.evaluate(doc);
            String startTimeStr = xPathTime.evaluate(doc).replace("Z", "+0000");
            Date startTime = TransferProgressView.iso8601.parse(startTimeStr);
            int totalItems = Integer.valueOf(xPathTotalItems.evaluate(doc));
            int currentItem = Integer.valueOf(xPathCurrentItem.evaluate(doc));
            String sourceURI = xPathSrcFile.evaluate(doc);
            Node sourceTypeNode = (Node)xPathSrcFile.evaluate(doc, XPathConstants.NODE);
            String sourceType = sourceTypeNode == null ? "file" : sourceTypeNode.getNodeName();
            String destURI = xPathDestFile.evaluate(doc);
            String currBytes = xPathCurrentTransferred.evaluate(doc);
            String currTotal = xPathCurrentSize.evaluate(doc);
            String transferSetBytes = xPathBytes.evaluate(doc);
            String elapsedSeconds = xPathSeconds.evaluate(doc);
            long percentage = -1L;
            if (Long.valueOf(currTotal) > 0L) {
                if (currentItem == totalItems && currBytes.equals(currTotal)) {
                    percentage = 100L;
                } else {
                    double filePercentage = Double.valueOf(currBytes) / Double.valueOf(currTotal);
                    if (totalItems == 1) {
                        percentage = Math.round(filePercentage * 100.0);
                    } else {
                        double sofar = currentItem > 1 ? (double)(currentItem - 1) / (double)totalItems : 0.0;
                        double thisPercentage = 1.0 / (double)totalItems * filePercentage;
                        percentage = Math.round((thisPercentage + sofar) * 100.0);
                    }
                }
            }
            Double divisor = Math.max(1.0, Double.valueOf(elapsedSeconds));
            long bytesPerSecond = Math.round(Double.valueOf(transferSetBytes) / divisor);
            return new TransferStatus(id, startTime, reportTime, bytesPerSecond, currentItem, totalItems, srcAgent, srcAgentQmgr, srcAgentBridgeURL, sourceURI, sourceType, destAgent, destAgentQmgr, destAgentBridgeURL, destURI, Long.valueOf(currBytes), Long.valueOf(currTotal), percentage);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public TransferStatus(String id, Date start, Date reportTime, long rate, int currentItem, int totalItems, String srcAgent, String srcAgentQmgr, String srcAgentBridgeURL, String srcFile, String sourceType, String destAgent, String destAgentQmgr, String destAgentBridgeURL, String destFile, long currBytes, long currTotal, long progress) {
        this.id = id;
        this.startTime = start;
        this.reportTime = reportTime;
        this.rate = rate;
        this.currentItem = currentItem;
        this.totalItems = totalItems;
        this.srcAgent = srcAgent;
        this.srcAgentQmgr = srcAgentQmgr;
        this.srcAgentBridgeURL = srcAgentBridgeURL;
        this.srcFile = srcFile;
        this.sourceType = sourceType;
        this.destAgent = destAgent;
        this.destAgentQmgr = destAgentQmgr;
        this.destAgentBridgeURL = destAgentBridgeURL;
        this.destFile = destFile;
        this.currBytes = currBytes;
        this.currTotal = currTotal;
        this.progress = progress;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.destAgent == null ? 0 : this.destAgent.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.srcAgent == null ? 0 : this.srcAgent.hashCode());
        result = 31 * result + this.totalItems;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TransferStatus other = (TransferStatus)obj;
        if (this.destAgent == null ? other.destAgent != null : !this.destAgent.equals(other.destAgent)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.srcAgent == null ? other.srcAgent != null : !this.srcAgent.equals(other.srcAgent)) {
            return false;
        }
        return this.totalItems == other.totalItems;
    }

    public static String getUTC_FORMAT() {
        return UTC_FORMAT;
    }

    public String getId() {
        return this.id;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getReportTime() {
        return this.reportTime;
    }

    public String getLogState(boolean force) {
        if (this.logState == null || force) {
            String state = TransferLogPage.getLogStateLocalised(this.id);
            this.logState = state == null ? this.logState : state;
        }
        return this.logState;
    }

    public boolean isStalled() {
        if (this.progress == 100L || Elements.UI_CONTENT_AUDIT_QUEUED_LABEL.equals(this.getLogState(false))) {
            return false;
        }
        now.setTime(System.currentTimeMillis());
        return now.getTime() - this.reportTime.getTime() > 15000L;
    }

    public boolean isCompleted() {
        return this.getProgress() == 100L || TransferLogPage.isFinalisedId(this.id);
    }

    public boolean isCDTransfer() {
        Pattern cdFileMatcher = Pattern.compile("[a-zA-Z0-9-]{2,}?:.*");
        return cdFileMatcher.matcher(this.srcFile).matches() || cdFileMatcher.matcher(this.destFile).matches();
    }

    public long getRate() {
        return this.rate;
    }

    public String getCurrentItem() {
        return Integer.toString(this.currentItem);
    }

    public String getTotalItems() {
        return Integer.toString(this.totalItems);
    }

    public String getCurrFile() {
        return PageUtils.basename(this.srcFile);
    }

    public String getSourceType() {
        return this.sourceType;
    }

    public long getCurrBytes() {
        if (this.isCDTransfer() && !Elements.UI_CONTENT_AUDIT_COMPLETED_SUCCESS_LABEL.equals(this.getLogState(false))) {
            return -1L;
        }
        return this.currBytes;
    }

    public long getCurrTotal() {
        if (this.currTotal < 0L && Elements.UI_CONTENT_AUDIT_COMPLETED_SUCCESS_LABEL.equals(this.getLogState(false))) {
            return this.currBytes;
        }
        if (this.isCDTransfer() && !Elements.UI_CONTENT_AUDIT_COMPLETED_SUCCESS_LABEL.equals(this.getLogState(false))) {
            return -1L;
        }
        return this.currTotal;
    }

    public long getProgress() {
        if (this.progress < 0L && Elements.UI_CONTENT_AUDIT_COMPLETED_SUCCESS_LABEL.equals(this.getLogState(false))) {
            return 100L;
        }
        if (this.isCDTransfer() && !Elements.UI_CONTENT_AUDIT_COMPLETED_SUCCESS_LABEL.equals(this.getLogState(false))) {
            return -1L;
        }
        return this.progress;
    }

    public String getSrcAgent() {
        return this.srcAgent;
    }

    public String getSrcAgentQmgr() {
        return this.srcAgentQmgr;
    }

    public String getSrcAgentBridgeURL() {
        return this.srcAgentBridgeURL;
    }

    public String getDestAgent() {
        return this.destAgent;
    }

    public String getDestAgentQmgr() {
        return this.destAgentQmgr;
    }

    public String getDestAgentBridgeURL() {
        return this.destAgentBridgeURL;
    }
}

