/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wmqfte.explorer.objects;

import com.ibm.wmqfte.explorer.Elements;
import com.ibm.wmqfte.explorer.objects.TransferLog;
import com.ibm.wmqfte.statestore.FTEStateType;
import com.ibm.wmqfte.utils.ProductVersion;

public class TransferLogStateUtils {
    public static boolean isMalformedState(String state) {
        return "malformed".equals(state);
    }

    public static boolean isNotAuthorizedState(String state) {
        return "notAuthorized".equals(state);
    }

    public static boolean isDeletedState(String state) {
        return "deleted".equals(state);
    }

    public static boolean isRecoveringState(String state) {
        return FTEStateType.RecoveringTransfer.toString().equals(state) || FTEStateType.ReSynchronisingTransfer.toString().equals(state) || FTEStateType.ResumingTransfer.toString().equals(state) || FTEStateType.RestartingTransfer.toString().equals(state) || FTEStateType.FailedTransferEnding.toString().equals(state);
    }

    public static boolean isQueuedState(String state) {
        return FTEStateType.NewSenderTransfer.toString().equals(state) || FTEStateType.WaitingForDestinationCapacity.toString().equals(state);
    }

    public static boolean isStartingState(String state) {
        return "started".equals(state) || FTEStateType.NewSenderTransfer.toString().equals(state) || FTEStateType.NewReceiverTransfer.toString().equals(state) || FTEStateType.NegotiatingTransfer.toString().equals(state) || FTEStateType.NegotiatingTransferTimedOut.toString().equals(state);
    }

    public static boolean isInProgressState(String state) {
        return "progress".equals(state) || FTEStateType.RunningTransfer.toString().equals(state);
    }

    public static boolean isCancelledState(String state) {
        return "cancelled".equals(state) || FTEStateType.CancelledNewTransfer.toString().equals(state) || FTEStateType.CancelledInProgressTransfer.toString().equals(state);
    }

    public static boolean isCompletedState(String state) {
        return "completed".equals(state) || FTEStateType.CompletedTransfer.toString().equals(state) || FTEStateType.CompleteReceivedTransfer.toString().equals(state);
    }

    public static boolean isFinalisedState(String state) {
        return "completed".equals(state) || "cancelled".equals(state) || FTEStateType.CompletedTransfer.toString().equals(state) || FTEStateType.CancelledNewTransfer.toString().equals(state) || FTEStateType.CancelledInProgressTransfer.toString().equals(state);
    }

    public static boolean updateTransferLogStateIfValidStateChange(TransferLog log, String state, boolean updateIfLogIsAlreadyFinalised) {
        boolean updateState = false;
        if (log == null || state == null) {
            return false;
        }
        String currentState = log.getState();
        if (currentState == null || "".equals(currentState)) {
            updateState = true;
        } else if (TransferLogStateUtils.isFinalisedState(currentState)) {
            if (updateIfLogIsAlreadyFinalised) {
                updateState = true;
            }
        } else if (TransferLogStateUtils.isFinalisedState(state)) {
            updateState = true;
        } else if (TransferLogStateUtils.isMalformedState(state)) {
            updateState = true;
        } else if (currentState.equals(state)) {
            updateState = true;
        } else if (TransferLogStateUtils.isInProgressState(currentState)) {
            if (TransferLogStateUtils.isCompletedState(state) || TransferLogStateUtils.isRecoveringState(state)) {
                updateState = true;
            }
        } else if (TransferLogStateUtils.isDeletedState(currentState)) {
            if (TransferLogStateUtils.isCompletedState(state)) {
                updateState = true;
            }
        } else if (TransferLogStateUtils.isStartingState(currentState)) {
            if (TransferLogStateUtils.isCompletedState(state) || TransferLogStateUtils.isInProgressState(state) || TransferLogStateUtils.isDeletedState(state) || TransferLogStateUtils.isRecoveringState(state)) {
                updateState = true;
            }
        } else if (TransferLogStateUtils.isQueuedState(currentState)) {
            if (TransferLogStateUtils.isCompletedState(state) || TransferLogStateUtils.isInProgressState(state) || TransferLogStateUtils.isDeletedState(state) || TransferLogStateUtils.isStartingState(state) || TransferLogStateUtils.isRecoveringState(state)) {
                updateState = true;
            }
        } else if (TransferLogStateUtils.isRecoveringState(currentState) && (TransferLogStateUtils.isCompletedState(state) || TransferLogStateUtils.isInProgressState(state) || TransferLogStateUtils.isDeletedState(state))) {
            updateState = true;
        }
        if (updateState) {
            log.setState(state);
        }
        return updateState;
    }

    public static boolean updateTransferLogStateIfValidStateChange(TransferLog log, FTEStateType state) {
        String stateAsString = state == null ? null : state.toString();
        return TransferLogStateUtils.updateTransferLogStateIfValidStateChange(log, stateAsString, false);
    }

    public static String getStateLocalised(String state, TransferLog log) {
        TransferLog.Status filesStatus;
        String result = "";
        if (state == null || "".equals(state)) {
            state = log.getState();
        }
        result = TransferLogStateUtils.isCompletedState(state) ? ((filesStatus = log.getFileStatus()) == TransferLog.Status.SUCCESS ? Elements.UI_CONTENT_AUDIT_COMPLETED_SUCCESS_LABEL : (filesStatus == TransferLog.Status.PARTIAL ? Elements.UI_CONTENT_AUDIT_PARTIAL_SUCCESS_LABEL : (filesStatus == TransferLog.Status.FAILURE ? Elements.UI_CONTENT_AUDIT_FAILED_LABEL : (log.getReturnCode() > 0 ? Elements.UI_CONTENT_AUDIT_FAILED_LABEL : (log.getFiles().size() == 0 ? Elements.UI_CONTENT_AUDIT_COMPLETED_SUCCESS_LABEL : Elements.UI_CONTENT_AUDIT_PROGRESS_LABEL))))) : (TransferLogStateUtils.isCancelledState(state) ? Elements.UI_CONTENT_AUDIT_CANCELLED_LABEL : (TransferLogStateUtils.isInProgressState(state) || TransferLogStateUtils.isDeletedState(state) ? Elements.UI_CONTENT_AUDIT_PROGRESS_LABEL : (TransferLogStateUtils.isStartingState(state) ? (log.getVersion() == null || !log.getVersion().greaterOrEqual(ProductVersion.ProductInterfaceVersion.V300) ? Elements.UI_CONTENT_AUDIT_PROGRESS_LABEL : Elements.UI_CONTENT_AUDIT_STARTED_LABEL) : (TransferLogStateUtils.isQueuedState(state) ? Elements.UI_CONTENT_AUDIT_QUEUED_LABEL : (TransferLogStateUtils.isRecoveringState(state) ? Elements.UI_CONTENT_AUDIT_RECOVERING_LABEL : (TransferLogStateUtils.isMalformedState(state) ? Elements.UI_CONTENT_AUDIT_MALFORMED_LABEL : (TransferLogStateUtils.isNotAuthorizedState(state) ? Elements.UI_CONTENT_AUDIT_NOT_AUTHORIZED_LABEL : state)))))));
        return result;
    }
}

