/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wmqfte.explorer.objects;

import com.ibm.wmqfte.explorer.objects.Call;
import com.ibm.wmqfte.explorer.objects.TransferLogStateUtils;
import com.ibm.wmqfte.utils.AgentType;
import com.ibm.wmqfte.utils.ProductVersion;
import com.ibm.wmqfte.utils.xmlmessage.audit.FTEAuditFileNamePair;
import com.ibm.wmqfte.utils.xmlmessage.audit.FTEAuditFileNamePairImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.xml.xpath.XPathExpressionException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.w3c.dom.Node;

public class TransferLog
implements Serializable,
IWorkbenchAdapter {
    private static final long serialVersionUID = -6462037226573832936L;
    private final ProductVersion.ProductInterfaceVersion version;
    private final String id;
    private final String role;
    private final String srcAgent;
    private final String srcAgentQmgr;
    private final String destAgent;
    private String destAgentQmgr;
    private Date startTime;
    private Date auditTime;
    private String state;
    private final String originator;
    private final List<FTEAuditFileNamePair> files;
    private final List<String> supplements;
    private final Map<String, String> metadata;
    private final Map<String, Call> calls;
    private int returnCode;
    private Status filesStatus = Status.UNKNOWN;
    private String jobName = "";
    private String xml = "";
    private SortedMap<Date, String> xmlMap;
    private final DateComparator dateComparator = new DateComparator();
    private String src;
    private String dest;
    private AgentType srcAgentType;
    private AgentType destAgentType;
    private String cdPNode;
    private String cdSNode;
    private boolean bridgeIsPNODE;

    public TransferLog(String version, String id, String role, String src, String srcAgentName, AgentType srcAgentType, String srcAgentQmgr, String dest, String destAgentName, AgentType destAgentType, String destAgentQmgr, Date startTime, Date auditTime, String state, String originator, int totalFiles, String cdPNode, String cdSNode, boolean bridgeIsPNODE) {
        this.version = ProductVersion.ProductInterfaceVersion.fromValue((String)version);
        this.id = id;
        this.role = role;
        this.src = src;
        this.srcAgent = srcAgentName;
        this.srcAgentType = srcAgentType;
        this.srcAgentQmgr = srcAgentQmgr;
        this.dest = dest;
        this.destAgent = destAgentName;
        this.destAgentType = destAgentType;
        this.destAgentQmgr = destAgentQmgr;
        this.startTime = startTime;
        this.auditTime = auditTime;
        this.state = state;
        this.originator = originator;
        this.files = new ArrayList<FTEAuditFileNamePair>(totalFiles);
        this.supplements = new ArrayList<String>(1);
        this.metadata = new LinkedHashMap<String, String>();
        this.calls = new LinkedHashMap<String, Call>();
        this.xmlMap = new TreeMap<Date, String>(this.dateComparator);
        this.cdPNode = cdPNode;
        this.cdSNode = cdSNode;
        this.bridgeIsPNODE = bridgeIsPNODE;
    }

    public void addXML(Date dateOfAuditInformation, String xml) {
        this.xmlMap.put(dateOfAuditInformation, xml);
    }

    public String getXML() {
        String auditInformationAsXML = "";
        auditInformationAsXML = String.valueOf(auditInformationAsXML) + this.xml;
        if (this.xmlMap != null && !this.xmlMap.isEmpty()) {
            for (Map.Entry<Date, String> entry : this.xmlMap.entrySet()) {
                auditInformationAsXML = String.valueOf(auditInformationAsXML) + entry.getValue();
            }
        }
        return auditInformationAsXML;
    }

    public void addFileNamePair(FTEAuditAgentFileNamePairImpl fp) {
        fp.setSrcAgent(this.src);
        fp.setSrcAgentQmgr(this.srcAgentQmgr);
        fp.setDestAgent(this.dest);
        fp.setDestAgentQmgr(this.destAgentQmgr);
        this.files.add((FTEAuditFileNamePair)fp);
    }

    public void addSupplement(String s) {
        this.supplements.add(s);
    }

    public void addMetaData(String key, String value) {
        this.metadata.put(key, value);
    }

    public void addCall(String type, Node node) {
        try {
            this.calls.put(type, Call.fromNode(type, node));
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
    }

    public List<FTEAuditFileNamePair> getFiles() {
        return this.files;
    }

    public List<String> getSupplements() {
        return this.supplements;
    }

    public Map<String, String> getMetaData() {
        return this.metadata;
    }

    public boolean hasMetaData() {
        return this.metadata.keySet().size() > 0;
    }

    public Map<String, Call> getCalls() {
        return this.calls;
    }

    public void setState(String state) {
        this.state = state;
    }

    public void setAuditTime(Date auditTime) {
        this.auditTime = auditTime;
    }

    public String getId() {
        return this.id;
    }

    public String getRole() {
        return this.role;
    }

    public String getSrc() {
        if (this.src == null || this.src.length() == 0) {
            this.setSrc(this.getSrcAgentName());
        }
        return this.src;
    }

    private void setSrc(String src) {
        this.src = src;
    }

    public String getSrcAgentName() {
        return this.srcAgent;
    }

    public AgentType getSrcAgentType() {
        return this.srcAgentType;
    }

    public String getSrcAgentQmgr() {
        return this.srcAgentQmgr;
    }

    public void setDest(String dest) {
        this.dest = dest;
    }

    public String getDest() {
        if (this.dest == null || this.dest.length() == 0) {
            this.setDest(this.getDestAgentName());
        }
        return this.dest;
    }

    public String getDestAgentName() {
        return this.destAgent;
    }

    public void setDestAgentType(AgentType agentType) {
        this.destAgentType = agentType;
    }

    public AgentType getDestAgentType() {
        return this.destAgentType;
    }

    public String getDestAgentQmgr() {
        return this.destAgentQmgr;
    }

    public String getOriginator() {
        return this.originator;
    }

    public Date getAuditTime() {
        return this.auditTime;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public String getState() {
        return this.state;
    }

    public ProductVersion.ProductInterfaceVersion getVersion() {
        return this.version;
    }

    public String getStateLocalised() {
        return TransferLogStateUtils.getStateLocalised(this.state, this);
    }

    public boolean isCompleted() {
        return TransferLogStateUtils.isCompletedState(this.state);
    }

    public boolean isInProgress() {
        return TransferLogStateUtils.isInProgressState(this.state);
    }

    public boolean isRecovering() {
        return TransferLogStateUtils.isRecoveringState(this.state);
    }

    public Status getFileStatus() {
        return this.filesStatus;
    }

    public void setFilesStatus(Status status) {
        this.filesStatus = status;
    }

    public int getReturnCode() {
        return this.returnCode;
    }

    public void setReturnCode(int returnCode) {
        this.returnCode = returnCode;
    }

    public String getJobName() {
        return this.jobName;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public String getCDPNode() {
        return this.cdPNode;
    }

    public void setCDPNode(String pNode) {
        this.cdPNode = pNode;
    }

    public String getCDSNode() {
        return this.cdSNode;
    }

    public void setCDSNode(String sNode) {
        this.cdSNode = sNode;
    }

    public boolean getBridgeIsPNODE() {
        return this.bridgeIsPNODE;
    }

    public void setBridgeIsPNODE(boolean bridgeIsPNODE) {
        this.bridgeIsPNODE = bridgeIsPNODE;
    }

    public Object[] getChildren(Object o) {
        return null;
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        return null;
    }

    public String getLabel(Object o) {
        if (this.getJobName().length() > 0) {
            return this.getJobName();
        }
        return this.getId();
    }

    public Object getParent(Object o) {
        return null;
    }

    class DateComparator
    implements Comparator<Date>,
    Serializable {
        private static final long serialVersionUID = -3106035890263322580L;

        DateComparator() {
        }

        @Override
        public int compare(Date d1, Date d2) {
            int returnValue = 0;
            returnValue = d1.before(d2) ? -1 : (d1.equals(d2) ? 0 : 1);
            return returnValue;
        }
    }

    public static class FTEAuditAgentFileNamePairImpl
    extends FTEAuditFileNamePairImpl {
        private static final long serialVersionUID = -3106035890263322579L;
        private String srcAgent;
        private String srcAgentQmgr;
        private AgentType srcAgentType;
        private String destAgent;
        private String destAgentQmgr;
        private AgentType destAgentType;

        public String getSrcAgent() {
            return this.srcAgent;
        }

        public String getSrcAgentQmgr() {
            return this.srcAgentQmgr;
        }

        public AgentType getSrcAgentType() {
            return this.srcAgentType;
        }

        public String getDestAgent() {
            return this.destAgent;
        }

        public String getDestAgentQmgr() {
            return this.destAgentQmgr;
        }

        public AgentType getDestAgentType() {
            return this.destAgentType;
        }

        public void setSrcAgent(String srcAgent) {
            this.srcAgent = srcAgent;
        }

        public void setSrcAgentQmgr(String srcAgentQmgr) {
            this.srcAgentQmgr = srcAgentQmgr;
        }

        public void setSrcAgentType(AgentType srcAgentType) {
            this.srcAgentType = srcAgentType;
        }

        public void setDestAgent(String destAgent) {
            this.destAgent = destAgent;
        }

        public void setDestAgentQmgr(String destAgentQmgr) {
            this.destAgentQmgr = destAgentQmgr;
        }

        public void setDestName(String destName) {
            this.destName = destName;
        }

        public void setDestAgentType(AgentType destAgentType) {
            this.destAgentType = destAgentType;
        }
    }

    public static enum Status {
        UNKNOWN,
        FAILURE,
        PARTIAL,
        SUCCESS;

    }
}

