/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wmqfte.explorer.objects;

import com.ibm.wmqfte.explorer.Elements;
import java.io.Serializable;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Call
implements Serializable {
    private static final long serialVersionUID = -1567896898147957695L;
    private static final XPath xPath = XPathFactory.newInstance().newXPath();
    private final String type;
    private final String commandName;
    private final String outcome;
    private final String retries;
    private final String stdout;
    private final String stderr;
    private final String error;

    public static Call fromNode(String type, Node node) throws XPathExpressionException {
        String commandName = xPath.compile("command/@name").evaluate(node);
        String outcome = xPath.compile("callResult/@outcome").evaluate(node);
        String retries = xPath.compile("callResult/@retries").evaluate(node);
        StringBuilder stdout = new StringBuilder();
        NodeList stdoutLines = (NodeList)xPath.compile("callResult/result[position()=last()]/stdout/node()").evaluate(node, XPathConstants.NODESET);
        int i = 0;
        while (i < stdoutLines.getLength()) {
            Node line = stdoutLines.item(i);
            if (i > 0) {
                stdout.append('\n');
            }
            stdout.append(line.getTextContent());
            ++i;
        }
        StringBuilder stderr = new StringBuilder();
        NodeList stderrLines = (NodeList)xPath.compile("callResult/result[position()=last()]/stderr/node()").evaluate(node, XPathConstants.NODESET);
        int i2 = 0;
        while (i2 < stderrLines.getLength()) {
            Node line = stderrLines.item(i2);
            if (i2 > 0) {
                stderr.append('\n');
            }
            stderr.append(line.getTextContent());
            ++i2;
        }
        StringBuilder error = new StringBuilder();
        NodeList errorLines = (NodeList)xPath.compile("callResult/result[position()=last()]/error/node()").evaluate(node, XPathConstants.NODESET);
        int i3 = 0;
        while (i3 < errorLines.getLength()) {
            Node line = errorLines.item(i3);
            if (i3 > 0) {
                error.append('\n');
            }
            error.append(line.getTextContent());
            ++i3;
        }
        return new Call(type, commandName, outcome, retries, stdout.toString(), stderr.toString(), error.toString());
    }

    public Call(String type, String commandName, String outcome, String retries, String stdout, String stderr, String error) {
        this.type = type;
        this.commandName = commandName;
        this.outcome = outcome;
        this.retries = retries;
        this.stdout = stdout;
        this.stderr = stderr;
        this.error = error;
    }

    public String getType() {
        return this.type;
    }

    public String getCommandName() {
        return this.commandName;
    }

    public String getOutcome() {
        return this.outcome;
    }

    public String getRetries() {
        return this.retries;
    }

    public String getOutcomeLocalised() {
        String result = this.outcome;
        if ("success".equals(this.outcome)) {
            result = Elements.UI_CONTENT_AUDIT_COMPLETED_SUCCESS_LABEL;
        } else if ("failure".equals(this.outcome)) {
            result = Elements.UI_CONTENT_AUDIT_FAILED_LABEL;
        } else if ("error".equals(this.outcome)) {
            result = Elements.UI_CONTENT_AUDIT_ERROR_LABEL;
        }
        return result;
    }

    public String getStdout() {
        return this.stdout;
    }

    public String getStderr() {
        return this.stderr;
    }

    public String getError() {
        return this.error;
    }
}

