/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wmqfte.explorer.dialogs;

import com.ibm.wmqfte.explorer.Elements;
import com.ibm.wmqfte.explorer.ExplorerPlugin;
import com.ibm.wmqfte.explorer.utils.v2.ControlGroup;
import com.ibm.wmqfte.explorer.utils.v2.PriorityStatus;
import com.ibm.wmqfte.explorer.utils.v2.ResMonAssist;
import com.ibm.wmqfte.explorer.utils.v2.Tools;
import com.ibm.wmqfte.explorer.wizards.pages.v2.ResourceMonitorPage;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

public class ResMonVarStDialog
extends TitleAreaDialog {
    private static final List<SubstituteVariableReference> substituteVariableDirectoryReferences = new ArrayList<SubstituteVariableReference>();
    private static final List<SubstituteVariableReference> substituteVariableQueueReferences = new ArrayList<SubstituteVariableReference>();
    private static final GridData FillSingle;
    private static final String[] Positional;
    private Combo nameCombo;
    private Text nameDescText;
    private Button toTokeniseButton;
    private Combo sepCombo;
    private Spinner tokenSpinner;
    private Combo endCombo;
    private Text fieldText;
    private String assistedText = null;
    private boolean changed = false;
    private PriorityStatus status;
    private Combo assistedCombo = null;
    private ScrolledComposite scrolledComposite;
    private Composite innerScrollable;
    private final ResMonAssist.AssistItemType assistItemType;
    private final ResourceMonitorPage.ResourceType resourceType;

    static {
        substituteVariableDirectoryReferences.add(new SubstituteVariableReference("AgentName", Elements.UI_WIZARD_V2_RESMON_ASSIST_VAR_AGENTNAME_DESC));
        substituteVariableDirectoryReferences.add(new SubstituteVariableReference("FilePath", Elements.UI_WIZARD_V2_RESMON_ASSIST_VAR_FILEPATH_DESC));
        substituteVariableDirectoryReferences.add(new SubstituteVariableReference("FileName", Elements.UI_WIZARD_V2_RESMON_ASSIST_VAR_FILENAME_DESC));
        substituteVariableDirectoryReferences.add(new SubstituteVariableReference("FileSize", Elements.UI_WIZARD_V2_RESMON_ASSIST_VAR_FILESIZE_DESC));
        substituteVariableDirectoryReferences.add(new SubstituteVariableReference("LastModifiedTime", Elements.UI_WIZARD_V2_RESMON_ASSIST_VAR_LASTMODTIME_DESC));
        substituteVariableDirectoryReferences.add(new SubstituteVariableReference("LastModifiedDate", Elements.UI_WIZARD_V2_RESMON_ASSIST_VAR_LASTMODDATE_DESC));
        substituteVariableDirectoryReferences.add(new SubstituteVariableReference("LastModifiedTimeUTC", Elements.UI_WIZARD_V2_RESMON_ASSIST_VAR_LASTMODTIMEUTC_DESC));
        substituteVariableDirectoryReferences.add(new SubstituteVariableReference("LastModifiedDateUTC", Elements.UI_WIZARD_V2_RESMON_ASSIST_VAR_LASTMODDATEUTC_DESC));
        substituteVariableDirectoryReferences.add(new SubstituteVariableReference("CurrentTimeStamp", Elements.UI_WIZARD_V2_RESMON_ASSIST_VAR_TIME_DESC));
        substituteVariableDirectoryReferences.add(new SubstituteVariableReference("CurrentTimeStampUTC", Elements.UI_WIZARD_V2_RESMON_ASSIST_VAR_TIME_UTC_DESC));
        substituteVariableQueueReferences.add(new SubstituteVariableReference("AgentName", Elements.UI_WIZARD_V2_RESMON_ASSIST_VAR_AGENTNAME_DESC));
        substituteVariableQueueReferences.add(new SubstituteVariableReference("QueueName", Elements.UI_WIZARD_V2_RESMON_ASSIST_VAR_QUEUE_DESC));
        substituteVariableQueueReferences.add(new SubstituteVariableReference("Encoding", Elements.UI_WIZARD_V2_RESMON_ASSIST_VAR_ENCODING_DESC));
        substituteVariableQueueReferences.add(new SubstituteVariableReference("MessageID", Elements.UI_WIZARD_V2_RESMON_ASSIST_VAR_MESSID_DESC));
        substituteVariableQueueReferences.add(new SubstituteVariableReference("GroupID", Elements.UI_WIZARD_V2_RESMON_ASSIST_VAR_GROUPID_DESC));
        substituteVariableQueueReferences.add(new SubstituteVariableReference("CurrentTimeStamp", Elements.UI_WIZARD_V2_RESMON_ASSIST_VAR_TIME_DESC));
        substituteVariableQueueReferences.add(new SubstituteVariableReference("CurrentTimeStampUTC", Elements.UI_WIZARD_V2_RESMON_ASSIST_VAR_TIME_UTC_DESC));
        FillSingle = new GridData(4, -1, true, false);
        Positional = new String[]{Elements.UI_WIZARD_V2_RESMON_ASSIST_TOKEN_BEGIN, Elements.UI_WIZARD_V2_RESMON_ASSIST_TOKEN_END};
    }

    public ResMonVarStDialog(Shell parent, Combo assistedCombo, ResMonAssist.AssistItemType assistItemType, ResourceMonitorPage.ResourceType resourceType) {
        this(parent, assistedCombo.getText(), assistItemType, resourceType);
        this.assistedCombo = assistedCombo;
    }

    public ResMonVarStDialog(Shell parent, String assistedText, ResMonAssist.AssistItemType assistItemType, ResourceMonitorPage.ResourceType resourceType) {
        super(parent);
        this.assistedText = assistedText;
        this.assistItemType = assistItemType;
        this.resourceType = resourceType;
        this.status = new PriorityStatus(Elements.UI_WIZARD_V2_RESMON_ASSIST_DESC);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    public void okPressed() {
        this.assistedText = this.fieldText.getText();
        this.changed = true;
        if (this.assistedCombo != null) {
            this.assistedCombo.setText(this.assistedText);
        }
        super.okPressed();
    }

    public String getAssistedValue() {
        return this.changed ? this.assistedText : null;
    }

    public Control createDialogArea(Composite shell) {
        Composite area = (Composite)super.createDialogArea(shell);
        this.getShell().setText(this.assistItemType.getDialogTitle());
        this.setTitle(Elements.UI_WIZARD_V2_RESMON_ASSIST_TITLE);
        this.status.updateTitleStatus(this);
        ExplorerPlugin.setHelp((Control)shell, "com.ibm.wmqfte.explorer.context.UI_ResMonVarStDialogHelp");
        this.scrolledComposite = new ScrolledComposite(area, 768);
        this.scrolledComposite.setExpandHorizontal(true);
        this.scrolledComposite.setExpandVertical(true);
        this.scrolledComposite.setLayoutData((Object)new GridData(4, 1, true, false));
        this.innerScrollable = new Composite((Composite)this.scrolledComposite, 0);
        this.innerScrollable.setLayoutData((Object)new GridData(4, 4, true, false));
        this.innerScrollable.setLayout((Layout)new GridLayout(1, true));
        this.scrolledComposite.setContent((Control)this.innerScrollable);
        Composite composite = new Composite(this.innerScrollable, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(4, -1, true, false));
        Label fieldLabel = new Label(composite, 0);
        fieldLabel.setText(Elements.UI_WIZARD_V2_RESMON_ASSIST_RESULT);
        this.fieldText = new Text(composite, 2114);
        GridData gd = new GridData(4, 4, false, false);
        this.fieldText.setLayoutData((Object)gd);
        this.fieldText.setText(this.assistedText);
        Group varGroup = new Group(composite, 0);
        varGroup.setText(Elements.UI_WIZARD_V2_RESMON_ASSIST_NAME_GRP);
        varGroup.setLayout((Layout)new GridLayout(2, false));
        varGroup.setLayoutData((Object)new GridData(4, -1, true, false, 2, 1));
        Composite leftColumn = new Composite((Composite)varGroup, 0);
        leftColumn.setLayout((Layout)Tools.noMarginGridLayout(2));
        leftColumn.setLayoutData((Object)new GridData(4, 1, true, false));
        Composite rightColumn = new Composite((Composite)varGroup, 0);
        rightColumn.setLayout((Layout)Tools.noMarginGridLayout(1));
        GridData gd2 = new GridData(4, 1, false, false);
        gd2.widthHint = 100;
        rightColumn.setLayoutData((Object)gd2);
        Label l1 = new Label(leftColumn, 0);
        l1.setText(Elements.UI_WIZARD_V2_RESMON_ASSIST_NAME);
        this.nameCombo = new Combo(leftColumn, 0);
        this.nameCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.nameCombo.setItems(this.getVarNames());
        this.nameCombo.select(0);
        this.nameDescText = new Text(leftColumn, 2122);
        GridData gd3 = new GridData(4, 4, true, true);
        gd3.heightHint = 60;
        gd3.horizontalSpan = 2;
        this.nameDescText.setLayoutData((Object)gd3);
        this.toTokeniseButton = new Button(leftColumn, 32);
        this.toTokeniseButton.setText(Elements.UI_WIZARD_V2_RESMON_ASSIST_TOKEN_ENABLE);
        this.toTokeniseButton.setLayoutData((Object)new GridData(16384, 1, true, false, 2, 1));
        final ControlGroup tokenControlgroup = new ControlGroup("Token");
        Composite tokenComp = new Composite(leftColumn, 0);
        tokenComp.setLayout((Layout)new GridLayout(2, false));
        tokenComp.setLayoutData((Object)new GridData(4, -1, true, false, 2, 1));
        tokenControlgroup.add((Control)tokenComp);
        int comboWidth = Tools.getWidth(tokenComp, Positional);
        GridData comboGD = new GridData(1, -1, true, false);
        comboGD.widthHint = comboWidth + 40;
        int labelWidth = Tools.getWidth(tokenComp, new String[]{Elements.UI_WIZARD_V2_RESMON_ASSIST_TOKEN_DIR, Elements.UI_WIZARD_V2_RESMON_ASSIST_TOKEN_INDEX, Elements.UI_WIZARD_V2_RESMON_ASSIST_DIALOG_INSERT});
        GridData labelGD = new GridData(1, 0x1000000, false, false);
        labelGD.widthHint = labelWidth + 8;
        Label sepLabel = new Label(tokenComp, 131072);
        sepLabel.setText(Elements.UI_WIZARD_V2_RESMON_ASSIST_TOKEN_SEPARATOR);
        sepLabel.setLayoutData((Object)labelGD);
        tokenControlgroup.add((Control)sepLabel);
        this.sepCombo = new Combo(tokenComp, 0);
        this.sepCombo.setItems(new String[]{"/", "\\", "."});
        this.sepCombo.setLayoutData((Object)comboGD);
        this.sepCombo.select(0);
        this.sepCombo.setTextLimit(1);
        tokenControlgroup.add((Control)this.sepCombo);
        Label endLabel = new Label(tokenComp, 131072);
        endLabel.setText(Elements.UI_WIZARD_V2_RESMON_ASSIST_TOKEN_DIR);
        endLabel.setLayoutData((Object)labelGD);
        tokenControlgroup.add((Control)endLabel);
        this.endCombo = new Combo(tokenComp, 8);
        this.endCombo.setItems(Positional);
        this.endCombo.select(0);
        this.endCombo.setLayoutData((Object)comboGD);
        tokenControlgroup.add((Control)this.endCombo);
        Label tokenLabel = new Label(tokenComp, 131072);
        tokenLabel.setText(Elements.UI_WIZARD_V2_RESMON_ASSIST_TOKEN_INDEX);
        tokenLabel.setLayoutData((Object)labelGD);
        tokenControlgroup.add((Control)tokenLabel);
        this.tokenSpinner = new Spinner(tokenComp, 2048);
        this.tokenSpinner.setMinimum(1);
        this.tokenSpinner.setIncrement(1);
        this.tokenSpinner.setMaximum(99);
        this.tokenSpinner.setLayoutData((Object)comboGD);
        tokenControlgroup.add((Control)this.tokenSpinner);
        tokenControlgroup.enabled(false);
        Button insert = new Button(rightColumn, 8);
        insert.setText(Elements.UI_WIZARD_V2_RESMON_ASSIST_DIALOG_INSERT);
        insert.setLayoutData((Object)FillSingle);
        this.nameCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ResMonVarStDialog.this.SetDescription();
            }
        });
        this.SetDescription();
        this.toTokeniseButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }

            public void widgetSelected(SelectionEvent arg0) {
                tokenControlgroup.enabled(ResMonVarStDialog.this.toTokeniseButton.getSelection());
            }
        });
        insert.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }

            public void widgetSelected(SelectionEvent arg0) {
                String insertValue = ResMonVarStDialog.this.createInsertValue();
                ResMonVarStDialog.this.insertIntoField(insertValue);
                ResMonVarStDialog.this.fieldText.setFocus();
            }
        });
        return area;
    }

    private String createInsertValue() {
        StringBuffer sb = new StringBuffer("${");
        sb.append(this.nameCombo.getText());
        if (this.toTokeniseButton.getSelection()) {
            sb.append("{token=");
            if (this.endCombo.getSelectionIndex() == 1) {
                sb.append("-");
            }
            sb.append(this.tokenSpinner.getSelection());
            sb.append("}{separator=");
            sb.append(this.sepCombo.getText());
            sb.append("}");
        }
        sb.append("}");
        return sb.toString();
    }

    private void insertIntoField(String insertValue) {
        this.fieldText.insert(insertValue);
    }

    private void SetDescription() {
        String description = this.getVarDescription(this.nameCombo.getText());
        this.nameDescText.setText(description);
    }

    private List<SubstituteVariableReference> getSubstituteVariableReference() {
        return this.resourceType == ResourceMonitorPage.ResourceType.DIRECTORY ? substituteVariableDirectoryReferences : substituteVariableQueueReferences;
    }

    private String[] getVarNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (SubstituteVariableReference svr : this.getSubstituteVariableReference()) {
            names.add(svr.getName());
        }
        return names.toArray(new String[0]);
    }

    private String getVarDescription(String varName) {
        for (SubstituteVariableReference svr : this.getSubstituteVariableReference()) {
            if (!svr.getName().equalsIgnoreCase(varName)) continue;
            return svr.getNLSDescription();
        }
        return "";
    }

    private static class SubstituteVariableReference {
        private final String name;
        private final String nlsDescription;

        public SubstituteVariableReference(String name, String nlsDescription) {
            this.name = name;
            this.nlsDescription = nlsDescription;
        }

        public String getName() {
            return this.name;
        }

        public String getNLSDescription() {
            return this.nlsDescription;
        }
    }
}

