/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wmqfte.explorer.dialogs;

import com.ibm.wmqfte.explorer.Elements;
import com.ibm.wmqfte.explorer.utils.v2.ResMonAssist;
import com.ibm.wmqfte.explorer.utils.v2.Tools;
import java.io.File;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Spinner;

public class ItemDialogUtils {
    public static final int INDENT = 16;

    public static Label fixedWidthLabel(Composite composite, int labelWidth, String text) {
        Label label = new Label(composite, 131072);
        label.setText(text);
        GridData gd = new GridData(0x1000008, 0x1000000, false, false);
        gd.widthHint = labelWidth;
        label.setLayoutData((Object)gd);
        return label;
    }

    public static void addListener(final Control control) {
        if (control instanceof Combo) {
            Combo combo = (Combo)control;
            if ((combo.getStyle() & 8) == 0) {
                combo.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        ItemDialogUtils.sendValidationEvent(control);
                    }
                });
            }
            combo.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    ItemDialogUtils.sendValidationEvent(control);
                }
            });
        } else if (control instanceof Button) {
            Button button = (Button)control;
            button.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    ItemDialogUtils.sendValidationEvent(control);
                }
            });
        } else if (control instanceof Spinner) {
            Spinner spinner = (Spinner)control;
            spinner.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    ItemDialogUtils.sendValidationEvent(control);
                }
            });
        }
    }

    public static void sendValidationEvent(final Control eventControl) {
        Display display = eventControl.getDisplay();
        if (!display.isDisposed()) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    Control c = eventControl;
                    while (c != null) {
                        if (c instanceof ScrolledComposite) {
                            c.notifyListeners(1000, (Event)new ItemEvent(null));
                            break;
                        }
                        c = c.getParent();
                    }
                }
            });
        }
    }

    public static Button addBrowse(final Composite composite, final ResMonAssist.ComboAssist browseCombo, boolean enabled, final boolean directoryBrowse) {
        Button fileBrowseCombo = new Button(composite, 8);
        fileBrowseCombo.setText(Elements.UI_WIZARD_V2_ITEM_DIALOG_BROWSE);
        GridData gd = new GridData(0x1000008, 0x1000000, false, false, 1, 1);
        gd.widthHint = Tools.getWidth(composite, Elements.UI_WIZARD_V2_ITEM_DIALOG_BROWSE) + 20;
        fileBrowseCombo.setLayoutData((Object)gd);
        fileBrowseCombo.setEnabled(enabled);
        fileBrowseCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                String currentPath = browseCombo.getText();
                currentPath = directoryBrowse ? Tools.directoryBrowser(composite, new File(currentPath), 4096) : Tools.fileBrowser(composite, new File(currentPath), 4096);
                if (currentPath != null) {
                    browseCombo.setText(currentPath);
                }
            }
        });
        return fileBrowseCombo;
    }

    public static GridLayout indentedGridLayout(int numColumns) {
        GridLayout gl = new GridLayout(numColumns, false);
        gl.marginLeft = 16;
        return gl;
    }

    public static GridLayout noIndentedGridLayout(int numColumns) {
        GridLayout gl = new GridLayout(numColumns, false);
        gl.marginLeft = 0;
        return gl;
    }

    public static Point findSelectionPoint(String text) {
        int endCh;
        Point point = null;
        int startCh = text.indexOf("(");
        if (startCh != -1 && (endCh = text.indexOf(")")) != -1) {
            point = new Point(startCh + 1, endCh);
        }
        return point;
    }

    public static boolean hasWildCardChar(String path) {
        return path.indexOf("*") != -1 || path.indexOf("?") != -1;
    }

    public static class ItemEvent
    extends Event {
        private SelectionEvent selectionEvent;

        public ItemEvent(SelectionEvent eventItem) {
            this.selectionEvent = eventItem;
        }

        public SelectionEvent getEvent() {
            return this.selectionEvent;
        }
    }
}

